// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14003 $
//  $Date: 2007-04-06 11:24:40 -0700 (Fri, 06 Apr 2007) $
//  $Author: snoeyink $

#ifndef INCLUDED_aaproperties_pack
#define INCLUDED_aaproperties_pack

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ headers
#include <vector>
#include <map>

//bk namespaces for amino acid properties
//bk variables have information about all
//bk possible atoms an amino acid variant can have
//jss complete versions are gone since they were identical.

//jjh If you add a new variable that needs to be defined for all
//jjh residue/variant combinations, be sure also to include the
//jjh the variable in the function init_new_variable() in
//jjh read_aaproperties.cc, so it will be correctly copied over
//jjh to new variants.

	/////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//  BRIEF INSTRUCTIONS ON HOW TO DEFINE A NEW ATOM TYPE IN ROSETTA
	//
	//  1) Add properties to all initializers in aaproperties_pack.cc
	//  2) Add proterties to all initializers in etable.cc
	//  3) Add properties to all initializers in gb_elec_ns.cc
	//  4) Add properties to all initializers in fullatom_extra_props.cc
	//  5) Add the number of atoms you have defined to options.cc in the set MAX_ATOMTYPES field at the
	//     if get_ligand_flag statement and in the set MAX_REALTYPES field i
	//     in the if get_ligand_flag statement
	//
	//  NOTE: All new atom type definitions must be inserted between the LAST real type definition and the
	//        first virtual atom type definition. Virtual atom types are at the end of every initializer and
	//        always start with the letter V. Also, the atoms you define must of course occur at the same
	//        position in each initializer.
	//
	//////////////////////////////////////////////////////////////////////////////////////////////////////



namespace aaproperties_pack {

namespace properties_per_aa_aav { // properties for each amino acid variant
	extern FArray1D_int nvar; // how many variants does each amino acid have

	extern FArray2D_int natoms; // number of atoms in aa/aav
	extern FArray2D_int nside; // # of sidechain atoms per aa/aav
	extern FArray2D_int nheavyatoms; // number of heavy atoms in aa/aav
	extern FArray2D_int first_scatom; // first sidechain atom in aa/aav

	extern FArray2D_int HNpos; // backbone HN position per residue
	extern FArray2D_int HApos; // backbone HA position per residue
	extern FArray2D_int nacceptors; // # of hbond acceptors per residiue
	extern FArray3D_int accpt_pos; // hbond acceptor positions
	extern FArray2D_int nH_polar; // number of polar H per residue
	extern FArray3D_int Hpos_polar; // positions (atm numbers) of polar hydrogens (to hbond)
	extern FArray2D_int nH_aromatic; // number of aromatic H per residue
	extern FArray3D_int Hpos_aromatic; // positions of aromatic H
	extern FArray2D_int nH_apolar; // number of apolar H per residue
	extern FArray3D_int Hpos_apolar; // positions of apolar H

	extern FArray2D_int nchi; // # chi on aa/aav
	extern FArray4D_int chi_atoms; // chi atoms; four for each nchi
	extern FArray4D_bool chi_required; // t/f: is chi needed to build atm in aa/aav
	extern FArray3D_int length_chi_rigid_atom_list;
	extern FArray4D_int chi_rigid_atom_list; //  all atoms that depend only given chi
}
using namespace properties_per_aa_aav;

namespace properties_per_atom_aa_aav { // properties for each atom in aa/aav
	extern FArray3D_int fullatom_type; // type of atom in aa/aav
	extern FArray3D_string atom_name;  // string for name of atom in aa/aav
	extern FArray3D_string atom_type_char; // string for type of atom in aa/aav
	extern FArray4D_float icoor; // coordinates for atom in aa/aav
	extern FArray4D_int ta; // template atoms for placing Hs (for H only)
	extern FArray3D_int cp_atom_num;   // count_pair number for atom in aa/aav

	extern std::map< int, std::vector<bool> > major_groove_hb_atom;

	// Every atom has an atom_base, the adjacent heavy atom. Used in graphics and hbonds.
  // Ideally, these should form a tree, with the root edge duplicated once in each direction.
  // In rings, atom_base indicates one of the two neighbors, and abase2 the other.
  extern FArray3D_int atom_base;
	// hbond acceptors need abase2 to define an acceptor plane.
  // abase2 = adj atm (!=atom_base) if one exists, else atom_base(atom_base(atm))
  // We define it for all acceptors; formerly was defined only for rings
	extern FArray3D_int abase2;// second atom defining acceptor plane (& used to define midpoint by RING_HYBRIDs)

  extern FArray3D_int na_anchor; // anchor atoms for base mutations (NA only)
}
using namespace properties_per_atom_aa_aav;

namespace properties_atom_nbr_in_aa_aav { // info on neighbors per atom in aa/aav
	extern int const max_bonded_neighbors;
	extern int const max_angle_neighbors;
	extern int const max_dihe_neighbors;
	extern FArray3D_int nhydrogens_on_atm; // number of hydrogens bound to the specified heavy atom
	extern FArray4D_int hydrogens_on_atm; // atom position numbers for hydrogens bound to a given heavy atom
	extern FArray3D_int nbonded_neighbors;
	extern FArray4D_int bonded_neighbor; // atom number of neighbor
	extern FArray3D_int nangle_neighbors;
	extern FArray4D_int angle_neighbor; // atom number of neighbor
	extern FArray3D_int ndihe_neighbors;
	extern FArray4D_int dihe_neighbor; // atom number of neighbor

	extern FArray3D_float atomic_charge; // explicitly assigned partial atomic charges
}
using namespace properties_atom_nbr_in_aa_aav;


namespace properties_water { // properties for water, mostly per atom in aa/aav
	extern int const max_h2o_per_aa; // maximum number of waters on any rotamer
	extern FArray2D_int nh2o; // number of waters per aa/aav
	extern FArray3D_int h2opos; // atom positions that have waters
	extern FArray3D_int nh2o_on_atm; // how many waters are on this atom (must be a heavyatom)
  extern FArray4D_int h2o_on_atm; // what waters are connected to this atom

	extern FArray3D_int heavy_atm_on_h2o; // which heavy atom is connected to this water
	extern FArray3D_int hyd_atm_on_h2o; // which hydrogen is connected to this water, if water is an acceptor
	extern FArray3D_int template_atm_on_h2o; // which template atom is connected to this water
}
using namespace properties_water;

namespace properties_atomtype { // properties based on atom type
	extern FArray1D_int const hybridization;
	extern FArray1D_int const HBdonchemtype;
	extern FArray1D_int const HBaccchemtype;
	extern FArray1D_int const atom_type_cent;
	extern FArray1D_int const atom_type_virt;
	extern FArray1D_string const atom_type_name;
	extern FArray1D_int const atomtype_sasapolarity;
	extern FArray1D_float const charge; // generic partial atom charges

	extern FArray2D_bool major_groove_spec; // DNA m.g. hbonders
}
using namespace properties_atomtype;


namespace param_aa_variant {
//bq number of aav type
	extern int const number_aav_type;
//bq aav types
	extern int const aav_base;
	extern int const aav_his_taut;
	extern int const aav_Nterm;
	extern int const aav_Cterm;
	extern int const aav_water;
	extern int const aav_pH;
}
using namespace param_aa_variant;


namespace aa_variant_properties {
	extern FArray3D_bool variant_type;
}
using namespace aa_variant_properties;



namespace pair_cutoffs {
	extern FArray2D_float paircutoff;
}
using namespace pair_cutoffs;


extern int const APOLAR;
extern int const POLAR;


//chu add a table indicating whether two atoms within the same residue should
//chu be counted for pairwise interaction. atom_base is the array telling the
//   bond connectivity information

namespace intra_cp {
	extern FArray4D_float intra_cp_table;
}
using namespace intra_cp;


namespace termini_properties {

	extern int Nterm_natoms; // number of atoms at the N_term
	extern int Cterm_natoms; // number of atoms at the C_term

	extern FArray2D_float Nterm_icoor; // template coordinates of N_term
	extern FArray2D_float Cterm_icoor; // template coordinates of C_term

	extern FArray2D_float Nterm_icoor_pro;

	extern FArray1D_string Nterm_atom_name;
	extern FArray1D_string Cterm_atom_name;
}
using namespace termini_properties;

} // namespace aaproperties_pack


#endif
