// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8303 $
//  $Date: 2006-05-10 12:24:27 -0700 (Wed, 10 May 2006) $
//  $Author: rhiju $


// Rosetta Headers
#include "abrelax.h"
#include "after_opts.h"
#include "files_paths.h"
#include "fold_abinitio.h"
#include "fullatom.h"
#include "idealize.h"
#include "initialize.h"
#include "jumping_refold.h"
#include "map_sequence.h"
#include "maps.h"
#include "monte_carlo.h"
#include "misc.h"
#include "namespace_options.h"
#include "options.h"
#include "output_decoy.h"
#include "pose.h"
#include "pose_io.h"
#include "relax_structure.h"
#include "score.h"

// ObjexxFCL Headers

// Utility Headers
#include <utility/basic_sys_util.hh>

// C++ Headers


void abrelax( int const farlx_stage ){
	using namespace files_paths;
	bool abinitio_accepted( true );

	if (farlx_stage > 0 && homolog_to_query_mapping){
		std::cout << "Cannot do abrelax with homolog-to-query mapping and checkpointing!" << std::endl;
		std::cerr << "Cannot do abrelax with homolog-to-query mapping and checkpointing!" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	// Ab initio first.
	if( farlx_stage == 0 ) {
		fold_abinitio();

		if ( use_abrelax_filters() && farlx_stage == 0 ) {
			apply_filters_wrapper( false /*fullatom*/, abinitio_accepted );
		}
	}

	// Map to query sequence
	bool map_success( true );
	if (homolog_to_query_mapping)		initialize_query_from_homolog( map_success );

	// Then relax.
	if (map_success && abinitio_accepted ) {
		relax_structure();
	}

	return;
}

//Semi redundant copy, uses a different version of fold_abinitio
//incorporating variable fragment lengths. Once testing is complete this
//will be put in a more appropriate place.
// - rvernon (nov 15, 2007)
void abrelax_vf( int const farlx_stage ){
	using namespace files_paths;
	bool abinitio_accepted( true );

	if (farlx_stage > 0 && homolog_to_query_mapping){
		std::cout << "Cannot do abrelax with homolog-to-query mapping and checkpointing!" << std::endl;
		std::cerr << "Cannot do abrelax with homolog-to-query mapping and checkpointing!" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	// Ab initio first.
	if( farlx_stage == 0 ) {
		fold_abinitio_variable_fragment_lengths();

		if ( use_abrelax_filters() && farlx_stage == 0 ) {
			apply_filters_wrapper( false /*fullatom*/, abinitio_accepted );
		}
	}

	// Map to query sequence
	bool map_success( true );
	if (homolog_to_query_mapping)		initialize_query_from_homolog( map_success );

	// Then relax.
	if (map_success && abinitio_accepted ) {
		relax_structure();
	}

	return;
}


void initialize_query_from_homolog( bool & ok ){
	using namespace files_paths;

	adjust_options_protein_prefix_query();

	// Need to do a little shuffle here. Save whats in misc in a pose object, while
	// everything gets reinitialized with query fragments, sequence, etc.
	pose_ns::Pose current_pose;
	pose_from_misc(current_pose, false /*fullatom*/, true /*ideal_pos*/, true /*coords_init*/ );
	initialize_query(); //Read in fragments, fasta file for query sequence.
	pose_to_misc(current_pose);

	// Now we're ready to map.
	ok = map_misc_coords( false /*input_fa*/, true /*!coord_fail*/,
												true /*files_paths::idealized_structure*/ ) ;

// 	if (ok) {
// 		// And it doesn't hurt to idealize as well.
// 		bool const save_fullatom_flag = get_fullatom_flag();
// 		set_pose_flag( false );
// 		monte_carlo_reset();
// 		initialize_maps();
// 		set_fullatom_flag(false);
// 		bool const save_no_faidl = get_no_faidl();
// 		set_no_faidl( true );
// 		idealize( ok );
// 		set_fullatom_flag( save_fullatom_flag );
// 		monte_carlo_reset();
// 		set_no_faidl( save_no_faidl );
// 		if( !files_paths::idealized_structure ) ok = false;
// 	}

	initialize_maps();
	monte_carlo_reset();

	return;
}

void reinitialize_query(){
	adjust_options_protein_prefix_homolog();
	initialize_query();
}

