// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision:
//  $Date:
//  $Author:

//==============================================================================
//
//     add a modified residue phospho-serine (MODE:phospho_ser )
//
//		Kosta Makrodimitris,Ph.D. (KMa) 2006-01
//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// There are more than 150 proteins with phosphorylated Serines(pser)in
// Protein Data Bank
// http://www.rcsb.org/pdb/cgi/resultBrowser.cgi?CoreDB__Het_Group_ID=SEP
// There are other small proteins like statherin that include (pser)
// and are not available as crystals but  participate in
// mechanisms and interactions with teeth, bones etc
// Adding a modified residue in Rosetta++ is general recipe in order to model:
// modified sidechains, protected groups or even a non-aminoacidic new group
// in a protein or DNA eg unusual organic and inorganic groups  etc
// The way to do that in the current Rosetta++ requires to
// modify parameters, constants, initializers, precalculations
// of more than 30 files.
// The most important task is to add the properties of the new residue
// in 'read_aaproperties.cc' (charges,bonds,torsions, hbonds, rotamers)


// Rosetta Headers
#include "add_pser.h"


namespace add_phosphoser {  bool aa_pser  =  { false };  }

//////////////////////////////////////////////////////////////////////////////
/// @begin set_pser
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors:Kosta Makrodimitris,Ph.D.
///
/// @last_modified 2006-01
///////////////////////////////////////////////////////////////////////////////
void
set_pser( bool const setval )
{
	using namespace add_phosphoser ;

	aa_pser = setval;
}



/////////////////////////////////////////////////////////////////////////////
/// @begin add_pser
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors:Kosta Makrodimitris,Ph.D.
///
/// @last_modified 2006-01
///////////////////////////////////////////////////////////////////////////////
bool
add_pser()
{
	using namespace add_phosphoser ;

//	std::cout << aa_pser << std::endl;

	return aa_pser;
}


