// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16901 $
//  $Date: 2007-09-03 18:49:14 -0700 (Mon, 03 Sep 2007) $
//  $Author: kaufmann $


// Rosetta Headers
#include "are_they_neighbors.h"
#include "add_pser.h"
#include "design.h"
#include "dna.h" // dna_enabled()
#include "enzyme.h"
#include "param.h"
#include "param_aa.h"


////////////////////////////////////////////////////////////////////////////////
void
atn_use_atom_initializer( FArray1D_int & use_atom )
{

	using namespace param;
	using namespace param_aa;

	use_atom(	aa_ala ) = 5; // A,C,D,E,F
	use_atom(	aa_cys ) = 5;
	use_atom(	aa_asp ) = 5;
	use_atom(	aa_glu ) = 5;
	use_atom(	aa_phe ) = 5;
	use_atom(	aa_gly ) = 2; // G,H,I,K,L
	use_atom(	aa_his ) = 5;
	use_atom(	aa_ile ) = 5;
	use_atom(	aa_lys ) = 5;
	use_atom(	aa_leu ) = 5;
	use_atom(	aa_met ) = 5; // M,N,P,Q,R
	use_atom(	aa_asn ) = 5;
	use_atom(	aa_pro ) = 5;
	use_atom(	aa_gln ) = 5;
	use_atom(	aa_arg ) = 5;
	use_atom(	aa_ser ) = 5; // S,T,V,W,Y
	use_atom(	aa_thr ) = 5;
	use_atom(	aa_val ) = 5;
	use_atom(	aa_trp ) = 5;
	use_atom(	aa_tyr ) = 5;
	if ( add_pser() ) {
		//KMa phospho_ser
		use_atom( aa_sep ) = 5;
	}
	if ( dna_enabled() ) {
		use_atom( na_gua ) = 11; // G,A,C,T
		use_atom( na_ade ) = 11;
		use_atom( na_cyt ) = 11;
		use_atom( na_thy ) = 11;
		use_atom( na_rgu ) = 12; // rG,rA,rC,rT
		use_atom( na_rad ) = 12;
		use_atom( na_rcy ) = 12;
		use_atom( na_ura ) = 12;
	}
	if( get_enable_ligaa_flag() ){
		for( utility::vector1< int >::iterator cligaa=param_aa::ligand_aa_vector.begin();
			cligaa!=param_aa::ligand_aa_vector.end(); cligaa++){

			use_atom( *cligaa )=1;
		}
//		use_atom( lig1 ) = 1; // ligand
//		use_atom( lig2 ) = 1;
	}

}
