// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.36 $
//  $Date: 2005/10/26 23:31:43 $
//  $Author: sheffler $


// Rosetta Headers
#include "aromatic_stack.h"
#include "decoystats.h"
#include "docking_ns.h"
#include "misc.h"
#include "param_aa.h"
#include "template_pack.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// C++ Headers
#include <algorithm>
#include <cassert>
#include <cmath>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <string>


////////////////////////////////////////////////////
//////  STARTING METHODS FOR aromatic_stack  //////
///////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
/// @begin aromatic_stack::aromatic_stack
///
/// @brief: constructor for class aromatic_stack
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors: John Karanicolas
///
/// @last_modified: 11/27/05
/////////////////////////////////////////////////////////////////////////////////
aromatic_stack::aromatic_stack(
  int const new_resnumA, int const new_aaA, int const new_aavA,
  int const new_resnumB, int const new_aaB, int const new_aavB
)
{

	resnumA = new_resnumA;
	aaA = new_aaA;
	aavA = new_aavA;
	resnumB = new_resnumB;
	aaB = new_aaB;
	aavB = new_aavB;

	plane_ene = 0.;
	intrastack_ene = 0.;
	atr_ene = 0.;
	deltaSASA = 0.;
	SASApack = 999.;
	SASAprob = 0.;

	return;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin aromatic_stack::describe
///
/// @brief
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
std::string
aromatic_stack::describe() {

	using namespace param_aa;

	std::ostringstream output_stream;
	output_stream << "STACK " << aa_name1(aaA) << ' ' << resnumA <<
		' ' << aa_name1(aaB) << ' ' << resnumB <<
		' ' << F(9,3,deltaSASA) << ' ' << F(9,3,intrastack_ene) <<
		' ' << F(9,3,plane_ene) << ' ' << F(9,3,atr_ene) <<
		' ' << F(9,3,SASApack) << ' ' << F(9,3,SASAprob);

	return output_stream.str();

}


