// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_aromatic_stack
#define INCLUDED_aromatic_stack

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>

// C++ Headers
#include <iosfwd>
#include <string>


// jk Class definition for aromatic_stack
class aromatic_stack
{

private:

	int resnumA;
	int aaA;
	int aavA;
	int resnumB;
	int aaB;
	int aavB;

	float plane_ene;
	float intrastack_ene;
	float atr_ene;
	float deltaSASA;
	float SASApack;
	float SASAprob;

public:

	aromatic_stack(
		int const new_resnumA, int const new_aaA, int const new_aavA,
		int const new_resnumB, int const new_aaB, int const new_aavB
	);

	inline void set_plane_ene( const float new_ene )
	  { plane_ene = new_ene; };

	inline void set_intrastack_ene( const float new_ene )
	  { intrastack_ene = new_ene; };

	inline void set_atr_ene( const float new_atr_ene ) { atr_ene = new_atr_ene; };

	inline void set_deltaSASA( const float new_deltaSASA )
	  { deltaSASA = new_deltaSASA; };

	inline void set_SASApack( const float new_SASApack )
	  { SASApack = new_SASApack; };

	inline void set_SASAprob( const float new_SASAprob )
	  { SASAprob = new_SASAprob; };

	inline int get_resnumA() { return resnumA; };

	inline int get_resnumB() { return resnumB; };

	inline float get_plane_ene() { return plane_ene; };

	inline float get_intrastack_ene() { return intrastack_ene; };

	inline float get_atr_ene() { return atr_ene; };

	inline float get_deltaSASA() { return deltaSASA; };

	inline float get_SASApack() { return SASApack; };

	inline float get_SASAprob() { return SASAprob; };

	std::string describe();

};


#endif
