// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 6746 $
//  $Date: 2005-09-29 16:18:52 -0700 (Thu, 29 Sep 2005) $
//  $Author: pbradley $


// Rosetta Headers
#include "barcode_stats_classes.h"

// ObjexxFCL Headers

// C++ Headers

namespace barcode_stats_ns {
	// hairpin params:
	namespace barcode_hairpins {
		// should probably not be set larger than the loop-length dimensions of the
		// vall hairpin data file:: 7
		// at any rate, not going to be useful for frag-vs-decoys
		int const MAX_LOOP_LENGTH = 8;
		float const SCORE_THRESHOLD = -1.0;
		int const MAX_NN = 100;
//  		int const MAX_NN = 25;
	}

	// stream inserter for features
	std::ostream & operator <<( std::ostream & out, Beta_feature const & f )
	{
		// now internal whitespace in this guy:
		std::ostringstream os;
		os << f.pos1 << ',' << f.pos2 << ',' << f.o();
		out << std::right << std::setw( 9 ) << os.str();
		return out;
	}
}
