// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15094 $
//  $Date: 2007-05-22 22:03:43 -0700 (Tue, 22 May 2007) $
//  $Author: rhiju $
#ifdef BOINC_GRAPHICS
#ifdef _WIN32
#include "boinc_win.h"
#endif

#include "after_opts.h"
#include "aaproperties_pack.h"
#include "boinc/boinc_rosetta_graphics.h"
#include "boinc/boinc_rosetta_util.h"
#include "graphics_api.h"
#include "files_paths.h"
#include "counters.h"
#include "docking_ns.h"
#include "electron_density.h"
#include "fullatom.h"
#include "initialize.h"
#include "misc.h"
#include "monte_carlo.h"
#include "namespace_low_pose.h"
#include "namespace_options.h"
#include "namespace_trajectory.h"
#include "native.h"
#include "output_decoy.h"
#include "param.h"
#include "param_aa.h"
#include "pdb.h"
#include "pose.h"
#include "pose_io.h"
#include "protein_graphics.h"
#include "read_aaproperties.h"
#include "score.h"
#include "structure.h"
#include "triangleIterator.h"
#ifdef MAC
#include <GLUT/glut.h>
#else
#include "glut/glut.h"
#endif

#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>
#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>

#include <ObjexxFCL/FArray3Dp.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <cmath>
#include <cstdio>
#include <iostream>
#include <vector>
#include <map>
#define PI2 (2*3.1415926)

namespace graphics {
	float window_size = { 28 };
	int default_aspect_width = 6;
	int default_aspect_height = 4;
	float aspect_width, aspect_height;
	float wu_text_box_height = 0.0;
	std::string initializing;
	std::string cpu_run_time_pref_str;
	int mouse_x, mouse_y;
	bool mouse_down;
	// should probably make this a map of rotations...

	GLfloat nativerotation[16], lowrotation[16], bestrotation[16], currentrotation[16];
	int window_height;
	std::string where_in_window;

	//std::vector<std::string> wu_desc_text;
	//bool add_wu_desc = { false };
	std::vector<std::string> wu_desc_rows;

	// tinker with these to modify how the text is displayed
	//int wu_desc_char_per_row = 90;
	int wu_desc_rows_per_small_box = 10;

	// should probably make these maps, indexes by "low", etc.
	int low_viewport_x,	low_viewport_y,	low_viewport_width,	low_viewport_height;
	int native_viewport_x,	native_viewport_y,	native_viewport_width,	native_viewport_height;
	int best_viewport_x,	best_viewport_y,	best_viewport_width,	best_viewport_height;
	int current_viewport_x,	current_viewport_y,	current_viewport_width,	current_viewport_height;

	std::string current_label; //"Native","Low Energy", etc.

	//rhiju "global" booleans to turn on/off problematic features
	bool const allow_rotation = true;
	bool const show_sidechains = true;

	//lin global of graphics state
	protein_graphics::GraphicsState current_gs;

	//toggle from keyboard

	//Trying to fix some memory access error in pose_rna.cc -- let Rosetta thread
	// tell the graphics display to hold on -- note this didn't actually help.
	bool show_graphics = true;

	// isosurface display list
	unsigned int isosurfaceDisplayList = 0;

}


// functions for drawing densities
void draw_density_as_dots();
void draw_density_as_isocontour();

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void setup_graphics_prefs() {
	using namespace graphics;

	boinc_max_fps = boinc_project_prefs::max_fps;
	boinc_max_gfx_cpu_frac = boinc_project_prefs::max_cpu/100.0;

	/*
	int target_hours = int (boinc_project_prefs::cpu_run_time/ 3600.0);
	int target_minutes = int ((boinc_project_prefs::cpu_run_time-3600*target_hours) / 60.0);
	int target_seconds = int ((boinc_project_prefs::cpu_run_time-3600*target_hours-60*target_minutes));
	cpu_run_time_pref_str = string_of(target_hours) + " hr "
		+ string_of(target_minutes) + " min "
		+ string_of(target_seconds) + " sec";
	*/
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void app_graphics_init()
{
	using namespace graphics;

	aspect_width = float(default_aspect_width);
	aspect_height = float(default_aspect_height);

	// read project specific prefs
	app_graphics_reread_prefs();

	get_wu_desc(); // now in initialize.cc to avoid stupid conflict in WIN32

	glClearColor (0.0, 0.0, 0.0, 0.0);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	int size = 30;
	glOrtho(-size, size, -size, size, -size, size);
	glMatrixMode(GL_MODELVIEW);
	glGetFloatv(GL_MODELVIEW_MATRIX, nativerotation);
	glGetFloatv(GL_MODELVIEW_MATRIX, lowrotation);
	glGetFloatv(GL_MODELVIEW_MATRIX, currentrotation);
	glGetFloatv(GL_MODELVIEW_MATRIX, bestrotation);

	glEnable( GL_DEPTH_TEST );
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);

	// Since lighting is not enabled by default, this shouldn't change anything.
  // When lighting is enabled, these will be the lights
	//  glEnable(GL_LIGHT0);
	//  glLightfv(GL_LIGHT0, GL_POSITION, (GLfloat [4]) {-100.000f, 300.000f, 000.000f, 0.0f});
	//  glLightfv(GL_LIGHT0, GL_AMBIENT,  (GLfloat [4]) { 0.666f,   0.666f, 0.666f, 1.0f});
	//  glLightfv(GL_LIGHT0, GL_DIFFUSE,  (GLfloat [4]) { 0.167f,   0.167f, 0.167f, 1.0f});
	//  glLightfv(GL_LIGHT0, GL_SPECULAR, (GLfloat [4]) { 0.000f,   0.000f, 0.000f, 1.0f});
	//  glEnable(GL_LIGHT1);
	//  glLightfv(GL_LIGHT1, GL_POSITION, (GLfloat [4]) { 100.000f, 300.000f, 100.000f, 0.0f});
	//  glLightfv(GL_LIGHT1, GL_AMBIENT,  (GLfloat [4]) { 0.000f,   0.000f, 0.000f, 1.0f});
	//  glLightfv(GL_LIGHT1, GL_DIFFUSE,  (GLfloat [4]) { 0.167f,   0.167f, 0.167f, 1.0f});
	//  glLightfv(GL_LIGHT1, GL_SPECULAR, (GLfloat [4]) { 0.000f,   0.000f, 0.000f, 1.0f});
	//  glEnable(GL_LIGHT2);
	//  glLightfv(GL_LIGHT2, GL_POSITION, (GLfloat [4]) { 100.000f, 200.000f, 300.000f, 0.0f});
	//  glLightfv(GL_LIGHT2, GL_AMBIENT,  (GLfloat [4]) { 0.000f,   0.000f, 0.000f, 1.0f});
	//  glLightfv(GL_LIGHT2, GL_DIFFUSE,  (GLfloat [4]) { 0.000f,   0.000f, 0.000f, 1.0f});
	//  glLightfv(GL_LIGHT2, GL_SPECULAR, (GLfloat [4]) { 0.500f,   0.500f, 0.500f, 1.0f});

	//This is called in the graphics thread when a window is created. It must make any calls needed to initialize graphics in the window.
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void start_rotate( GLfloat decoyrotation[16]) {
	glPushMatrix();
	glMultMatrixf(decoyrotation);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void end_rotate() {
	glPopMatrix();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void
app_graphics_render(int xs, int ys, double time_of_day)
{
	glViewport(0 , 0, xs, ys );

	if (boinc_params::rosetta_is_running && graphics::show_graphics) draw_rosetta_screensaver( xs, ys );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void
draw_rosetta_screensaver( int width, int height )
{
	using namespace param;
	using namespace misc;
	using namespace graphics;
	using namespace boinc_coords;
	using namespace protein_graphics;

	using namespace numeric;

	window_height = height; // needed to track mouse position.

	if ( ! param::MAX_RES().initialized() )  return;

	int nres = misc::total_residue;

	if ( int(pdb::occupancy.size2()) < nres ) return;

	//users complaining that they can't see the whole protein...
	int total_visible_protein_size = 0;
	for (int i = 1; i <= nres; i++) {
		if (res(i) < 1) return;
		if (pdb::occupancy(2,i) > 0.01) total_visible_protein_size += param_aa::is_protein( misc::res(i)) ? 1:2 ;
	}
	if (nres > 100) window_size = 28 + ( total_visible_protein_size - 100)*0.15;

	if (nres > 0) {
		float aspect = float(width)/float(height);
		glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
		glViewport(0 , 0, width, height );
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluOrtho2D(0 , 1, 0, 1);
		glMatrixMode(GL_MODELVIEW);
		glEnable( GL_DEPTH_TEST );
		float xwidth = .5;
		int small_box;

		if (aspect >= aspect_width / aspect_height) {
			// add space to right side (wider than tall)
			small_box = int(height/aspect_height);
		} else {
			// add space to bottom (taller than wide)
			small_box = int(width/aspect_width);
		}
		int dim_main = 2*small_box;

		// generate box above text box (need this to prevent lines from
		// disappearing in graph and plot boxes for some odd reason)
		glViewport( 0, height-3*small_box, small_box*6, small_box*3 );
		gluOrtho2D(0,1,0,aspect);
		glMatrixMode( GL_MODELVIEW );
		glLoadIdentity();
		glColor3f( 0.5f, 0.5f, 0.5f );
		glTranslatef( 0.0, 0.0, 0.0 );
		glBegin( GL_LINE_STRIP ) ;
		glVertex2f(0,0);
		glVertex2f(0,1);
		glVertex2f(1,1);
		glVertex2f(1,0);
		glVertex2f(0,0);
		glEnd();
		glLoadIdentity();

		// generate box above text box (need this to prevent lines from
		// disappearing in graph and plot boxes for some odd reason)
		glViewport( 0, height-3*small_box, small_box*6, small_box );
		gluOrtho2D(0,1,0,aspect);
		glMatrixMode( GL_MODELVIEW );
		glLoadIdentity();
		glColor3f( 0.5f, 0.5f, 0.5f );
		glTranslatef( 0.0, 0.0, 0.0 );
		glBegin( GL_LINE_STRIP ) ;
		glVertex2f(0,0);
		glVertex2f(0,1);
		glVertex2f(1,1);
		glVertex2f(1,0);
		glVertex2f(0,0);
		glEnd();
		glLoadIdentity();

		// generate boxes for plots
		glViewport( small_box*5, height-3*small_box, small_box, small_box );
		gluOrtho2D(0,1,0,aspect);
		glMatrixMode( GL_MODELVIEW );
		glLoadIdentity();
		glColor3f( 0.5f, 0.5f, 0.5f );
		glTranslatef( 0.0, 0.0, 0.0 );
		glBegin( GL_LINE_STRIP ) ;
		glVertex2f(0,0);
		glVertex2f(0,1);
		glVertex2f(1,1);
		glVertex2f(1,0);
		glVertex2f(0,0);
		glEnd();
		glLoadIdentity();

		glViewport( 0, height-3*small_box, 5*small_box, small_box );
		gluOrtho2D(0,1,0,aspect);
		glMatrixMode( GL_MODELVIEW );
		glLoadIdentity();
		glColor3f( 0.5f, 0.5f, 0.5f );
		glTranslatef( 0.0, 0.0, 0.0 );
		glBegin( GL_LINE_STRIP ) ;
		glVertex2f(0,0);
		glVertex2f(0,1);
		glVertex2f(1,1);
		glVertex2f(1,0);
		glVertex2f(0,0);
		glEnd();
		glLoadIdentity();

		// Work Unit Description?
		if (wu_desc_rows.size() > 0) {

    	// generate box for description
			glViewport( 0, height - 3*small_box - int(wu_text_box_height*small_box),
				int(small_box*aspect_width), int(wu_text_box_height*small_box) );
			gluOrtho2D(0,1,0,aspect);
			glMatrixMode( GL_MODELVIEW );
			glLoadIdentity();
			glColor3f( 0.5f, 0.5f, 0.5f );
			glTranslatef( 0.0, 0.0, 0.0 );
			glBegin( GL_LINE_STRIP ) ;
			glVertex2f(0,0);
			glVertex2f(1,0);
			glVertex2f(1,1);
			glVertex2f(0,1);
			glVertex2f(0,0);
			glEnd();
			glLoadIdentity();

			glViewport( 0, height - 3*small_box - int(wu_text_box_height*small_box),
				int(small_box*aspect_width), int(wu_text_box_height*small_box) );
			display_wu_desc( width, int(wu_text_box_height*small_box) );

			// Main text box
			glViewport( 0, height - 4*small_box-int(wu_text_box_height*small_box),
				int(small_box*aspect_width), small_box );
			display_text( width, small_box, .00014,  .00012, .00010 );

		} else {

			glViewport( 0, height-4*small_box, small_box*6, small_box );
			display_text( width, small_box, .00014,  .00012, .00010 );
		}

		// Searching.... box
		current_viewport_x      = 0;
		current_viewport_y      = height-dim_main;
		current_viewport_width  = dim_main;
		current_viewport_height = dim_main;
		glViewport( current_viewport_x, current_viewport_y, current_viewport_width, current_viewport_height );

		Structure_display(CURRENT);

	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
		// Accepted box
		best_viewport_x      = dim_main;
		best_viewport_y      = height-dim_main;
		best_viewport_width  = dim_main;
		best_viewport_height = dim_main;
		glViewport( best_viewport_x, best_viewport_y, best_viewport_width, best_viewport_height );
		Structure_display(ACCEPTED);

		bool vertical = true;
		float rms_min = 0.0;
		float rms_max = 0.0;
		get_bounds( trajectory::rmsd_vector, rms_min, rms_max );
		if (rms_max > 20) rms_max = 20.00;
		rms_max += 1.00;
		rms_min -= 1.00;
		if (rms_min < 1) rms_min = 0.0;

		if ( get_native_exists() ) {
			// Low energy box
			low_viewport_x      = 2 * dim_main;
			low_viewport_y      = height - small_box;
			low_viewport_width  = small_box;
			low_viewport_height = small_box;
			glViewport( low_viewport_x, low_viewport_y, low_viewport_width, low_viewport_height );
			Structure_display( LOW );

			// Native box
			native_viewport_x      = 2 * dim_main;
			native_viewport_y      = height - 2*small_box;
			native_viewport_width  = small_box;
			native_viewport_height = small_box;
			glViewport( native_viewport_x, native_viewport_y, native_viewport_width, native_viewport_height );
			Structure_display( NATIVE );
			glLoadIdentity();

			get_bounds( trajectory::rmsd_vector, rms_min, rms_max );
			if (rms_max > 20) rms_max = 20.00;
			rms_max += 1.00;
			rms_min -= 1.00;
			if (rms_min < 1.0) rms_min = 0.0;
			//			rms_min = 0.0;

			// RMSD graph box
			glViewport( 5*small_box, height-2*small_box, small_box, 2*small_box );

		} else {

			// Low energy box
			low_viewport_x      = 2 * dim_main;
			low_viewport_y      = height - dim_main;
			low_viewport_width  = dim_main;
			low_viewport_height = dim_main;
			glViewport( low_viewport_x, low_viewport_y, low_viewport_width, low_viewport_height );
			glViewport( 2*dim_main, height-dim_main, dim_main, dim_main );
			Structure_display( LOW );

		}
		plot_timeseries( trajectory::rmsd_vector, vertical, rms_min, rms_max );
		glLoadIdentity();

		// Energy graph box
		glViewport( 0, height-3*small_box, 5*small_box, small_box );
		vertical = false;
		float energy_min = 0.0;// = int (misc::low_score - 10 );
		float energy_max = 0.0;// = int (misc::low_score + 30 );
		get_bounds( trajectory::energy_vector, energy_min, energy_max );
		//		if (energy_max > 100) energy_max = energy_min + 30.00;
		energy_min -= 10.00;
		energy_max += 10.00;
		plot_timeseries( trajectory::energy_vector, vertical, energy_min, energy_max );
		glLoadIdentity();

		// Plot box
		glViewport( 5*small_box, height-3*small_box, small_box, small_box );
		plot_2D( trajectory::rmsd_vector,
			trajectory::energy_vector,
			rms_min, rms_max,
			energy_min, energy_max ) ;
		glLoadIdentity();

	}

	glFlush();
	//  glutSwapBuffers();
	// This will be called periodically in the graphics thread. It
	// should generate the current graphic. xs and ys are the X and Y
	// sizes of the window, and time_of_day is the relative time in
	// seconds. The function should return true if it actually drew
	// anything. It can refer to the user name, CPU time etc. obtained
	// from boinc_get_init_data(). Applications that don't do graphics
	// must also supply a dummy app_graphics_render() to link with the
	// API.
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void
display_wu_desc( float width, float height ) {
	using namespace graphics;
	using namespace protein_graphics;
	float aspect = height/width;
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
	gluOrtho2D(0,1,0,aspect);
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();
	glColor3f( 0.5f, 0.5f, 0.5f );

	int row_chars = 0;
	int rows = 1;
	std::string row_string;
	float row_height = 0.95/float(wu_desc_rows.size());

	for(unsigned int i=0;i < wu_desc_rows.size(); i++) {
		std::string row_string = wu_desc_rows.at(i);
		glTranslatef( .01, (0.98-row_height*float(rows))*aspect, 0.0 );
		writeStrokeString( row_string, .00013, .00010 );
		glLoadIdentity();
		rows++;
	}

/*  for(unsigned int i=0;i < wu_desc_text.size(); i++) {
    std::string word = wu_desc_text.at(i);
		if (row_chars >= wu_desc_char_per_row) {
			glTranslatef( .01, (0.9-row_height*float(rows))*aspect, 0.0 );
			//glLineWidth( 2.0 );
			writeStrokeString( row_string, .00013, .00010 );
			glLoadIdentity();
			row_chars = word.size() + 1;
			row_string = word + " ";
			rows++;
		} else {
			row_chars += word.size() + 1;
			row_string += word + " ";
		}
  }
	if (row_chars > 0) {
		glTranslatef( .02, (0.9-row_height*float(rows))*aspect, 0.0 );
		writeStrokeString( row_string, .00013, .00010 );
		glLoadIdentity();
	}
*/

	glLoadIdentity();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void
display_text( float width, float height, float big, float medium, float small ) {
	using namespace param;
	using namespace misc;
	using namespace graphics;
	using namespace files_paths;
	using namespace boinc_project_prefs;
	using namespace protein_graphics;

	float aspect = height/width;

	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
	gluOrtho2D(0,1,0,aspect);
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();
	glColor3f( 1.0f, 1.0f, 1.0f );
	glLineWidth( 1.0 );

	// PERCENT COMPLETE TEXT
	glTranslatef( .01, .80 *aspect, 0.0f );
	double boinc_pct_complete = 100.0 * boinc_params::pct_complete;
	std::string run_status_str = F( 7, 2, boinc_pct_complete ) + "% Complete";
	writeStrokeString( run_status_str, medium, small );
	glLoadIdentity();

	// CPU TIME TEXT
	glTranslatef( .01, .63 *aspect, 0.0f );
	double cpu_time;
	boinc_wu_cpu_time(cpu_time);
	int hours = int (cpu_time / 3600.0);
	int minutes = int ((cpu_time-3600*hours) / 60.0);
	int seconds = int ((cpu_time-3600*hours-60*minutes));
	std::string cpu_time_str = "CPU time: " + string_of(hours) + " hr "
		+ string_of(minutes) + " min "
		+ string_of(seconds) + " sec ";
	writeStrokeString( cpu_time_str, medium, small);
	glLoadIdentity();

	// USER TEXT
	std::string user_string = app_init_data.user_name;
	std::string user_total_credit_string = string_of(app_init_data.user_total_credit,  6);
	std::string user_expavg_credit_string = string_of(app_init_data.user_expavg_credit , 6);
	user_string = user_string + " - Total credit: " + user_total_credit_string
		+ " - RAC: " + user_expavg_credit_string;
	glTranslatef( .01, 0.47*aspect, 0 );
	writeStrokeString( user_string, medium, small );
	glLoadIdentity();

	// TEAM TEXT
	std::string team_string = app_init_data.team_name;
	if (team_string != "") {
		glTranslatef( .01, .31 *aspect, 0.0f );
		writeStrokeString( team_string , medium, small );
		glLoadIdentity();
	}

	// LOGO TEXT
	std::string appver = string_of(app_init_data.app_version/100.0, 3);
	std::string logo_string = "Rosetta@home v" + appver + " http://boinc.bakerlab.org/rosetta/";
	glTranslatef( .01, .06*aspect, 0.0 );
	writeStrokeString( logo_string, big, medium );
	glLoadIdentity();

	// STAGE TEXT
	glTranslatef( .65, .7 *aspect, 0.0f );
	std::string mode_string = "Stage: " + mode_title;
	if (mode_title == "Initializing") {
		// show it's doing something
		initializing = (initializing.length() >= 10) ? " ." : initializing + " .";
		mode_string += initializing;
	}
	writeStrokeString( mode_string , medium, small );
	glLoadIdentity();

	// MODEL AND STEP TEXT
	std::string ntrials_string = "Model: " + string_of(boinc_params::current_nstruct+1, 4) +
		"  Step: " + string_of(counters::ntrials);
	glTranslatef( .65, .5 *aspect, 0.0f );
	writeStrokeString( ntrials_string , medium, small );
	glLoadIdentity();

	// RMSD TEXT
	glTranslatef( .65, .3 *aspect, 0.0f );
	std::string acc_rmsd_string;
	if ( get_native_exists() ) {
		acc_rmsd_string = "Accepted RMSD:  " + string_of(mc_global_track::diagnose::best_rms, 4);
	} else {
		acc_rmsd_string = "Accepted RMSD:  ?";
	}
	writeStrokeString( acc_rmsd_string , medium, small );
	glLoadIdentity();

	// ENERGY TEXT
	glTranslatef( .65, .1 *aspect, 0.0f );
	std::string score_string2 = "Accepted Energy: " + string_of(mc_global_track::mc_score::best_score, 7);

	writeStrokeString( score_string2 , medium, small );
	glLoadIdentity();


	glColor3f( 0.5f, 0.5f, 0.5f );
	glLoadIdentity();

}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void app_graphics_resize(int x, int y)
{
	glViewport(0 , 0, x, y );
	//Called when the window size changes.
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void app_graphics_reread_prefs()
{
	//This is called, in the graphics thread, whenever the user's project preferences change.
	reread_boinc_project_prefs();
	setup_graphics_prefs();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////
//rhiju Weird, I couldn't pass decoyrotation in by reference... that would be more efficient!
void do_the_rotation(int x, int y, int left, int middle, int right, GLfloat decoyrotation[16]) {
	using namespace graphics;

	double delta_y = y-mouse_y;
	double delta_x = x-mouse_x;

	if (left) {
		double axis_z = 0.0;
		double axis_x = delta_y;
		double axis_y = delta_x;
		double userangle = sqrt(delta_x*delta_x + delta_y*delta_y);

		glMatrixMode(GL_MODELVIEW);
		// Standard GLUT rotation is a postmultiplication - rotation around
		// molecule's inertial frame --  and leads to
		// non-intuitive behavior.
		//glRotatef(userangle,axis_x,axis_y,0.0);

		//A premultiplication -- rotates around the axis the user actually sees.
		// A little more complicated to code; unfortunately GLUT doesn't have a one-line
		// function for it.
		glLoadIdentity();
		glRotatef(userangle,axis_x,axis_y,0.0);
		glMultMatrixf(decoyrotation);
		glGetFloatv(GL_MODELVIEW_MATRIX, decoyrotation);  // Store current model view in decoyrotation
		mouse_y = y;
		mouse_x = x;
	}  else if (right){ //Zoom
		double s = exp( 1.0* (double) delta_y*0.01);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glMultMatrixf(decoyrotation);
		glScalef(s,s,s);
		glGetFloatv(GL_MODELVIEW_MATRIX, decoyrotation); // Store current model view in decoyrotation
		mouse_y = y;
		mouse_x = x;
	}
	else if (middle) { //Translate
		GLint viewport[4];
		glGetIntegerv(GL_VIEWPORT,viewport);
		glMatrixMode(GL_MODELVIEW);
		double xscale = (graphics::window_size * 2.0)/(viewport[2]);
		double yscale = (graphics::window_size * 2.0)/(viewport[3]);
		glLoadIdentity();
		glTranslatef( delta_x * xscale, -delta_y * yscale, 0);
		glMultMatrixf(decoyrotation);
		glGetFloatv(GL_MODELVIEW_MATRIX, decoyrotation);
		mouse_y = y;
		mouse_x = x;
	}
	else {
		mouse_down = false;
	}
}
/////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void boinc_app_mouse_move(int x, int y, int left, int middle, int right) {
	using namespace graphics;

	if (!allow_rotation) return;

	//if (!native_centered) return; // just rotate native for now
	// Where are we? In low, native, accepted, or current?
	if ( where_in_window == "native" )
		do_the_rotation( x, y, left, middle, right, nativerotation);
	if ( where_in_window == "low" )
		do_the_rotation( x, y, left, middle, right, lowrotation);
	if ( where_in_window == "current" )
		do_the_rotation( x, y, left, middle, right, currentrotation);
	if ( where_in_window == "best" )
		do_the_rotation( x, y, left, middle, right, bestrotation);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void boinc_app_mouse_button(int x, int y, int which, int is_down) {
	using namespace graphics;

	if (!allow_rotation) return;

	if (is_down) {
        mouse_down = true;
        mouse_x = x;
        mouse_y = y;
    } else {
        mouse_down = false;
    }

	if ( mouse_x > native_viewport_x && mouse_x < native_viewport_x + native_viewport_width &&
			 mouse_y > window_height -  native_viewport_y - native_viewport_height&& mouse_y < window_height - native_viewport_y ) {
		where_in_window = "native"; //native
	} else if
			( mouse_x > low_viewport_x && mouse_x < low_viewport_x + low_viewport_width &&
				mouse_y > window_height - low_viewport_y -low_viewport_height && mouse_y < window_height - low_viewport_y ) {
		where_in_window = "low";
	} else if
			( mouse_x > current_viewport_x && mouse_x < current_viewport_x + current_viewport_width &&
				mouse_y > window_height - current_viewport_y - current_viewport_height && mouse_y < window_height - current_viewport_y ) {
		where_in_window = "current";
	} else if
			( mouse_x > best_viewport_x && mouse_x < best_viewport_x + best_viewport_width &&
				mouse_y > window_height - best_viewport_y - best_viewport_height && mouse_y < window_height - best_viewport_y ) {
		where_in_window = "best";
	} else {
		where_in_window = ""; //somewhere else
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void boinc_app_key_press(
												 int key, int lParam           // system-specific key encodings
												 )
{
	using namespace graphics;
	using namespace protein_graphics;
	if (key == 67 || key == 99) { //'c' control color
		current_gs.Color_mode = ColorMode ( current_gs.Color_mode + 1 );
		if ( current_gs.Color_mode > RESIDUE_CPK_COLOR ) current_gs.Color_mode = RAINBOW_COLOR;
	}
	if (key == 66 || key == 98) { //'b' control backbone display
		current_gs.BBdisplay_state = BBdisplayState ( current_gs.BBdisplay_state + 1 );
		//if ( current_gs.BBdisplay_state > SHOW_BACKBONE ) current_gs.BBdisplay_state = SHOW_NOBB;
		if ( current_gs.BBdisplay_state > SHOW_BB_SPACEFILL ) current_gs.BBdisplay_state = SHOW_CARTOON;
	}
	if (key == 83 || key == 115) { //'s' control sidechain display
		current_gs.SCdisplay_state = SCdisplayState ( current_gs.SCdisplay_state + 1 );
		//if ( current_gs.SCdisplay_state > SHOW_WIREFRAME ) current_gs.SCdisplay_state = SHOW_NOSC;
		if ( current_gs.SCdisplay_state > SHOW_SC_SPACEFILL ) current_gs.SCdisplay_state = SHOW_NOSC;
}
	if (key == 76 || key == 108) { //'l' control ligand display
	  current_gs.LIGdisplay_state = LIGdisplayState ( current_gs.LIGdisplay_state + 1 );
		if ( current_gs.LIGdisplay_state > SHOW_LIG_SPACEFILL ) current_gs.LIGdisplay_state = SHOW_NOLIG;
	}
	//std::cerr << "keypress " << key << " " << lParam << std::endl;
	// tab   => 9
    // shift => 16
	// cntl  => 17
	// up		=> 38
	// down		=> 40
	// left		=> 37
	// right	=> 39
	//if (key == 65) { // 'a'
		//graphics::text_aliasing = !graphics::text_aliasing;
	//}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void boinc_app_key_release(
    int, int            // system-specific key encodings
)
{
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// All molecule drawing routines moved to protein_graphics.cc!!!
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void
Structure_display ( graphics::GraphicsPoseType graphics_pose_type )
{
		using namespace graphics;
		using namespace protein_graphics;

		if (graphics_pose_type == NATIVE && !native::native_exists) return;

		//////////////////
		// Draw molecule
		//////////////////
		switch( graphics_pose_type ){
		case CURRENT:
			start_rotate(currentrotation);
			break;
		case ACCEPTED:
			start_rotate(bestrotation);
			break;
		case LOW:
			start_rotate(lowrotation);
			break;
		case NATIVE:
			start_rotate(nativerotation);
			break;
		}

		float y_min_screen = - window_size;
		float y_max_screen = + window_size;
		float x_min_screen = - window_size;
		float x_max_screen = + window_size;
		float delta_y = y_max_screen - y_min_screen;

		float zmax = 300.0;
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho(x_min_screen, x_max_screen, y_min_screen, y_max_screen, -zmax, zmax);
		glMatrixMode(GL_MODELVIEW);

		float xlabel = x_min_screen + 1.0; // .05*(window_size);
		float ylabel = y_min_screen + 1.0;

		bool centered = !(electron_density_map::density_map_present); //Need to preserve an absolute coordinate system.

		switch( graphics_pose_type ){
		case CURRENT:
			protein_graphics::draw_pose( misc::total_residue, misc::full_coord, misc::Eposition,
																	 misc::res, misc::res_variant, misc::secstruct,
																	 pdb::occupancy, graphics::current_gs,
																	 get_fullatom_flag(), centered );
			break;
		case ACCEPTED:
			protein_graphics::draw_pose( misc::total_residue, misc::best_full_coord, misc::Ebest_position,
																	 misc::best_res, misc::best_res_variant, misc::best_secstruct,
																	 pdb::occupancy, graphics::current_gs,
																	 get_fullatom_flag(), centered );
			break;
		case LOW:
			protein_graphics::draw_pose( misc::total_residue, low_pose::low_full_coord, low_pose::Elow_position,
																	 low_pose::low_res, low_pose::low_res_variant, low_pose::low_secstruct,
																	 pdb::occupancy, graphics::current_gs,
																	 get_fullatom_flag(), centered );
			break;
		case NATIVE:
			protein_graphics::draw_pose( misc::total_residue, native::native_coord, native::native_Eposition,
																	 misc::res, misc::res_variant, native::nat_secstruct,
																	 native::native_occupancy, graphics::current_gs,
																	 get_fullatom_flag(), centered );
			break;
		}

		if (electron_density_map::density_map_present ){
			//				draw_density_as_dots();
			draw_density_as_isocontour();
		}

		glLoadIdentity();
		end_rotate();
		glColor3f(.5,.5,.5);
		float offset = 0; //.1;
		glBegin( GL_LINE_STRIP ) ;
		glVertex3f(x_min_screen+offset,y_min_screen+offset,zmax-1);
		glVertex3f(x_min_screen+offset,y_max_screen-offset,zmax-1);
		glVertex3f(x_max_screen-offset,y_max_screen-offset,zmax-1);
		glVertex3f(x_max_screen-offset,y_min_screen+offset,zmax-1);
		glVertex3f(x_min_screen+offset,y_min_screen+offset,zmax-1);
		glEnd();

		glLoadIdentity();

		////////////////
		//Write label
		////////////////
		glTranslatef( xlabel + 2.0, ylabel + 2.0, 0 );
		glColor3f(.5,.5,.5);

		float scale = .04;
		if (misc::total_residue > 100) {
			scale = scale + (misc::total_residue - 100)*0.00008;
		}

		switch( graphics_pose_type ){
		case CURRENT:
			current_label = "Searching...";
			break;
		case ACCEPTED:
			current_label = "Accepted";
			break;
		case LOW:
			current_label = "Low Energy";
			break;
		case NATIVE:
			current_label = "Native";
			break;
		}

		writeStrokeString(current_label, scale, scale);
		glLoadIdentity();
}

///////////////////////////////////////////////////////////////////////////////
void
glVertex3fxyz( numeric::xyzVector_float  coord ) {
	glVertex3f(coord.x(), coord.y(), coord.z() );
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void
set_show_graphics( bool const show_graphics_input ){
	using namespace graphics;
	show_graphics = show_graphics_input;
}

void
draw_density_as_isocontour() {
	using namespace electron_density_map;
	using namespace numeric;
	using graphics::isosurfaceDisplayList;

	if (!isosurfaceDisplayList) {
		isosurfaceDisplayList = glGenLists(1);
		assert(isosurfaceDisplayList != 0);

		glNewList(isosurfaceDisplayList, GL_COMPILE);

		// figure out a coordinate sysmtem for this
		glPushMatrix();
		xyzVector_float v111(&native_electron_density.grid_xyz()(1,1,1,1));
		xyzVector_float v211(&native_electron_density.grid_xyz()(1,2,1,1));
		xyzVector_float v121(&native_electron_density.grid_xyz()(1,1,2,1));
		xyzVector_float v112(&native_electron_density.grid_xyz()(1,1,1,2));
		xyzVector_float xAxis = v211 - v111;
		xyzVector_float yAxis = v121 - v111;
		xyzVector_float zAxis = v112 - v111;
		float xform[16] = {
			xAxis(1), xAxis(2), xAxis(3), 0.0,
			yAxis(1), yAxis(2), yAxis(3), 0.0,
			zAxis(1), zAxis(2), zAxis(3), 0.0,
			v111(1),  v111(2),  v111(3),  1.0};
		glMultMatrixf(xform);
		glTranslatef(-1.0, -1.0, -1.0); // fixes off by one error


		// lighting
		//		glPushAttrib(GL_ENABLE_BIT | GL_LIGHTING_BIT);
		//		glEnable(GL_LIGHTING);
		//		glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE,	 (GLfloat [4]) { 0.2f, 0.2f, 0.2f, 1.0f});
		//		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT,	 (GLfloat [4]) { 0.4f, 0.4f, 0.4f, 1.0f});
		//		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, (GLfloat [4]) { 0.4f, 0.4f, 0.4f, 1.0f});

		// draw the triangles of the isosurface
		glColor4f(0.7, 0.7, 1.0, 1.0);
		xyzVector_float verts[3];
		xyzVector_float norms[3]; // normals, not yet defined.
		triangleIterator iter(native_electron_density.density(), 1.5*native_electron_density.threshold());

		//		glBegin(GL_TRIANGLES);
		while (iter.hasNext()) {
			iter.next(verts, norms);
			//			xyzVector_float normal = cross(verts[1] - verts[0], verts[2] - verts[0]).normalized_any();

			glBegin(GL_TRIANGLES);
			//			glNormal3f(normal(1), normal(2), normal(3));
			glNormal3f(norms[2](1), norms[2](2), norms[2](3)); //IA test
			glVertex3f(verts[2](1), verts[2](2), verts[2](3));
			glNormal3f(norms[1](1), norms[1](2), norms[1](3)); //IA test
		  glVertex3f(verts[1](1), verts[1](2), verts[1](3));
			glNormal3f(norms[0](1), norms[0](2), norms[0](3)); //IA test
			glVertex3f(verts[0](1), verts[0](2), verts[0](3));
			glEnd();

			// debug - begin
/*			glPushAttrib(GL_ENABLE_BIT);
//			glDisable(GL_LIGHTING);
			glBegin(GL_LINES);
			// draw normals here
			glVertex3f(verts[0](1), verts[0](2), verts[0](3));
			glVertex3f(verts[0](1)+norms[0](1), verts[0](2)+norms[0](2), verts[0](3)+norms[0](3));
			glEnd();
			glPopAttrib();
			// debug - end
*/
		}
		//		glEnd();

		glPopAttrib();
		glPopMatrix();

		glEndList();
	}

	glCallList(isosurfaceDisplayList);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void draw_density_as_dots() {
	using namespace electron_density_map;

	int const size1 (native_electron_density.data_point_size()(1) );
	int const size2 (native_electron_density.data_point_size()(2) );
	int const size3 (native_electron_density.data_point_size()(3) );

	glColor3f( 0.5, 0.5, 0.5); //gray.
	glBegin(GL_POINTS);
	for (int i = 1; i <= size1; i++){
		for (int j = 1; j <= size2; j++){
			for (int k = 1; k <= size3; k++){
				if (native_electron_density.density()(i,j,k) > native_electron_density.threshold()){
					//Draw it.
					FArray1Dp_float xyz(native_electron_density.grid_xyz()(1,i,j,k), 3 );

					glVertex3f(xyz(1) + 0.5, xyz(2) + 0.5, xyz(3) + 0.5);

// 					glBegin(GL_POLYGON);
// 					glVertex3f ( xyz(1), xyz(2), xyz(3) );
// 					glVertex3f ( xyz(1)+0.5, xyz(2), xyz(3) );
// 					glVertex3f ( xyz(1)+0.5, xyz(2)+0.5, xyz(3));
// 					glVertex3f ( xyz(1), xyz(2)+0.5, xyz(3) );
// 					//						glVertex3f ( xgrid(i), ygrid(j), zgrid(k) );
// 					//           glVertex3f ( xgrid(i)+0.5, ygrid(j), zgrid(k) );
// 					//            glVertex3f ( xgrid(i)+0.5, ygrid(j)+0.5, zgrid(k) );
// 					//            glVertex3f ( xgrid(i), ygrid(j)+0.5, zgrid(k) );
// 					glEnd();
// 					//								std::cerr << "Drawing a polygon" << xyz(1) << " " << xyz(2) << " " << xyz(3) << std::endl;
				}
			}
		}
	}
	glEnd();
}


#endif



