// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14795 $
//  $Date: 2007-05-08 14:46:13 -0700 (Tue, 08 May 2007) $
//  $Author: dekim $

#include "boinc_rosetta_util.h"

// Boinc Headers
#ifdef _WIN32
#include "boinc_win.h"
#endif
#include "boinc_api.h"
#include "diagnostics.h"
#include "parse.h"

#include "after_opts.h"
#include "initialize.h"
#include "output_decoy.h" // For checkpoint_decoys

// Utility Headers
#include <utility/file/file_sys_util.hh>
#include <utility/basic_sys_util.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>
#include <cmath>

// <murphp>
// !!! not sure if the paths are set up so that boinc will know where ObjexxFCL is
#include <ObjexxFCL/ObjexxFCL.hh>
//#include <ObjexxFCL/FArray1Da.hh>
#include <numeric/xyzVector.hh>
// </murphp>

namespace boinc_params {
	double pct_complete = 0.0;
	double cpu_time_per_nstruct = 0.0; // cpu_time per nstruct
	double cpu_time = 0.0;             // total wu cpu time
	int current_nstruct;
	int orig_number_of_output;
	int orig_nstartnm;
	int no_progress_init_cnt = 0;
	std::string init_cnt_filename = "boinc_rosetta_init_cnt.txt";
	bool rosetta_is_running = {false};
	bool pct_complete_handled_by_watchdog = { false };
}

namespace boinc_project_prefs {
	APP_INIT_DATA app_init_data;
	double max_fps;
	double max_cpu;
	int cpu_run_time = 0;

	// don't change these or boinc users may get upset
	float default_max_fps = 10.0;
	float default_max_cpu = 10.0;

	// this gets set from a command line option added
	// by the submission script, boinc_submit
	int default_cpu_run_time = 2*60*60;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin resolve_filename_boinc
///
/// @brief convert logical file names to physical names
///
/// @detailed
///
/// @param[in]  string
///
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
resolve_filename_boinc( std::string & filename )
{
	// first check if file exists
	if ( !utility::file::file_exists( filename ) ) return;
	char resolved_name[ 300 ];
	if ( boinc_resolve_filename( filename.c_str(), resolved_name, sizeof( resolved_name ) ) ) {
		std::cout << "BOINC WARNING: can't resolve filename "
		 << filename << std::endl;
	}
	filename = resolved_name;
}

void default_boinc_project_prefs()
{
	using namespace boinc_project_prefs;
	max_fps = (double)default_max_fps;
	max_cpu = (double)default_max_cpu;
	cpu_run_time = default_cpu_run_time;
}

void parse_boinc_project_prefs(char *buf)
{
	using namespace boinc_project_prefs;
	if (!buf) return;
	double max_fpstmp = 0.0;
	double max_cputmp = 0.0;
	int cpu_run_timetmp = 0;
	parse_double(buf, "<max_fps>", max_fpstmp);
	if (max_fpstmp > 0) max_fps = max_fpstmp;
	parse_double(buf, "<max_cpu>", max_cputmp);
	if (max_cputmp > 0) max_cpu = max_cputmp;
	parse_int(buf, "<cpu_run_time>", cpu_run_timetmp);
	if (cpu_run_timetmp > 0) cpu_run_time = cpu_run_timetmp;
}

void reread_boinc_project_prefs() {
	using namespace boinc_project_prefs;
	int tmp_cpu_run_time = cpu_run_time;
	default_boinc_project_prefs();
	boinc_parse_init_data_file();
	boinc_get_init_data(app_init_data);
	parse_boinc_project_prefs(app_init_data.project_preferences);
	if (cpu_run_time != tmp_cpu_run_time)
		std::cerr << "# cpu_run_time_pref: " << cpu_run_time << std::endl;
}

void update_boinc_params( int & num_decoys, int & number_of_output ) {
	using namespace boinc_params;
	using namespace boinc_project_prefs;
	current_nstruct = num_decoys;
	int total_iterations = orig_number_of_output * orig_nstartnm;
	if (total_iterations != 0) {
		boinc_wu_cpu_time(cpu_time); // get wu cpu run time
		reread_boinc_project_prefs();
		if (cpu_run_time > 0 && cpu_time > 0 && num_decoys > 0) {
			cpu_time_per_nstruct = (double)(cpu_time) / (double)(num_decoys);

			if (!pct_complete_handled_by_watchdog){
				pct_complete = (double)(cpu_time) / (double)(cpu_run_time);
				pct_complete = std::floor(1000*pct_complete)*0.001;
			}

			// update number_of_output (nstruct) to adjust for cpu run time user preference
			number_of_output = (int)(cpu_run_time / cpu_time_per_nstruct);

			std::cout << "BOINC :: " << utility::timestamp() <<
					" :: cpu_time_pref: " << cpu_run_time <<
					" :: cpu_time: " << cpu_time <<
					" :: cpu_time_per_nstruct: " << cpu_time_per_nstruct << std::endl;

		} else {
			number_of_output = orig_number_of_output;
			pct_complete = (double)(num_decoys)/(double)(total_iterations);
		}
	}
	if (pct_complete > 1) pct_complete = 1;
	if (number_of_output > BOINC_MAX_NSTRUCT) number_of_output = BOINC_MAX_NSTRUCT;
}


bool
boinc_checkpoint_in_main_loop(int & attempted_decoys, int & num_decoys, int & number_of_output, int & farlx_stage)
{
	using namespace boinc_params;
	bool ready_for_boinc_end = false;
	farlx_stage = 0;

	boinc_begin_critical_section();
	checkpoint_decoys(attempted_decoys, num_decoys, farlx_stage);
	update_boinc_params( num_decoys, number_of_output );
	boinc_fraction_done(boinc_params::pct_complete);
	// do not call boinc_checkpoint_completed for the last decoy
	if (num_decoys >= number_of_output || boinc_params::pct_complete >= 1) {
		ready_for_boinc_end = true;
	} else {
		boinc_checkpoint_completed();
	}
	boinc_end_critical_section();
	return ready_for_boinc_end;
}

void rosetta_has_started(){
	boinc_params::rosetta_is_running = true;
}

void rosetta_has_finished(){
	boinc_params::rosetta_is_running = false;
}


// <murphp>

time_t
cross_benchmark()
{
	using numeric::xyzVector;

  //FArray1Da_double xvec(3), yvec(3), zvec(3);
	xyzVector<double> xvec,yvec,zvec;

  double dist;
  time_t t0,t1;
  time(&t0);
  for ( int i = 1; i <= 100; ++i ) {
    xvec[0] = double(i);
    xvec[1] = xvec[1]  + 2.37;
    xvec[2] = xvec[2]  + 17.65;
    for ( int j = 1; j <= 100; ++j ) {
      yvec[0] = double(j);
      yvec[1] = yvec[0] - 19.83;
      yvec[2] = yvec[0] + 34.76;
      zvec = cross(xvec,yvec);
      sqrt(zvec[2]);
    }
  }
  time(&t1);
  return t1-t0;
}

// </murphp>
