// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17056 $
//  $Date: 2007-09-08 19:32:06 -0700 (Sat, 08 Sep 2007) $
//  $Author: csmith $

#ifndef INCLUDED_BOND_ANGLE_H
#define INCLUDED_BOND_ANGLE_H

// Rosetta Headers
#include "after_opts.h"
#include "pack_geom_inline.h"
#include "pose.h"
#include "util_vector.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/ObjexxFCL.hh>

// Numeric Headers
#include <numeric/conversions.hh>

// Utility Headers
#include <utility/vector0.hh>
#include <utility/vector1.hh>


namespace bond_angle {

extern bool initialized;
extern utility::vector1<int> CBpos;
extern utility::vector1<utility::vector0<float> > Ktheta;
extern utility::vector1<utility::vector0<float> > Theta0;
extern utility::vector1<float> Ktheta_bb;
extern utility::vector1<float> Theta0_bb;
extern utility::vector1<float> Energy0_bb;
extern utility::vector1<utility::vector0<float> > thetaCB;
extern utility::vector1<utility::vector0<float> > phiCB;
extern utility::vector1<utility::vector0<float> > thetaHA;
extern utility::vector1<utility::vector0<float> > phiHA;

void
read_bond_angle_params_default();

void
read_bond_angle_params(
	std::string const & filename
);

////////////////////////////////////////////////////////////////////////////////
/// @begin initialize_bond_angle_params
///
/// @brief
/// initialize bond angle parameters if not already initialized
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @return
///
/// @remarks
///
/// @refrences
///
/// @authors Colin A. Smith
///
/// @last_modified March 12, 2007
////////////////////////////////////////////////////////////////////////////////
inline
void
initialize_bond_angle_params()
{
	if (!initialized) {

		std::string param_file("bond_angle_amber_rosetta");
		stringafteroption("bond_angle_params", param_file, param_file);
		if (param_file == "-") {
			read_bond_angle_params_default();
		} else {
			read_bond_angle_params(param_file);
		}
		initialized = true;
	}
}

} // namespace bond_angle


float
get_bond_angleE(
  int const aa, // amino acid type
  int const aav, // amino acid variants
  FArray2Da_float coord // coordinates
);


float
get_bond_angleE_Ep(
  int const aa, // amino acid type
  int const aav, // amino acid variants
  FArray2Da_float coord // coordinates
);


void get_cbha_angles(
	int const aa,
	int const aav,
	float const phiC,
	float & thetaCB,
	float & phiCB,
	float & thetaHA,
	float & phiHA
);


void
get_cbha_angles(
	int const aa,
	int const aav,
	FArray2Da_float coord,
	float & thetaCB,
	float & phiCB,
	float & thetaHA,
	float & phiHA
);


void
print_idealzed_ca_angles(
	std::ostream & out
);


void
precalc_bond_angle_deriv(
	pose_ns::Pose & pose
);


void
bond_angle_deriv_quad(
	pose_ns::Pose & pose,
	kin::Atom const & center_atom,
	utility::vector0<float> & deriv
);


float
bond_angle_deriv(
	pose_ns::Pose & pose,
	kin::Torsion_node const & tor
);

#endif
