// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10263 $
//  $Date: 2006-09-08 13:36:09 -0700 (Fri, 08 Sep 2006) $
//  $Author: chu $

#ifndef INCLUDED_bonds_class
#define INCLUDED_bonds_class

// ROSETTA headers
//#include "shotgun_bonds.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Forward declaration
namespace utility {
	namespace io {
	class izstream;
	}
}

namespace bonds_class {

	class Bonds {
	public:
		// constructors
		Bonds():
			nres_(0)
		{}

		// creates a new object with ideal bonds and angles
		Bonds( const int nres_in ) {
			nres_ = nres_in;
			redimension();
			idealize( 1, nres_ );
		}
		void dump( std::ostream & out ) const;
		void read( utility::io::izstream & data );

		void clear() {nres_=0;}

		void set_nres( int const nres_in );

		// calculate the lengths and angles from a coordinate array
		void calculate(
			int const nres_in,
			FArray3D_float const & Eposition,
			FArray1D_float const & phi,
			FArray1D_float const & psi,
			FArray1D_float const & omega
		);

		//
		FArray1D_bool
		flag_nonideal(
			float const tolerance = 1.0
		);

		// insert ideal bonds in the residue range from start to stop (inclusive)
		void idealize(
			int const start,
			int const stop
		);

		// fix geometry around a cutpoint
		void
		idealize_chainbreak(
			int const cutpoint
		);

		bool
		is_ideal(
			int const seqpos
		) const { return is_ideal( seqpos, seqpos ); }

		bool
		is_ideal(
			int const start,
			int const stop
		) const;



		// copy a stretch from another bonds array
		void copy_segment(
			int const size,
			Bonds const & src,
			int const begin,
			int const src_begin
		);

		// operator=
		Bonds & operator =( Bonds const & src );

		// const accessors
		inline int nres()                             const { return nres_; }
		inline FArray2D_float const & cb_phi_offset() const { return cb_phi_offset_; }
		inline FArray2D_float const & ox_psi_offset() const { return ox_psi_offset_; }
		inline FArray3D_float const & D()             const { return D_;}
		inline FArray3D_float const & cT()            const { return cT_;}
		inline FArray3D_float const & sT()            const { return sT_;}

		friend std::ostream & operator <<( std::ostream & os, const Bonds & b );

	private:
		// call after changes to nres_
		void redimension();
		void idealize_termini();
		void idealize_main_chain();

		int nres_;
		FArray2D_float cb_phi_offset_;
		FArray2D_float ox_psi_offset_;
		FArray3D_float D_;
		FArray3D_float cT_;
		FArray3D_float sT_;
	};


} // namespace bonds_class


// helper routine
void
calculate_bond_info(
	int const total_residue,
	FArray3D_float const & Eposition,
	FArray1D_float const & phi,
	FArray1D_float const & psi,
	FArray1D_float const & omega,
	FArray2D_float & st_cb_phi_offset,
	FArray2D_float & st_ox_psi_offset,
	FArray3D_float & st_D,
	FArray3D_float & st_cT,
	FArray3D_float & st_sT
);


void
build_centroid_n2c(
	int const aa,
	float const phi,
	FArray1Da_float c_xyz,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz,
	FArray1Da_float cen_xyz
);

void
build_centroid_n2c_ncac(
	int const aa,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz,
	FArray1Da_float c_xyz,
	FArray1Da_float cen_xyz
);


#endif
