// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 6493 $
//  $Date: 2005-07-18 11:00:30 -0700 (Mon, 18 Jul 2005) $
//  $Author: huxz $


#ifndef CLUSTER_MUTE_H
#define CLUSTER_MUTE_H

#include <iosfwd>
#include <string>
#include <vector>

class cluster_mutE{
public:
	typedef std::vector< float > Energies;

	//default constructor
	cluster_mutE();

	cluster_mutE( int mutnum_a, std::string mut_type_a,Energies & energy_a);

	//copy constructor
	cluster_mutE(const cluster_mutE& thecluster_mutE);

	//destructor
	~cluster_mutE();

	int mutID() const {return mutID_;} //return the mut ID
	int mutnum() const {return mutnum_;} //return the number of point mutations
	std::string type() const {return mut_type;} //return the mut_type
	float total_energy() const {return energy_[energy_.size() - 1];}//return the total energy
	float each_energy(int i) const{return energy_[i];}//return each single energy
	int number_of_energy_terms() const{ return energy_.size();}//number of energy terms

	cluster_mutE& operator = (const cluster_mutE & p);
  void setcluster_mutE( int mutnum_a,std::string mut_type_a, Energies & energy_a);

private:
	static int n_cluster_;
	int mutnum_;
	int mutID_;
	std::string mut_type;
	Energies energy_;
};


//-----------------------------------NON-MEMBER FUNCIONS---------------

bool operator == ( const cluster_mutE & p1 , const cluster_mutE & p2 );
bool operator != ( const cluster_mutE & p1 , const cluster_mutE & p2 );
bool display_order( const cluster_mutE *p1 , const cluster_mutE *p2 );
std::ostream & operator << ( std::ostream &,const cluster_mutE & );

#endif
