// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17046 $
//  $Date: 2007-09-08 17:44:49 -0700 (Sat, 08 Sep 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_count_pair
#define INCLUDED_count_pair


// Rosetta Headers
#include "aaproperties_pack.h"
#include "disulfides.h"
#include "enzyme_ns.h"
#include "fullatom_id.h"
#include "param_aa.h"
#include "pose_rna_ns.h"
#include "read_aaproperties.h"

// ENZYME
//#ifdef ENZYME
#include "cst_countpair.h"
#include "pose_ligand.h"
#include "runlevel.h"
//#endif

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// C++ Headers
#include <algorithm>

// Forward Declarations
void
cp_table_initializer( FArray2D_float & cp_table );


////////////////////////////////////////////////////////////////////////////////
//\BEGIN count_pair
//
//\BRIEF
//
//\FULL
//
//\PARAM - res1 - in/out -
//\PARAM - atom1 - in/out -
//\PARAM - aa1 - in/out -
//\PARAM - aav1 - in/out -
//\PARAM - res2 - in/out -
//\PARAM - atom2 - in/out -
//\PARAM - aa2 - in/out -
//\PARAM - aav2 - in/out -
//\PARAM - fullatom - in/out -
//
//\RETURN
//
//\GLOBAL_READ
//
//\GLOBAL_WRITE
//
//\NOTES
//
//\COMMENTERS
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
bool
count_pair(
	int const res1,
	int const atom1,
	int const aa1,
	int const aav1,
	int const res2,
	int const atom2,
	int const aa2,
	int const aav2,
	bool const fullatom,
	float & weight
)
{
//bk count pair returns true for atom pairs that should have their
//bk pairwise interactions calculated;  These rules should also
//car be followed by vdw (which does not explicitly call
//car this function because this function uses the full_coord atom
//car numbering scheme, not the position numbering scheme.
//car  ie. n = 1 ca = 2 c = 3 o = 4 cb = 5... (cen = 6)

//bk the current full atom cutoffs are set so that any interaction
//bk that depends on more than the phi and psi angles of one residue
//bk will be counted (there are a few exceptions)

// for i_to_i+1 count_pair, look up a predefined table instead of going
// through many if-else statements. "full" means that they are counted
// normally as before; "half" means that they are >3-bond away but might be
// already implicitly represented in ramachandran table, therefore should be
// down-weighted; "zero" means that they are within 3 bonds and should not
// be counted anyway. In order to look up the table, full atom numbering
// has to be converted to the index numbers shown below.
// Note that centroid mode DOES NOT use this down-weighting scheme and
// return the same count_pair as the old criterion does.
// --Chu

	using namespace aaproperties_pack;
	using namespace param_aa;
	using namespace disulfides::BOUNDARY;

	static float const zero = { 0.0 };
	static float const half = { 0.20 };
	static float const full = { 1.0 };
	static int const cp_atoms = { 8 };
	static FArray2D_float const cp_table( cp_atoms, cp_atoms, cp_table_initializer );

	weight = zero;

	//#ifdef ENZYME
	using namespace cst_countpair_ns;

	//////
	// cst descriptor count pair

	//lin count pair from the constraint
	if( !countpair_poslist.empty() ){
		if( find( countpair_poslist.begin(), countpair_poslist.end(), res1) != countpair_poslist.end() ){
			if(  find( countpair_poslist.begin(), countpair_poslist.end(), res2) != countpair_poslist.end() ){
				int a1( kin::fullatom_index(res1,atom1,aa1,aav1) );
				int a2( kin::fullatom_index(res2,atom2,aa2,aav2) );
				if( find( atompair_list.begin(), atompair_list.end(), std::make_pair( std::min(a1,a2), std::max(a1,a2) ) ) != atompair_list.end() ) {
					if( false && runlevel_ns::runlevel > runlevel_ns::standard ) {
						kin::Fullatom_id tmp1(res1,atom1,aa1,aav1);
						kin::Fullatom_id tmp2(res2,atom2,aa2,aav2);
						std::cout<<"Count_pair from constraints: < "<< tmp1 <<" -- "<< tmp2<<" >"<<std::endl;
					}
					return false;
				}
			}
		}
	}
	//#endif

	/////////////////
	/////////////////
	// Nucleic Acids

	/////////////////
	// rhiju -- RNA/RNA interactions can now be turned on.
	if ( rna_scoring::rna_fullatom && is_RNA(aa1) && is_RNA(aa2) ) {
		if ( res1 == res2 ) {
			return false;
	//Disallow any sugar/backbone interactions in count pair. This is a bit extreme.
		} else if ( rna_scoring::count_pair_ignore_neighbor_backbone &&
								( res1 == res2 + 1 ||  res2 == res1 + 1 ) &&
								(atom1 <= 12 && atom2 <= 12 ) ) {
			return false;
			//Discount atoms connected by alpha or zeta torsions;
			// these torsions should be constrained by empirical dihedral
			// potentials not the crazy Lazaridis-Karplus or Lennard-Jones values!
 		} else if ( res1 == res2 + 1 &&
 								(atom2 == 6 || atom2 == 10 ||
								 (( aa2 == na_rad && atom2 == 26) ||
									( aa2 == na_rgu && atom2 == 27 ) ||
									( aa2 == na_rcy && atom2 == 24 ) ||
									( aa2 == na_ura && atom2 == 24 )) ) && // C4* or C2* or H3*
 								(atom1 == 1 ) ) {
 			return false;
 		} else if ( res1 == res2 + 1 &&
 								(atom2 == 8 ) && // C3*
 								(atom1 == 1 || atom1 == 2 || atom1 == 3 || atom1 == 4) ) {
 			return false;
 		} else if ( res1 == res2 + 1 &&
 								(atom2 == 9 ) && // O3*
 								(atom1 == 1 || atom1 == 2 || atom1 == 3 || atom1 == 4 || atom1 == 5) ) {
 			return false;
 		} else if ( res2 == res1 + 1 &&
 								(atom1 == 6 || atom1 == 10 ||
								 (( aa1 == na_rad && atom1 == 26) ||
									( aa1 == na_rgu && atom1 == 27 ) ||
									( aa1 == na_rcy && atom1 == 24 ) ||
									( aa1 == na_ura && atom1 == 24 )) ) && // C4* or C2* or H3*
 								(atom2 == 1 ) ) {
 			return false;
 		} else if ( res2 == res1 + 1 &&
 								(atom1 == 8 ) && // C3*
 								(atom2 == 1 || atom2 == 2 || atom2 == 3 || atom2 == 4) ) {
 			return false;
 		} else if ( res2 == res1 + 1 &&
 								(atom1 == 9 ) && // O3*
 								(atom2 == 1 || atom2 == 2 || atom2 == 3 || atom2 == 4 || atom2 == 5) ) {
 			return false;
		} else {
			weight = 1.0;
			return true;
		}
	}

	//jjh for now, nucleic acids cannot move, so disallow na-na intx's
	if ( is_NA(aa1) && is_NA(aa2) ) {
		return false;
	}

	//jjh Include all protein-DNA interactions at full strength
	if ( is_NA(aa1) || is_NA(aa2) ) {
		weight = full;
		return true;
	}


	///////////////////
	// Ligand, as an aa
	if ( is_ligand(aa1) || is_ligand(aa2) ) {
		// pb -- handle alternate representation of ligand as an
		// amino acid
		//
		using namespace enable_ligaa_ns;
		if ( res1 == res2 ) {
			//lin  no intra-ligand scoring now, intrares_count_pair should take care it
			return false;//lin
		} else {//lin assuming only LG1 and LG2
			weight = 1.0;
			if( enzyme::read_occ_weights ) {
				if (is_ligand(aa1) ) weight *= lig_iocc_weight(atom1,has_ligand_no(aa1));
				if (is_ligand(aa2) ) weight *= lig_iocc_weight(atom2,has_ligand_no(aa2));
			}

			if( false && runlevel_ns::runlevel > runlevel_ns::standard ) {
				kin::Fullatom_id tmp1(res1,atom1,aa1,aav1);
				kin::Fullatom_id tmp2(res2,atom2,aa2,aav2);
				std::cout<< "Atom_pair [ "<< tmp1 <<" , "<<tmp2<<" ] weight = "<< weight<<std::endl;
			}
			return true;
		}
	}


//bs disulfides -- this must happen _before_ the i,i+3 check!
//bs (1) fullatom: no LJ or solv between side chain atoms (Cb,S) in disulfides
//bs (2) fullatom: count pair false for disulf-bonded HG to any other atom
//bs (3) centroid: for cen-cen, if atom_vdw>nat_minimum_dist,count_pair=false
//bs               same for ca-ca,cb-cb,ca-cen,cb-cen
//bs
//bs the diff numbering schemes drive me nuts -- here is fa numbering for cys
//$$$ATOM     1      N       CYS
//$$$ATOM     2      CA      CYS
//$$$ATOM     3      C       CYS
//$$$ATOM     4      O       CYS
//$$$ATOM     5      CB      CYS
//$$$ATOM     6      SG      CYS
//$$$ATOM     7      H       CYS
//$$$ATOM     8      HA      CYS
//$$$ATOM     9      2HB     CYS
//$$$ATOM    10      3HB     CYS
//$$$ATOM    11      HG      CYS

	if ( aa1 == aa_cys && cys_res_in_disulf(res1) ) {
		//if ( atom1 == LookupByName(aa1, aav1, " HG ") ) return false;
		// HG does not exist if disulf bond present
		//apl LookupByName disasterously slow if any disulfides present.
		if ( fullatom )
		{
			int atom1_temp(atom1);
			if ( variant_type( aav_Cterm, aa1, aav1 ) && atom1_temp > 8 ) --atom1_temp;
			else if ( variant_type( aav_Nterm, aa1, aav1 ) && atom1_temp > 9 ) atom1_temp-=2;

			if ( atom1_temp == 11 ) return false;
		}
		if ( cys_pair_in_disulf(res1,res2) ) {
			if ( fullatom ) {
				int atom1_temp(atom1);
				int atom2_temp(atom2);
				if ( variant_type( aav_Cterm, aa2, aav2 ) && atom2_temp > 8 ) --atom2_temp;
				else if ( variant_type( aav_Nterm, aa2, aav2 ) && atom2_temp > 9 ) atom2_temp-=2;
				if ( variant_type( aav_Cterm, aa1, aav1 ) && atom1_temp > 8 ) --atom1_temp;
				else if ( variant_type( aav_Nterm, aa1, aav1 ) && atom1_temp > 9 ) atom1_temp-=2;
//bs S-all is F except S-0 and S-H
				if ( atom1_temp == 6 && atom2_temp != 4 && atom2_temp != 7 ) return false;
				if ( atom2_temp == 6 && atom1_temp != 4 && atom1_temp != 7 ) return false;
//bs Ca-Cb, Cb-Ca
				if ( ( atom1_temp == 2 && atom2_temp == 5 ) || ( atom1_temp == 5 && atom2_temp == 2 ) )
				 return false;
//bs Cb-Cb, Cb-2Hb, Cb-3Hb, 2Hb-2Hb, 2Hb-3Hb -- all False
				if ( ( atom1_temp == 5 || atom1_temp >= 9 ) && ( atom2_temp == 5 || atom2_temp >= 9 ) )
				 return false;
//bs Cb-HA
				if ( ( atom1_temp == 5 && atom2_temp == 8 ) || ( atom2_temp == 5 && atom1_temp == 8 ) )
				 return false;
			} else if ( AtomVdwDisulfNativeClash(atom1,atom2) ) {
				return false; // centroid mode, if atom_vdw>nat_minimum_dist, F
			}
		}
	}
//bs HG for res2 not exist in disulf bond
	if ( fullatom && aa2 == aa_cys && cys_res_in_disulf(res2) )
	{
		//&& atom2 == LookupByName(aa2, aav2, " HG ") ) return false;
		//apl LookupByName disaterously slow if any disulfides present;
		// HG does not exist if disulf bond present
		int atom2_temp(atom2);

		if ( variant_type( aav_Cterm, aa2, aav2 ) && atom2_temp > 8 ) --atom2_temp;
		else if ( variant_type( aav_Nterm, aa2, aav2 ) && atom2_temp > 9 ) atom2_temp-=2;

		if ( atom2_temp == 11 ) return false;
	}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// some backbone-backbone pairs are implicitly counted in the ramachandran
//  table and so are not counted when computing LJ scores:
//  atom pairs whose relative positions depend only on the phi and/or psi
//  of a single residue + no more than one adjacent omega angle are NOT
//  counted when summing LJ interactions
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

//km Res1 and Res2 can be in any order

	if ( res1 == res2 ) { //car i,i  (intra-residue) //car count no pairs

		return false; //chu should we add intrares_count_pair????

	} else if ( res1 < res2 ) {

//car i,i+3 and greater
//car count all pairs
//$$$		if ( res2 - res1 != 1 ) return false;
		if ( res2 - res1 > 2 ) {
			weight = full;
			return true;
		}

		if ( res2 - res1 == 2 ) {
			if ( atom1 == 3 && atom2 == 1 ) {
				weight = half;
				return fullatom;
			} else {
				weight = full;
				return true;
			}
		}

//chu i to i+1
		if ( fullatom ) { // fullatom
			int atom2_cp = atom2;
			if ( aa2 == aa_pro ) { // i+1 is PRO: NOT count some pairs
				if ( variant_type( aav_Cterm, aa2, aav2 ) && atom2_cp > 8 ) atom2_cp--;
				else if ( variant_type( aav_Nterm, aa2, aav2 ) && atom2_cp > 9 ) atom2_cp-=2;
				if ( atom2_cp == 7 ) { //atom_name(atom2, aa2, aav2) == " CD " ) {
					atom2_cp = 2; // Assume CD as CA
				} else if ( atom2_cp == 8 || atom2_cp == 9 ) //atom_name(atom2, aa2, aav2) == "1HD " ||
										//atom_name(atom2, aa2, aav2) == "2HD " ||
										//atom_name(atom2, aa2, aav2) == "3HD " )
				{ // 8,9 // pdb convention
					atom2_cp = 8; // Assume HD as HA
				} else {
					atom2_cp = cp_atom_num(atom2,aa2,aav2);
				}
			} else {
				atom2_cp = cp_atom_num(atom2,aa2,aav2);
			}
			weight = cp_table(cp_atom_num(atom1,aa1,aav1),atom2_cp);
			return ( weight != zero );
		} else {
			weight = cp_table(atom1,atom2);
			return ( weight == full );
		}

	} else { // res1 > res2

//car i,i+3 and greater
//car count all pairs
//$$$		if ( res1 - res2 != 1 ) return false;
		if ( res1 - res2 > 2 ) {
			weight = full;
			return true;
		}

		if ( res1 - res2 == 2 ) {
			if ( atom2 == 3 && atom1 == 1 ) {
				weight = half;
				return fullatom;
			} else {
				weight = full;
				return true;
			}
		}

//chu i to i+1
		if ( fullatom ) { // fullatom
			int atom1_cp = atom1;
			if ( aa1 == aa_pro ) { // i+1 is PRO: NOT count some pairs
				if ( variant_type( aav_Cterm, aa1, aav1 ) && atom1_cp > 8 ) atom1_cp--; // shift back 1 atom
				else if ( variant_type( aav_Nterm, aa1, aav1 ) && atom1_cp > 9 ) atom1_cp-=2;
				if ( atom1_cp == 7 ){ //atom_name(atom1, aa1, aav1) == " CD " ) { //7
					atom1_cp = 2; // Assume CD as CA
				} else if ( atom1_cp == 8 || atom1_cp == 9 ) //atom_name(atom1, aa1, aav1) == "1HD " ||
										//atom_name(atom1, aa1, aav1) == "2HD " ||
										//atom_name(atom1, aa1, aav1) == "3HD " )
				{ // 8,9
					atom1_cp = 8; // Assume HD as HA
				} else {
					atom1_cp = cp_atom_num(atom1,aa1,aav1);
				}
			} else {
				atom1_cp = cp_atom_num(atom1,aa1,aav1);
			}
			weight = cp_table(cp_atom_num(atom2,aa2,aav2),atom1_cp);
			return ( weight != zero );
		} else {
			weight = cp_table(atom2,atom1);
			return ( weight == full );
		}

	}

}


#endif
