// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_count_pair_position
#define INCLUDED_count_pair_position


// Rosetta Headers
#include "count_pair.h"
#include "minimize.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// C++ Headers
#include <iostream>


inline
void
minimize_reorder_initializer( FArray1D_int & reorder )
{
	reorder( 1 ) = 1;
	reorder( 2 ) = 2;
	reorder( 3 ) = 5;
	reorder( 4 ) = 3;
	reorder( 5 ) = 4;
}


////////////////////////////////////////////////////////////////////////////////
//\BEGIN count_pair_position
//
//\BRIEF
//
//\FULL
//
//\PARAM - res1 - in/out -
//\PARAM - atom1 - in/out -
//\PARAM - aa1 - in/out -
//\PARAM - res2 - in/out -
//\PARAM - atom2 - in/out -
//\PARAM - aa2 - in/out -
//
//\RETURN
//
//\GLOBAL_READ
//
//\GLOBAL_WRITE
//
//\NOTES
//
//\COMMENTERS
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
bool
count_pair_position(
	int res1,
	int atom1,
	int aa1,
	int res2,
	int atom2,
	int aa2
)
{
//bs count_pair function for scoring functions relying on the position
//car array (ie vdw_compute)

//bs Inputs a pair of residue numbers,atom numbers, & amino acid types
//car Returns bool indicating if this atom pair should count in
//car the scoring functions

//car atom1 and atom2 are the atom_type numbers NOT the indices
//car into the position array!!  They are assumed to be numbered in the
//car same order as the position array (with the exception of Gly CB)

//bs The inputs atom1 & atom2 are converted
//bs to fullcoord numbering scheme before calling count_pair.

//bs local
	static FArray1D_int const reorder( 5, minimize_reorder_initializer );
	 // reorder(i) maps cent->fa numbering

	//// fixed aav parameters
//	static int const aav1 = { 1 };
//	static int const aav2 = { 1 };

//bs use reorder to convert numbering scheme for atom1,atom2
//bs inputs here have Eposition ordering:     (N=1,Ca=2,Cb=3,C=4,O=5)
//bs but count_pair inputs must use the full_coord atom ordering:
//bs                                          (N=1,Ca=2,C=3,O=4,Cb=5)
	// (e.g. i=3 gets 5 (Cb))
//------------------------------------------------------------------------------
	if ( atom1 == 0 ) return false; // gly cbetas;
	if ( atom2 == 0 ) return false;
//car check to see if position atom indicies were sent instead of atom_types
	if ( atom1 == 3 && aa1 == 6 ) {
		std::cerr << "ERROR:: gly CB has atom type=3 " << res1 << '\n';
		assert(false);
		return false;
	}
	if ( atom2 == 3 && aa2 == 6 ) {
		std::cerr << "ERROR:: gly CB has atom type=3 " << res2 << '\n';
		assert(false);
		return false;
	}

//bs convert atom1->atom1_fa, atom2->atoms2_fa
// atom number in fullcoord ordering: =1-5 for atoms, =6 for centroid
	int const atom1_fa = ( atom1 >= 6 ? 6 : reorder(atom1) );
	int const atom2_fa = ( atom2 >= 6 ? 6 : reorder(atom2) );

//bs return result of count_pair
	float cp_weight;
	return count_pair(res1,atom1_fa,aa1,1,res2,atom2_fa,aa2,1,false,cp_weight);
}


#endif
