// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10781 $
//  $Date: 2006-10-18 11:52:09 -0700 (Wed, 18 Oct 2006) $
//  $Author: sraman $

#ifndef INCLUDED_crankshaft
#define INCLUDED_crankshaft


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// Types
typedef  float (*Scoring_Function)();


// crankshaft Function Declarations


void
choose_crankshaft(
	int & minfrag_begin1,
	int & maxfrag_begin1,
	int & minfrag_begin2,
	int & maxfrag_begin2,
	int size, // size of frag to insert
	int & delta // spacing/size of each region
);


void
find_closest_maxima(
	int & first_try,
	int & maxima1,
	int & maxima2
);


void
find_closest_loop(
	int & first_try,
	int & loop
);


void
fragment_diversity();


int
dihedral_bin(
	int const width,
	int const minimum,
	float const angle
);


void
crankshaft_move(
	int size,
	float cutoff_max,
	int nwobble1,
	int nwobble2,
	int & crank_begin,
	int & crank_end,
	float & wobble_cost,
	float & bump_score,
	bool & gfrag // if true, powell minimized sucessfully
);


void
main_crank_trial(
	int size,
	float cutoff_max,
	Scoring_Function score_fxn,
	int & cycle_number,
	int nwobble1,
	int nwobble2
);


void
main_crank_min_trial(
	int size,
	float cutoff_max,
	Scoring_Function score_fxn,
	int & cycle_number,
	int nwobble1,
	int nwobble2,
	std::string const & type
);


int
choose_double(
	int & minfrag_begin1,
	int & maxfrag_begin1,
	int & minfrag_begin2,
	int & maxfrag_begin2,
	int size1, // size of insertion in region 1
	int size2, // size of insertion in region 2
	int delta, // size of each region (maxbegin-minbegin+1) = 2*delta +1
	int min_spacing, // min # of unmodified residues between two modified regions
	int max_spacing  // max # of unmodified residues between two modified regions
	                 // max not guaranteed--depends on method used to select site2
);

bool
choose_crankshaft_trial(
	int & maxsites,
	int & minfrag_begin1,
	int & maxfrag_begin1,
	int & minfrag_begin2,
	int & maxfrag_begin2,
	int size1, // size of insertion in region 1
	int size2, // size of insertion in region 2
	int delta, // size of each region (maxbegin-minbegin+1) = 2*delta +1
	int min_spacing, // min # of unmodified residues between two modified regions
	int max_spacing  // max # of unmodified residues between two modified regions
									 // max not guaranteed--depends on method used to select site2
);

bool
use_new_crankshaft();
#endif
