// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7523 $
//  $Date: 2006-02-20 15:10:59 -0800 (Mon, 20 Feb 2006) $
//  $Author: jiangl $

//////////////////////////////////////////////
#ifndef INCLUDED_cst_allow_move
#define INCLUDED_cst_allow_move

// Rosetta Headers
#include "cst_set.h"
#include "fullatom_id.h"
#include "pose_fwd.h"

// ObjexxFCL Headers


// C++ Headers

//////////////////////////////////
//lin  the Cst_allow_move object holds data which is used to define the
//lin  pose allow move and conformation from the constraint
//

namespace cst_allow_move_ns {

	struct Distance_atoms {
		kin::Fullatom_id atom1;
		kin::Fullatom_id atom2;
		float dis, dis_sd;
		int conf_N;
	};

  struct Angle_atoms {
    kin::Fullatom_id atom1;
    kin::Fullatom_id atom2;
    kin::Fullatom_id atom3;
		float ang, ang_sd;
		int conf_N, ang_N;
  };

  struct Torsion_atoms {
    kin::Fullatom_id atom1;
    kin::Fullatom_id atom2;
    kin::Fullatom_id atom3;
    kin::Fullatom_id atom4;
		float tor, tor_sd;
		int conf_N, tor_N;
  };


  //lin method for set_allow_move
  void set_bond_length_allow_move(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2
    );

  void set_bond_angle_allow_move(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2,
    kin::Atom_id const & a3
    );

  void set_torsion_angle_allow_move(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2,
    kin::Atom_id const & a3,
    kin::Atom_id const & a4
    );

  //lin method for bond length, angle and torsion
  void set_bond_length(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2,
		float dis
    );

  void set_bond_angle(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2,
    kin::Atom_id const & a3,
		float ang
    );

  void set_torsion_angle(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2,
    kin::Atom_id const & a3,
    kin::Atom_id const & a4,
		float tor
    );


  class Allow_move_set {
  public:
    Allow_move_set() {
			erase();
		}

		void erase() {
			dis_allow_move_.clear();
			angle_allow_move_.clear();
			torsion_allow_move_.clear();
			conf_index_ = 0;
			conf_counter_ =0;
			conf_dimension_list_.clear();
		}

		void add_distance_atoms(
			kin::Fullatom_id const & atom1,
			kin::Fullatom_id const & atom2,
			float dis, float dis_sd, int conf_N
		) {
			Distance_atoms a;
			a.atom1=atom1;
			a.atom2=atom2;
			a.dis=dis;
			a.dis_sd=dis_sd;
			a.conf_N=conf_N;
			dis_allow_move_.push_back(a);
		};

    void add_angle_atoms(
      kin::Fullatom_id const & atom1,
      kin::Fullatom_id const & atom2,
      kin::Fullatom_id const & atom3,
			float ang, float ang_sd, int conf_N, int ang_N
	 ) {
      Angle_atoms a;
      a.atom1=atom1;
      a.atom2=atom2;
      a.atom3=atom3;
			a.ang=ang;
			a.ang_sd=ang_sd;
			a.conf_N=conf_N;
			a.ang_N=ang_N;
      angle_allow_move_.push_back(a);
    };

    void add_torsion_atoms(
      kin::Fullatom_id const & atom1,
      kin::Fullatom_id const & atom2,
      kin::Fullatom_id const & atom3,
      kin::Fullatom_id const & atom4,
			float tor, float tor_sd, int conf_N, int tor_N
		) {
      Torsion_atoms a;
      a.atom1=atom1;
      a.atom2=atom2;
      a.atom3=atom3;
      a.atom4=atom4;
			a.tor=tor;
			a.tor_sd=tor_sd;
			a.conf_N=conf_N;
			a.tor_N=tor_N;
      torsion_allow_move_.push_back(a);
    };

		void set_pose_allow_move( pose_ns::Pose & pose ) const;

		/////////////////////////////////////////////////////////////////////////////
		void conformer( pose_ns::Pose & pose );
		int conformer_counter( pose_ns::Pose & pose );

		friend std::ostream& operator<< ( std::ostream& s, const Allow_move_set& d );

  private:
    std::vector< Distance_atoms > dis_allow_move_;
    std::vector< Angle_atoms > angle_allow_move_;
		std::vector< Torsion_atoms > torsion_allow_move_;
		int conf_index_;
		int conf_counter_;
		std::vector< int > conf_dimension_list_;

  };


}//namespace cst_allow_move_ns

#endif
