// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7523 $
//  $Date: 2006-02-20 15:10:59 -0800 (Mon, 20 Feb 2006) $
//  $Author: jiangl $

//////////////////////////////////////////////
#ifndef INCLUDED_cst_packer
#define INCLUDED_cst_packer

// Rosetta Headers
#include "cst_set.h"
#include "fullatom_id.h"

// ObjexxFCL Headers


// C++ Headers

//////////////////////////////////
//lin  the Packer_cst object holds data which is used to define the
//lin  constraint set contacting with the packer
//

namespace packer_cst_ns {

  ////////////////////////////////
  //  Rsd_rsd_cst constraint
  ////////////////////////////////
  // residue residue pair constraint: distance, angle, torsion cst
  // Lin Jiang

	// number constraint types
	const size_t number_cst_types_ = 3;
 	// constraint type
	enum Cst_type { DISTANCE_CST, ANGLE_CST, TORSION_CST };

  class Rsd_rsd_cst {
  public:
		//lin Assumption to make the constraint to use the packer FArray2D_float array:
		//lin in virtual score function for packer score( FArray3D_float const & coord )
		//lin       the FArray3D_float is combining two residue coords FArray2D_float( 3,MAX_ATOM() )
		//lin       the first res1, the second res2, and res1 <=res2
		//lin  atomno1() and atomno2() is key atom id, and I assume atom1 < atom2

    virtual
		float score( kin::Coords const & coords ) const = 0; // virtual score method for fullatom scoring

    virtual
		float score( FArray3D_float const & coord ) const = 0; // virtual score method for packer

		virtual
		void show( std::ostream& s ) const =0;

		virtual
		Cst_type cst_type() const = 0; // get the constraint type

		virtual
		int
		atomno1() const = 0;

		virtual
		int
		atomno2() const = 0;

		virtual
		void take_input_value( pose_ns::Pose & pose )  = 0;

		Rsd_rsd_cst() { }; //

		virtual
		~Rsd_rsd_cst() { owner_count=0; }; //

		int owner_count;
  };

  class Rsd_rsd_distance_cst : public Rsd_rsd_cst {
  public:

		// residue-residue cst scoring
    virtual
		float score( kin::Coords const & coords ) const; // virtual score method for fullatom scoring

		virtual
    float score( FArray3D_float const & coord ) const;// virtual score method for packer

		virtual
		void show( std::ostream& s ) const;

		virtual
		Cst_type cst_type() const { return DISTANCE_CST; }; // get the constraint type

		virtual
		int atomno1() const;

		virtual
		int atomno2() const ;

		virtual
		void take_input_value( pose_ns::Pose & pose );

    Rsd_rsd_distance_cst(
			 kin::Atom_id const & a1,
			 kin::Atom_id const & a2,
			 cst_set_ns::Cst const & cst_in
			 ) { assign( a1, a2, cst_in ); };

		void assign(
       kin::Atom_id const & a1,
			 kin::Atom_id const & a2,
			 cst_set_ns::Cst const & cst_in );


		kin::Atom_id atom1, atom2;
		cst_set_ns::Cst cst_set; //distance constraint

	private:
		// lin the mapping of key atoms which residue belongs to
		// lin Attention: using FAarray index( 1: coord1, 2: coord2 )
		int atomno1_, atomno2_;
		int index1_, index2_;

  };

  class Rsd_rsd_angle_cst : public Rsd_rsd_cst {
  public:

		// residue-residue cst scoring
    virtual
		float score( kin::Coords const & coords ) const; // virtual score method for fullatom scoring

		virtual
    float score( FArray3D_float const & coord ) const;// virtual score method for packer

		virtual
		Cst_type cst_type() const { return ANGLE_CST; }; // get the constraint type

		virtual
		void show( std::ostream& s ) const;

		virtual
		int atomno1() const ;

		virtual
		int atomno2() const ;

		virtual
		void take_input_value( pose_ns::Pose & pose );

    Rsd_rsd_angle_cst( cst_set_ns::Angle_cst const & cst_set_in );

		cst_set_ns::Angle_cst cst_set; //angle constraint

	private:
		// lin the mapping of atoms which residue belongs to
		// lin Attention: using FAarray index( 1: coord1, 2: coord2 )
		int index1_,index2_,index3_;
		int atomno1_, atomno2_, atomno3_;

  };

  class Rsd_rsd_torsion_cst : public Rsd_rsd_cst {
  public:

 		// residue-residue cst scoring
    virtual
		float score( kin::Coords const & coords ) const; // virtual score method for fullatom scoring

		virtual
    float score( FArray3D_float const & coord ) const;// virtual score method for packer

		virtual
		Cst_type cst_type() const { return TORSION_CST; }; // get the constraint type

		virtual
		void show( std::ostream& s ) const;

		virtual
		int atomno1() const;

		virtual
		int atomno2() const ;

		virtual
		void take_input_value( pose_ns::Pose & pose );

    Rsd_rsd_torsion_cst( cst_set_ns::Torsion_cst const & cst_set_in );

		cst_set_ns::Torsion_cst cst_set;//torsion constraint

	private:
		// lin the mapping of atoms which residue belongs to
		// lin Attention: using FAarray index( 1: coord1, 2: coord2 )
		int index1_, index2_, index3_, index4_;
		int atomno1_, atomno2_, atomno3_, atomno4_;

  };


  ////////////////////////////////
  //  packer constraint
  ////////////////////////////////
  // set up constraint for packer
  // Lin Jiang

	typedef std::vector< Rsd_rsd_cst* > Rsd_cst_plist;

	class Group_rsd_rsd_cst {
  public:

		float get_best_score_cst(
            kin::Coords const & coords,
						std::vector<Rsd_rsd_cst*> & best_cst_plist,
						bool const if_score ) const ;

		float best_packer_score(
						int const aa1, int const aav1,
						int const aa2, int const aav2,
						FArray3D_float const & coord1,
						bool const bb1, bool const sc1,
						bool const bb2, bool const sc2
						) const ;

		Group_rsd_rsd_cst() { };
		~Group_rsd_rsd_cst() { clear(); };

		bool is_ambiguous_cst() const;

		inline void clear() {
			for ( int ii=0, ie=group_cst_plist_.size(); ii<ie; ++ii ) {
				// it is danger to deletes all pointers, since other class share the same Rsd_rsd_cst
				for( int jj=0, je=group_cst_plist_[ii].size(); jj<je; ++jj ) {
					Rsd_rsd_cst* it ( group_cst_plist_[ii][jj] );
					it->owner_count--;
					if( it->owner_count == 0 ) delete it;
				}
				group_cst_plist_[ii].clear();
			}
			group_cst_plist_.clear();
		}

		void insert( std::vector<Rsd_rsd_cst*> const & rsd_cst_plist, bool ambiguous_cst );

		void insert( Rsd_rsd_cst* const  & rsd_cst_p );

		Group_rsd_rsd_cst &
		collect( Group_rsd_rsd_cst const & other_cst );

		void show( std::ostream & s ) const ;

		inline std::vector < Rsd_cst_plist > & cst_list()
		{ return group_cst_plist_; }

	private:
		std::vector < Rsd_cst_plist > group_cst_plist_;
	};

	// define the data type
	typedef std::pair<int,int> Rsd_pair;
	typedef std::pair< std::pair<int,int>, std::pair<int,int> > Aa_aav_pair;
	typedef std::vector< Group_rsd_rsd_cst* > Group_cst_plist;
	typedef std::map< Aa_aav_pair, Group_cst_plist > Cst_rsd_map;
	typedef std::map< Rsd_pair, Cst_rsd_map > Cst_rsd_map_map;

  class Packer_cst_set {
  public:

		Packer_cst_set() { packer_cst_weight=1; rsd_cst_set.clear(); };

		~Packer_cst_set() { packer_cst_weight=0; clear(); };

		void
		clear(); // deletes all pointers


    ///////////////////////////////////////////////////////////////////////////
    //lin add RSD_RSD constraints
    void
    add_distance_constraint(
				kin::Fullatom_id const & atom1,
				kin::Fullatom_id const & atom2,
				float const r0_in,
				float const r_sd_in,
				float const weight_in ) ;

    void
    add_angle_constraint(
				kin::Fullatom_id const & atom1,
				kin::Fullatom_id const & atom2,
				kin::Fullatom_id const & atom3,
				float const theta0_in,
				float const theta_sd_in,
				float const periodic_value_in,
				float const weight_in )	;

    void
    add_torsion_constraint(
	      kin::Fullatom_id const & atom1,
				kin::Fullatom_id const & atom2,
				kin::Fullatom_id const & atom3,
				kin::Fullatom_id const & atom4,
				float const theta0_in,
				float const theta_sd_in,
				float const periodic_value_in,
				float const weight_in,
				std::string const & func_name = "HARMONIC") ;

    void
    add_distance_constraint(
				pose_ns::Pose const & pose,
				kin::Atom_id const & atom1,
				kin::Atom_id const & atom2,
				cst_set_ns::Cst const & cst  ) ;

    void
    add_angle_constraint(
				pose_ns::Pose const & pose,
				cst_set_ns::Angle_cst cst )	;

    void
    add_torsion_constraint(
	      pose_ns::Pose const & pose,
				cst_set_ns::Torsion_cst const & cst ) ;

    void
    add_rr_constraint(
				kin::Fullatom_id const & atom1,
				kin::Fullatom_id const & atom2,
				Rsd_rsd_cst* const & rr_cst_p,
				bool cst_ambiguous_group = false );

		void
		add_rr_constraint_list(
        kin::Fullatom_id const & atom1,
				kin::Fullatom_id const & atom2,
				std::vector< Rsd_rsd_cst* > const & cst_plist,
				bool cst_ambiguous_group = false );

    float
    get_res_res_cstE(
			 int const res1,
			 int const res2,
			 int const aa1,
			 int const aav1,
			 int const aa2,
			 int const aav2,
			 FArray2Da_float coord1,
			 FArray2Da_float coord2,
			 bool const bb1,
			 bool const sc1,
			 bool const bb2,
			 bool const sc2
			 ) const;

    float
    get_rsd_pair_cstE(
			 Rsd_pair const & rsd_pair,
			 int const aa1,
			 int const aav1,
			 int const aa2,
			 int const aav2,
			 FArray2Da_float coord1,
			 FArray2Da_float coord2,
			 bool const bb1,
			 bool const sc1,
			 bool const bb2,
			 bool const sc2
			 ) const;

    float
    get_cstE( pose_ns::Pose const & pose ) const ;

		void
		get_cst_set(
			pose_ns::Pose const & pose,
			cst_set_ns::Cst_set & cst,
			bool keep_cst_sd = true,
			bool keep_cst = false
			) const ;

		cst_set_ns::Cst_set &
		cst_set() ;

		// method to assume another packer constraints
		Packer_cst_set &
		collect( Packer_cst_set const & other_cst );

		void
		cst_take_input_value( pose_ns::Pose & pose );

		void clean_up();

    friend std::ostream& operator<< ( std::ostream& s, const Packer_cst_set& d );

		Cst_rsd_map_map rsd_cst_set;
		float packer_cst_weight;

	private:
		//pointer
		cst_set_ns::Cst_set * cst_set_;
  };

}//namespace packer_cst_ns

#endif
