// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10422 $
//  $Date: 2006-09-26 21:14:01 -0700 (Tue, 26 Sep 2006) $
//  $Author: pbradley $

// Rosetta Headers
#include "current_packer_cst.h"

// C++ Headers
#include <cassert>
#include <cstdlib>
#include <iostream>
#include <utility>

//Utility Headers
#include <utility/basic_sys_util.hh>

///////////////////////////////////////////////////////////////////////////////
namespace current_pack_cst_set {
    packer_cst_ns::Packer_cst_set  * packer_cst(0);
}

// set
void
pack_set_current_cst_set(
	packer_cst_ns::Packer_cst_set & packer_cst
)
{
  assert( current_pack_cst_set::packer_cst == 0 );
  current_pack_cst_set::packer_cst = &packer_cst;
}

// get
packer_cst_ns::Packer_cst_set &
pack_get_current_cst_set(
)
{
  if ( current_pack_cst_set::packer_cst == 0 ) {
    std::cout << "pack_get_current_cst_set called with uninit packer_cst" <<
      std::endl;
    assert(false);
    utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }
  return *(current_pack_cst_set::packer_cst);
}

// check
bool
pack_check_current_cst_set(
)
{
  return ( current_pack_cst_set::packer_cst != 0 );
}

// reset
void
pack_reset_current_cst_set(
)
{
  current_pack_cst_set::packer_cst  = 0;
}

