// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 19866 $
//  $Date: 2008-01-23 11:54:04 -0800 (Wed, 23 Jan 2008) $
//  $Author: possu $

#include "decoy_features.h"

#include "aaproperties_pack.h"
#include "after_opts.h"
#include "are_they_neighbors.h"
#include "atom_is_backbone.h"
#include "cenlist.h"
#include "constraints.h"
#include "counters.h"
#include "decoystats.h"
#include "decoystats_ns.h"
#include "design.h"
#include "dipolar.h"
#include "docking.h"
#include "etable.h"
#include "files_paths.h"
#include "fragments.h"
#include "fragments_ns.h"
#include "fullatom.h"
#include "namespace_fullatom_flag.h"
#include "fullatom_energy.h"
#include "fullatom_energies.h"
#include "fullatom_sasa.h"
#include "hbonds.h"
#include "hbonds_ns.h"
#include "initialize.h"
#include "ligand.h"
#include "ligand_ns.h"
#include "make_pdb.h"
#include "maxsub.h"
#include "maxsub_threshold.h"
#include "misc.h"
#include "monte_carlo.h" // yab: misc removal
#include "native.h"
#include "namespace_options.h"
#include "orient_rms.h"
#include "output_decoy.h"
#include "pack_fwd.h"
#include "packing_measures.h"
#include "param.h"
#include "param_aa.h"
#include "pdb.h"
#include "pdbstatistics_pack.h"
#include "pdbstats.h"
#include "pdbstats_ns.h"
#include "pose.h"
#include "pose_io.h"
#include "pose_rms.h"
#include "read_aa_ss.h"
#include "read_paths.h"
#include "score_ns.h"
#include "start.h"
#include "status.h"
#include "T32S3.h"
#include "template_pack.h"
#include "util_basic.h"
#include "util_vector.h"
#include "void.h"
#include "void_ns.h"
#include "water.h"
//KMa phospho_ser
#include "add_pser.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// Numeric Headers
#include <numeric/constants.hh>

// Utility Headers
#include <utility/vector1.hh>
#include <utility/vector1.fwd.hh>
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <vector>
#include <map>


int DF_MAX_BINS = 10000;
int DF_MAX_QUANTILE = 101;

using namespace std;
using namespace decoy_features_ns;
using namespace pose_ns;
using namespace misc;
using namespace param;

namespace decoy_features_ns {

	using namespace packing_ns;

DecoyFeatures nativeDF;
DecoyFeatures currentDF;
bool   df_flag_ = false;
string decoy_features_mode = "none";
EnergyQuantileData *  atrEQ = NULL;
EnergyQuantileData *  repEQ = NULL;
EnergyQuantileData *  solEQ = NULL;
EnergyQuantileData *   hbEQ = NULL;
EnergyQuantileData *intraEQ = NULL;
EnergyQuantileData * pairEQ = NULL;
EnergyQuantileData * probEQ = NULL;
EnergyQuantileData *  spkEQ = NULL;
EnergyQuantileData *  tljEQ = NULL;
EnergyQuantileData *  resEQ = NULL;
EnergyQuantileData *  dunEQ = NULL;
BuriedPolarData    * bpdata = NULL;
//KMa phospho_ser
FArray1D_float rsd_max_sasa( MAX_AA_PLUS() );

string BPLOG = "";

map<string,bool> df_flags;
string df_decoy_name_ = "null_decoy_name";

packing_ns::ProteinSasa * df_protein_sasa_ = NULL;

string df_hetero_atoms_;
FArray2D_float df_bfactor_  (MAX_ATOM(),MAX_RES(),-123.0);
FArray2D_float df_occupancy_(MAX_ATOM(),MAX_RES(),-123.0);

utility::io::ozstream * df_packing_stats_out_ = NULL;

//////////////////////////////////////////////////////////////////////
/// @begin decoy_features_initialize
///
/// @brief
/// checks for decoyfeatures mode and reads data files
///
/// @detailed
/// TODO: fill me in!
///
/// @global_read None
///
/// @global_write None
///
/// @remarks
/// TODO: fill me in!
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

void decoy_features_initialize() {

	set_df_flag(truefalseoption("decoyfeatures"));

  static bool use_t32s3( truefalseoption("t32s3") );
	if ( use_t32s3 ) {
    score_file_ns::use_new_columns = true;
    score_file_ns::new_float_cols["t32s3"] = -1.0f;
  }
	//////////// this is the new modular system... add recognized modes below
	df_flags["score"]       = false;
	df_flags["make_packing_pdb"] = false;
	df_flags["packing_fasc_cols"] = false;
	df_flags["pruned_packing_score"] = false;
	df_flags["packing_stats"] = false;
	df_flags["rms_matrix"] = false;
	df_flags["file"] = false;
	for( int ii=0; ii < options::arg_count; ii++ ) {
		string arg = options::arg_vector[ii];
		//cout << arg << " '" << arg.substr(0,4) << "'" << endl;
		if( arg.substr(0,4) == "-df_" ) {
			//cout << "df_" << arg << endl;
			arg = arg.substr(4);
			if( df_flags.count(arg) ) {
				cout << "decoy_features.cc: enabling option " << arg << endl;
				df_flags[arg] = true;
				//set_df_flag(true);
			} else {
				cout << "decoy_features.cc: no option " << arg << " exiting..." << endl;
				exit(-1);
			}
		}
	}

	if ( df_flags["packing_stats"] ) {
		string tmp;
		if( truefalseoption("l") )
			tmp = stringafteroption("l");
		else if( truefalseoption("s") )
			tmp = stringafteroption("s");
		else
			tmp = "dummy_name";
		strip_path(tmp,tmp);
		string fname = (files_paths::pdb_out_path+tmp+"_packing_stats.data");
		cout << "PACKING: DF writting packing stats to " << fname << endl;
		df_packing_stats_out_ = new utility::io::ozstream( fname.c_str() );
	}

	if ( df_flags["packing_fasc_cols"] ) {
		cout <<  "decoyfeatures: output new packing fasc cols" << endl;
		score_file_ns::use_new_columns = true;
	}


	if ( df_flags["rms_matrix"] ) {
		//df_compute_gdtmm_matrix();
		exit(0);
	}

	if( get_df_flag() ) {

		if ( truefalseoption("df_file") || truefalseoption("t32s3") ) {
			score_file_ns::use_new_columns = true;
			score_file_ns::new_float_cols["t32s3"] = -1;
			score_file_ns::new_float_cols["sasapack"] = -1;
		}

		atrEQ   = new EnergyQuantileData("energy_quantile__atre__aa_ss_sf_nb.data");
		repEQ   = new EnergyQuantileData("energy_quantile__repe__aa_ss_sf_nb.data");
		tljEQ   = new EnergyQuantileData("energy_quantile__tlje__aa_ss_sf_nb.data");
		solEQ   = new EnergyQuantileData("energy_quantile__sole__aa_ss_sf_nb.data");
		hbEQ    = new EnergyQuantileData("energy_quantile__hbe__aa_ss_sf_nb.data");
		intraEQ = new EnergyQuantileData("energy_quantile__intrae__aa_ss_sf_nb.data");
		pairEQ  = new EnergyQuantileData("energy_quantile__paire__aa_ss_sf_nb.data");
		probEQ  = new EnergyQuantileData("energy_quantile__probe__aa_ss_sf_nb.data");
		spkEQ   = new EnergyQuantileData("energy_quantile__spk__aa_ss_sf_nb.data");
		dunEQ   = new EnergyQuantileData("energy_quantile__dune__aa_ss_sf_nb.data");
		resEQ   = new EnergyQuantileData("energy_quantile__rese__aa_ss_sf_nb.data");
		bpdata  = new BuriedPolarData("unsatisfied_buried_polar__pdb__aa_at_ss.data");

		//stringafteroption("decoyfeatures","none",decoy_features_mode);
		cout << "DecoyFeatures Mode" /*<< decoy_features_mode */<< endl;
		rsd_max_sasa( param_aa::aa_ala ) = 115.594; // 1 A
		rsd_max_sasa( param_aa::aa_cys ) = 136.441; // 2 C
		rsd_max_sasa( param_aa::aa_asp ) = 166.109; // 3 D
		rsd_max_sasa( param_aa::aa_glu ) = 187.047; // 4 E
		rsd_max_sasa( param_aa::aa_phe ) = 227.126; // 5 F
		rsd_max_sasa( param_aa::aa_gly ) =  95.379; // 6 G
		rsd_max_sasa( param_aa::aa_his ) = 174.877; // 7 H
		rsd_max_sasa( param_aa::aa_ile ) = 175.089; // 8 I
    rsd_max_sasa( param_aa::aa_lys ) = 215.766; // 9 K
    rsd_max_sasa( param_aa::aa_leu ) = 178.404; // 10 L
    rsd_max_sasa( param_aa::aa_met ) = 187.310; // 11 M
    rsd_max_sasa( param_aa::aa_asn ) = 142.086; // 12 N
    rsd_max_sasa( param_aa::aa_pro ) = 146.215; // 13 P
    rsd_max_sasa( param_aa::aa_gln ) = 180.624; // 14 Q
    rsd_max_sasa( param_aa::aa_arg ) = 216.548; // 15 R
    rsd_max_sasa( param_aa::aa_ser ) = 125.275; // 16 S
    rsd_max_sasa( param_aa::aa_thr ) = 138.319; // 17 T
    rsd_max_sasa( param_aa::aa_val ) = 153.885; // 18 V
    rsd_max_sasa( param_aa::aa_trp ) = 229.518; // 19 W
    rsd_max_sasa( param_aa::aa_tyr ) = 215.013; // 20 Y
//KMa phospho_ser 2006-01
    if ( add_pser() )    rsd_max_sasa( param_aa::aa_sep ) = 125.275;  // 21 O

  }
}


void
decoy_features_final()
{
  delete   atrEQ;
  delete   repEQ;
  delete   tljEQ;
  delete   solEQ;
  delete    hbEQ;
  delete intraEQ;
  delete  pairEQ;
  delete  probEQ;
  delete   spkEQ;
  delete   dunEQ;
  delete   resEQ;
  delete  bpdata;
	if( df_packing_stats_out_ ) {
		df_packing_stats_out_->close();
	}
}



//FArray2D_float df_compute_gdtmm_matrix( ) {
//	;
	//string list_name = "test.list";
	//utility::io::izstream pdblist( list_name.c_str() );
	//if ( !pdblist.good() ) {
	//	std::cout << "cant open " << list_name << std::endl;
	//	utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	//}
	//
	//vector1<Pose*> pose_list;
	//std::string filename;
	//std::string tribe_name;
	//while ( getline( pdblist, filename ) ) {
	//
	//	cout << filename << endl;
	//	Pose * const pose_ptr( new Pose() );
	//	Pose & one_pose( *pose_ptr );
	//	one_pose.set_fullatom_flag( fullatom, false );
	//	one_pose.simple_fold_tree( nres );
	//	bool const ok( pose_from_pdb( one_pose, filename, fullatom, ideal_pose ) );
	//	if ( !ok ) {
	//		std::cout << "input failed: " << filename << std::endl;
	//		continue;
	//	}
	//	pose_list.push_back( pose_ptr );
	//
	//
	//}


//}




//////////////////////////////////////////////////////////////////////
/// @begin decoy_features_store_native
///
/// @brief
///stires info about the native structure, if available
///
/// @detailed
/// TODO: fill me in!
///
/// No Params
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

void decoy_features_store_native() {
  //cout << " decoy_features_store_native() {" << endl;
  if( ! get_df_flag() )
    return;
  //set_pose_flag(true);
  nativeDF.initFromMisc();
  //set_pose_flag(false);

}



//////////////////////////////////////////////////////////////////////
/// @begin decoy_features_store_decoy
///
/// @brief
/// stores info about the crrent structure in misc
///
/// @detailed
/// TODO: fill me in!
///
/// No Params
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

// TODO do not re-create protsasa obj
// TODO get jian's df output working again
// TODO add T32S3

void decoy_features_store_decoy() {
  //cout << " decoy_features_store_decoy) {" << endl;

	//retrieve_decoy_name( df_decoy_name_ ); // why is the function stupid?
	using namespace  files_paths;

  static bool use_t32s3( truefalseoption("t32s3") );
	if ( use_t32s3 ) {
    score_file_ns::use_new_columns = true;
		score_file_ns::new_float_cols["t32s3"] = t32s3_ns::compute_t32s3_score_from_misc();
	}

	df_decoy_name_ = start_file;
	int const tmp = df_decoy_name_.rfind("/");
	if( tmp >= 0 )
	  df_decoy_name_ = df_decoy_name_.substr( tmp+1 , df_decoy_name_.size()	);
	if ( df_decoy_name_ == "none" )
		df_decoy_name_ = code + protein_name + protein_chain;

	//if( df_protein_sasa_ )
	//	df_protein_sasa_->init();
	cout << "PACKNG: deleting curent protein_sasa oject" << endl;
	using namespace  files_paths;

	packing_ns::heavy_atoms_only = truefalseoption("packing_heavy_atoms_only");

	if( df_flags["make_packing_pdb"] ||
		  df_flags["pruned_packing_pdb"] ||
			df_flags["packing_fasc_cols"] ||
			df_flags["packing_stats"] )
	{
		if( NULL != df_protein_sasa_ )    // for now, just make a new one!
			delete df_protein_sasa_;

		df_protein_sasa_ = new ProteinSasa();

		//df_protein_sasa_->set_hole_prune_probe_radius( 1.4);
		//df_protein_sasa_->set_max_hole_radius        ( 999 );
		//df_protein_sasa_->set_max_hole_sasa_         ( 0.000001 );
		//df_protein_sasa_->set_min_hole_radius        ( 0.9 );

		df_protein_sasa_->compute_atom_bsasa_score();
		df_protein_sasa_->compute_cavity_ball_burial();

	}

	if ( df_flags["packing_stats"] ) {
		cout << "PACKING output packing stats" << endl;
		assert( df_packing_stats_out_ != NULL );
		df_protein_sasa_->output_packing_statistics( *df_packing_stats_out_ , start_file );
	}
  if( df_flags["make_packing_pdb"] ) {
		string fname = (files_paths::pdb_out_path+df_decoy_name_+"_packing.pdb");
		cout << "PACKING: DF writting pdb to " << fname << endl;
	  utility::io::ozstream out( fname.c_str());
	  df_protein_sasa_->makePackingPDB( out, true, true, true, true );
	  out.close();
  }
	if( df_flags["pruned_packing_score"] ) {
			cout << "PACKING: compute pruned packing score " << endl;
		df_protein_sasa_->compute_pruned_bsasa_score(); // just use defult args
	}
  if( df_flags["packing_fasc_cols"] ) {
		cout << "PACKING: setting up fasc cols " << endl;
		df_protein_sasa_->setup_fasc_cols();
  }

  if( ! get_df_flag() )
    return;


  //set_pose_flag(true);
  currentDF.initFromMisc();
	if ( truefalseoption("df_file") || truefalseoption("t32s3") ) {
		cout << "DECOYFEATURES!!!!!!!!!!" << endl;
		//set_pose_flag(true);
		score_file_ns::new_float_cols["t32s3"]   = t32s3_ns::compute_t32s3_score_from_misc();
		score_file_ns::new_float_cols["sasapack"] = retrieve_sasa_pack_score();

		/*
		currentDF.initFromMisc();
		string s = stringafteroption("df_file");
		ofstream out( s.c_str() );
		print_decoy_features(out);
		out.close();
		set_pose_flag(false);
		using namespace score_file_ns;
		*/
	}

}

void df_print_hetero_atoms(utility::io::orstream & out) {
  out << df_hetero_atoms_;
}

//////////////////////////////////////////////////////////////////////
/// @begin print_decoy_features
///
/// @brief
/// prints energy vs. pdb, regional average data and buried polar info
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in,out?] ostream & out - to print to
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

void print_decoy_features(ostream & out) {
  if( ! get_df_flag() )
    return;
	currentDF.print(out);
}

struct Atom {
  float dist;
  int res;
  int atom;
};



//////////////////////////////////////////////////////////////////////
/// @begin compAtom
///
/// @brief
/// comarator for atom structs
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] Atom a - TODO: fill me in!
/// @param[in] Atom b - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// int
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

int compAtom(Atom a, Atom b) {
  return a.dist < b.dist ;
}



//////////////////////////////////////////////////////////////////////
/// @begin calc_atom_center_rms
///
/// @brief
/// computes rms over the closest heavy <Neighbors> atoms to x,y,z
/// including side chains that have more than <nbthresh> neighbors
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] float x
/// @param[in] float y
/// @param[in] float z
/// @param[in] int   Nneighbors
/// @param[in] int   nbthresh
/// @param[in] float disthresh  - max allowed distance
///
/// @return
/// TODO: fill me in!
/// float
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     int            total_residue in misc.h
///     FArray1D_int   res           in misc.h
///     FArray3D_float full_coord    in misc.h
///     FArray1D_int   res_variant   in misc.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

float
calc_atom_center_rms(float x, float y, float z, int Nneighbors,
		     int nbthresh, float disthresh) {
  using namespace template_pack;
  using namespace aaproperties_pack;

  if( ! nativeDF.defined() ) {
    cout << "WARNING: calc_atom_center_rms: no native!" << endl;
    return -1;
  }

  vector<Atom> atoms;
  for(int ii = 1; ii <= total_residue; ii++) {
    int  aai = misc::res(ii);
    int  aav = misc::res_variant(ii);
    int Natom =  aaproperties_pack::natoms(aai,aav);
    for(int atom = 1; atom <= Natom; atom++ ) {
      int atype = fullatom_type( atom, aai, aav );
      float dis = (full_coord(1,atom,ii)-x)*(full_coord(1,atom,ii)-x)+
	          (full_coord(2,atom,ii)-y)*(full_coord(2,atom,ii)-y)+
	          (full_coord(3,atom,ii)-z)*(full_coord(3,atom,ii)-z);
      if( (dis < disthresh ) &&
	  (neighbors(ii) >= nbthresh || atom <= 5) &&
          (atype != 22 && atype != 23 && atype != 24 && atype != 25) ){
	Atom a;
	a.dist = dis;
	a.res = ii;
	a.atom = atom;
	atoms.push_back(a);
      }
    }
  }
  sort(atoms.begin(),atoms.end(),compAtom);
  //for(int ii=1; ii<=(int)atoms.size(); ii++)
  //  cout << atoms[ii].dist << ' ' << atoms[ii].res << ' ' << atoms[ii].atom << endl;

  int n = std::min((int)atoms.size(),Nneighbors);
  FArray2D_double decoycoord (3,n);
  FArray2D_double nativecoord(3,n);
  for(int ii = 1; ii <= n; ii++) {
      for(int kk = 1; kk <= 3; kk++) {
	int atom = atoms[ii+1].atom;
	int res  = atoms[ii+1].res;
	decoycoord (kk,ii) = currentDF.full_coord()(kk,atom,res);
	nativecoord(kk,ii) =  nativeDF.full_coord()(kk,atom,res);
      }
  }

  float atomrms;
  FArray1D_double ww( n, 1.0 );
  FArray2D_double uu( 3, 3  );
  double ctx;
  findUU(                 decoycoord, nativecoord, ww, n, uu, ctx );
  calc_rms_fast( atomrms, decoycoord, nativecoord, ww, n,     ctx );

  return atomrms;
}


} // end namespace decoy_features_ns







//////////////////////////////////////////////////////////////////////
/// @begin DecoyFeatures
///
/// @brief
/// constructor; just initializes members
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] float ballRadius - TODO: fill me in!
/// @param[in] int   seqLength  - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// None (constructor)
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace DecoyFeatures
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

DecoyFeatures::DecoyFeatures(float ballRadius, int seqLength) :
  defined_   (false),
  ballRadius_(ballRadius),
  seqLength_ (seqLength),
  resScores_ (),
  ballScores_(ballRadius),
  seqScores_ (seqLength),
  Eposition_ (3,MAX_POS,MAX_RES()),
  full_coord_(3,MAX_ATOM(),MAX_RES()),
  atomrms50_ (param::MAX_RES(),0.0f),
  atomrms100_(param::MAX_RES(),0.0f),
  resrms_    (param::MAX_RES(),0.0f),
  rescenters_(3,param::MAX_RES(),0.0f),
  ressasa14_ (param::MAX_RES(),0.0f),
  sasafrac14_(param::MAX_RES(),0.0f),
  atomsasa14_(param::MAX_ATOM(),param::MAX_RES(),0.0f)
{

}
// DecoyFeatures::DecoyFeatures(Pose & pose, float ballRadius, int seqLength) :
//   defined_   (false),
//   ballRadius_(ballRadius),
//   seqLength_ (seqLength),
//   resScores_ (),
//   ballScores_(ballRadius),
//   seqScores_ (seqLength)
// {
//   initFromPose(pose);
// }




//////////////////////////////////////////////////////////////////////
/// @begin initFromMisc
///
/// @brief
/// initializes local  full_coord_ and Eposition_
///
/// @detailed
/// TODO: fill me in!
///
/// No Params
///
/// @return
/// TODO: fill me in!
/// bool
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     FArray3Dp_float Eposition  in misc.h
///     FArray3D_float  full_coord in misc.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace DecoyFeatures
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

bool DecoyFeatures::initFromMisc(){
  //  pose_from_misc(pose_,true,true,true);
  for(int ii = 1; ii <= MAX_RES(); ii++)
    for(int jj = 1; jj <= MAX_POS; jj++)
      for(int xyz = 1; xyz <=3 ; xyz++)
	Eposition_(xyz,jj,ii) = misc::Eposition(xyz,jj,ii);
  for(int ii = 1; ii <= MAX_RES()(); ii++)
    for(int jj = 1; jj <= MAX_ATOM()(); jj++)
      for(int xyz = 1; xyz <=3 ; xyz++)
	full_coord_(xyz,jj,ii) = misc::full_coord(xyz,jj,ii);
  defined_ = true;
  calcScores();
  return defined_;
}


// bool DecoyFeatures::initFromPose(Pose & pose) {
//   pose_ = pose;
//   defined_ = true;
//   calcScores();
//   return defined_;
// }



//////////////////////////////////////////////////////////////////////
/// @begin calcResidueCenters
///
/// @brief
/// computes heavy atom centroid of each residue
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in,out?] FArray2D_float & center - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     int            total_residue in misc.h
///     FArray1D_int   res           in misc.h
///     FArray3D_float full_coord    in misc.h
///     FArray1D_int   res_variant   in misc.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace DecoyFeatures
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

void DecoyFeatures::calcResidueCenters(FArray2D_float & center) {

  //cout << "DECOYFEATURES calc_residue_centers" << endl;

  using namespace template_pack;
  using namespace aaproperties_pack;
  FArray1D_float natomrms(total_residue,-1);
  for(int resnum = 1; resnum <= total_residue; resnum++) {
    int   aai = misc::res(resnum);
    int   aav = misc::res_variant(resnum);
    int Natom = aaproperties_pack::natoms(aai,aav);
    float x=0,y=0,z=0;
    int count = 0;
    for(int atom = 1; atom <= Natom; atom++ ) {
      int atype = fullatom_type( atom, aai, aav );
      if( (atype != 22 && atype != 23 && atype != 24 && atype != 25) ){
	count++;
	x += misc::full_coord(1,atom,resnum);
	y += misc::full_coord(2,atom,resnum);
	z += misc::full_coord(3,atom,resnum);
      }
    }
    center(1,resnum) = x / count;
    center(2,resnum) = y / count;
    center(3,resnum) = z / count;
  }
}


// assumes energy arrays are filled for this pose


//////////////////////////////////////////////////////////////////////
/// @begin calcScores
///
/// @brief
/// computes all the scores using in decoyfeatures
///
/// @detailed
/// TODO: fill me in!
///
/// No Params
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     int          total_residue in misc.h
///     FArray1D_int res           in misc.h
///     float        rms_err       in misc.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace DecoyFeatures
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

void DecoyFeatures::calcScores()
{
  if(!defined_) {
    cout << "DecoyFeatures::calcScores() error" << endl;
    return;
  }

  calcResidueCenters(rescenters_);
  bool setting = get_use_big_polar_h();
  set_use_big_polar_h(true);
  calc_per_atom_sasa( atomsasa14_, ressasa14_, 1.400, false, false );
  set_use_big_polar_h(setting);
  copy_hbenergies(); // from decoystats

  // get native stuff
  if( nativeDF.defined() ) {
    calc_residue_rms( *this , nativeDF , resrms_ );
    for(int resnum = 1; resnum <= total_residue; resnum++) {
      atomrms50_(resnum) = calc_atom_center_rms(rescenters_(1,resnum),
						rescenters_(2,resnum),
						rescenters_(3,resnum),
						50) ;
      atomrms100_(resnum) = calc_atom_center_rms(rescenters_(1,resnum),
						 rescenters_(2,resnum),
						 rescenters_(3,resnum),
						 100) ;
      rms_ = mc_global_track::diagnose::rms_err;
    }

  }

  for(int ii = 1; ii <= total_residue; ii++)
    sasafrac14_(ii) = std::max(0.0f,std::min(1.0f,ressasa14_(ii) / rsd_max_sasa( res(ii) )));

  resScores_.initFromMisc( ressasa14_ , atomsasa14_ );

  int totbp = 0;
  for(int ii = 1; ii <= total_residue; ii++) {

    avgatr_ += resScores_.atr(ii);
    avgrep_ += resScores_.rep(ii);
    avgtlj_ += resScores_.tlj(ii);
    avgsol_ += resScores_.sol(ii);
    avghb_  += resScores_.hb(ii);
    avgintra_+= resScores_.intra(ii);
    avgpair_+= resScores_.pair(ii);
    avgprob_+= resScores_.prob(ii);
    avgres_ += resScores_.res(ii);
    avgatrvpdb_ += resScores_.atrvpdb(ii);
    avgrepvpdb_ += resScores_.repvpdb(ii);
    avgtljvpdb_ += resScores_.tljvpdb(ii);
    avgsolvpdb_ += resScores_.solvpdb(ii);
    avghbvpdb_  += resScores_.hbvpdb(ii);
    avgintravpdb_+= resScores_.intravpdb(ii);
    avgpairvpdb_+= resScores_.pairvpdb(ii);
    avgprobvpdb_+= resScores_.probvpdb(ii);
    avgresvpdb_ += resScores_.resvpdb(ii);
    avgspkvpdb_ += resScores_.spkvpdb(ii);
    avgbupvpdb_ += resScores_.bupvpdb(ii);
    totbp += resScores_.bpcount(ii);
  }
  avgatrvpdb_ /= total_residue;
  avgrepvpdb_ /= total_residue;
  avgtljvpdb_ /= total_residue;
  avgsolvpdb_ /= total_residue;
  avghbvpdb_  /= total_residue;
  avgintravpdb_/= total_residue;
  avgpairvpdb_/= total_residue;
  avgprobvpdb_/= total_residue;
  avgresvpdb_ /= total_residue;
  avgspkvpdb_ /= total_residue;
  avgbupvpdb_ /= totbp;

  avgspkbup_ = 0.7*(1.0-avgbupvpdb_) + 0.3*avgspkvpdb_;

  ballScores_.calcScores(resScores_,*this,nativeDF);
   seqScores_.calcScores(resScores_,*this,nativeDF);

}




//////////////////////////////////////////////////////////////////////
/// @begin print
///
/// @brief
/// prints energies v pdb, regional energies and buried polar data to out
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in,out?] ostream & out - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     int             total_residue in misc.h
///     FArray1D_int    res           in misc.h
///     FArray1D_string residue3      in misc.h
///     FArray1D_char   secstruct     in misc.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace DecoyFeatures
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

void
DecoyFeatures::print(ostream & out) {
  if ( ! get_df_flag() )
    return;
	if ( ! ( defined_ && resScores_.defined() && ballScores_.defined() && seqScores_.defined() ) ) {
		cerr << "WARNING: attempt to print undefined DecoyFeatures object!" << endl;
		cerr << "         resScores: " << resScores_.defined()
								 << " ballScores: " << ballScores_.defined()
								 << " seqScores: " << seqScores_.defined()
								 << endl;
		return;
	}
  cout << "decoy_features: printing features" << endl;
  out << endl << "decoy_features scores" << endl;
  out << "tag res  aa ss nb sasafrac atrvpdb repvpdb tljvpdb solvpdb hbvpdb pairvpdb probvpdb resvpdb spkvpdb bpcount bup bupvpdb spkbup relrms" << endl;
  //out << "DF    1 PRO  L 10   0.884    0.995   0.800   1.000  0.621    0.131    0.000   0.948   0.939   0.464   1   0.000   0.255  0.987  17.200" << endl;
  for(int ii = 1; ii <= total_residue; ii++) {
    out << "DF  "
		<< I( 3, ii ) << " "
		<< misc::residue3(ii) << "  "
		<< misc::secstruct(ii) << " "
		<< I( 2, template_pack::neighbors(ii)) << "  "
		<< F( 7, 3, sasafrac14(ii) ) << " "
		<< F( 7, 3, resScores_.atrvpdb(ii)) << " "
		<< F( 7, 3, resScores_.repvpdb(ii)) << " "
		<< F( 7, 3, resScores_.tljvpdb(ii)) << " "
		<< F( 7, 3, resScores_.solvpdb(ii)) << " "
		<< F( 6, 3, resScores_.hbvpdb(ii)) << "  "
		<< F( 7, 3, resScores_.pairvpdb(ii)) << "  "
		<< F( 7, 3, resScores_.probvpdb(ii)) << " "
		<< F( 7, 3, resScores_.resvpdb(ii)) << " "
		<< F( 7, 3, resScores_.spkvpdb(ii)) << " "
		<< I( 7, resScores_.bpcount(ii)) << " "
		<< I( 3, resScores_.bup(ii)) << " "
		<< F( 7, 3, resScores_.bupvpdb(ii)) << " "
		<< F( 6, 3, resScores_.spkbup(ii)) << " "
		//<< F( 7, 3, resScores_.absrms(ii)) << " "
		<< F( 6, 3, resScores_.relrms(ii)) << " "
		<< endl;
  }
  out << "average:           "
      << F( 7, 3, avgatrvpdb()) << " "
      << F( 7, 3, avgrepvpdb()) << " "
      << F( 7, 3, avgtljvpdb()) << " "
      << F( 7, 3, avgsolvpdb()) << "  "
      << F( 6, 3, avghbvpdb()) << ""
      << F( 7, 3, avgpairvpdb()) << "  "
      << F( 7, 3, avgprobvpdb()) << "  "
      << F( 7, 3, avgresvpdb()) << " "
      << F( 7, 3, avgspkvpdb()) << "                             "
    //<< I( 7, avgbpcount()) << "        "
    //<< I( 3, avgbup()) << " "
    //<< F( 7, 3, avgbupvpdb()) << " "
      << F( 6, 3, avgspkbup()) << " "
    //<< F( 7, 3, avgabsrms()) << " "
    //<< F( 6, 3, avgrelrms()) << " "
      << endl;


  out << endl;
  out << "decoy_features radius 7 spherical regional scores" << endl;
  out << "tag    res  aa ss nb sasafrac";
  //  out << "" << endl;
  //        DFBALL   1 PRO  L 10  0.88
  ballScores_.printHeader(out);
  //cout << "DFBALL   1 PRO  L 10     0.88   5  0.730  0.462  0.504 12.218  9.871" << endl;
  for(int ii = 1; ii <= total_residue; ii++) {
    out << "DFBALL" << " "
	<< I( 3, ii ) << " "
	<< misc::residue3(ii) << "  "
	<< misc::secstruct(ii) << " "
	<< I( 2, template_pack::neighbors(ii)) << "  "
	<< F( 7, 3, sasafrac14(ii) ) << " ";
    ballScores_.print(out,ii);
    out << endl;
  }
  out << endl;
  out << "decoy_features length 7 sequence window scores" << endl;
  out << "tag    res  aa ss nb sasafrac" ;
  seqScores_.printHeader(out);
  for(int ii = 1; ii <= total_residue; ii++) {
    out << "DFSEQ" << "  "
	<< I( 3, ii ) << " "
	<< misc::residue3(ii) << "  "
	<< misc::secstruct(ii) << " "
	<< I( 2, template_pack::neighbors(ii)) << "  "
	<< F( 7, 3, sasafrac14(ii) ) << " ";
    seqScores_.print(out,ii);
    out << endl;
  }
  out << endl;
  out << "decoy_features buried polar vs. pdb" << endl;
  out << BPLOG << endl;

}


//////////////////////////////////////////////////////////////////////
/// @begin RegionScores
///
/// @brief
/// constructor for RegionScores; just initializes members
///
/// @detailed
/// TODO: fill me in!
///
/// No Params
///
/// @return
/// TODO: fill me in!
/// None (constructor)
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace RegionScores
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

RegionScores::RegionScores() : //DecoyFeatures & df) :
  defined_ (false),
  count_  (param::MAX_RES(),0),
  bpcount_(param::MAX_RES(),0),
  absrms_ (param::MAX_RES(),-1.0f),
  relrms_ (param::MAX_RES(),-1.0f),
  atr_  (param::MAX_RES(),0.0f),
  rep_  (param::MAX_RES(),0.0f),
  tlj_  (param::MAX_RES(),0.0f),
  sol_  (param::MAX_RES(),0.0f),
  hb_   (param::MAX_RES(),0.0f),
  intra_(param::MAX_RES(),0.0f),
  pair_ (param::MAX_RES(),0.0f),
  prob_ (param::MAX_RES(),0.0f),
  dun_  (param::MAX_RES(),0.0f),
  res_  (param::MAX_RES(),0.0f),
  spk_  (param::MAX_RES(),0.0f),
  bup_  (param::MAX_RES(),0.0f),
  atrvpdb_  (param::MAX_RES(),0.0f),
  repvpdb_  (param::MAX_RES(),0.0f),
  tljvpdb_  (param::MAX_RES(),0.0f),
  solvpdb_  (param::MAX_RES(),0.0f),
  hbvpdb_   (param::MAX_RES(),0.0f),
  intravpdb_(param::MAX_RES(),0.0f),
  pairvpdb_ (param::MAX_RES(),0.0f),
  probvpdb_ (param::MAX_RES(),0.0f),
  resvpdb_  (param::MAX_RES(),0.0f),
  spkvpdb_  (param::MAX_RES(),0.0f),
  bupvpdb_  (param::MAX_RES(),0.0f),
  spkbup_      (param::MAX_RES(),0.0f)
{

}






//////////////////////////////////////////////////////////////////////
/// @begin calcScores
///
/// @brief
/// compute scores averaged over the region attained from calcRegion
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] ResidueScores const & resscores - TODO: fill me in!
/// @param[in] DecoyFeatures const & decoy     - TODO: fill me in!
/// @param[in] DecoyFeatures const & native    - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     int          total_residue in misc.h
///     FArray1D_int res           in misc.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace RegionScores
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

void RegionScores::calcScores(ResidueScores const & resscores,
			      DecoyFeatures const & decoy ,
			      DecoyFeatures const & native)
{

  using namespace misc;
  using namespace utility;
  using namespace param;

  if( !decoy.defined() || ! native.defined() ) {
    cout << "WARNING: celcScores called with undefined DecoyFeatures object" << endl;
    return;
  }


  for(int ii = 1; ii <= misc::total_residue; ii++) {
    FArray2D_bool in_region = this->calcRegion(ii);
    count_(ii) = 0;
    for(int jj = 1; jj <= misc::total_residue; jj++) {
      const int atom = 1;
      if( in_region(atom,jj) ) {
	count_  (ii) += 1;
	bpcount_(ii) += resscores.bpcount(jj);
	atr_  (ii) += resscores.atr  (jj);
	rep_  (ii) += resscores.rep  (jj);
	tlj_  (ii) += resscores.tlj  (jj);
	sol_  (ii) += resscores.sol  (jj);
	hb_   (ii) += resscores.hb   (jj);
	intra_(ii) += resscores.intra(jj);
	pair_ (ii) += resscores.pair (jj);
	prob_ (ii) += resscores.prob (jj);
	res_  (ii) += resscores.res  (jj);
	spk_  (ii) += resscores.spk  (jj);
	bup_  (ii) += resscores.bup  (jj);
	atrvpdb_  (ii) += resscores.atrvpdb  (jj);
	repvpdb_  (ii) += resscores.repvpdb  (jj);
	tljvpdb_  (ii) += resscores.tljvpdb  (jj);
	solvpdb_  (ii) += resscores.solvpdb  (jj);
	hbvpdb_   (ii) += resscores.hbvpdb   (jj);
	intravpdb_(ii) += resscores.intravpdb(jj);
	pairvpdb_ (ii) += resscores.pairvpdb (jj);
	probvpdb_ (ii) += resscores.probvpdb (jj);
	resvpdb_  (ii) += resscores.resvpdb  (jj);
	spkvpdb_  (ii) += resscores.spkvpdb  (jj);
	bupvpdb_  (ii) += resscores.bupvpdb  (jj);
      }
    } // CHECKME
    int count = count_(ii);
    if( count == 0 )
      count = 1;
    atr_  (ii) /= count;
    rep_  (ii) /= count;
    tlj_  (ii) /= count;
    sol_  (ii) /= count;
    hb_   (ii) /= count;
    intra_(ii) /= count;
    pair_ (ii) /= count;
    prob_ (ii) /= count;
    res_  (ii) /= count;
    spk_  (ii) /= count;
    atrvpdb_  (ii) /= count;
    repvpdb_  (ii) /= count;
    tljvpdb_  (ii) /= count;
    solvpdb_  (ii) /= count;
    hbvpdb_   (ii) /= count;
    intravpdb_(ii) /= count;
    pairvpdb_ (ii) /= count;
    probvpdb_ (ii) /= count;
    resvpdb_  (ii) /= count;
    spkvpdb_  (ii) /= count;

    if(bpcount_(ii)==0) {
      bup_    (ii) = 1;
      bupvpdb_(ii) = 1;
    }  else {
      //cout << bupvpdb_(ii) << ' ' << bpcount_(ii) << endl;
      bup_    (ii) /= bpcount_(ii);
      bupvpdb_(ii) /= bpcount_(ii);
    }

    spkbup_(ii) = 0.3*spkvpdb_(ii)+0.7*(1.0-bupvpdb_(ii));

    if( native.defined() ) {
      //float absolute_rms = -1.0, relative_rms = -1.0;     CHECKME!!!
      calc_region_rms(decoy,native,in_region,absrms_(ii),relrms_(ii));
      //_absregrms(ii) = absolute_rms;
      //_relregrms(ii) = relative_rms;
    }
    if(count_(ii)==0) {
      cout << "WARNING: DF_REGION: no neighbors for res " << ii << endl;
    }
  }
  defined_ = true;
}




//////////////////////////////////////////////////////////////////////
/// @begin printHeader
///
/// @brief
/// print the region scores header
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in,out?] ostream & out - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace RegionScores
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

void
RegionScores::printHeader(ostream & out) {
  if( ! defined_ )
    cout << "WARNING: printing undefined RegionScores" << endl;
  //out << "   5  0.730  0.462  0.504 12.218  9.871 ;"
  out << " rnb resvpdb spkvpdb bupvpdb spkbup absrms relrms" << endl;

}



//////////////////////////////////////////////////////////////////////
/// @begin print
///
/// @brief
/// prints the regional scores for residue ii. This is not a complete line
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in,out?] ostream & out    - TODO: fill me in!
/// @param[in]      int       resnum - TODO: fill me in!
/// @param[in]      int       space  - TODO: fill me in!
/// @param[in]      int       digits - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace RegionScores
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

void
RegionScores::print(ostream & out, int resnum, int space, int digits) {
  if( ! defined_ )
    cout << "WARNING: printing undefined RegionScores" << endl;
  out << I( 3,               count_  (resnum) ) << "  "
      << F( space-1, digits, resvpdb_(resnum) ) << "  "
      << F( space-1, digits, spkvpdb_(resnum) ) << "  "
      << F( space-1, digits, bupvpdb_(resnum) ) << " "
      << F( space-1, digits, spkbup_(resnum) ) << " "
      << F( space-1, digits, absrms_ (resnum) ) << " "
      << F( space-1, digits, relrms_ (resnum) ) << " " ;
}



//////////////////////////////////////////////////////////////////////
/// @begin initFromMisc
///
/// @brief
/// initialized a regionscores object which holds data only for each residue
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] const FArray1D_float & ressasa14  - TODO: fill me in!
/// @param[in] const FArray2D_float & atomsasa14 - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// bool
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     int            total_residue  in misc.h
///     FArray1D_float atrenergy      in fullatom_energies.h
///     FArray1D_float repenergy      in fullatom_energies.h
///     FArray1D_float solenergy      in fullatom_energies.h
///     FArray1D_float probenergy     in fullatom_energies.h
///     FArray1D_float hbenergy       in fullatom_energies.h
///     FArray1D_float resenergy      in fullatom_energies.h
///     FArray1D_float pair_energy    in fullatom_energies.h
///     FArray1D_float intraresenergy in fullatom_energies.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace ResidueScores
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

bool
ResidueScores::initFromMisc(const FArray1D_float & ressasa14,
			    const FArray2D_float & atomsasa14) {
  using namespace decoy_features_ns;

  atr_   = fullatom_energies::atrenergy;
  rep_   = fullatom_energies::repenergy;
  sol_   = fullatom_energies::solenergy;
  hb_    = fullatom_energies::hbenergy;
  intra_ = fullatom_energies::intraresenergy;
  pair_  = fullatom_energies::pair_energy;
  prob_  = fullatom_energies::probenergy;
  res_   = fullatom_energies::resenergy;
  spk_   = void_ns::rsd_sasa_pack_score;
  for(int ii = 1; ii <= misc::total_residue; ii++) {
    count_(ii) = 1;
    tlj_(ii) = atr_(ii) + rep_(ii);
  }

  atrvpdb_   = atrEQ->score  (ressasa14,atr_);
  repvpdb_   = repEQ->score  (ressasa14,rep_);
  tljvpdb_   = tljEQ->score  (ressasa14,tlj_);
  solvpdb_   = solEQ->score  (ressasa14,sol_);
  hbvpdb_    = hbEQ->score   (ressasa14,hb_);
  intravpdb_ = intraEQ->score(ressasa14,intra_);
  pairvpdb_  = pairEQ->score (ressasa14,pair_);
  probvpdb_  = probEQ->score (ressasa14,prob_);
  resvpdb_   = resEQ->score  (ressasa14,res_);
  spkvpdb_   = spkEQ->score  (ressasa14,spk_);
  bpdata->score(atomsasa14,bup_,bupvpdb_,bpcount_,BPLOG);
  for(int ii = 1; ii <= total_residue; ii++) {
    //cout << ii << ' ' << 1.0-bupvpdb(ii)/bpcount_(ii) << endl;
    float tmp =  0.7*(1.0-bupvpdb_(ii)/bpcount_(ii));
    //cout << tmp << endl;
    if(bpcount(ii)==0)
      tmp = 0;
    spkbup_(ii) =  tmp + 0.3*spkvpdb_(ii);
    //cout << spkbup_(ii) << endl;
  }


  if(nativeDF.defined()) {
    calc_residue_rms(currentDF,nativeDF,relrms_);
  }

  //check on this... what is failure condition?
  defined_ = true;
  return defined_;
}


//////////////////////////////////////////////////////////////////////
/// @begin calcRegion
///
/// @brief
/// gives a region which is just the atoms for res 'resnum'
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] int resnum - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// FArray2D_bool
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace ResidueScores
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:32 2005
/////////////////////////////////////////////////////////////////////////

FArray2D_bool
ResidueScores::calcRegion(int resnum)
{
  FArray2D_bool region( MAX_ATOM()() , MAX_RES()() , false);
  for(int atom = 1; atom <= param::MAX_ATOM()(); atom++)
    region(atom,resnum) = true;
  return region;
}

//////////////////////////////////////////////////////////////////////
/// @begin calcRegion
///
/// @brief
/// computes a region which is all residues within radius_ sphere
/// from resnum
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] int resnum - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// None (constructor)
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace BallRegionScores
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

FArray2D_bool
BallRegionScores::calcRegion(int resnum)
{
  FArray2D_bool region( MAX_ATOM()() , MAX_RES()() , false);
  for(int jj = 1; jj <= total_residue; jj++) {
    float dis = 999999;
    //cout << radius_ << endl;
    distance_bk( currentDF.rescenter()(1,resnum), currentDF.rescenter()(1,jj), dis ); // GLOBAL
    if( dis <= radius_ ) {
      for(int atom = 1; atom <= param::MAX_ATOM()(); atom++)
	region(atom,jj) = true;
    } //else {
      //cout << resnum << ' ' << "not including res " << jj << endl;
    //}
  }
  return region;
}


//////////////////////////////////////////////////////////////////////
/// @begin calcRegion
///
/// @brief
/// returns all residues in a length_ sequence window about 'resnum'
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] int resnum - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// FArray2D_bool
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace SequenceRegionScores
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

FArray2D_bool
SequenceRegionScores::calcRegion(int resnum)
{
  int below = (int)std::floor(((float)length_)/2.0f);
  int above = (int)std::ceil( ((float)length_)/2.0f);
  FArray2D_bool region( MAX_ATOM()() , MAX_RES()() , false);
  for(int ii = resnum-below; ii <= resnum+above; ii++) {
    if(ii < 1 || ii > total_residue)
      continue;
    for(int atom = 1; atom <= MAX_ATOM()(); atom++)
      region(atom,ii) = true;
  }
  return region;
}



//////////////////////////////////////////////////////////////////////
/// @begin EnergyQuantileData
///
/// @brief
/// initializes object which contains information about energy qualties
/// in the pdb, as read freom a data file
///
/// @detailed
/// TODO: fill me in!
///
/// No Params
///
/// @return
/// TODO: fill me in!
/// None (constructor)
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace EnergyQuantileData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////
/*
EnergyQuantileData::EnergyQuantileData() :
  aa_(       DF_MAX_BINS ),
  aai_(      DF_MAX_BINS ),
  ss_(       DF_MAX_BINS ),
  lowsf_(    DF_MAX_BINS ),
  highsf_(   DF_MAX_BINS ),
  lownb_(    DF_MAX_BINS ),
  highnb_(   DF_MAX_BINS ),
  quantile_( DF_MAX_BINS, DF_MAX_QUANTILE ),
  defined_(false)
{
}
*/



//////////////////////////////////////////////////////////////////////
/// @begin EnergyQuantileData
///
/// @brief
/// reads in data file
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] string fname - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// None (constructor)
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace EnergyQuantileData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

EnergyQuantileData::EnergyQuantileData(string fname) :
  aa_(       DF_MAX_BINS ),
  aai_(      DF_MAX_BINS ),
  ss_(       DF_MAX_BINS ),
  lowsf_(    DF_MAX_BINS ),
  highsf_(   DF_MAX_BINS ),
  lownb_(    DF_MAX_BINS ),
  highnb_(   DF_MAX_BINS ),
  quantile_( DF_MAX_BINS, DF_MAX_QUANTILE ),
  defined_(false)
{
	fname_ = fname;
	this->readData(fname);
}

bool EnergyQuantileData::readData(string fname)
{
  bool fail;
  string tmp;
  fname_ = fname;
  utility::io::izstream & datafile( try_to_open_data_file(fname_, fail ) );
  if ( fail ) {
    defined_ = false;
    cout << "WARNING: can't find data file " << fname << endl;
    datafile.clear();
  } else {
    defined_ = true;
  }
  if(defined_) {
    datafile >> tmp ;
    if(tmp != "META") {
      cout << "WARNING: energy quantile data has no META entry!" << endl;
      defined_ = false;
      return false;
    }
    datafile >> tmp >> Nbins_ >> tmp >> Nquantiles_ >> tmp
		  >> Nssbins_ >> tmp >> Nsfbins_ >> tmp >> Nnbbins_;
    getline( datafile , header_ ); // gets end of meta line
    getline( datafile , header_ );

    for ( int ii = 1; ii <= Nbins_; ++ii ) {
      datafile >> tmp >> aa_(ii) >> aai_(ii) >> ss_(ii)
		    >> lowsf_  (ii) >> highsf_ (ii)
		    >> lownb_  (ii) >> highnb_ (ii)
		    >> tmp; //for nsamp column
      for(int jj=1; jj <= Nquantiles_; jj++) {
	datafile >> quantile_(ii,jj);
      }
    }
    datafile.close();
  }
  return defined_;
}




//////////////////////////////////////////////////////////////////////
/// @begin isDefined
///
/// @brief
/// returns true if the object has successfully read in a data file
///
/// @detailed
/// TODO: fill me in!
///
/// No Params
///
/// @return
/// TODO: fill me in!
/// bool
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace EnergyQuantileData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

bool EnergyQuantileData::isDefined()
{
  return defined_;
}




//////////////////////////////////////////////////////////////////////
/// @begin print
///
/// @brief
/// prints the quantile data from the data file
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in,out?] ostream & out - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace EnergyQuantileData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

void EnergyQuantileData::print(ostream & out) {
  if(!defined_) {
    cout << "WARNING: Can't Print quantile data from " << fname_ << endl;
    return;
  }
  out << header_ << endl;
  for(int ii = 1; ii <= Nbins_; ii++) {
    out << ii << '\t'
	<< aa_(ii) << '\t'
	<< aai_(ii) << '\t'
	<< ss_(ii) << '\t'
	<< lowsf_(ii) << '\t'
	<< highsf_(ii) << '\t'
	<< lownb_(ii) << '\t'
	<< highnb_(ii) << '\t';
    for(int jj = 1; jj <= Nquantiles_; jj++)
      out << quantile_(ii,jj) << '\t';
    out << endl;
  }
}





//////////////////////////////////////////////////////////////////////
/// @begin score
///
/// @brief
/// returns the appropriate quantile number for a residue
/// with the input parameters
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] int   aai  - amino acid type number
/// @param[in] char  ss   - secondary structyre H, L, E
/// @param[in] float sf   - fraction exposed sasa
/// @param[in] int   nb   - number of neighbors
/// @param[in] float eval - score value input
///
/// @return
/// TODO: fill me in!
/// float
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace EnergyQuantileData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

float EnergyQuantileData::score(int aai, char ss, float sf, int nb, float eval){
  if(!defined_) {
    cout << "WARNING: score: can't get quantile data from " << fname_ << endl;
    return 0;
  }
  nb = std::max(6,std::min(30,nb));
  sf = std::max(0.0f,std::min(1.0f,sf));
  //cout << Nsfbins_ << ' ' << Nnbbins_ << ' '
  //     << aai << ' '<< sf << ' ' << nb << ' ' << eval << endl;
  int bin = 1;
  //cout << "bin0 " << bin << endl;
  while(aai_(bin) != aai) {
    //cout << "bin1 " << bin << ' ' << aai << ' ' << aai_(bin) << endl;
    bin += Nssbins_*Nnbbins_*Nsfbins_;
    if(bin > Nbins_) {
      cout << "WARNING: score: can't find aai " << aai << "!!!" << endl;
      return(0);
    }
  }
  while( ss != ss_(bin) && ss_(bin) != '.' ) {
    //cout << "bin2 " << bin << ' ' << lowsf_(bin) << ' ' << sf << ' ' << highsf_(bin) << endl;
    bin += Nsfbins_*Nnbbins_;
    if(bin > Nbins_) {
      cout << "WARNING: score: can't find ss " << ss << "!!!" << endl;
      return(0);
    }
  }
  while( sf < lowsf_(bin) || highsf_(bin) < sf ) {
    //cout << "bin2 " << bin << ' ' << lowsf_(bin) << ' ' << sf << ' ' << highsf_(bin) << endl;
    bin += Nnbbins_;
    if(bin > Nbins_) {
      cout << "WARNING: score: can't find sasafrac " << sf << "!!!" << endl;
      return(0);
    }
  }
  while( nb < lownb_(bin) || highnb_(bin) < nb ) {
    //cout << "bin3 " << bin << ' ' << lownb_(bin) << ' ' << nb << ' ' << highnb_(bin) << endl;
    bin += 1;
    if(bin > Nbins_) {
      cout << "WARNING: score: can't find nb " << nb << "!!!" << endl;
      return(0);
    }
  }
  int q = 1;
  while( eval > quantile_(bin,q) ) {
    q += 1;
    if(q > Nquantiles_)
      break;
  }
  if(q > Nquantiles_)
    return 1;
  else if(q==1)
    return 0;
  else
    return ((float)(q-2) + ( eval             - quantile_(bin,q-1) )/
	                   ( quantile_(bin,q) - quantile_(bin,q-1) ))
                   / ((float)Nquantiles_-1);
}




//////////////////////////////////////////////////////////////////////
/// @begin score
///
/// @brief
/// scores all residues with the above function
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] const FArray1D_float & ressasa14 - TODO: fill me in!
/// @param[in] const FArray1D_float & energy    - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// FArray1D_float
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     int           total_residue in misc.h
///     FArray1D_int  res           in misc.h
///     FArray1D_char secstruct     in misc.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace EnergyQuantileData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

FArray1D_float
EnergyQuantileData::score(const FArray1D_float & ressasa14,
			  const FArray1D_float & energy)
{
  using namespace decoystats;
  using namespace misc;
  using namespace template_pack;

  FArray1D_float evpdb(total_residue,-1.0);
  for(int ii = 1; ii <= misc::total_residue; ii++) {
    int  aai = misc::res(ii);
    char  ss = misc::secstruct(ii);
    int   nb = template_pack::neighbors(ii);
    float sf = ressasa14(ii) / rsd_exposed_sasa( aai ); // from decoystats
    nb = std::max(6, std::min(30,nb));
    sf = std::max(0.0f, std::min(1.0f,sf));
    evpdb(ii) = this->score(aai,ss,sf,nb,energy(ii));
  }
  return evpdb;
}



//////////////////////////////////////////////////////////////////////
/// @begin BuriedPolarData
///
/// @brief
/// class contains info and scoring mechanizm for buried polar groups
/// based on what is found in the pdb
///
/// @detailed
/// TODO: fill me in!
///
/// No Params
///
/// @return
/// TODO: fill me in!
/// None (constructor)
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace BuriedPolarData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

BuriedPolarData::BuriedPolarData() :
  aa_(    DF_MAX_BINS ),
  aai_(   DF_MAX_BINS ),
  atype_( DF_MAX_BINS ),
  ss_(    DF_MAX_BINS ),
  score_( DF_MAX_BINS ),
  defined_(false)
{

}




//////////////////////////////////////////////////////////////////////
/// @begin BuriedPolarData
///
/// @brief
/// constructor which also reads a data file
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] string fname - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// None (constructor)
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace BuriedPolarData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

BuriedPolarData::BuriedPolarData(string fname) :
  aa_(    DF_MAX_BINS ),
  aai_(   DF_MAX_BINS ),
  atype_( DF_MAX_BINS ),
  ss_(    DF_MAX_BINS ),
  score_( DF_MAX_BINS ),
  defined_(false)
{
  this->readData(fname);
}





//////////////////////////////////////////////////////////////////////
/// @begin readData
///
/// @brief
/// reads in the data from data file
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] string fname - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// bool
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace BuriedPolarData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

bool
BuriedPolarData::readData(string fname)
{

  bool fail;
  string tmp;
  fname_ = fname;
  utility::io::izstream & datafile( try_to_open_data_file(fname_, fail ) );
  if ( fail ) {
    defined_ = false;
    cout << "WARNING: can't find data file " << fname << endl;
    datafile.clear();
  } else {
    defined_ = true;
  }
  if(defined_) {
    datafile >> tmp ;
    if(tmp != "META") {
      cout << "WARNING: buried polar data has no META entry!" << endl;
      defined_ = false;
      return false;
    }
    datafile >> tmp >> Nbins_;
    getline( datafile , header_ ); // gets end of meta line
    getline( datafile , header_ );
    for ( int ii = 1; ii <= Nbins_; ++ii ) {
      datafile >> tmp >> aa_(ii) >> aai_(ii) >> atype_(ii) >> ss_(ii) >> score_(ii);
    }
    datafile.close();
  }
  return defined_;
}





//////////////////////////////////////////////////////////////////////
/// @begin print
///
/// @brief
/// prints the information contained in the data file which was read
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in,out?] ostream & out - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace BuriedPolarData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

void
BuriedPolarData::print(ostream & out)
{
  if(!defined_) {
    cout << "WARNING: Can't Prinburied polar data from " << fname_ << endl;
    return;
  }
  out << header_ << endl;
  for(int ii = 1; ii <= Nbins_; ii++) {
    out << ii << '\t'
	<< aa_(ii) << '\t'
	<< aai_(ii) << '\t'
	<< atype_(ii) << '\t'
	<< ss_(ii) << '\t'
	<< score_(ii) << '\t'
	<< endl;
  }
}


//////////////////////////////////////////////////////////////////////
/// @begin score
///
/// @brief
/// scores a buried polar group of a particular type
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in] int  aai   - amine acid type
/// @param[in] int  atype - atom type
/// @param[in] char ss    - secondary structure
/// @param[in] int  nb    - number of neighbors
///
/// @return
/// TODO: fill me in!
/// float
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace BuriedPolarData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

float
BuriedPolarData::score(int aai, int atype, char ss, int nb)
{
  nb ++; // this param isn't used at the moment
  if(!defined_) {
    cout << "WARNING: buried polar score: bad data from '" << fname_ << endl;
    return 0;
  }
  int ii = 1;
  while( aai_(ii)!=aai || atype_(ii)!=atype || (ss_(ii)!=ss && ss_(ii)!='.') ) {
    ii++;
    if(ii > Nbins_) {
      cout << "WARNING: buried polar score: cant find bin '"
	   << aai<< "' '" << atype<< "' '" << ss<< "'" << endl;
      return 0;
    }
  }
  return score_(ii);
}







//////////////////////////////////////////////////////////////////////
/// @begin score
///
/// @brief
/// scores all residues with the above function
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in]      FArray2D_float const & atomsasa14 - TODO: fill me in!
/// @param[in,out?] FArray1D_float &       bup        - TODO: fill me in!
/// @param[in,out?] FArray1D_float &       bupvpdb    - TODO: fill me in!
/// @param[in,out?] FArray1D_int &         bpcount    - TODO: fill me in!
/// @param[in,out?] string &               log        - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     int             total_residue in misc.h
///     FArray1D_int    res           in misc.h
///     FArray1D_string residue3      in misc.h
///     FArray1D_int    res_variant   in misc.h
///     FArray1D_string name          in misc.h
///     FArray1D_char   secstruct     in misc.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace BuriedPolarData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

void
BuriedPolarData::score(FArray2D_float const & atomsasa14, FArray1D_float & bup,
		       FArray1D_float & bupvpdb, FArray1D_int & bpcount , string & log)
{
  using namespace misc;
  using namespace aaproperties_pack;
  using namespace decoystats;

  log = "tag  res  aa aa nb sasafrac atom type name   hbE  sasa14   score\n";
  //         DFBP  3 GLN H  9   0.000 12 22 2HE2   0.000   0.000   0.227
  //log = "DFBP  69 GLN  H  9    0.000   10   25  H     0.000   0.000   0.075\n";

  for(int ii = 1; ii <= misc::total_residue; ii++) {
    int  aai = misc::res(ii);
    int  aav = misc::res_variant(ii);
    char  ss = misc::secstruct(ii);
    bpcount(ii) = 0;
    bup(ii)     = 0.0f;
    bupvpdb(ii) = 0.0f;
    for(int atom = 1; atom <= aaproperties_pack::natoms(aai,aav); atom++ ) {
      int atype = fullatom_type( atom, aai, aav );
      if( atype==8 || atype==13 || atype==14 || atype==15 ||
          	      atype==20 || atype==22 || atype==25 ) {
	float hbE = decoystats::atom_hbondE(atom,ii);
	if ( atomsasa14(atom,ii) < 0.01) {
	  bpcount(ii)++;
	  float sc = 1.0;
	  if( hbE >= -0.01) {
	    sc = this->score(aai,atype,ss,-1);
	    bupvpdb(ii) += sc;
	    bup(ii)     += 0.0f;
	  } else {
	    bupvpdb(ii) += 1.0f;
	    bup(ii)     += 1.0f;
	  }
	  log = log + "DFBP" + I(3,ii) + "  "
	    + misc::residue3(ii) + "  "
	    + ss + " "
	    + I(2,template_pack::neighbors(ii)) + "  "
	    + F(7,3,currentDF.sasafrac14(ii)) + "   " // OUT OF SCOPE!
	    + I(2,atom) + "   "
	    + I(2,atype) + " "
	    + atom_name(atom,aai,aav) + " "
	    + F(5,3,hbE) + " "
	    + F(7,3,atomsasa14(atom,ii)) + " "
	    + F(7,3,sc)
	    + '\n';
	}
      }
    }
  }
}





//////////////////////////////////////////////////////////////////////
/// @begin isDefined
///
/// @brief
/// returns true if the object has successfully read in a data file
///
/// @detailed
/// TODO: fill me in!
///
/// No Params
///
/// @return
/// TODO: fill me in!
/// bool
///
/// @global_read
/// TODO: fill me in!
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace BuriedPolarData
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

bool
BuriedPolarData::isDefined()
{
  return defined_;
}



//////////////////////////////////////////////////////////////////////
/// @begin calc_region_rms
///
/// @brief
/// computes the rms difference between two structures over a specified
/// region. returns both teh relative and absolute rms. relative rms
/// is rms after aligning over only the region, while absolute rms is rms
/// after aligning over the whole structure (bb only).
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in]      DecoyFeatures const & df1          - TODO: fill me in!
/// @param[in]      DecoyFeatures const & df2          - TODO: fill me in!
/// @param[in]      const FArray2D_bool & in_region    - TODO: fill me in!
/// @param[in,out?] float &               absolute_rms - TODO: fill me in!
/// @param[in,out?] float &               relative_rms - TODO: fill me in!
/// @param[in]      int                   nbthresh     - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     int          total_residue in misc.h
///     FArray1D_int res           in misc.h
///     FArray1D_int res_variant   in misc.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace decoy_features_ns
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

void
decoy_features_ns::calc_region_rms(DecoyFeatures const & df1,
				   DecoyFeatures const & df2,
				   const FArray2D_bool & in_region,
				   float & absolute_rms,
				   float & relative_rms,
				   int nbthresh) {
  using namespace param;
  using namespace misc;
  using namespace template_pack;
  using namespace aaproperties_pack;
  using namespace pose_ns;

  absolute_rms = -1.0;
  relative_rms = -1.0;

  int coordsize = misc::total_residue*param::MAX_ATOM()();

  FArray2D_double p1coord  (3,coordsize,0.0);
  FArray2D_double p2coord  (3,coordsize,0.0);

  int regpoints = 0;
  for(int ii = 1; ii <= misc::total_residue; ii++) {
    int  aai = misc::res(ii);
    int  aav = misc::res_variant(ii);
    int Natom =  aaproperties_pack::natoms(aai,aav);
    if( neighbors(ii) < nbthresh )
      Natom = 5;
    for(int atom = 1; atom <= Natom; atom++ ) {
      int atype = fullatom_type( atom, aai, aav );
      if( atype != 22 && atype != 23 && atype != 24 && atype != 25 ) {
	if( in_region( atom , ii ) ) {
	  regpoints++;
	  for(int kk = 1; kk <= 3; kk++) {
	    p1coord(kk,regpoints) = df1.full_coord()(kk,atom,ii);
	    p2coord(kk,regpoints) = df2.full_coord()(kk,atom,ii);
	  }
	}
      }
    }
  }

  FArray1D_double ww(regpoints,1.0);
  FArray2D_double uu( 3, 3 );
  double ctx;
  findUU(                      p1coord, p2coord, ww, regpoints, uu, ctx );
  calc_rms_fast( relative_rms, p1coord, p2coord, ww, regpoints,     ctx );

  // since the above doesn't work right... redo abs rms
  absolute_rms = 0.0;
  float tmp;
  FArray3D_float tmp_Eposition ( df1.Eposition());
  FArray3D_float tmp_full_coord( df1.full_coord());
  orient_region(total_residue,
		tmp_Eposition,
		tmp_full_coord,
		df2.Eposition(),
		1,
		1,
		total_residue,
		1,
		1,
		total_residue,
		tmp);
  int count = 0;
  for(int ii = 1; ii <= misc::total_residue; ii++) {
    int resnum = ii;
    int  aai = misc::res(resnum);
    int  aav = misc::res_variant(resnum);
    int Natom =  aaproperties_pack::natoms(aai,aav);
    if( neighbors(resnum) < nbthresh)
      Natom = 5;
    for(int atom = 1; atom <= Natom; atom++ ) {
      int atype = fullatom_type( atom, aai, aav );
      if( atype != 22 && atype != 23 && atype != 24 && atype != 25 ) {
	if( in_region( atom, ii ) ) {
	  count++;
	  for(int kk = 1; kk <= 3; kk++) {
	    float const d = tmp_full_coord(kk,atom,resnum) - df2.full_coord()(kk,atom,resnum);
	    absolute_rms += d*d;
	  }
	}
      }
    }
  }
  absolute_rms = sqrt(absolute_rms/count);
}








//////////////////////////////////////////////////////////////////////
/// @begin calc_residue_rms
///
/// @brief
/// computes the fullatom absolute rms for each residue
///
/// @detailed
/// TODO: fill me in!
///
/// @param[in]      DecoyFeatures const & df1      - TODO: fill me in!
/// @param[in]      DecoyFeatures const & df2      - TODO: fill me in!
/// @param[in,out?] FArray1D_float &      out      - TODO: fill me in!
/// @param[in]      int                   nbthresh - TODO: fill me in!
///
/// @return
/// TODO: fill me in!
/// void
///
/// @global_read
/// TODO: fill me in!, but here are some guesses:
///     int          total_residue in misc.h
///     FArray1D_int res           in misc.h
///     FArray1D_int res_variant   in misc.h
///
/// @global_write
/// TODO: fill me in!
///
/// @remarks
/// TODO: fill me in!
/// In namespace decoy_features_ns
///
/// @references
/// TODO: fill me in!
///
/// @authors sheffler
///
/// @last_modified Wed Oct 26 12:52:33 2005
/////////////////////////////////////////////////////////////////////////

void
decoy_features_ns::calc_residue_rms(DecoyFeatures const & df1,
				    DecoyFeatures const & df2,
				    FArray1D_float & out,
				    int nbthresh) {
  using namespace misc;
  using namespace param;
  using namespace template_pack;
  using namespace aaproperties_pack;
  using namespace pose_ns;

  float tmp;
  //FArray1D_float out(misc::total_residue,0.0);
  FArray3D_float tmp_Eposition( df1.Eposition());
  FArray3D_float tmp_full_coord( df1.full_coord());
  orient_region(total_residue,
		tmp_Eposition,
		tmp_full_coord,
		df2.Eposition(),
		1,
		1,
		total_residue,
		1,
		1,
		total_residue,
		tmp);
  for(int ii = 1; ii <= total_residue; ii++) {
    int  aai = misc::res(ii);
    int  aav = misc::res_variant(ii);
    int Natom =  aaproperties_pack::natoms(aai,aav);
    int count = 0;
    out(ii) = 0.0;
    if( neighbors(ii) > nbthresh)
      Natom = 5;
    for(int atom = 1; atom <= Natom; atom++ ) {
      int atype = fullatom_type( atom, aai, aav );
      if( atype != 22 && atype != 23 && atype != 24 && atype != 25 ) {
	count++;
	for(int kk = 1; kk <= 3; kk++) {
	  float const d = tmp_full_coord(kk,atom,ii) - df2.full_coord()(kk,atom,ii);
	  out(ii) += d*d;
	  //if(ii==52)
	  //  cout << "ASDF " << count << ' '<< d << endl;
	}
      }
    }
    //if(ii==52)
    //  cout << sqrt(out(ii)/count) << endl;
    out(ii) = sqrt(out(ii)/count);
  }
}


