// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15540 $
//  $Date: 2007-06-19 15:37:31 -0700 (Tue, 19 Jun 2007) $
//  $Author: chu $

// author sheffler
//

#ifndef INCLUDED_decoy_features
#define INCLUDED_decoy_features

// Rosetta Headers
#include "atom_is_backbone.h"
#include "pack_geom_inline.h"
#include "RotamerDotsFWD.h"
#include "pose.h"
#include "misc.h"
#include "aaproperties_pack.h"
#include "RotamerDotsFWD.h"
#include "fullatom_sasa.h"
#include "fullatom_sasa_ns.h"
#include "RotamerDots.h"
#include "packing_measures.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>

// C++ Headers
#include <iosfwd>
#include <ostream>
#include <map>
#include <string>


namespace decoy_features_ns {

  //using namespace pose_ns;
  using namespace std;

  class DecoyFeatures;
  class EnergyQuantileData;
  class BuriedPolarData;
  class         RegionScores;
  class        ResidueScores;
  class     BallRegionScores;
  class SequenceRegionScores;

  extern DecoyFeatures currentDF;
  extern DecoyFeatures nativeDF;
  extern bool   df_flag_;
  extern string decoy_features_mode;
  extern EnergyQuantileData *atrEQ;
  extern EnergyQuantileData *repEQ;
  extern EnergyQuantileData *solEQ;
  extern EnergyQuantileData *hbEQ;
  extern EnergyQuantileData *intraEQ;
  extern EnergyQuantileData *pairEQ;
  extern EnergyQuantileData *probEQ;
  extern EnergyQuantileData *spkEQ;
  extern EnergyQuantileData *tljEQ;
  extern EnergyQuantileData *resEQ;
  extern EnergyQuantileData *dunEQ;
  extern BuriedPolarData    *bpdata;
  extern FArray1D_float rsd_max_sasa;

  // global functions which connect up to the rest of rosetta


  inline bool get_df_flag() { return df_flag_; }
  inline void set_df_flag(bool b) { df_flag_ = b; }
  void decoy_features_initialize();
  void decoy_features_final();
  void decoy_features_store_native();
  void decoy_features_store_decoy();
  void print_decoy_features(ostream & out);

  void calc_region_rms(DecoyFeatures const & df1,
		       DecoyFeatures const & df2,
		       FArray2D_bool const & in_region,
		       float & absolute_rms,
		       float & relative_rms,
		       int nbthresh=10);

  void calc_residue_rms(DecoyFeatures const & df1,
			DecoyFeatures const & df2,
			FArray1D_float & out,
			int nbthresh=10);

  float calc_atom_center_rms(float x, float y, float z,
			     int Nneighbors,
			     int nbthresh = 10,
			     float disthresh = 99999);

	void df_make_packing_pdb(utility::io::ozstream & out, packing_ns::ProteinSasa & ps);

	FArray2D_float df_compute_gdtmm_matrix( );

	class EnergyQuantileData {
  public:
    //EnergyQuantileData();
    EnergyQuantileData(string fname);
    bool  readData(string fname);
    void  print(ostream & out);
    float score(int aai, char ss, float sf, int nb, float eval);
    FArray1D_float score(const FArray1D_float & ressasa14, const FArray1D_float & energy);
    bool  isDefined();
  private:
    FArray1D_string aa_;
    FArray1D_int    aai_;
    FArray1D_char   ss_;
    FArray1D_float  lowsf_;
    FArray1D_float  highsf_;
    FArray1D_float  lownb_;
    FArray1D_float  highnb_;
    FArray2D_float  quantile_;
    string     fname_;
    string     header_;
    int  Nbins_;
    int  Nquantiles_;
    int  Nssbins_;
    int  Nsfbins_;
    int  Nnbbins_;
    bool defined_;
  };



  class BuriedPolarData {
  public:
    BuriedPolarData();
    BuriedPolarData(string fname);
    bool  readData(string fname);
    void  print(ostream & out);
    float score(int aai, int atype, char ss, int nb);
    void  score(FArray2D_float const & atomsasa14, FArray1D_float & bup,
		FArray1D_float & bupvpdb, FArray1D_int & bpcount, string & log );
    bool  isDefined();
  private:
    FArray1D_string aa_;
    FArray1D_int    aai_;
    FArray1D_int    atype_;
    FArray1D_char   ss_;
    FArray1D_float  score_;
    string fname_;
    string header_;
    int  Nbins_;
    bool defined_;
  };


  class RegionScores {
  public:
    RegionScores(); //DecoyFeatures & df);
    virtual ~RegionScores() {}
    void calcScores(ResidueScores const & resscores,
		    DecoyFeatures const & decoy,
		    DecoyFeatures const & native);
    void printHeader(ostream & out);
    void print(ostream & out,
	       int resnum,
	       int space=7,
	       int digits=3);
    virtual FArray2D_bool calcRegion(int res) = 0;
    //const DecoyFeatures & decoyFeatures() { return df_; }
    bool  defined() { return defined_; }
    int   count  (int resnum) const { return count_(resnum); }
    int   bpcount(int resnum) const { return bpcount_(resnum); }
    float absrms(int resnum) const { return absrms_(resnum); }
    float relrms(int resnum) const { return relrms_(resnum); }
    float atr  (int resnum) const { return atr_(resnum); }
    float rep  (int resnum) const { return rep_(resnum); }
    float tlj  (int resnum) const { return tlj_(resnum); }
    float sol  (int resnum) const { return sol_(resnum); }
    float hb   (int resnum) const { return hb_(resnum); }
    float intra(int resnum) const { return intra_(resnum); }
    float pair (int resnum) const { return pair_(resnum); }
    float prob (int resnum) const { return prob_(resnum); }
    float dun  (int resnum) const { return dun_(resnum); }
    float res  (int resnum) const { return res_(resnum); }
    float spk  (int resnum) const { return spk_(resnum); }
    float bup  (int resnum) const { return bup_(resnum); }
    float atrvpdb  (int resnum) const { return atrvpdb_(resnum); }
    float repvpdb  (int resnum) const { return repvpdb_(resnum); }
    float tljvpdb  (int resnum) const { return tljvpdb_(resnum); }
    float solvpdb  (int resnum) const { return solvpdb_(resnum); }
    float hbvpdb   (int resnum) const { return hbvpdb_(resnum); }
    float intravpdb(int resnum) const { return intravpdb_(resnum); }
    float pairvpdb (int resnum) const { return pairvpdb_(resnum); }
    float probvpdb (int resnum) const { return probvpdb_(resnum); }
    float resvpdb  (int resnum) const { return resvpdb_(resnum); }
    float spkvpdb  (int resnum) const { return spkvpdb_(resnum); }
    float bupvpdb  (int resnum) const { return bupvpdb_(resnum); }
    float spkbup   (int resnum) const { return spkbup_(resnum); }

  protected:
    bool           defined_;
    //DecoyFeatures & df_; // TODO try using a reference
    FArray1D_int   count_;
    FArray1D_int   bpcount_;
    FArray1D_float absrms_;
    FArray1D_float relrms_;
    FArray1D_float atr_;
    FArray1D_float rep_;
    FArray1D_float tlj_;
    FArray1D_float sol_;
    FArray1D_float hb_;
    FArray1D_float intra_;
    FArray1D_float pair_;
    FArray1D_float prob_;
    FArray1D_float dun_;
    FArray1D_float res_;
    FArray1D_float spk_;
    FArray1D_float bup_;
    FArray1D_float atrvpdb_;
    FArray1D_float repvpdb_;
    FArray1D_float tljvpdb_;
    FArray1D_float solvpdb_;
    FArray1D_float hbvpdb_;
    FArray1D_float intravpdb_;
    FArray1D_float pairvpdb_;
    FArray1D_float probvpdb_;
    FArray1D_float resvpdb_;
    FArray1D_float spkvpdb_;
    FArray1D_float bupvpdb_;
    FArray1D_float spkbup_;

  };

  class ResidueScores : public RegionScores {
  public:
    ResidueScores() : RegionScores() {}
      ~ResidueScores() {}
      FArray2D_bool calcRegion(int res);
      bool initFromMisc(const FArray1D_float & ressasa14, const FArray2D_float & atomsasa14);
  };

  class BallRegionScores : public RegionScores {
  public:
    BallRegionScores(float radius) : RegionScores() { radius_ = radius; }
      ~BallRegionScores() {}
      FArray2D_bool calcRegion(int res);
  private:
      float radius_;
  };

  class SequenceRegionScores : public RegionScores {
  public:
    SequenceRegionScores(int length) : RegionScores() { length_ = length; }
      ~SequenceRegionScores() {}
      FArray2D_bool calcRegion(int res);
  private:
      int length_;
  };


  class DecoyFeatures {
  public:
    DecoyFeatures(float ballRadius = 7.0, int seqLength = 7);
    //DecoyFeatures(Pose & pose, float ballRadius = 7.0, int seqLength = 7);
    //bool initFromPose(Pose & pose);
    bool initFromMisc();
    void print(ostream & out);
    void calcScores();
    void calcResidueCenters(FArray2D_float & center);
    //Pose const & pose()                       const { return pose_; }
    ResidueScores        const &  resScores() const { return  resScores_; }
    BallRegionScores     const & ballScores() const { return ballScores_; }
    SequenceRegionScores const &  seqScores() const { return  seqScores_; }
    bool defined() const { return defined_; }
    FArray2D_float const & rescenter () const { return rescenters_; }
    FArray3D_float const & Eposition  () const { return Eposition_; }
    FArray3D_float const & full_coord () const { return full_coord_; }
    float atomrms50 (int resnum) const { return atomrms50_(resnum); }
    float atomrms100(int resnum) const { return atomrms100_(resnum); }
    float resrms    (int resnum) const { return resrms_(resnum); }
    float centerx(int resnum) const { return rescenters_(1,resnum); }
    float centery(int resnum) const { return rescenters_(2,resnum); }
    float centerz(int resnum) const { return rescenters_(3,resnum); }
    float ressasa14 (int resnum)           const { return  ressasa14_(resnum); }
    float atomsasa14(int resnum, int atom) const { return atomsasa14_(resnum,atom); }
    float sasafrac14(int resnum) const  { return sasafrac14_(resnum); }
    float rms() const { return rms_; }
    float avgatr() const { return avgatr_; }
    float avgrep() const { return avgrep_; }
    float avgtlj() const { return avgtlj_; }
    float avgsol() const { return avgsol_; }
    float avghb() const { return avghb_; }
    float avgintra() const { return avgintra_; }
    float avgpair() const { return avgpair_; }
    float avgprob() const { return avgprob_; }
    float avgres() const { return avgres_; }
    float avgspk() const { return avgspk_; }
    float avgatrvpdb() const { return avgatrvpdb_; }
    float avgrepvpdb() const { return avgrepvpdb_; }
    float avgtljvpdb() const { return avgtljvpdb_; }
    float avgsolvpdb() const { return avgsolvpdb_; }
    float avghbvpdb() const { return avghbvpdb_; }
    float avgintravpdb() const { return avgintravpdb_; }
    float avgpairvpdb() const { return avgpairvpdb_; }
    float avgprobvpdb() const { return avgprobvpdb_; }
    float avgresvpdb() const { return avgresvpdb_; }
    float avgspkvpdb() const { return avgspkvpdb_; }
    float avgspkbup()  const { return avgspkbup_; }

  private:
    //Pose                 pose_;
    bool                 defined_;
    float                ballRadius_;
    int                  seqLength_;
    ResidueScores        resScores_;
    BallRegionScores     ballScores_;
    SequenceRegionScores seqScores_;
    FArray3D_float Eposition_;
    FArray3D_float full_coord_;
    FArray1D_float atomrms50_;
    FArray1D_float atomrms100_;
    FArray1D_float resrms_;
    FArray2D_float rescenters_;
    FArray1D_float ressasa14_;
    FArray1D_float sasafrac14_;
    FArray2D_float atomsasa14_;
    float rms_  ;
    float avgatr_  ;
    float avgrep_  ;
    float avgtlj_  ;
    float avgsol_  ;
    float avghb_   ;
    float avgintra_;
    float avgpair_ ;
    float avgprob_ ;
    float avgres_  ;
    float avgspk_  ;
    float avgatrvpdb_  ;
    float avgrepvpdb_  ;
    float avgtljvpdb_  ;
    float avgsolvpdb_  ;
    float avghbvpdb_   ;
    float avgintravpdb_;
    float avgpairvpdb_ ;
    float avgprobvpdb_ ;
    float avgresvpdb_  ;
    float avgspkvpdb_  ;
    float avgbupvpdb_  ;
    float avgspkbup_   ;
  };




}

#endif
