// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-17 23:39:36 -0700 (Sat, 17 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_decoystats
#define INCLUDED_decoystats

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <iosfwd>
#include <list>
#include <string>

// Forward declarations
class unsatisfied_buried_polar;
class unsatisfied_buried_group;

// decoystats Function Declarations


void
setup_decoystats();


void
dimension_big_decoystats_arrays();


void
set_decoystats_flag( bool setting );


void
set_ds_outpdbonly_flag( bool setting );


bool
get_decoystats_flag();


bool
get_ds_outpdbonly_flag();


void
reset_decoy_scores();


void
add_decoy_score(
	std::string const & tag,
	float const sc
);

float
get_decoy_score(
	std::string const & tag
);

void
decoystats_make_pdb_scores( std::ostream & iunit );


void
decoystats_score_header_output( std::ostream & iunit );


void
decoystats_score_output( std::ostream & iunit );


void
decoystats_analyze_fragments( int const nres /* total_residue */ );


int
ppo_to_int(
	float const ph,
	float const ps,
	float const om
);


void
decoystats_store_native();


void
copy_hbenergies();


int
get_hbondE_key(
	bool const d_is_bb,
	bool const a_is_bb
);


void
decoystats_store_output_line( std::string const & line );


void
decoystats_reset_output_lines();


void
decoystats_write_output_lines( std::ostream & iunit );


void find_unsatisfied_hbonds(
  std::list < unsatisfied_buried_polar > & uns_list,
	std::list < unsatisfied_buried_group > & group_uns_list
);


void
report_unsatisfied_hbonds(
  std::string const tag,
  std::list < unsatisfied_buried_polar > & uns_list);


void
report_unsatisfied_hbonds(
  std::string const tag,
  std::list < unsatisfied_buried_polar > & uns_list,
  std::list < unsatisfied_buried_group > & group_uns_list
);


void
dump_uns_list(
  std::string const tag,
  std::list < unsatisfied_buried_polar > & uns_list
);


// Note: template functions must have declaration with definition
template <typename T>
std::list < T > find_unique_uns( std::list < T > & curr_list, std::list < T > & ref_list ) {
	std::list < T > unique_list;
	for( typename std::list< T >::iterator uns = curr_list.begin();
			 uns != curr_list.end(); ++uns ) {
		bool unique = true;
		for( typename std::list< T >::iterator ref_uns = ref_list.begin();
				 ( ( ref_uns != ref_list.end() ) && ( unique ) ); ++ref_uns ) {
			if ( *uns == *ref_uns ) {
				unique=false;
			}
		}
		if ( unique ) unique_list.push_back(*uns);
	}
	return unique_list;
}


void collect_group_uns(
  std::list < unsatisfied_buried_polar > & uns_list,
  std::list < unsatisfied_buried_group > & group_uns_list
);


void read_uns_from_pdb(
  utility::io::izstream & pdb_stream,
	std::list < unsatisfied_buried_polar > & uns_list,
	std::list < unsatisfied_buried_group > & group_uns_list
);


int
find_tight_core_packing( bool const interface_flag );


void
decoystats_store_decoy();


void
dump_torsions();


void
dump_rsd_energies(
	int const total_residue,
	FArray1Da_int res
);


void
increment_counters();


void
hbond_counter();


void
fa_atr_counter();


void
local_bb_counter();


void
output_top_local_bb( std::string const & xxx );


void
reset_counters();


void
new_counter(
	std::string const & tag, // input
	int const type // input
);


void
increment_counter(
	std::string const & tag, // input
	int const type,
	int const i,
	int const j
);


void
output_decoystats();


void
output_counters( int const total );


void
DS_PAIR_output(
	std::string const & tag, // input
	int const i,
	int const j,
	float const f
);


void
DS_PAIR_BOX(
	std::string const & tag, // input
	int const i,
	int const j
);


void
DS_RSD_output(
	std::string const & tag, // input
	int const i, // input
	float const f
);


void
DS_RSD_BOX(
	std::string const & tag, // input
	int const i // input
);


void
DS_ATOM_output(
	std::string const & tag, // input
	int const i,
	int const j,
	std::string const & name, // input
	float const f
);


void
compare_to_native();


void
flip_side_chains(
	FArray3Da_float coord, // input/output
	FArray3Da_float nat_coord, // input
	FArray1D_bool & flipped // output
);


void
unflip_side_chains(
	FArray3Da_float coord, // input/output
	FArray1D_bool & flipped // input
);


void
flip_sc_chi_angle(
	FArray2Da_float coord, // input/output
	int const aa,
	int const aav,
	int const chi_to_flip
);


float
sc_rms(
	FArray3Da_float coord1,
	FArray3Da_float coord2,
	FArray2Da_bool use_atom, // input
	FArray1Da_float residue_rms // output
);


void
calc_sc_msd(
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	int const aa,
	int const aav,
	FArray1Da_bool use_atom, // input
	float & sc_msd, // output
	int & sc_npoints // output
);


void
sc_rms_coord_sys(
	FArray2Da_float p, // input: full_coord(1,1,pos): N,CA,C
	FArray2Da_float m,
	FArray1Da_float z
);


float
calc_sc_atom_msd(
	FArray1Da_float coord1,
	FArray2Da_float m1,
	FArray1Da_float z1,
	FArray1Da_float coord2,
	FArray2Da_float m2,
	FArray1Da_float z2
);


float
allatom_rms(
	FArray3Da_float coord1,
	FArray3Da_float coord2,
	FArray2Da_bool use_atom // which atoms to use
);


void
get_allatom_contacts(
	FArray3Da_float coord,
	FArray2Da_bool use_atom,
	int & num_contacts, // output
	FArray2Da_int contacts // list: res1,atom1,res2,atom2
);


float
allatom_touch_score(
	FArray3Da_float coord,
	FArray2Da_bool use_atom,
	FArray2Da_int correct_contacts, // list: res1,atom1,res2,atom2
	float & frac_nat_contacts,
	int & total_contacts
);


bool
atoms_in_contact(
	FArray1Da_float v,
	FArray1Da_float w
);


bool
get_use_big_polar_h();


void
set_use_big_polar_h( bool const setting );


void
decoystats_get_bfactor_occ(
	int const i,
	int const j,
	float & bfactor,
	float & occ
);


void
set_bfactor_by_atom_set( FArray2Da_bool use_atom );


float
rsd_exposed_sasa( int const rsd );


void
generate_hbond_info(
	FArray1Da_float dhatm_xyz,
	FArray1Da_float aatm_xyz,
	FArray1Da_float datm_xyz,
	FArray1Da_float abase_xyz,
	float & dis_ha,
	float & dis_dh,
	float & dis_ad,
	float & psi_hb,
	float & phi_hb
);


void
dump_hbond_info(
	std::string const & start_file,
	int const dres,
	int const dres_type,
	int const datm,
	int const dtype,
	int const ares,
	int const ares_type,
	int const aatm,
	int const atype,
	float const dis_ha,
	float const dis_dh,
	float const dis_ad,
	float const psi_hb,
	float const phi_hb,
	int const hb_num
);


std::string decide_uns_type( unsatisfied_buried_polar & uns );

#endif
