// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_decoystats_classes
#define INCLUDED_decoystats_classes

// C++ Headers
#include <iosfwd>
#include <list>
#include <string>


// jk Class definition for unsatisfied_buried_polar
class unsatisfied_buried_polar
{

private:

	bool is_donor;
	bool is_backbone;
	bool is_satisfied;
	std::string start_file;
	std::string residue_type;
	int seqpos;
	int atm;
	float hbE;
	std::string atom_name;
	float atom_sasa, atom_sasa10, atom_sasa7;

public:

	bool operator == ( unsatisfied_buried_polar& rhs ) const;

	bool operator < ( unsatisfied_buried_polar& rhs ) const;

	void set_all(
		const bool in_is_donor, const bool in_is_backbone, const bool in_is_satisfied,
		const std::string in_start_file, const std::string in_residue_type, const int in_seqpos,
		const int in_atm, const float in_hbE, const std::string in_atom_name,
		const float in_atom_sasa, const float in_atom_sasa10, const float in_atom_sasa7);

	inline bool donor() const { return is_donor; };

	inline int get_seqpos() const { return seqpos; };

	std::string get_residue_type() const { return residue_type; };

	inline int get_atm() const { return atm; };

	inline bool backbone() const { return is_backbone; };

	inline bool satisfied() const { return is_satisfied; };

	inline bool buried10() const { if ( atom_sasa10 <= 0. ) { return true; } return false; };

	inline bool buried() const { if ( atom_sasa <= 0. ) { return true; } return false; };

	int group_type() const;

	float weight() const;

	bool uns_group( std::list < unsatisfied_buried_polar > uns_list ) const;

	void write_to_PDB( const std::string tag, const std::string uns_type ) const;

	void write_to_cout( const std::string tag, const std::string uns_type ) const;

};


enum group_uns_types {
	BBH, BBO, NH3_plus, NH2_plus, NH2, NHaro_plus,
	NHaro, NHarg, COO_minus, CO, OH, SH, N, IGNORE
};


// jk Class definition for unsatisfied_buried_group
class unsatisfied_buried_group
{

private:

	int seqpos;
	bool is_backbone;
	int group_type;

public:

	unsatisfied_buried_group( const int in_seqpos, const int in_type );

	unsatisfied_buried_group( const int in_seqpos, const std::string in_type );

	bool operator == ( unsatisfied_buried_group& rhs ) const;

	bool operator < ( unsatisfied_buried_group& rhs ) const;

	inline int get_seqpos() const { return seqpos; };

	inline int get_type() const { return group_type; };

	std::string get_type_name() const;

	float weight() const;

	void write_to_PDB( const std::string tag ) const;

	void write_to_cout( const std::string tag ) const;

};



#endif
