// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_decoystats_interface
#define INCLUDED_decoystats_interface


// Rosetta Headers
#include "decoystats_classes.h"
#include "aromatic_stack.h"
#include "decoystats_interface_classes.h"
#include "hotspot_residue.h"
#include "packing_measures.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <iosfwd>
#include <list>
#include <vector>
#include <string>

// Forward declarations
namespace pose_ns { class Pose; }

namespace energy_quantifier_ns {
	enum energy_quantifier {
		ATR, REP, SOL, HB, PROB, DUN, PAIR, INTRARES, GB, CST, PLANE,
		H2O, H2OHB, WSOL, UNF, TOT, SASAPACK, SASAPROB
	};
}

// Function Declarations

void
set_interface_ds_flag( bool setting );


bool
get_interface_ds_flag();


// jk Class definition for interface_ds
class interface_ds
{

private:

	// jk pointer to a pose
	pose_ns::Pose * pose_;
	int NRES_;

	// jk definition of the interface
	int num_interface_res;
	int num_core_interface_res;
	int num_interface_atom;
	int num_interface_water;
	FArray1D_bool interface_res;
	FArray1D_bool core_interface_res;
	FArray2D_bool interface_atom;
	FArray1D_float res_sasa_complex;
	FArray2D_float atom_sasa_complex;
	FArray1D_float res_sasa_diff;
	FArray2D_float atom_sasa_diff;

	// jk Sasa to a 0.7 A probe (in the complex)
	FArray2D_float atom_sasa_smallprobe;
	FArray1D_float res_sasa_smallprobe;

	bool done_packing_measures_init;
	bool done_finding_hotspots;
	bool done_finding_stacks;

	// jk measure of interface size
	float max_interface_void_volume;
	float max_interface_void_radius;
	float total_interface_void_volume;

	// jk bound - unbound score
	float delta_score;

	// jk measure of interface size
	float delta_sasa;

	// jk measures of composition
	int num_interface_aromatics;
	float sasa_interface_aromatics;
	int num_polar_atoms;
	int num_atoms;
	int met_sc_atoms;
	int interface_chi_angles;

	// jk for hotspot analysis
	int num_hotspot_residues;
	FArray1D_bool hotspot_res;
	std::vector < hotspot_residue > hotspot_list;

	// jk for aromatic stacking analysis
	int num_stacks;
	FArray1D_bool stack_res;
	FArray1D_bool buried_stack_res;
	std::vector < aromatic_stack > stack_list;

	// jk energetic measures
	bool energies_initialized;
	std::vector < interface_energy_quantifier > energy_quantifiers;

	// jk measures of packing
	int interface_num_tight;
	packing_ns::ProteinSasa ps;

	// jk uns lists
	std::list < unsatisfied_buried_polar > bound_uns_list;
	std::list < unsatisfied_buried_group > bound_group_uns_list;
	std::list < unsatisfied_buried_polar > unbound_uns_list;
	std::list < unsatisfied_buried_group > unbound_group_uns_list;
	std::list < unsatisfied_buried_polar > exempt_uns_list;
	std::list < unsatisfied_buried_group > exempt_group_uns_list;
	std::list < unsatisfied_buried_polar > interface_strict_uns_list;
	std::list < unsatisfied_buried_group > interface_strict_group_uns_list;
	std::list < unsatisfied_buried_polar > interface_delta_uns_list;
	std::list < unsatisfied_buried_group > interface_delta_group_uns_list;

	void initialize_interface_packing_measures();

	void define_interface();

	void find_hotspots();

	void find_stacks();

	float compute_Cbeta_atr( int const seqpos, bool const interface_mode = false );

	void count_interface_waters(
		float const probe_radius,
		float const interface_diff_thres
  );

	void setup_energetic_quantifiers();

	void compute_quantifiers();

	float compute_delta_sasa();

	void compute_composition();

	void compute_energies();

	int compute_tight_core_packing();

public:

	interface_ds( pose_ns::Pose * input_pose_ptr );

	inline void adjust_pointer( pose_ns::Pose * input_pose_ptr ) { pose_ = input_pose_ptr; };

	void report_core_uns(
    std::string const tag,
    std::list < unsatisfied_buried_polar > & uns_list
  );

	void report_core_uns(
    std::string const tag,
    std::list < unsatisfied_buried_polar > & uns_list,
    std::list < unsatisfied_buried_group > & group_uns_list
  );

	void describe_hotspots();

	float best_hotspot_atr_ene();

	float best_hotspot_SASA_small();

	float best_hotspot_SASApack();

	float best_hotspot_SASAprob();

	float best_hotspot_maxvoid();

	void describe_stacks();

	float best_stack_intrastack_ene();

	float best_stack_plane_ene();

	float best_stack_atr_ene();

	float best_stack_SASApack();

	float best_stack_SASAprob();

	void write_all_quantifiers_to_PDB();

	void list_interface_res();

	void list_interface_atoms();

	void find_CBCB();

	void compute_delta_UNS(
    bool const do_repack,
		bool const compare_to_polyAla,
		bool const refine_loops
  );

	void reset_noninterface_bfactors( float const reset_val );

	bool test_for_hotspot( int const seqpos, hotspot_residue & hr );

	bool test_for_stack( int const seqposA, int const seqposB, aromatic_stack & stack );

	int count_buried_AspAsn();

	bool test_AspAsn_burial( int const seqpos );

	inline float get_delta_score() { return delta_score; };

	inline float get_delta_sasa() { return delta_sasa; };

	inline float get_max_interface_void_volume() { return max_interface_void_volume; };

	inline float get_max_interface_void_radius() { return max_interface_void_radius; };

	inline float get_total_interface_void_volume() { return total_interface_void_volume; };

	inline bool num_hotspots() { find_hotspots(); return num_hotspot_residues; };

	inline bool is_hotspot( int const seqpos ) { find_hotspots(); return hotspot_res(seqpos); };

	inline bool is_stack( int const seqpos ) { return stack_res(seqpos); };

	inline bool is_buried_stack( int const seqpos ) { return buried_stack_res(seqpos); };

	inline int count_interface_delta_group_uns_list()
	{ return interface_delta_group_uns_list.size(); };

	// Note: return by const reference
	inline std::list < unsatisfied_buried_group > const & get_interface_delta_group_uns_list()
	{ return interface_delta_group_uns_list; };

	// Note: return by value!
	inline std::list < unsatisfied_buried_group > get_copy_of_interface_delta_group_uns_list()
	{ return interface_delta_group_uns_list; };

};



#endif
