// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32323 $
//  $Date: 2009-08-25 13:16:13 -0700 (Tue, 25 Aug 2009) $
//  $Author: johnk $


// Rosetta Headers
#include "decoystats_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Using
using namespace param;


namespace decoystats {


// constants -------------------------------------------

int const max_contacts = { 10000 }; // heavyatom contacts

// as calculated by calc_per_atom_sasa w/1.4A probe
// then take fraction of values for extended chain
// given in decoystats.cc

float const buried_residue_threshold = { 0.20 };


// info about the native --------------------------------

namespace decoystats_native_common {
	FArray3D_float native_full_coord( 3, MAX_ATOM(), MAX_RES() );
	FArray1D_int native_aa( MAX_RES() );
	FArray1D_int native_aav( MAX_RES() );
	FArray3D_float native_hbondE; //( MAX_RES(), MAX_RES(), 4 );
	FArray2D_float native_lj_atr; //( MAX_RES(), MAX_RES() );
	FArray2D_int native_contacts( 4, max_contacts );
	FArray2D_float native_chi( MAX_CHI, MAX_RES() );
	FArray2D_int native_rot( MAX_CHI, MAX_RES() );
}


// different atomsets ------------------
int const n_atom_set = { 6 };
int const all_heavyatoms = { 1 };
int const native_buried_heavyatoms = { 2 };
int const native_buried_rsd_heavyatoms = { 3 };

namespace chi_atom_set_common {


	void
	chi_atom_set_number_initializer( FArray1D_int & chi_atom_set_number )
	{
		int i = 0;
		// no-chi, 1-chi, and 2-chi-required atom sets
		chi_atom_set_number( ++i ) = 4;
		chi_atom_set_number( ++i ) = 5;
		chi_atom_set_number( ++i ) = 6;
	}


	FArray1D_int chi_atom_set_number( 3, chi_atom_set_number_initializer );
}


namespace decoystats_atom_set_common {
	FArray3D_bool atom_set; //( MAX_ATOM(), MAX_RES(), n_atom_set );
}


// jk interface decoystats
namespace decoystats_interface {
	bool interface_ds_flag = { false };
	bool find_interface_CBCB = { false };
}


// info about the current structure ---------------------

namespace decoystats_current_pose {
	FArray2D_float atom_hbondE( MAX_ATOM(), MAX_RES() );
	FArray3D_float rsd_pair_hbondE; //( MAX_RES(), MAX_RES(), 4 );
	bool decoy_is_native = { false };
}


// list of tightly packed atoms -------------

namespace tight_packing {
	bool tight_core_analysis = { false };
	bool tight_core_Bfactors = { false };
	float tight_core_thres;
	FArray2D_bool tightly_packed( MAX_ATOM(), MAX_RES() );
}


// counters::: ------------------------------------------
int const max_pair_count = { 10 };
int const max_rsd_count = { 10 };
int const max_atom_count = { 10 };
int const max_tags = { 10 };
int const pair_type = { 1 };
int const rsd_type = { 2 };
int const atm_type = { 3 };


namespace decoystats_counter_common {
	int total_decoys;
	FArray3D_int pair_count; //( MAX_RES(), MAX_RES(), max_pair_count );
	FArray2D_int rsd_count( MAX_RES(), max_rsd_count );
	FArray3D_int atom_count; //( MAX_ATOM(), MAX_RES(), max_atom_count );
	FArray2D_string tags( max_tags, 3, std::string( 8, ' ' ) ); // 1=pair,2=rsd,3=atom
	FArray1D_int ntags( 3 ); // 1=pair,2=rsd,3=atom
}


// for tracking decoy scores ----------------------------

namespace decoystats_decoy_score_common {
	int const max_score_tags = { 1000 };
	int n_score_tags;
	FArray1D_string score_tags( max_score_tags );
	FArray1D_float decoystats_score( max_score_tags );
}

} // namespace decoystats

