// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32323 $
//  $Date: 2009-08-25 13:16:13 -0700 (Tue, 25 Aug 2009) $
//  $Author: johnk $

#ifndef INCLUDED_decoystats_ns
#define INCLUDED_decoystats_ns

// Rosetta Headers
//#include "decoystats_classes.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace decoystats {


// constants -------------------------------------------
extern int const max_contacts; // heavyatom contacts

// as calculated by calc_per_atom_sasa w/1.4A probe
// then take fraction of values for extended chain
// given in decoystats.cc

extern float const buried_residue_threshold;


// info about the native --------------------------------

namespace decoystats_native_common {
	extern FArray3D_float native_full_coord;
	extern FArray1D_int native_aa;
	extern FArray1D_int native_aav;
	extern FArray3D_float native_hbondE;
	extern FArray2D_float native_lj_atr;
	extern FArray2D_int native_contacts;
	extern FArray2D_float native_chi;
	extern FArray2D_int native_rot;
}
using namespace decoystats_native_common;


// different atomsets ------------------
extern int const n_atom_set;
extern int const all_heavyatoms;
extern int const native_buried_heavyatoms;
extern int const native_buried_rsd_heavyatoms;

namespace chi_atom_set_common {
	extern FArray1D_int chi_atom_set_number;
}
using namespace chi_atom_set_common;


namespace decoystats_atom_set_common {
	extern FArray3D_bool atom_set;
}
using namespace decoystats_atom_set_common;


// jk interface decoystats
namespace decoystats_interface {
	extern bool interface_ds_flag;
	extern bool find_interface_CBCB;
}
using namespace decoystats_interface;


// info about the current structure ---------------------

namespace decoystats_current_pose {
	extern FArray2D_float atom_hbondE;
	extern FArray3D_float rsd_pair_hbondE;
	extern bool decoy_is_native;
}
using namespace decoystats_current_pose;


// list of tightly packed atoms -------------

namespace tight_packing {
	extern bool tight_core_analysis;
	extern bool tight_core_Bfactors;
	extern FArray2D_bool tightly_packed;
	extern float tight_core_thres;
}
using namespace tight_packing;


// counters::: ------------------------------------------
extern int const max_pair_count;
extern int const max_rsd_count;
extern int const max_atom_count;
extern int const max_tags;
extern int const pair_type;
extern int const rsd_type;
extern int const atm_type;


namespace decoystats_counter_common {
	extern int total_decoys;
	extern FArray3D_int pair_count;
	extern FArray2D_int rsd_count;
	extern FArray3D_int atom_count;
	extern FArray2D_string tags; // 1=pair,2=rsd,3=atom
	extern FArray1D_int ntags; // 1=pair,2=rsd,3=atom
}
using namespace decoystats_counter_common;


// for tracking decoy scores ----------------------------

namespace decoystats_decoy_score_common {
	extern int const max_score_tags;
	extern int n_score_tags;
	extern FArray1D_string score_tags;
	extern FArray1D_float decoystats_score;
}
using namespace decoystats_decoy_score_common;


}

#endif
