// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32323 $
//  $Date: 2009-08-25 13:16:13 -0700 (Tue, 25 Aug 2009) $
//  $Author: johnk $

#ifndef INCLUDED_design
#define INCLUDED_design


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Rosetta Headers
#include "ConformerLibHandler.h"
#include "RotamerOptions.h"


//bk command line arguments specific to the design module

namespace design {

extern RotamerOptions active_rotamer_options;

extern bool eval_sc_bbE_for_energy1b;

//ds parameter values for design_from_mut_list and get_redesign_mutation_list
extern int const max_sim;
extern int const max_mut_per_sim;
extern int const max_num_chains;
extern int const max_filename;

namespace design_commands {

	extern bool fix_interface_UNS_flag;
	extern bool incorporate_hotspot;
	extern bool design_only_hydrophobic;
	extern bool refine_hotspot;
	extern float hotspot_scale_fac;

	extern bool identify_interface_UNS_flag;
	extern bool build_Ala_interface;
	extern int ndruns;
	extern bool onlypack;
	extern bool fast_ala_scan;
	extern bool optE;
	extern bool optE_ctsa;
	extern bool optE_jk;
	extern bool optE_rep_cut;
	extern float optE_rep_cut_val;
	extern bool fixbb;
	extern bool natrot;
	extern bool fixseq;
	extern bool mvbb;
	extern bool shakenbake;
	extern bool design_in_pieces;
	extern bool dna_interface;
	extern bool explicit_h2o;
  extern bool water_on_fixed_chain;
	extern bool solvate;
	extern bool try_both_his_tautomers;
	extern bool hydrate_dna;
	extern bool ex_dna_waters;
	extern bool rotamerize;
	extern bool minimize_rot;
	extern bool desock;   // design and dock_mcm protocol
	extern bool desrub;   // design and backrub protocol (interface only)
	extern bool design_inter;
	extern bool repack_inter;
	extern bool design_unbound;
	extern bool point_mutation;
	extern float interface_residue_cutoff;
	extern FArray1D_bool interface_residue;
	extern int n_interface_residues;
	extern FArray1D_int interface_residue_list;
	extern int fix_target_seq;
	extern bool read_optE_poslist;
	extern bool optE_inter;
	extern bool alter_spec;
	extern bool chain_limit;
	extern char chain_choose;
	extern bool design_trials;
	extern FArray2D_bool design_matrix;
	extern bool use_design_matrix;
	extern bool mut_list;
	extern FArray1D_bool automatic_behavior;
	extern bool no_his_his_pairE;
	extern bool use_electrostatic_repulsion;
	extern bool safety;
	extern bool dna_motifs;
  extern bool test_random_blocker_sequences;
	extern bool multistate;
	extern bool tail;
	extern bool tail_fix_helix;
	extern int tail_begin;
	extern int tail_end;
	extern bool design_min_inter;
	extern bool dock_des_min_inter;
  extern bool flex_peptide; // SJF
	extern bool mcmin_trials;
	extern bool linmin_trials;
	extern bool design_dock_pert;
	extern bool ligand_filter;
	extern float ligand_filter_score;
	extern int ligand_filter_count;
	extern bool output_design_movie;
	extern int num_movie_frames;
	extern bool no_new_CGP;
	extern bool auto_resfile;
	extern bool mutate_cluster;
	extern bool output_pdb;
	extern bool pack_in_parallel;
	extern int conv_limit_mod;
	extern std::string chain_in_preferred_state;
	extern std::string chain_in_ref_state;
	extern bool reverse_comp;
	extern bool use_directed_design;
	extern std::string directed_design_filename;
	extern int timelimit;
	extern bool design_interface_electrostatic_complementarity;
	extern float interface_electrostatic_complementarity_shift;
	extern float interface_electrostatic_complementarity_shift_weight;

	extern bool compute_homodimer_specificity;
	extern float homodimerA_energy;
	extern float homodimerB_energy;

	extern bool debug_annealer_design;
}

using namespace design_commands;

namespace design_cluster {
	extern bool cluster_design;
	extern bool use_cluster_size;
	extern int cluster_size;
	extern std::string mutenergy_out;
	extern bool fix_mut;
	extern std::string mutenergy_in;
	extern std::string design_mutlist;
	extern bool use_real_cluster_only;
	extern	float cluster_dis_cut1;
	extern	float cluster_dis_cut2;
	extern	float cluster_dis_cut3;
	extern	float design_dis_cut1;
	extern	float design_dis_cut2;
	extern	float repack_dis_cut1;
	extern	float repack_dis_cut2;
	extern float high_nb;
	extern float low_nb;
	extern bool check_point;
	extern int last_cpts_size;
	extern int n_mutatpos;
	extern bool debug_output;
	extern bool minimize_structures;
	extern bool minimize_wt_struct;
	extern bool output_structures;
	extern bool minimize_bb;
	extern bool design_neighbors;

}

using namespace design_cluster;

	namespace design_loops_flags{
		extern bool design_loops;
		extern std::string design_loops_option;
		extern bool design_loops_dock;//design loops and docking (2 chains)
		extern bool design_loops_hold;//design loops for a single chain loop of a protein
	}

using namespace design_loops_flags;

namespace conformer {
	extern ConformerLibHandler confLibHandler; // use conformer library if true
	extern std::string confLibChoice; //sets the cluster size of the lib to be loaded
}
using namespace conformer;

} // namespace design



#endif

