// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13036 $
//  $Date: 2007-02-22 19:03:09 -0800 (Thu, 22 Feb 2007) $
//  $Author: yab $


// Rosetta Headers
#include "diagnostics_rosetta.h"
#include "aaproperties_pack.h"
#include "cenlist.h"
#include "counters.h"
#include "maps.h"
#include "misc.h"
#include "monte_carlo.h"
#include "param.h"
#include "pdb.h"
#include "refold.h"
#include "runlevel.h"
#include "score_ns.h"
#include "vdw.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/FArray3Dp.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>


////////////////////////////////////////////////////////////////////////////////
/// @begin increment_trial_counters
///
/// @brief
///
/// @detailed
///
/// @param  cycle_number - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
increment_trial_counters( int cycle_number )
{
	using namespace counters;
	using namespace runlevel_ns;

	//// local
	int accept;
	int current_trial_index_no = 0;
//------------------------------------------------------------------------------

	if ( cycle_number < -.5 ) return;
	accept = get_monte_carlo_accept();

//
// ctsa   diagnostics changed to automatically count different trial types
//

	////  find previous index for trial label if it already exists
	////
	for ( int i = 1; i <= n_trial_labels; ++i ) {
		if ( move_type == trial_label_index(i) ) {
			current_trial_index_no = i;
			goto L122; // jump out of label search
		}
	}

L122:

	////  add new index for trial label if it doesn't exist
	////
	if ( current_trial_index_no == 0 ) {
		++n_trial_labels;

		//// check against max array size
		if ( n_trial_labels > max_trial_index ) {
			if ( runlevel >= standard ) {
				std::cout << "max_trial_index exceeded! current value=" <<
				 max_trial_index << std::endl;
				std::cout << "acceptance rate of move_type " << move_type <<
				 "will not be tracked" << std::endl;
			}
			return;
		}

		//// initialize a new trial type
		trial_label_index( n_trial_labels ) = move_type;
		trial_total_counts( n_trial_labels ) = 0;
		trial_accept_counts( n_trial_labels ) = 0;
		trial_energy_drop( n_trial_labels ) = 0.0f;
		current_trial_index_no = n_trial_labels;

	}


	////  increment trial counters for this trial index
	////
	++trial_total_counts(current_trial_index_no);

	if ( accept > 0 ) {
		++trial_accept_counts(current_trial_index_no);
		trial_energy_drop( current_trial_index_no ) += get_monte_carlo_energy_drop();
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_trial_stats_by_type
///
/// @brief
///
/// @detailed
///
/// @param  type - [in/out]? -
/// @param  trials - [in/out]? -
/// @param  accepts - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_trial_stats_by_type(
	std::string & type,
	int & trials,
	int & accepts
)
{
	using namespace counters;

//car local
	int current_trial_index_no = 0;

	trials = 0;
	accepts = 0;

//car find index for trial label if it exists
	for ( int i = 1; i <= n_trial_labels; ++i ) {
		if ( type == trial_label_index(i) ) {
			current_trial_index_no = i;
			goto L122; // jump out of label search
		}
	}
	return;

L122:
	trials = trial_total_counts(current_trial_index_no);
	accepts = trial_accept_counts(current_trial_index_no);
}

////////////////////////////////////////////////////////////////////////////////
/// @begin reset_trial_counters
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
reset_trial_counters()
{
	using namespace counters;

	n_trial_labels = 0;
}



////////////////////////////////////////////////////////////////////////////////
/// @begin output_trial_counters
///
/// @brief
///
/// @detailed
///
/// @param  iunit - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
output_trial_counters( std::ostream & iunit )
{
	//// ctsa - diagnostics changed to automatically account for different trial types
	////

	using namespace counters;

	//// local
	FArray1D_int print_order( max_trial_index );
	FArray1D_float print_order_perc( max_trial_index );
	float accept_perc;
	int insert_point;
//------------------------------------------------------------------------------
	//// initialize array with non-sorted order for safety
	for ( int i = 1; i <= n_trial_labels; ++i ) {
		print_order(i) = i;
	}

	//// sorted insert in list from highest to lowest percent accepted
	////   ( this is a dog sort algorithm, but no need to improve here )
	////
	for ( int i = 1; i <= n_trial_labels; ++i ) {

		accept_perc = (trial_accept_counts(i)*100.)/trial_total_counts(i);

		//// find insert point
		insert_point = 1;
		print_order_perc(i) = 0;
		for ( int j = 1; j <= i; ++j ) {
			if ( accept_perc >= print_order_perc(j) ) {
				insert_point = j;
				goto L121;
			}
		}

L121:

		//// shift everything below insert point down one
		for ( int j = i; j >= insert_point+1; --j ) {
			print_order(j) = print_order(j-1);
			print_order_perc(j) = print_order_perc(j-1);
		}

		//// insert new value
		print_order(insert_point) = i;
		print_order_perc(insert_point) = accept_perc;
	}


	//// write trials out in sorted order
	////
	for ( int i = 1; i <= n_trial_labels; ++i ) {
		int j = print_order(i);
		float const avg_energy_drop = trial_energy_drop( j )/ trial_total_counts( j );
		iunit << sized( trial_label_index(j), 12 ) << " trials: "
					<< I( 6, trial_total_counts(j)) << " accepts: " << I( 6, trial_accept_counts(j))
					<< " %: " << F(6, 2, print_order_perc(i))
					<< " e/trial: " << F(9, 5, avg_energy_drop) << std::endl;
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin output_accepted_trial_stats
///
/// @brief
///
/// @detailed
///
/// @param  j - [in/out]? -
/// @param  num - [in/out]? - num of the scoring function used
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
output_accepted_trial_stats(
	int & j,
	int & num // num of the scoring function used
)
{
	// to select output type

	using namespace counters;
	using namespace misc;
	using namespace scores;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	int monte_carlo_accept;


	monte_carlo_accept = get_monte_carlo_accept();
	if ( num < 0 ) {
		std::cout << " trial: monte carlo accept" <<
		 SS( monte_carlo_accept ) << std::endl;
		std::cout << "j,naccept,rg,score,pc_score,vdw_score,env_score," <<
		 "ss_score,rms_err,rms_min,low_cycle" << std::endl;
		std::cout << I( 5, j ) << ' ' << I( 5, naccept ) << ' ' <<
		 G( 9, 3, rg ) << ' ' <<
		 G( 9, 3, score ) << ' ' <<
		 G( 9, 3, pc_score ) << ' ' <<
		 G( 9, 3, vdw_score ) << ' ' <<
		 G( 9, 3, env_score ) << ' ' <<
		 G( 9, 3, ss_score ) << ' ' <<
		 G( 9, 3, rms_err ) << ' ' <<
		 G( 9, 3, rms_min ) << ' ' <<
		 I( 5, low_cycle ) << std::endl;
		return;
	}

	if ( monte_carlo_accept < 1 ) return;

	if ( num < 9 ) {
		std::cout << " monte carlo accept " << SS( monte_carlo_accept ) << std::endl;
		std::cout << "j,naccept,rg,score,pc_score,vdw_score,env_score," <<
		 "ss_score,rms_err,rms_min,low_cycle" << std::endl;
		std::cout << I( 5, j ) << ' ' << I( 5, naccept ) << ' ' <<
		 G( 9, 3, rg ) << ' ' <<
		 G( 9, 3, score ) << ' ' <<
		 G( 9, 3, pc_score ) << ' ' <<
		 G( 9, 3, vdw_score ) << ' ' <<
		 G( 9, 3, env_score ) << ' ' <<
		 G( 9, 3, ss_score ) << ' ' <<
		 G( 9, 3, rms_err ) << ' ' <<
		 G( 9, 3, rms_min ) << ' ' <<
		 I( 5, low_cycle ) << std::endl;
	}
	if ( num == 9 ) {
		std::cout << " monte carlo accept " << SS( monte_carlo_accept ) << std::endl;
		std::cout << "j,naccept,rg,score,pc_score,lj_atr,lj_rep,env_score," <<
		 "ss_score,rms_err,rms_min,low_cycle,atr,rep" << std::endl;
		std::cout << I( 5, j ) << ' ' << I( 5, naccept ) << ' ' <<
		 G( 9, 3, rg ) << ' ' <<
		 G( 9, 3, score ) << ' ' <<
		 G( 9, 3, pc_score ) << ' ' <<
		 G( 9, 3, fa_atr_score ) << ' ' <<
		 G( 9, 3, fa_rep_score ) << ' ' <<
		 G( 9, 3, env_score ) << ' ' <<
		 G( 9, 3, ss_score ) << ' ' <<
		 G( 9, 3, rms_err ) << ' ' <<
		 G( 9, 3, rms_min ) << ' ' <<
		 I( 5, low_cycle ) << std::endl;
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin check_cendist
///
/// @brief
///car check that the cenlist is correct.  After a partial refold and
///car score, this function copies the cenlist, does a complete refold
///car and the recalculates the cenlist and looks for differences
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
check_cendist()
{

//car for debugging purposes only

	using namespace cenlist_ns;
	using namespace misc;
	using namespace param;

	FArray2D_float old_cendist( cendist );

	//car make a copy of the current pair_moved array
	FArray2D_bool old_pair_moved( retrieve_pair_moved() );

	debug_move_maps(true);
	refold(1,total_residue);
	update_cendist(total_residue,centroid);
	compare_cendist(old_cendist,cendist,MAX_RES()(),total_residue,old_pair_moved);
	cendist = old_cendist;
	debug_move_maps(false);

}

////////////////////////////////////////////////////////////////////////////////
/// @begin compare_cendist
///
/// @brief
///
/// @detailed
///
/// @param  old_cendist - [in/out]? -
/// @param  cendist - [in/out]? -
/// @param  max_res - [in/out]? -
/// @param  total_residue - [in/out]? -
/// @param  pair_moved - [in] -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
compare_cendist(
	FArray2Da_float old_cendist,
	FArray2Da_float cendist,
	int max_res,
	int total_residue,
	FArray2Da_bool pair_moved
)
{
	old_cendist.dimension( max_res, total_residue );
	cendist.dimension( max_res, total_residue );

	for ( int i = 1; i <= total_residue; ++i ) {
		for ( int j = 1; j <= total_residue; ++j ) {
			if ( std::abs(cendist(i,j) - old_cendist(i,j)) > 0.1  && ! pair_moved(i,j)) {
				std::cout << "cen i,j " << i << ", " << j << ' ' <<
					SS( cendist(i,j) ) << SS( old_cendist(i,j) ) << std::endl;
			}
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin write_res
///
/// @brief
/// output the entire identity of a residue
///
/// @detailed
///
/// @param  iunit - [in/out]? -
/// @param  res_x - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
write_res(
	std::ostream & iunit,
	int res_x
)
{

	using namespace misc;
	using namespace pdb;

	iunit << space( 5 ) <<
	 residue3(res_x) << I( 4, pdb_res_num(res_x) ) << pdb_insert_let(res_x) <<
	 res_chain(res_x) << " (Rosetta" << I( 4, res_x ) << ")";
}

////////////////////////////////////////////////////////////////////////////////
/// @begin write_res_coords
///
/// @brief
///
/// @detailed
///
/// @param  iunit - [in/out]? -
/// @param  res_x - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
write_res_coords(
	std::ostream & iunit,
	int res_x
)
{
// output the entire identity of a residue, plus coordinates of the N

	using namespace misc;

	write_res( iunit, res_x );

//     coordinates of N
	iunit << "  " << "N-Coords, ";
	for ( int i = 1; i <= 3; ++i ) {
		iunit << F( 9, 3, Eposition(i,1,res_x) ) << ' ';
	}
	iunit << std::endl;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin write_fullcoord_atom
///
/// @brief
/// output the entire identity of a residue
///
/// @detailed
///
/// @param  iunit - [in/out]? -
/// @param  res_x - [in/out]? -
/// @param  atom_x - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
write_fullcoord_atom(
	std::ostream & iunit,
	int res_x,
	int atom_x
)
{

	using namespace aaproperties_pack;
	using namespace misc;

	write_res( iunit, res_x );

//     atom
	iunit << "  " << "Atom " <<
	 atom_name(atom_x,res(res_x),res_variant(res_x)) <<
	 " (Rosetta atom " << I( 2, atom_x ) << ")" << std::endl;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin write_fullcoord_atom_coords
///
/// @brief
/// output the entire identity of a residue
///
/// @detailed
///
/// @param  iunit - [in/out]? -
/// @param  res_x - [in/out]? -
/// @param  atom_x - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
write_fullcoord_atom_coords(
	std::ostream & iunit,
	int res_x,
	int atom_x
)
{

	using namespace misc;

	write_fullcoord_atom(iunit,res_x,atom_x);

//     coordinates
	iunit << "  " << "Coords, ";
	for ( int i = 1; i <= 3; ++i ) {
		iunit << F( 9, 3, full_coord(i,atom_x,res_x) ) << ' ';
	}
	iunit << std::endl;
}
