// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#include "dim.h"

dim_ns::dim::dim() :
  w(wPriv), h(hPriv), d(dPriv), slice(slicePriv), voxels(voxelsPriv) {

  wPriv = -1;
  hPriv = -1;
  dPriv = -1;
  slicePriv = -1;
  voxelsPriv = -1;
}

dim_ns::dim::dim(const int &wInit, const int &hInit, const int &dInit) :
  w(wPriv), h(hPriv), d(dPriv), slice(slicePriv), voxels(voxelsPriv) {

  assert(wInit > 0);
  assert(hInit > 0);
  assert(dInit > 0);

  wPriv = wInit;
  hPriv = hInit;
  dPriv = dInit;
  slicePriv = wInit * hInit;
  voxelsPriv = wInit * hInit * dInit;
}

dim_ns::dim::dim(const dim &d) :
  w(wPriv), h(hPriv), d(dPriv), slice(slicePriv), voxels(voxelsPriv) {
  wPriv = d.wPriv;
  hPriv = d.hPriv;
  dPriv = d.dPriv;
  slicePriv = d.slicePriv;
  voxelsPriv = d.voxelsPriv;
}

int dim_ns::dim::max() {
  int m = (wPriv > hPriv) ? wPriv : hPriv;
  m = (dPriv > m) ? dPriv : m;
  return m;
}

bool dim_ns::dim::operator==(const dim &rhs) const {
  return (w == rhs.w) &&  (h == rhs.h) &&  (d == rhs.d);
}

bool dim_ns::dim::operator!=(const dim &rhs) const {
  return !((*this) == rhs);
}

dim_ns::dim &dim_ns::dim::operator=(const dim &rhs) {
  wPriv = rhs.wPriv;
  hPriv = rhs.hPriv;
  dPriv = rhs.dPriv;
  slicePriv = rhs.slicePriv;
  voxelsPriv = rhs.voxelsPriv;

  return *this;
}

std::ostream &operator <<(std::ostream &s, const dim_ns::dim &size) {
  s << "(" << size.w << ", " << size.h << ", " << size.d << ")";
  return s;
}
