// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef DIM_H
#define DIM_H

#include <iostream>
#include <assert.h>

namespace dim_ns {
  class dim {
  public:
    dim();
    dim(const int &wInit, const int &hInit, const int &dInit);
    dim(const dim &d);

    // member variables
    const int &w;
    const int &h;
    const int &d;
    const int &slice;  // Number of voxels in a slice.
    const int &voxels; // Total number of voxels.

    int max();

    // operators
    bool operator==(const dim &rhs) const;
    bool operator!=(const dim &rhs) const;
    dim &operator=(const dim &rhs);

    friend std::ostream &operator << (std::ostream &s, const dim &size);

  private:
    // The referemces point to these.
    int wPriv;
    int hPriv;
    int dPriv;
    int slicePriv;  // Number of voxels in a slice.
    int voxelsPriv; // Total number of voxels.
  };
}

#endif
