// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_dipolar_ns
#define INCLUDED_dipolar_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <iosfwd>


namespace dipolar {


extern int const MAXDIPOLAR;
extern int const MAXDIPSETS;
extern int const ORDERSIZE; // # independent elements in ordermatrix
extern int const MAXDIPTYPES; // types for which data is precomputed in vall
 // 1:HN-N,2:HA-CA,3:CA-C,4:C(i-1)-N,5:C(i-1)-HN,HN(i)-HA(i)


extern float const dipolar_cutoff; // score cutoff for full atom


	// (key,index) key:1=res1,2=atom1
	//                 3=res2,4=atom2
	//                 5=set#
	// <0 for atoms whose distance is variable
	// when Ddist2 < 0 (ie variable dist) invDmax
	// is equal to the last calculated value


namespace dipolar_private {
	extern int Ndipolar; // number of dipolar constraints
	extern FArray2D_int pairDipolar;
	extern int Ndipolar_sets;
	extern FArray1D_double Jdipolar;
	 // coupling constant of ith constraint (Hz)
	extern FArray1D_double invDcnst; // 1/dipolar interaction constant
	extern FArray1D_float Ddist; // dist for atom pairs whose distance is fixed
	extern FArray1D_double invDmax;
	 // dist^3/Dcnst/dist^3 for fixed dist pairs
	extern std::ostream * dunit_p; // stream to dump output to
	std::ostream & dunit(); // Function returning dump stream
}
using namespace dipolar_private;


	// (res1,atom1,res2,atom2,res3,atom3,res4,atom4)
	// (angle1...angle2) and (angle3...angle4)
	// allowed ranges for the projection angle


namespace projection_private {
	extern Dimension Nprojection; // number of projecton angles
	extern FArray2D_int pairProjection;
	extern FArray2D_float anglProjection;
}
using namespace projection_private;


namespace dipolar_public {
	extern bool dipolar_exist;
}
using namespace dipolar_public;


} // namespace dipolar


// private dipolar namespaces

namespace dipolar_vflag {
	extern bool verbose;
}

namespace align_tensor {
	extern FArray2D_double x;
	extern FArray1D_double Azz;
	extern FArray1D_double eta;
	extern FArray3D_double paf_rot;
	extern FArray1D_bool reject;
}


#endif
