// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16636 $
//  $Date: 2007-08-21 15:47:16 -0700 (Tue, 21 Aug 2007) $
//  $Author: ashworth $

#ifndef INCLUDED_dna_ns
#define INCLUDED_dna_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh> // FArrays
#include <list>
#include <map>
#include <vector>

// forward declarations
#include "dna_fwd.h"

namespace dna_variables {

	extern bool enable_dna;
	extern bool design_by_base;
	extern bool dna_verbose;

	extern bool favor_designed_bases;
	extern float dna_bonus_value;
	extern float total_intxn_bonus;

	extern float const empty_value;

	extern FArray1D_bool no_sidechain;
	extern FArray1D_bool na_missing_phosphate;

	extern std::list< ResInfo > interface_list;

/// Morozov's globals follow ///

	extern DnaSeqInfo basepairs; // here only so that dna_am_min will compile

	extern FArray2D_float dna_dihedrals; // store dna dihedral angles
	extern FArray2D_float prot_chi_dihedrals; // store prot chi angles
	extern FArray2D_float basestep_prms; // store base-step parameters
	extern FArray2D_float basepair_prms; // store base-pair parameters
	extern FArray1D_int basestep_nums; // store resnums of basestep residues (i->j)
	extern FArray1D_int basestep_nums_inv; // store resnums of basestep residues (j->i)
	extern FArray1D_char paired_chain; // chainID lookup by strand number (I or II)
	extern FArray3D_float triad_icoor; // ideal base coords used to compute triads
	extern FArray1D_int triad_icoor_natoms; // natoms in the triad_icoor (natoms over which fitting is done)
	//extern FArray1D_float chain_dir;
	extern FArray2D_float chain_dir;
	extern bool base_flip_allowed;
	extern FArray1D_bool flip_occured;
	// Params for effective DNA potential:
	extern FArray2D_float means_bs;
	extern FArray2D_float stddevs_bs;
	extern FArray3D_float Fij;
	extern FArray2D_float means_bp;
	extern FArray2D_float stddevs_bp;
	extern FArray3D_float Gij;
	// Minimization selectors:
	extern FArray1D_bool res2minim;
	extern FArray2D_bool ang2minim;
	extern FArray1D_int cluster_map;
	extern bool dna_cluster_present;
	extern bool do_dna_setup;
	extern int nangles;
	extern Dimension const MAX_ANGLES;
	extern int minimize_start;
	// Refold selector:
	extern bool fixed_prot_bb_refold;

	// DNA scores:
	extern FArray1D_float dna_bp_score;
	extern FArray1D_float dna_bs_score;
	extern float dna_bp_total;
	extern float dna_bs_total;
	// Total energy:
	extern float total_minim_energy;
	//extern float total_minim_energy_with_penalty;
	extern float chiral_deviation;
	//////////////////////////////////////
	// debugging flag:
	extern int const dna_debug;
	// Atom number aliases, for increased code readability:
	extern int const p;
	extern int const o1p;
	extern int const o2p;
	extern int const o5star;
	extern int const c5star;
	extern int const c4star;
	extern int const o4star;
	extern int const c3star;
	extern int const o3star;
	extern int const c2star;
	extern int const c1star;
	extern int const n1;
	extern int const c2;
	extern int const c4A;
	extern int const c8A;
	extern int const n9A;
	extern int const c4G;
	extern int const c8G;
	extern int const n9G;
	extern int const n1C;
	extern int const n3C;
	extern int const c6C;
	extern int const n1T;
	extern int const n3T;
	extern int const c6T;

	extern int const rna_n1;
	extern int const rna_n3pyr;
	extern int const rna_c4rA;
	extern int const rna_c4rG;
	extern int const rna_c6rC;
	extern int const rna_c6rU;

}


namespace rna_variables {
	extern bool enable_rna;

	extern int const p;
	extern int const o1p;
	extern int const o2p;
	extern int const o5star;
	extern int const c5star;
	extern int const c4star;
	extern int const o4star;
	extern int const c3star;
	extern int const o3star;
	extern int const c2star;
	extern int const o2star;
	extern int const c1star;
	extern int const n1;
	extern int const c2;
	extern int const c4A;
	extern int const c6A;
	extern int const c8A;
	extern int const n9A;
	extern int const c4G;
	extern int const c6G;
	extern int const c8G;
	extern int const n9G;
	extern int const n1C;
	extern int const n3C;
	extern int const c4C;
	extern int const c6C;
	extern int const n1U;
	extern int const n3U;
	extern int const c4U;
	extern int const c6U;

	extern int const ho2starA;
	extern int const ho2starG;
	extern int const ho2starC;
	extern int const ho2starU;

}

bool
IsDnaDomain(
	int const domain_finish,
	FArray1DB_int const & res
);

bool
IsRnaDomain(
	int const domain_finish,
	FArray1DB_int const & res
);

#endif
