// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.10 $
//  $Date: 2005/10/06 23:09:52 $
//  $Author: sid $
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/...
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   rosetta++/dock_ensemble.h
///
/// @brief  Provides ensemble docking in the low resolution phase of pose docking.
/// 	    when pose_docking_ensemble_move( pose ) is called, a conformer in the  pose
///	    is swapped out for a conformer in the ensemble.  This uses an ensemble for
///         partner 1 (ensemble1) or partner 2 (ensemble2) or both.  Conformer swap is
///         made by generating a partition function in conformer space and randomly
///	    selecting a conformer based on its Boltzmann weighted probability.
///
///	    command line options:
///         -ensemble1 [ensemble size]
///         -ensemble2 [ensemble size]
///         -ensemble_prepack
///
/// @author Sid Chaudhury (sidc@jhu.edu)

#ifndef INCLUDED_dock_ensemble
#define INCLUDED_dock_ensemble

//Rosetta headers
#include "pose.h"

// C++ Headers
#include <string>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

void
pose_ensemble_switch_structure(
	pose_ns::Pose & pose,
	int p_num,
	int m_num
);

/// @brief recovers sidechains for each selected monomer from respective
///        monomer in the ensemble
void
pose_ensemble_recover_sidechains(
	pose_ns::Pose & pose,
	int p_num,
	int m_num
);

void
pose_dock_superpos(
	pose_ns::Pose & pose1,
	pose_ns::Pose & new_pose,
	int p_num
);


void
pose_docking_ensemble_move(
	pose_ns::Pose & pose
);

void
pose_docking_ensemble_repack_conformer(
	pose_ns::Pose & pose
);

void
set_cen_unbound_score(
	float & cen_unbound_score
);

void
set_FA_unbound_score(
	float & FA_unbound_score
);

void
read_ensemble();

void
read_ensemble(
	int partner_num,
	std::string filename
);

void
detect_current_conformer(
	const pose_ns::Pose & pose
);

void
ensemble_recover_sidechains(
	pose_ns::Pose & pose 
);

void
ensemble_calculate_ref_energy();

void
calc_FA_ref_energy(
	const pose_ns::Pose & pose,
	const int repeat,
	const bool repack,
	const int p_num,
	const int c_num
);

void
calc_cen_ref_energy(
	const int p_num
);

void
update_pdblist_file();


#endif
