// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32323 $
//  $Date: 2009-08-25 13:16:13 -0700 (Tue, 25 Aug 2009) $
//  $Author: johnk $

#ifndef INCLUDED_docking
#define INCLUDED_docking


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Numeric Headers
#include <numeric/xyzVector.hh>
// C++ Headers
#include <iosfwd>
#include <vector>

// Forward declarations
namespace pose_ns { class Pose; }

// docking Function Declarations


bool
get_docking_flag();


bool
get_pose_docking_flag();

bool
get_pose_symmetry_docking_flag();

bool
get_flexbb_docking_flag();


bool
get_docking_silent_input_flag();

void
set_docking_flag( bool & m );


void
set_pose_docking_flag( bool & m );

bool
get_docking_fullatom_flag();


bool
get_docking_FAsearch_flag();


bool
get_docking_minimize_flag();


bool
get_docking_mcm_flag();


bool
get_docking_output_position_hetatm_flag();



bool
get_docking_prepack_mode();


bool
get_unboundrot_flag();


bool
get_unbound_start_flag();


void
set_unbound_start_flag( bool m );


void
set_docking_use_mapped_rmsd( bool m );


int
get_docking_part2_begin();


float
get_docking_rmsd();


float
get_docking_translation_dist();


float
get_docking_rotation_angle();


float
get_docking_frac_nat_contact();


float
get_docking_frac_nonnat_contact();


int
get_countcont();


float
get_docking_interf_rmsd();


float
get_docking_interf_energy();


bool
docking_jumpout_check();


void
docking_output_geometry( std::ostream & iunit );


void
output_docking_position( std::ostream & iunit );


void
output_docking_position_hetatm( std::ostream & iunit );


void
docking_store_native_interface();


void
docking_print_native_interface();


void
docking_store_residues();


void
initialize_docking_start();


void
docking_derive_coord_frame();


void
initialize_docking_decoy();


void
docking_store_native();


void
docking_init_query();


void
calculate_interface_centroid( FArray1Da_float interface_centroid );


void
chain_centroid(
	FArray3Da_float xyz, // atom position array, in full_coord format
	FArray1Da_int aan, // amino acid numbers
	FArray1Da_int aav, // amino acid variants
	int & start_res,
	int & end_res,
	FArray1Da_float ch_centroid // the chain centroid
);


void
chain_centroid_CA(
	FArray3Da_float xyz, // atom position array, in Eposition format
	int start_res,
	int end_res,
	FArray1Da_float ch_centroid // the chain centroid
);

numeric::xyzVector<double>
vector_centroid(
	std::vector< numeric::xyzVector< double > > const xyz // atom position array, in Eposition format
);



void
docking_score_input(
	std::string const & filename,
	std::string const & label // 'native ' or 'input '
);


void
docking_init_unboundrot_query();


void
docking_save_unbound();


void
retrieve_unbound_rotamers(
	FArray2Da_int unbound_rot,
	FArray2Da_float unbound_chi
);


void
get_size_from_docking_map();


void
docking_mapping_native();


void
check_docking_native_map(
	int const align, // num of characters read in
	FArray1Da_int native_aa, // seq to be aligned
	FArray1Da_int native_pos // seqpos num in rosetta
);


void
check_docking_unbound_map(
	int const align, // num of characters read in
	FArray1Da_int unbound_aa, // seq to be aligned
	FArray1Da_int unbound_pos // seqpos num in rosetta
);


void
docking_store_nat_contact_map();


void
convert_docking_nat_contact_map();


void
calc_docking_frac_nat_contact();


void
calc_docking_number_of_contacts();


void
calc_docking_interf_rmsd();


void
calc_docking_hb_stats();

bool
get_docking_local_refine();

void
chain_centroid_DNA(
  FArray2Da_float DNA_cen, // DNA centroid array
  int start_res,
  int end_res,
  FArray1Da_float ch_centroid // the chain centroid
								);

bool
bias_this_rot_to_native(
	int aa,
	int const seqpos,
	FArray1DB_int const & rot //rotamer numbers
);

void translate_subunits( float const dist );

void
docking_initialize_silent_input_file();


void
docking_read_silent_input( bool & fail );


void
docking_calculate_silent_matrix();

void
docking_apply_silent_matrix(
	bool const fullatom
);

void
docking_write_silent_matrix(
	std::ostream & iunit
	);

void
docking_flag_ideal_sidechain(
	FArray1D_bool & ideal_sc,
	FArray2D_float & decoy_chi
);

void
docking_refold_silent_chi(
	FArray2D_float & decoy_chi,
	FArray1D_bool & ideal_sc
);

std::string
docking_silent_input_get_current_tag(
	bool setting
);


void
calc_docking_interf_energy(
	bool repack_away
);


float
calc_docking_partner_rmsd(
	int const partner
);


#endif
