// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 9595 $
//  $Date: 2006-08-08 16:20:23 -0700 (Tue, 08 Aug 2006) $
//  $Author: tex $


// Rosetta Headers
#include "docking_db.h"
//KMa phospho_ser
#include "param.h"
#include "param_aa.h"
//KMa phospho_ser
#include "add_pser.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>


//     Docking statistics
//
//     J. Gray 5/15/01
//
//     Environment and Pair scores, see docking_db.cc for the current
//     implementation
//
//
//     Environment and pair statistics compiled by Ora Furman using a
//     selected set of interfaces from Nussinov JMB 1996
//
//     Also available, Pair scores from Glaser et al Proteins 2001,
//     simple stats from a large, non-redundant database of interfaces.
//     (currently commented out)  6/01


	// 1=interface residue, buried in complex
	// 2=interface residue, exposed in complex
	// 3=not interface residue, buried in complex
	// 4=not interface residue, exposed in complex
	// second index=amino acid

	// pair interaction score for interface residues


namespace docking_db {

	//     Docking statistics -- Env and Pair scores
	//
	//     J. Gray 5/15/01
	//
	//     Environment statistics compiled by Ora Furman using a selected set
	//     of interfaces from Nussinov JMB 1996
	//
	//     Pair scores from the same database set
	//
	//     Also available but commented out: Pair scores from Glaser et al
	//     Proteins 2001, simple stats from a large, non-redundant database
	//     of interfaces.

	void
	log_docking_env_initializer( FArray2D_float & log_docking_env )
	{
		// These are ora's preliminary numbers, from an email 5/21 captioned:
		//     the table derived according to
		//     interface = residue with cb within 6.0A of cb in other chain
		//     burial : #neibs 16 cutoff
		//
		//               env = 1       // interface residue, buried in complex
		//               env = 2       // interface residue, exposed in complex
		//               env = 3       // not interface residue, buried in complex
		//               env = 4       // not interface residue, exposed in complex
		//
		//   env:     1         2         3         4
		//
		//        0.19662,  0.54182, -0.07557,  0.04986,  ! A  ! Tsai 40 set
		//       -0.32201,  0.61098, -0.54827,  1.58536,  ! C
		//        0.19192, -0.33661,  0.57898, -0.38402,  ! D
		//        0.41000, -0.34342,  0.77818, -0.46480,  ! E
		//       -0.41651, -0.05329, -0.33734,  0.65460,  ! F
		//       -0.19630,  0.46476,  0.05376, -0.04646,  ! G
		//       -0.24158,  0.08115, -0.06459,  0.10067,  ! H
		//       -0.18894,  0.22081, -0.40506,  0.78275,  ! I
		//        0.51090, -0.15200,  0.81876, -0.48680,  ! K
		//        0.31999,  0.89100, -0.41063,  0.66758,  ! L
		//        0.11054, -0.17287, -0.32386,  0.51382,  ! M
		//       -0.15488, -0.59591,  0.35827, -0.23926,  ! N
		//       -0.18676, -0.57126,  0.29592, -0.19925,  ! P
		//        0.18365, -0.24286,  0.30665, -0.25187,  ! Q
		//       -0.05784, -0.28718,  0.29595, -0.22509,  ! R
		//        0.07450, -0.07788,  0.28720, -0.23804,  ! S
		//        0.21400,  0.14191,  0.19107, -0.18997,  ! T
		//        0.17964,  0.66170, -0.38804,  0.62868,  ! V
		//       -0.75541,  0.66593, -0.36835,  0.84180,  ! W
		//       -0.43095, -0.24436, -0.39220,  0.85553/  ! Y
		//
		// Ben Tal set with CB, 24 May
		//       -0.05271,  0.29616, -0.13634,  0.15712,  ! A
		//       -0.23931,  0.55532, -0.45722,  0.94292,  ! C
		//        0.30311, -0.19951,  0.53179, -0.36912,  ! D
		//        0.34939, -0.21324,  0.70658, -0.43619,  ! E
		//       -0.14240,  0.34388, -0.36196,  0.60626,  ! F
		//       -0.08314,  0.03463,  0.02534, -0.01673,  ! G
		//       -0.13816, -0.10878, -0.02496,  0.05036,  ! H
		//       -0.01562,  0.26183, -0.38645,  0.64911,  ! I
		//        0.64688, -0.29835,  0.72298, -0.45233,  ! K
		//        0.01074,  0.30611, -0.33881,  0.51459,  ! L
		//       -0.20962,  0.48425, -0.25436,  0.36980,  ! M
		//        0.02020, -0.31819,  0.37716, -0.26936,  ! N
		//       -0.15838, -0.42996,  0.30834, -0.20564,  ! P
		//        0.07280, -0.21176,  0.35745, -0.26805,  ! Q
		//       -0.02747, -0.13168,  0.26711, -0.20846,  ! R
		//       -0.11405, -0.01254,  0.21395, -0.16832,  ! S
		//       -0.04284, -0.19131,  0.16780, -0.13481,  ! T
		//       -0.05760,  0.43192, -0.33548,  0.51406,  ! V
		//       -0.15029,  0.49946, -0.32640,  0.50980,  ! W
		//       -0.14323,  0.09467, -0.31888,  0.51323/  ! Y
		//
		// env_scores_Centroid6.0_BenTal_613_dc_for_jeff (June 2001)
		//        0.03481,  0.42519, -0.15173,  0.14907,  ! A
		//       -0.17211,  0.84016, -0.47126,  0.93182,  ! C
		//        0.32427, -0.27640,  0.53739, -0.36928,  ! D
		//        0.26194, -0.28054,  0.74314, -0.43837,  ! E
		//       -0.18263,  0.35294, -0.36275,  0.61287,  ! F
		//        0.01289,  0.12392,  0.01447, -0.02439,  ! G
		//       -0.17228, -0.04944, -0.01607,  0.05070,  ! H
		//       -0.03417,  0.30786, -0.39469,  0.65826,  ! I
		//        0.56015, -0.31559,  0.73944, -0.45499,  ! K
		//       -0.11321,  0.23988, -0.33434,  0.52798,  ! L
		//       -0.29828,  0.20120, -0.24393,  0.39216,  ! M
		//        0.05890, -0.26282,  0.38605, -0.27453,  ! N
		//       -0.04826, -0.34875,  0.30349, -0.20815,  ! P
		//       -0.03692, -0.30588,  0.39361, -0.26421,  ! Q
		//       -0.14895, -0.45962,  0.30740, -0.18696,  ! R
		//       -0.02392,  0.01906,  0.20732, -0.17313,  ! S
		//        0.02184, -0.02589,  0.16180, -0.14356,  ! T
		//       -0.02672,  0.49999, -0.34704,  0.51350,  ! V
		//       -0.15110,  0.26746, -0.33240,  0.53227,  ! W
		//       -0.21465,  0.18976, -0.31572,  0.51972/  ! Y
		//
		// env_scores_Centroid6.0_BenTal_612_v2_for_jeff  (7/9/1)
		// JJG 8/23/1: this is the current env thing *** (applied below)
		//        0.01651,  0.52268, -0.17788,  0.19530,  ! A
		//       -0.13961,  0.74148, -0.47677,  1.01935,  ! C
		//        0.28722, -0.25821,  0.53590, -0.38006,  ! D
		//        0.29639, -0.35513,  0.81030, -0.47251,  ! E
		//       -0.18904,  0.43519, -0.36484,  0.65150,  ! F
		//       -0.01586,  0.21868, -0.03367,  0.02645,  ! G
		//       -0.13501, -0.13792, -0.01098,  0.04622,  ! H
		//       -0.06366,  0.44490, -0.40329,  0.72345,  ! I
		//        0.62584, -0.42369,  1.00961, -0.54058,  ! K
		//       -0.12003,  0.28551, -0.34813,  0.59242,  ! L
		//       -0.25586,  0.09762, -0.23186,  0.38415,  ! M
		//        0.05834, -0.26889,  0.39498, -0.28946,  ! N
		//       -0.09320, -0.28008,  0.23933, -0.17299,  ! P
		//        0.00274, -0.38186,  0.47512, -0.31604,  ! Q
		//       -0.08273, -0.59040,  0.48567, -0.29394,  ! R
		//       -0.04129,  0.06792,  0.16397, -0.14674,  ! S
		//        0.01202, -0.00059,  0.11893, -0.11426,  ! T
		//       -0.03290,  0.58028, -0.36380,  0.58472,  ! V
		//       -0.14854,  0.28911, -0.32064,  0.52998,  ! W
		//       -0.18890,  0.14016, -0.29494,  0.49427/  ! Y
		//
		//  env_scores_Centroid6.0_Sternberg_91_v2_for_jeff  (7/9/1)
		//        0.18031,  0.74662, -0.16958,  0.16248,  ! A
		//       -0.13352,  0.69630, -0.48282,  1.12184,  ! C
		//       -0.04461, -0.39234,  0.57593, -0.36934,  ! D
		//        0.39119, -0.58799,  0.79671, -0.47584,  ! E
		//       -0.10835,  0.65141, -0.42002,  0.82881,  ! F
		//        0.00042,  0.08959, -0.00164, -0.00255,  ! G
		//       -0.42376,  0.03648, -0.01634,  0.10275,  ! H
		//        0.03481,  0.61812, -0.41269,  0.75338,  ! I
		//        0.35240, -0.45814,  0.96136, -0.52524,  ! K
		//        0.08646,  0.37625, -0.39187,  0.68342,  ! L
		//       -0.36744,  0.01416, -0.28239,  0.55153,  ! M
		//       -0.07628, -0.37015,  0.45363, -0.30997,  ! N
		//        0.18885,  0.05312,  0.26722, -0.25080,  ! P
		//       -0.05621, -0.23472,  0.47219, -0.32830,  ! Q
		//       -0.00746, -0.78190,  0.47805, -0.30334,  ! R
		//       -0.03822,  0.12246,  0.20110, -0.18110,  ! S
		//       -0.04938,  0.15205,  0.12144, -0.11692,  ! T
		//        0.11656,  0.66155, -0.37289,  0.60158,  ! V
		//       -0.40394,  0.53253, -0.32529,  0.64580,  ! W
		//       -0.43565,  0.39361, -0.32045,  0.65445/  ! Y

		FArray1Da_float env( log_docking_env, log_docking_env.size() );
		int i = 0;

		// A
		env( ++i ) = 0.01651;
		env( ++i ) = 0.52268;
		env( ++i ) = -0.17788;
		env( ++i ) = 0.19530;

		// C
		env( ++i ) = -0.13961;
		env( ++i ) = 0.74148;
		env( ++i ) = -0.47677;
		env( ++i ) = 1.01935;

		// D
		env( ++i ) = 0.28722;
		env( ++i ) = -0.25821;
		env( ++i ) = 0.53590;
		env( ++i ) = -0.38006;

		// E
		env( ++i ) = 0.29639;
		env( ++i ) = -0.35513;
		env( ++i ) = 0.81030;
		env( ++i ) = -0.47251;

		// F
		env( ++i ) = -0.18904;
		env( ++i ) = 0.43519;
		env( ++i ) = -0.36484;
		env( ++i ) = 0.65150;

		// G
		env( ++i ) = -0.01586;
		env( ++i ) = 0.21868;
		env( ++i ) = -0.03367;
		env( ++i ) = 0.02645;

		// H
		env( ++i ) = -0.13501;
		env( ++i ) = -0.13792;
		env( ++i ) = -0.01098;
		env( ++i ) = 0.04622;

		// I
		env( ++i ) = -0.06366;
		env( ++i ) = 0.44490;
		env( ++i ) = -0.40329;
		env( ++i ) = 0.72345;

		// K
		env( ++i ) = 0.62584;
		env( ++i ) = -0.42369;
		env( ++i ) = 1.00961;
		env( ++i ) = -0.54058;

		// L
		env( ++i ) = -0.12003;
		env( ++i ) = 0.28551;
		env( ++i ) = -0.34813;
		env( ++i ) = 0.59242;

		// M
		env( ++i ) = -0.25586;
		env( ++i ) = 0.09762;
		env( ++i ) = -0.23186;
		env( ++i ) = 0.38415;

		// N
		env( ++i ) = 0.05834;
		env( ++i ) = -0.26889;
		env( ++i ) = 0.39498;
		env( ++i ) = -0.28946;

		// P
		env( ++i ) = -0.09320;
		env( ++i ) = -0.28008;
		env( ++i ) = 0.23933;
		env( ++i ) = -0.17299;

		// Q
		env( ++i ) = 0.00274;
		env( ++i ) = -0.38186;
		env( ++i ) = 0.47512;
		env( ++i ) = -0.31604;

		// R
		env( ++i ) = -0.08273;
		env( ++i ) = -0.59040;
		env( ++i ) = 0.48567;
		env( ++i ) = -0.29394;

		// S
		env( ++i ) = -0.04129;
		env( ++i ) = 0.06792;
		env( ++i ) = 0.16397;
		env( ++i ) = -0.14674;

		// T
		env( ++i ) = 0.01202;
		env( ++i ) = -0.00059;
		env( ++i ) = 0.11893;
		env( ++i ) = -0.11426;

		// V
		env( ++i ) = -0.03290;
		env( ++i ) = 0.58028;
		env( ++i ) = -0.36380;
		env( ++i ) = 0.58472;

		// W
		env( ++i ) = -0.14854;
		env( ++i ) = 0.28911;
		env( ++i ) = -0.32064;
		env( ++i ) = 0.52998;

		// Y
		env( ++i ) = -0.18890;
		env( ++i ) = 0.14016;
		env( ++i ) = -0.29494;
		env( ++i ) = 0.49427;
//KMa phospho_ser
			// O
		if ( add_pser() )
		{
		env( ++i ) = -0.04129;
		env( ++i ) = 0.06792;
		env( ++i ) = 0.16397;
		env( ++i ) = -0.14674;
		}

	}

	void
	log_docking_pair_initializer( FArray2D_float & log_docking_pair )
	{
		//
		// numbers taken directly from Table III of
		// Glaser et al, Proteins 43:89 (2001)
		//
		// G_{ij} = 10 log(Q_{ij}/W_i W_j)
		// Q_{ij} = C_{ij} / \sum_{k \le l} C_{kl}
		// W_i    = F_i / \sum_j F_j
		// F_i are frequency counts of interface residues
		// C_{ij} are counts of interface pairs
		// interface is defined by residues with centroids within 6 Angstroms
		// of a residue on the other protein
		//
		// note that a *potential* function would be -log_docking_pair, because
		// Glaser used a different sign convention
		//
		//
		//      data log_docking_pair / //   /A,C,D,E,F,G,H,I,K,L,M,N,P,Q,R,S,T,V,W,Y/
		//     #     0.26,1.16,0.59,0.38,0.74,0.46,0.92,0.95,-0.13,0.88,0.41,0.91,0.72,0.19,-0.76,0.80,0.57,1.40,0.29,0.02,              // A
		//     #     1.16,6.26,-1.39,0.10,0.34,0.90,1.36,-1.21,-1.29,-0.05,-1.13,-2.28,1.16,-1.28,-0.93,1.81,-0.70,0.64,-2.02,-1.06,     // C
		//     #     0.59,-1.39,-1.74,-2.59,-2.60,0.82,2.20,-0.92,0.31,-1.82,-2.86,1.74,-0.37,0.41,0.95,2.02,1.91,-0.57,-1.79,-2.02,     // D
		//     #     0.38,0.10,-2.59,-1.80,-1.51,-0.77,-1.49,-0.80,0.95,-0.89,-0.13,-0.22,0.55,-1.69,0.97,0.90,0.12,-0.06,-3.99,-0.02,   // E
		//     #     0.74,0.34,-2.61,-1.51,0.04,-0.68,-1.25,0.40,-1.73,-0.07,0.35,-0.71,0.70,-0.32,-1.21,-0.89,-0.34,0.48,-0.29,0.33,    // F
		//     #     0.46,0.90,0.82,-0.77,-0.68,-0.72,0.85,0.33,0.52,-0.82,0.47,0.13,0.44,0.62,0.38,0.33,1.01,-0.13,-0.21,0.25,          // G
		//     #     0.92,1.36,2.20,-1.49,-1.25,0.85,1.24,-0.97,-2.00,0.53,0.30,-0.85,-0.07,0.02,-0.22,-1.25,-0.39,-0.41,0.92,1.14,      // H
		//     #     0.95,-1.21,-0.92,-0.80,0.40,0.33,-0.97,-0.67,-1.70,0.03,0.68,-1.87,0.09,-0.60,-1.53,-1.26,-0.27,1.07,0.49,0.49,     // I
		//     #     -0.13,-1.29,0.31,0.95,-1.73,0.52,-2.00,-1.70,-2.06,-1.78,-1.01,-0.66,0.21,-1.07,-3.41,0.10,-0.02,0.23,-0.36,-0.23,  // K
		//     #     0.88,-0.05,-1.82,-0.89,-0.07,-0.82,0.53,0.03,-1.78,-0.53,0.76,-1.14,-0.67,-0.74,-0.34,-0.85,-1.25,0.36,0.02,-0.93,  // L
		//     #     0.41,-1.13,-2.86,-0.13,0.35,0.47,0.30,0.68,-1.01,0.76,1.45,-1.15,0.21,-0.02,-1.71,-0.65,-1.23,0.53,-0.86,-0.32,     // M
		//     #     0.91,-2.28,1.74,-0.22,-0.71,0.13,-0.85,-1.87,-0.66,-1.14,-1.15,0.58,1.03,0.36,-0.38,0.62,0.32,-1.37,-1.10,-0.35,    // N
		//     #     0.72,1.16,-0.37,0.55,0.70,0.44,-0.07,0.09,0.21,-0.67,0.21,1.03,-1.18,0.69,0.05,0.46,0.72,0.45,3.51,0.49,            // P
		//     #     0.19,-1.28,0.41,-1.69,-0.32,0.62,0.02,-0.60,-1.07,-0.74,-0.02,0.36,0.69,-1.00,-0.47,0.10,-1.13,-0.26,-4.02,-2.71,   // Q
		//     #     -0.76,-0.93,0.95,0.97,-1.21,0.38,-0.22,-1.53,-3.41,-0.34,-1.71,-0.38,0.05,-0.47,-3.23,-0.21,-0.32,-0.43,2.05,-0.61, // R
		//     #     0.80,1.81,2.02,0.90,-0.89,0.33,-1.25,-1.26,0.10,-0.85,-0.65,0.62,0.46,0.10,-0.21,-0.06,0.89,-0.12,-0.58,-0.52,      // S
		//     #     0.57,-0.70,1.91,0.12,-0.34,1.01,-0.39,-0.27,-0.02,-1.25,-1.23,0.32,0.72,-1.13,-0.32,0.89,-0.79,0.24,0.62,-0.73,     // T
		//     #     1.40,0.64,-0.57,-0.06,0.48,-0.13,-0.41,1.07,0.23,0.36,0.53,-1.37,0.45,-0.26,-0.43,-0.12,0.24,0.62,-2.11,-0.45,      // V
		//     #     0.29,-2.02,-1.79,-3.99,-0.29,-0.21,0.92,0.49,-0.36,0.02,-0.86,-1.10,3.51,-4.02,2.05,-0.58,0.62,-2.11,-1.09,-0.12,   // W
		//     #     0.02,-1.06,-2.02,-0.02,0.33,0.25,1.14,0.49,-0.23,-0.93,-0.32,-0.35,0.49,-2.71,-0.61,-0.52,-0.73,-0.45,-0.12,0.25/   // Y

		// pair_scores_Centroid6.0_BenTal_613_dc_for_jeff
		log_docking_pair(1,1) = 0.200541562754133; // AA
		log_docking_pair(1,2) = 0.0429399827073992; // AC
		log_docking_pair(2,1) = 0.0429399827073992; // CA
		log_docking_pair(1,3) = 0.0752055767053971; // AD
		log_docking_pair(3,1) = 0.0752055767053971; // DA
		log_docking_pair(1,4) = 0.125312289132248; // AE
		log_docking_pair(4,1) = 0.125312289132248; // EA
		log_docking_pair(1,5) = -0.00179262422777463; // AF
		log_docking_pair(5,1) = -0.00179262422777463; // FA
		log_docking_pair(1,6) = 0.0689881776098794; // AG
		log_docking_pair(6,1) = 0.0689881776098794; // GA
		log_docking_pair(1,7) = -0.0529983841475926; // AH
		log_docking_pair(7,1) = -0.0529983841475926; // HA
		log_docking_pair(1,8) = 0.053530589742304; // AI
		log_docking_pair(8,1) = 0.053530589742304; // IA
		log_docking_pair(1,9) = 0.138807126503877; // AK
		log_docking_pair(9,1) = 0.138807126503877; // KA
		log_docking_pair(1,10) = -0.0375714962729643; // AL
		log_docking_pair(10,1) = -0.0375714962729643; // LA
		log_docking_pair(1,11) = -0.0587004602500561; // AM
		log_docking_pair(11,1) = -0.0587004602500561; // MA
		log_docking_pair(1,12) = -0.0230749438144194; // AN
		log_docking_pair(12,1) = -0.0230749438144194; // NA
		log_docking_pair(1,13) = 0.0605924770804463; // AP
		log_docking_pair(13,1) = 0.0605924770804463; // PA
		log_docking_pair(1,14) = 0.122740491548554; // AQ
		log_docking_pair(14,1) = 0.122740491548554; // QA
		log_docking_pair(1,15) = 0.190417110810608; // AR
		log_docking_pair(15,1) = 0.190417110810608; // RA
		log_docking_pair(1,16) = 0.0702966604687777; // AS
		log_docking_pair(16,1) = 0.0702966604687777; // SA
		log_docking_pair(1,17) = 0.0688641379710027; // AT
		log_docking_pair(17,1) = 0.0688641379710027; // TA
		log_docking_pair(1,18) = -0.0533253727353715; // AV
		log_docking_pair(18,1) = -0.0533253727353715; // VA
		log_docking_pair(1,19) = 0.188708862322716; // AW
		log_docking_pair(19,1) = 0.188708862322716; // WA
		log_docking_pair(1,20) = 0.175036683056711; // AY
		log_docking_pair(20,1) = 0.175036683056711; // YA
		log_docking_pair(2,2) = -1.3871997482347; // CC
		log_docking_pair(2,3) = 0.570187734886602; // CD
		log_docking_pair(3,2) = 0.570187734886602; // DC
		log_docking_pair(2,4) = 0.304797622669346; // CE
		log_docking_pair(4,2) = 0.304797622669346; // EC
		log_docking_pair(2,5) = 0.0555754099684488; // CF
		log_docking_pair(5,2) = 0.0555754099684488; // FC
		log_docking_pair(2,6) = -0.111520366550219; // CG
		log_docking_pair(6,2) = -0.111520366550219; // GC
		log_docking_pair(2,7) = -0.0738706810676344; // CH
		log_docking_pair(7,2) = -0.0738706810676344; // HC
		log_docking_pair(2,8) = 0.432600740638912; // CI
		log_docking_pair(8,2) = 0.432600740638912; // IC
		log_docking_pair(2,9) = 0.277861872109939; // CK
		log_docking_pair(9,2) = 0.277861872109939; // KC
		log_docking_pair(2,10) = 0.0692858688520714; // CL
		log_docking_pair(10,2) = 0.0692858688520714; // LC
		log_docking_pair(2,11) = 0.0914705155676288; // CM
		log_docking_pair(11,2) = 0.0914705155676288; // MC
		log_docking_pair(2,12) = 0.68266000377055; // CN
		log_docking_pair(12,2) = 0.68266000377055; // NC
		log_docking_pair(2,13) = -0.08178763486951; // CP
		log_docking_pair(13,2) = -0.08178763486951; // PC
		log_docking_pair(2,14) = 0.183920348272986; // CQ
		log_docking_pair(14,2) = 0.183920348272986; // QC
		log_docking_pair(2,15) = 0.227068182033808; // CR
		log_docking_pair(15,2) = 0.227068182033808; // RC
		log_docking_pair(2,16) = -0.213045215013151; // CS
		log_docking_pair(16,2) = -0.213045215013151; // SC
		log_docking_pair(2,17) = 0.287867898753201; // CT
		log_docking_pair(17,2) = 0.287867898753201; // TC
		log_docking_pair(2,18) = 0.0585370747238727; // CV
		log_docking_pair(18,2) = 0.0585370747238727; // VC
		log_docking_pair(2,19) = 0.0202914607752645; // CW
		log_docking_pair(19,2) = 0.0202914607752645; // WC
		log_docking_pair(2,20) = 0.030065600411322; // CY
		log_docking_pair(20,2) = 0.030065600411322; // YC
		log_docking_pair(3,3) = 0.408054136786226; // DD
		log_docking_pair(3,4) = 0.359346524987357; // DE
		log_docking_pair(4,3) = 0.359346524987357; // ED
		log_docking_pair(3,5) = 0.47888749653669; // DF
		log_docking_pair(5,3) = 0.47888749653669; // FD
		log_docking_pair(3,6) = 0.00311804293049387; // DG
		log_docking_pair(6,3) = 0.00311804293049387; // GD
		log_docking_pair(3,7) = -0.28881778654333; // DH
		log_docking_pair(7,3) = -0.28881778654333; // HD
		log_docking_pair(3,8) = 0.312871416784952; // DI
		log_docking_pair(8,3) = 0.312871416784952; // ID
		log_docking_pair(3,9) = -0.592073649741112; // DK
		log_docking_pair(9,3) = -0.592073649741112; // KD
		log_docking_pair(3,10) = 0.535496209865913; // DL
		log_docking_pair(10,3) = 0.535496209865913; // LD
		log_docking_pair(3,11) = 0.686199417720425; // DM
		log_docking_pair(11,3) = 0.686199417720425; // MD
		log_docking_pair(3,12) = -0.370894919927587; // DN
		log_docking_pair(12,3) = -0.370894919927587; // ND
		log_docking_pair(3,13) = 0.294792815162778; // DP
		log_docking_pair(13,3) = 0.294792815162778; // PD
		log_docking_pair(3,14) = -0.0879295972035717; // DQ
		log_docking_pair(14,3) = -0.0879295972035717; // QD
		log_docking_pair(3,15) = -0.527328593584565; // DR
		log_docking_pair(15,3) = -0.527328593584565; // RD
		log_docking_pair(3,16) = -0.362444802297388; // DS
		log_docking_pair(16,3) = -0.362444802297388; // SD
		log_docking_pair(3,17) = -0.179973783829245; // DT
		log_docking_pair(17,3) = -0.179973783829245; // TD
		log_docking_pair(3,18) = 0.30958475354005; // DV
		log_docking_pair(18,3) = 0.30958475354005; // VD
		log_docking_pair(3,19) = 0.244734293733923; // DW
		log_docking_pair(19,3) = 0.244734293733923; // WD
		log_docking_pair(3,20) = 0.290695982661095; // DY
		log_docking_pair(20,3) = 0.290695982661095; // YD
		log_docking_pair(4,4) = 0.153664798524263; // EE
		log_docking_pair(4,5) = 0.241014997218086; // EF
		log_docking_pair(5,4) = 0.241014997218086; // FE
		log_docking_pair(4,6) = 0.155894559013271; // EG
		log_docking_pair(6,4) = 0.155894559013271; // GE
		log_docking_pair(4,7) = 0.0491109511063299; // EH
		log_docking_pair(7,4) = 0.0491109511063299; // HE
		log_docking_pair(4,8) = 0.222949330105117; // EI
		log_docking_pair(8,4) = 0.222949330105117; // IE
		log_docking_pair(4,9) = -0.570625139997523; // EK
		log_docking_pair(9,4) = -0.570625139997523; // KE
		log_docking_pair(4,10) = 0.224453527243206; // EL
		log_docking_pair(10,4) = 0.224453527243206; // LE
		log_docking_pair(4,11) = -0.0212640855812318; // EM
		log_docking_pair(11,4) = -0.0212640855812318; // ME
		log_docking_pair(4,12) = -0.0122030693698257; // EN
		log_docking_pair(12,4) = -0.0122030693698257; // NE
		log_docking_pair(4,13) = 0.0157723878770948; // EP
		log_docking_pair(13,4) = 0.0157723878770948; // PE
		log_docking_pair(4,14) = 0.148038273876502; // EQ
		log_docking_pair(14,4) = 0.148038273876502; // QE
		log_docking_pair(4,15) = -0.447644400543407; // ER
		log_docking_pair(15,4) = -0.447644400543407; // RE
		log_docking_pair(4,16) = -0.214272603296108; // ES
		log_docking_pair(16,4) = -0.214272603296108; // SE
		log_docking_pair(4,17) = -0.0407336888505611; // ET
		log_docking_pair(17,4) = -0.0407336888505611; // TE
		log_docking_pair(4,18) = 0.31067433318949; // EV
		log_docking_pair(18,4) = 0.31067433318949; // VE
		log_docking_pair(4,19) = 1.3069252637632; // EW
		log_docking_pair(19,4) = 1.3069252637632; // WE
		log_docking_pair(4,20) = 0.130958391808066; // EY
		log_docking_pair(20,4) = 0.130958391808066; // YE
		log_docking_pair(5,5) = -0.0389694758916439; // FF
		log_docking_pair(5,6) = 0.250677913531172; // FG
		log_docking_pair(6,5) = 0.250677913531172; // GF
		log_docking_pair(5,7) = 0.145092513553453; // FH
		log_docking_pair(7,5) = 0.145092513553453; // HF
		log_docking_pair(5,8) = -0.172973085707143; // FI
		log_docking_pair(8,5) = -0.172973085707143; // IF
		log_docking_pair(5,9) = 0.17703108820021; // FK
		log_docking_pair(9,5) = 0.17703108820021; // KF
		log_docking_pair(5,10) = -0.00121701624801704; // FL
		log_docking_pair(10,5) = -0.00121701624801704; // LF
		log_docking_pair(5,11) = -0.257331768023765; // FM
		log_docking_pair(11,5) = -0.257331768023765; // MF
		log_docking_pair(5,12) = 0.0430605648586168; // FN
		log_docking_pair(12,5) = 0.0430605648586168; // NF
		log_docking_pair(5,13) = -0.150106641928051; // FP
		log_docking_pair(13,5) = -0.150106641928051; // PF
		log_docking_pair(5,14) = 0.00485782181796057; // FQ
		log_docking_pair(14,5) = 0.00485782181796057; // QF
		log_docking_pair(5,15) = 0.0975783610954343; // FR
		log_docking_pair(15,5) = 0.0975783610954343; // RF
		log_docking_pair(5,16) = 0.302392998351719; // FS
		log_docking_pair(16,5) = 0.302392998351719; // SF
		log_docking_pair(5,17) = 0.112787817968501; // FT
		log_docking_pair(17,5) = 0.112787817968501; // TF
		log_docking_pair(5,18) = 0.00373654628388984; // FV
		log_docking_pair(18,5) = 0.00373654628388984; // VF
		log_docking_pair(5,19) = -0.178947180603825; // FW
		log_docking_pair(19,5) = -0.178947180603825; // WF
		log_docking_pair(5,20) = -0.166351777589751; // FY
		log_docking_pair(20,5) = -0.166351777589751; // YF
		log_docking_pair(6,6) = 0.206164258087186; // GG
		log_docking_pair(6,7) = -0.0778414157571991; // GH
		log_docking_pair(7,6) = -0.0778414157571991; // HG
		log_docking_pair(6,8) = 0.15861375472327; // GI
		log_docking_pair(8,6) = 0.15861375472327; // IG
		log_docking_pair(6,9) = -0.147028987016624; // GK
		log_docking_pair(9,6) = -0.147028987016624; // KG
		log_docking_pair(6,10) = 0.322149075089659; // GL
		log_docking_pair(10,6) = 0.322149075089659; // LG
		log_docking_pair(6,11) = 0.0703375255006981; // GM
		log_docking_pair(11,6) = 0.0703375255006981; // MG
		log_docking_pair(6,12) = 0.0616666627906732; // GN
		log_docking_pair(12,6) = 0.0616666627906732; // NG
		log_docking_pair(6,13) = -0.00371138244694785; // GP
		log_docking_pair(13,6) = -0.00371138244694785; // PG
		log_docking_pair(6,14) = -0.0567946228790494; // GQ
		log_docking_pair(14,6) = -0.0567946228790494; // QG
		log_docking_pair(6,15) = -0.151359437373697; // GR
		log_docking_pair(15,6) = -0.151359437373697; // RG
		log_docking_pair(6,16) = 0.0504913205007163; // GS
		log_docking_pair(16,6) = 0.0504913205007163; // SG
		log_docking_pair(6,17) = -0.189486908625152; // GT
		log_docking_pair(17,6) = -0.189486908625152; // TG
		log_docking_pair(6,18) = 0.261426702753256; // GV
		log_docking_pair(18,6) = 0.261426702753256; // VG
		log_docking_pair(6,19) = -0.0935593297913658; // GW
		log_docking_pair(19,6) = -0.0935593297913658; // WG
		log_docking_pair(6,20) = 0.00774133616833843; // GY
		log_docking_pair(20,6) = 0.00774133616833843; // YG
		log_docking_pair(7,7) = -0.269444183037653; // HH
		log_docking_pair(7,8) = 0.445327653780846; // HI
		log_docking_pair(8,7) = 0.445327653780846; // IH
		log_docking_pair(7,9) = 0.34405395669982; // HK
		log_docking_pair(9,7) = 0.34405395669982; // KH
		log_docking_pair(7,10) = -0.0511481810779868; // HL
		log_docking_pair(10,7) = -0.0511481810779868; // LH
		log_docking_pair(7,11) = 0.0688894401523365; // HM
		log_docking_pair(11,7) = 0.0688894401523365; // MH
		log_docking_pair(7,12) = 0.446560305578335; // HN
		log_docking_pair(12,7) = 0.446560305578335; // NH
		log_docking_pair(7,13) = 0.212044130846733; // HP
		log_docking_pair(13,7) = 0.212044130846733; // PH
		log_docking_pair(7,14) = -0.11096320548565; // HQ
		log_docking_pair(14,7) = -0.11096320548565; // QH
		log_docking_pair(7,15) = -0.0633668256730208; // HR
		log_docking_pair(15,7) = -0.0633668256730208; // RH
		log_docking_pair(7,16) = 0.0838072855992079; // HS
		log_docking_pair(16,7) = 0.0838072855992079; // SH
		log_docking_pair(7,17) = 0.0917990027011224; // HT
		log_docking_pair(17,7) = 0.0917990027011224; // TH
		log_docking_pair(7,18) = 0.226558159997959; // HV
		log_docking_pair(18,7) = 0.226558159997959; // VH
		log_docking_pair(7,19) = -0.235393120448686; // HW
		log_docking_pair(19,7) = -0.235393120448686; // WH
		log_docking_pair(7,20) = -0.146671803452178; // HY
		log_docking_pair(20,7) = -0.146671803452178; // YH
		log_docking_pair(8,8) = -0.0336729958887398; // II
		log_docking_pair(8,9) = 0.245911018070765; // IK
		log_docking_pair(9,8) = 0.245911018070765; // KI
		log_docking_pair(8,10) = -0.328255416171397; // IL
		log_docking_pair(10,8) = -0.328255416171397; // LI
		log_docking_pair(8,11) = -0.125033419988662; // IM
		log_docking_pair(11,8) = -0.125033419988662; // MI
		log_docking_pair(8,12) = 0.31089913286822; // IN
		log_docking_pair(12,8) = 0.31089913286822; // NI
		log_docking_pair(8,13) = 0.049957588963747; // IP
		log_docking_pair(13,8) = 0.049957588963747; // PI
		log_docking_pair(8,14) = 0.387391032275265; // IQ
		log_docking_pair(14,8) = 0.387391032275265; // QI
		log_docking_pair(8,15) = 0.365641194080438; // IR
		log_docking_pair(15,8) = 0.365641194080438; // RI
		log_docking_pair(8,16) = 0.347866614151615; // IS
		log_docking_pair(16,8) = 0.347866614151615; // SI
		log_docking_pair(8,17) = 0.0631024435478185; // IT
		log_docking_pair(17,8) = 0.0631024435478185; // TI
		log_docking_pair(8,18) = -0.187989604522111; // IV
		log_docking_pair(18,8) = -0.187989604522111; // VI
		log_docking_pair(8,19) = -0.187095229186262; // IW
		log_docking_pair(19,8) = -0.187095229186262; // WI
		log_docking_pair(8,20) = -0.0860022342329113; // IY
		log_docking_pair(20,8) = -0.0860022342329113; // YI
		log_docking_pair(9,9) = 0.440169991821494; // KK
		log_docking_pair(9,10) = 0.395460640775314; // KL
		log_docking_pair(10,9) = 0.395460640775314; // LK
		log_docking_pair(9,11) = 0.0631290828827496; // KM
		log_docking_pair(11,9) = 0.0631290828827496; // MK
		log_docking_pair(9,12) = -0.0227236992284896; // KN
		log_docking_pair(12,9) = -0.0227236992284896; // NK
		log_docking_pair(9,13) = 0.132457819478912; // KP
		log_docking_pair(13,9) = 0.132457819478912; // PK
		log_docking_pair(9,14) = -0.251135526563838; // KQ
		log_docking_pair(14,9) = -0.251135526563838; // QK
		log_docking_pair(9,15) = 0.447737416386293; // KR
		log_docking_pair(15,9) = 0.447737416386293; // RK
		log_docking_pair(9,16) = 0.00374379127528639; // KS
		log_docking_pair(16,9) = 0.00374379127528639; // SK
		log_docking_pair(9,17) = 0.166681324017209; // KT
		log_docking_pair(17,9) = 0.166681324017209; // TK
		log_docking_pair(9,18) = 0.179934384994622; // KV
		log_docking_pair(18,9) = 0.179934384994622; // VK
		log_docking_pair(9,19) = 0.0236067088284424; // KW
		log_docking_pair(19,9) = 0.0236067088284424; // WK
		log_docking_pair(9,20) = -0.110995796786266; // KY
		log_docking_pair(20,9) = -0.110995796786266; // YK
		log_docking_pair(10,10) = 0.0800491933957594; // LL
		log_docking_pair(10,11) = -0.148366394725989; // LM
		log_docking_pair(11,10) = -0.148366394725989; // ML
		log_docking_pair(10,12) = 0.494331886295976; // LN
		log_docking_pair(12,10) = 0.494331886295976; // NL
		log_docking_pair(10,13) = 0.183905725715046; // LP
		log_docking_pair(13,10) = 0.183905725715046; // PL
		log_docking_pair(10,14) = 0.128163554351632; // LQ
		log_docking_pair(14,10) = 0.128163554351632; // QL
		log_docking_pair(10,15) = 0.0572775142192655; // LR
		log_docking_pair(15,10) = 0.0572775142192655; // RL
		log_docking_pair(10,16) = 0.249373389332147; // LS
		log_docking_pair(16,10) = 0.249373389332147; // SL
		log_docking_pair(10,17) = 0.215035498578683; // LT
		log_docking_pair(17,10) = 0.215035498578683; // TL
		log_docking_pair(10,18) = -0.236832667593465; // LV
		log_docking_pair(18,10) = -0.236832667593465; // VL
		log_docking_pair(10,19) = -0.0251772400466227; // LW
		log_docking_pair(19,10) = -0.0251772400466227; // WL
		log_docking_pair(10,20) = 0.110793456122197; // LY
		log_docking_pair(20,10) = 0.110793456122197; // YL
		log_docking_pair(11,11) = -0.443445185515161; // MM
		log_docking_pair(11,12) = 0.4211688646789; // MN
		log_docking_pair(12,11) = 0.4211688646789; // NM
		log_docking_pair(11,13) = 0.0677000618890408; // MP
		log_docking_pair(13,11) = 0.0677000618890408; // PM
		log_docking_pair(11,14) = 0.261001600618351; // MQ
		log_docking_pair(14,11) = 0.261001600618351; // QM
		log_docking_pair(11,15) = 0.32518894648236; // MR
		log_docking_pair(15,11) = 0.32518894648236; // RM
		log_docking_pair(11,16) = 0.283608458487134; // MS
		log_docking_pair(16,11) = 0.283608458487134; // SM
		log_docking_pair(11,17) = 0.325012878623281; // MT
		log_docking_pair(17,11) = 0.325012878623281; // TM
		log_docking_pair(11,18) = -0.054203951972701; // MV
		log_docking_pair(18,11) = -0.054203951972701; // VM
		log_docking_pair(11,19) = -0.0656479822672528; // MW
		log_docking_pair(19,11) = -0.0656479822672528; // WM
		log_docking_pair(11,20) = -0.0699357257653894; // MY
		log_docking_pair(20,11) = -0.0699357257653894; // YM
		log_docking_pair(12,12) = -0.202565969007635; // NN
		log_docking_pair(12,13) = -0.0340479482256142; // NP
		log_docking_pair(13,12) = -0.0340479482256142; // PN
		log_docking_pair(12,14) = -0.0994760054211672; // NQ
		log_docking_pair(14,12) = -0.0994760054211672; // QN
		log_docking_pair(12,15) = 0.109586313430305; // NR
		log_docking_pair(15,12) = 0.109586313430305; // RN
		log_docking_pair(12,16) = -0.209908101714297; // NS
		log_docking_pair(16,12) = -0.209908101714297; // SN
		log_docking_pair(12,17) = -0.110094042258381; // NT
		log_docking_pair(17,12) = -0.110094042258381; // TN
		log_docking_pair(12,18) = 0.325625051058157; // NV
		log_docking_pair(18,12) = 0.325625051058157; // VN
		log_docking_pair(12,19) = 0.224623816955715; // NW
		log_docking_pair(19,12) = 0.224623816955715; // WN
		log_docking_pair(12,20) = 0.126342239316249; // NY
		log_docking_pair(20,12) = 0.126342239316249; // YN
		log_docking_pair(13,13) = 0.46418385657461; // PP
		log_docking_pair(13,14) = -0.141351015982218; // PQ
		log_docking_pair(14,13) = -0.141351015982218; // QP
		log_docking_pair(13,15) = 0.142904949002942; // PR
		log_docking_pair(15,13) = 0.142904949002942; // RP
		log_docking_pair(13,16) = -0.0121312550036925; // PS
		log_docking_pair(16,13) = -0.0121312550036925; // SP
		log_docking_pair(13,17) = -0.106732777339643; // PT
		log_docking_pair(17,13) = -0.106732777339643; // TP
		log_docking_pair(13,18) = 0.138957243268606; // PV
		log_docking_pair(18,13) = 0.138957243268606; // VP
		log_docking_pair(13,19) = -0.502927500682678; // PW
		log_docking_pair(19,13) = -0.502927500682678; // WP
		log_docking_pair(13,20) = -0.325780094934824; // PY
		log_docking_pair(20,13) = -0.325780094934824; // YP
		log_docking_pair(14,14) = 0.0021447111132508; // QQ
		log_docking_pair(14,15) = -0.0737565126437286; // QR
		log_docking_pair(15,14) = -0.0737565126437286; // RQ
		log_docking_pair(14,16) = 0.0540201131833789; // QS
		log_docking_pair(16,14) = 0.0540201131833789; // SQ
		log_docking_pair(14,17) = 0.150743001779069; // QT
		log_docking_pair(17,14) = 0.150743001779069; // TQ
		log_docking_pair(14,18) = 0.0156501771658744; // QV
		log_docking_pair(18,14) = 0.0156501771658744; // VQ
		log_docking_pair(14,19) = 0.202630310524554; // QW
		log_docking_pair(19,14) = 0.202630310524554; // WQ
		log_docking_pair(14,20) = 0.35581738332889; // QY
		log_docking_pair(20,14) = 0.35581738332889; // YQ
		log_docking_pair(15,15) = 0.312036715484619; // RR
		log_docking_pair(15,16) = 0.181810483541033; // RS
		log_docking_pair(16,15) = 0.181810483541033; // SR
		log_docking_pair(15,17) = 0.311569421713946; // RT
		log_docking_pair(17,15) = 0.311569421713946; // TR
		log_docking_pair(15,18) = 0.222125347940464; // RV
		log_docking_pair(18,15) = 0.222125347940464; // VR
		log_docking_pair(15,19) = -0.312643375935516; // RW
		log_docking_pair(19,15) = -0.312643375935516; // WR
		log_docking_pair(15,20) = -0.0911888910507283; // RY
		log_docking_pair(20,15) = -0.0911888910507283; // YR
		log_docking_pair(16,16) = 0.148261497205755; // SS
		log_docking_pair(16,17) = -0.0750275409487633; // ST
		log_docking_pair(17,16) = -0.0750275409487633; // TS
		log_docking_pair(16,18) = 0.26296403805335; // SV
		log_docking_pair(18,16) = 0.26296403805335; // VS
		log_docking_pair(16,19) = 0.00289254816338779; // SW
		log_docking_pair(19,16) = 0.00289254816338779; // WS
		log_docking_pair(16,20) = 0.0890947285301724; // SY
		log_docking_pair(20,16) = 0.0890947285301724; // YS
		log_docking_pair(17,17) = 0.200520047676389; // TT
		log_docking_pair(17,18) = 0.0062646765316308; // TV
		log_docking_pair(18,17) = 0.0062646765316308; // VT
		log_docking_pair(17,19) = 0.0876471877712991; // TW
		log_docking_pair(19,17) = 0.0876471877712991; // WT
		log_docking_pair(17,20) = 0.142960777809504; // TY
		log_docking_pair(20,17) = 0.142960777809504; // YT
		log_docking_pair(18,18) = -0.0280473736507061; // VV
		log_docking_pair(18,19) = 0.747551018299331; // VW
		log_docking_pair(19,18) = 0.747551018299331; // WV
		log_docking_pair(18,20) = 0.0816328075702439; // VY
		log_docking_pair(20,18) = 0.0816328075702439; // YV
		log_docking_pair(19,19) = -0.143478895427391; // WW
		log_docking_pair(19,20) = -0.0948734008721987; // WY
		log_docking_pair(20,19) = -0.0948734008721987; // YW
		log_docking_pair(20,20) = 0.209328953934282; // YY


		//KMa phospho_ser
		// O
		if ( add_pser() )
		{
			for (int i=1;i<=20;i++) log_docking_pair(i,21)=log_docking_pair(i,16);
			for (int i=1;i<=20;i++) log_docking_pair(21,i)=log_docking_pair(16,i);
			log_docking_pair(21,21)=log_docking_pair(16,16);
		}
	}

	void
	log_docking_env_fab_initializer( FArray2D_float & log_docking_env_fab )
	{
		//     These are FAB-specific stats from Ora, 6.0A avg centroids
		//     to be copied into log_docking_env in case either
		//     partner is an antibody
		//     numbers from ~ora/Capri/FAB/env_scores_fab_final 8/24/1
		//        0.78580,  1.98702, -0.17800,  0.16899,  ! A
		//        1.50000,  1.50000, -0.57170,  1.43665,  ! C
		//       -0.36359, -0.89003,  0.50295, -0.31817,  ! D
		//        0.46329, -0.21030,  0.64458, -0.44078,  ! E
		//        0.48683,  0.21214, -0.47112,  1.01324,  ! F
		//       -0.32050, -0.59519,  0.19664, -0.14100,  ! G
		//        0.05663,  0.59287, -0.18356,  0.23636,  ! H
		//        0.32708,  0.99338, -0.42909,  0.82545,  ! I
		//        0.11085,  0.58457,  0.91797, -0.52371,  ! K
		//        0.65333,  2.55482, -0.45399,  0.87447,  ! L
		//        0.30236,  0.99276, -0.42811,  0.82483,  ! M
		//       -0.92264, -0.66756,  0.48094, -0.25157,  ! N
		//        0.38680,  0.83604,  0.32006, -0.29517,  ! P
		//        0.29946,  0.24792,  0.19264, -0.19939,  ! Q
		//        0.24436, -0.84410,  0.55791, -0.38149,  ! R
		//       -0.11842, -0.07053,  0.48983, -0.35108,  ! S
		//        0.29550, -0.47300,  0.12218, -0.12651,  ! T
		//        1.33393,  0.97223, -0.38891,  0.61398,  ! V
		//       -0.59545,  0.16394, -0.44870,  1.17822,  ! W
		//       -1.10213, -0.03757, -0.42339,  1.37227/  ! Y

		FArray1Da_float env( log_docking_env_fab, log_docking_env_fab.size() );
		int i = 0;

		// A
		env( ++i ) = 0.78580;
		env( ++i ) = 1.98702;
		env( ++i ) = -0.17800;
		env( ++i ) = 0.16899;

		// C
		env( ++i ) = 1.50000;
		env( ++i ) = 1.50000;
		env( ++i ) = -0.57170;
		env( ++i ) = 1.43665;

		// D
		env( ++i ) = -0.36359;
		env( ++i ) = -0.89003;
		env( ++i ) = 0.50295;
		env( ++i ) = -0.31817;

		// E
		env( ++i ) = 0.46329;
		env( ++i ) = -0.21030;
		env( ++i ) = 0.64458;
		env( ++i ) = -0.44078;

		// F
		env( ++i ) = 0.48683;
		env( ++i ) = 0.21214;
		env( ++i ) = -0.47112;
		env( ++i ) = 1.01324;

		// G
		env( ++i ) = -0.32050;
		env( ++i ) = -0.59519;
		env( ++i ) = 0.19664;
		env( ++i ) = -0.14100;

		// H
		env( ++i ) = 0.05663;
		env( ++i ) = 0.59287;
		env( ++i ) = -0.18356;
		env( ++i ) = 0.23636;

		// I
		env( ++i ) = 0.32708;
		env( ++i ) = 0.99338;
		env( ++i ) = -0.42909;
		env( ++i ) = 0.82545;

		// K
		env( ++i ) = 0.11085;
		env( ++i ) = 0.58457;
		env( ++i ) = 0.91797;
		env( ++i ) = -0.52371;

		// L
		env( ++i ) = 0.65333;
		env( ++i ) = 2.55482;
		env( ++i ) = -0.45399;
		env( ++i ) = 0.87447;

		// M
		env( ++i ) = 0.30236;
		env( ++i ) = 0.99276;
		env( ++i ) = -0.42811;
		env( ++i ) = 0.82483;

		// N
		env( ++i ) = -0.92264;
		env( ++i ) = -0.66756;
		env( ++i ) = 0.48094;
		env( ++i ) = -0.25157;

		// P
		env( ++i ) = 0.38680;
		env( ++i ) = 0.83604;
		env( ++i ) = 0.32006;
		env( ++i ) = -0.29517;

		// Q
		env( ++i ) = 0.29946;
		env( ++i ) = 0.24792;
		env( ++i ) = 0.19264;
		env( ++i ) = -0.19939;

		// R
		env( ++i ) = 0.24436;
		env( ++i ) = -0.84410;
		env( ++i ) = 0.55791;
		env( ++i ) = -0.38149;

		// S
		env( ++i ) = -0.11842;
		env( ++i ) = -0.07053;
		env( ++i ) = 0.48983;
		env( ++i ) = -0.35108;

		// T
		env( ++i ) = 0.29550;
		env( ++i ) = -0.47300;
		env( ++i ) = 0.12218;
		env( ++i ) = -0.12651;

		// V
		env( ++i ) = 1.33393;
		env( ++i ) = 0.97223;
		env( ++i ) = -0.38891;
		env( ++i ) = 0.61398;

		// W
		env( ++i ) = -0.59545;
		env( ++i ) = 0.16394;
		env( ++i ) = -0.44870;
		env( ++i ) = 1.17822;

		// Y
		env( ++i ) = -1.10213;
		env( ++i ) = -0.03757;
		env( ++i ) = -0.42339;
		env( ++i ) = 1.37227;
		//KMa phospho_ser
		// O
		if ( add_pser() )
		{
					// S
		env( ++i ) = -0.11842;
		env( ++i ) = -0.07053;
		env( ++i ) = 0.48983;
		env( ++i ) = -0.35108;

		}

	}
//KMa phospho_ser
	FArray2D_float log_docking_env( 4, param::MAX_AA_PLUS(), log_docking_env_initializer );
	 // first index indicates environment:
//KMa phospho_ser MAX_AA_PLUS()
	FArray2D_float const log_docking_pair( param::MAX_AA_PLUS(), param::MAX_AA_PLUS(), log_docking_pair_initializer );
	FArray2D_float const log_docking_env_fab( 4, param::MAX_AA_PLUS(), log_docking_env_fab_initializer );
	 // same table, specific to antibodies
}
