// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10040 $
//  $Date: 2006-08-29 00:01:52 -0700 (Tue, 29 Aug 2006) $
//  $Author: chu $

#ifndef INCLUDED_docking_movement
#define INCLUDED_docking_movement


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// Types
typedef  float (*Scoring_Function)();


// docking_movement Function Declarations


void
main_rigid_body_trial(
	Scoring_Function scoring_function, // which score to use
	int const cycle_number, // for labelling output
	bool const repack_flag, // repack sidechains after the move?
	std::string const & move_label, // usually "rigid_body" or "rigid_body_FA"
	float const trans_magnitude,
	float const rot_magnitude
);


void
main_rigid_body_test();


void
choose_rigid_body(
	FArray1Da_float translation,
	FArray1Da_float rotation,
	float const trans_normal_mag, // magnitudes of movement
	float const trans_parall_mag,
	float const rot_mag // rotation magnitude in degrees
);


void
create_docking_trans_vector(
	FArray1Da_float translation,
	float m_norm,
	float m_par1,
	float m_par2
);


void
apply_rigid_body(
	FArray1DB_float const & translation,
	FArray1DB_float const & rotation
);


void
apply_rigid_body_matrix(
	FArray1DB_float const & translation,
	FArray2DB_float const & R, // rotation matrix
	FArray1Da_float rot_center // rotation center
);


void
apply_rb_to_vector(
	FArray1Da_float y, // output position vector
	FArray1Da_float x, // input position vector
	FArray2DB_float const & R, // rotation matrix
	FArray1DB_float const & P, // offset for rotation center
	FArray1DB_float const & PT // P + translation vector
);

void
apply_rb_to_vector(
	FArray1Da_float y, // output position vector
	FArray1Da_float x, // input position vector
	FArray2DB_double const & R, // rotation matrix
	FArray1DB_double const & P, // offset for rotation center
	FArray1DB_double const & PT // P + translation vector
);

void
rotate_tilt_rotate(
	float phi,
	float theta,
	float psi,
	FArray2DB_float & M
);


void
setup_rotation_matrix(
	float phi,
	float theta,
	float psi,
	FArray1DB_float const & u,
	FArray1DB_float const & v,
	FArray1DB_float const & w,
	FArray2DB_float & R
);


void
rotation_coord_transform(
	FArray1DB_float const & u,
	FArray1DB_float const & v,
	FArray1DB_float const & w,
	FArray2DB_float const & Rin,
	FArray2DB_float & Rout
);


void
calc_docking_rmsd();


void
docking_hijack_best_pose();


void
docking_hijack_best_pose_rlease();


void
docking_mc_accept_best();


void
docking_mc_accept_low();


void
docking_retrieve_best();


void
docking_hose_pose();


void
docking_retrieve_low();


void
set_docking_interface_pack( bool set_pack_interface );

bool
get_docking_interface_pack();

void
docking_set_allow_rottrial();


void
docking_repack( bool const rotamers_exist /* passed to pack */ );


void
dock_random_orient(
	int npartner, // which partner to rotate, 1 or 2?
	FArray1Da_float rotation_center
);


void
dock_slide_into_contact();


void
create_random_orientation_matrx(
	FArray2Da_float R,
	int npartner // which partner to rotate -- changes order of operations
);


void
create_orientation_matrix(
	FArray2Da_float R,
	float & psi,
	float & theta,
	int npartner // which partner to rotate -- changes order of operations
);


void
create_three_rotations_matrix(
	FArray2Da_float R,
	float & a,
	float & b,
	float & c
);


void
xrotation(
	FArray2Da_float R,
	float alpha
);


void
yrotation(
	FArray2Da_float R,
	float alpha
);


void
zrotation(
	FArray2Da_float R,
	float alpha
);


void
docking_axis_spin();


#endif
