// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32323 $
//  $Date: 2009-08-25 13:16:13 -0700 (Tue, 25 Aug 2009) $
//  $Author: johnk $


// Rosetta Headers
#include "docking_ns.h"
#include "pose.h" //added by Sid temporarily

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>
#include <numeric/xyzMatrix.hh>

namespace docking {


//jjg   docking_ns: variables for docking calculations using Rosetta
//jjg
//jjg   Jeff Gray 3/7/2001
//jjg
//jjg


//-------
// modes
//-------

namespace docking_flagflags {
	bool docking_flag = { false }; // true for docking simulations
	bool flexbb_docking_flag = { false }; // true if backbone is flexible
	bool pose_docking_flag = { false }; // true if pose is used.
	bool docking_randomize1;
	bool docking_randomize2;
	bool docking_axis_spin_flag; // spin around the centroid bond?
	bool docking_small_perturbation; // small perturbation?
	bool dock_generate_diversity;
	bool docking_fullatom_flag = { false }; // indicates runs with fullatom parts
	bool docking_fullatom_search_flag = { false }; // turns on fullatom search
	bool docking_minimize_flag; // minimize final fullatom structure?
	bool docking_mcm_flag; // monte-carlo minimize search?
	bool docking_output_position_hetatm = { true }; // print hetatms in pdbfiles?
	bool norepack1;
	bool norepack2;
	bool prepack_mode; // indicates a special protocol: just
	bool score_only;
	bool docking_jumpout_mode; // jumpout of loop early when true
	bool actual_centroids_mode; // use actual centroids on norepacks
	float normal_perturbation; // starting perturbation
	float parallel_perturbation; // "
	float rotational_perturbation; // "
	bool smart_scorefilter_flag;
	float scorefilter_fraction;
	float delta_before_mcm;
	float delta_after_one_min;
	float delta_after_five_mcm;
	bool unboundrot = { false }; // native rotamers in unbound?
	bool unbound_start = { false }; // use unbound structure as start
	bool dock_rtmin = { false }; // minimize_rot in dock_mcm?
	bool dock_mcm_loop_min_flag = { false }; // minimize_loops in dock_mcm?
	bool docking_score_norepack;
	bool docking_fake_native; // is 'native' just a reference position?
	bool docking_hb_stats;
	bool docking_local_refine = { false };
	bool docking_loop_trials = { false };
	// aroop: backbone flexibility in dock
	bool dle_flag = { false };
	// aroop: loop modelling in dock
	bool dle_loops_flag = { false };
	// aroop: enable light-heavy chain perturbation while docking Ab-Ag
	bool antibody_modeling_dock_n_snug_flag = { false };
	bool minimize_backbone = { false };
	bool docking_ensemble_flag = { false };
}


namespace prepack_flags {
	bool prepack_full;
	bool prepack_rtmin;
}

// multimer definition: currently setup as dimer
namespace dock_multi {
        int const max_monomers = { 2 }; // max number of monomers in docking
        int n_monomers; // number of monomers
}

namespace pose_dock_symm {
  bool docking_pose_symmetry = { false };
  bool docking_pose_symm_full = { false };
  bool docking_pose_symm_subsystem = {false};
  int docking_pose_symm_subsystem_size;
  int pose_symm_n_monomers;
  std::string symm_type;
  bool docking_pose_symm_loops;
	bool docking_pose_symm_looprlx;
  bool monomer_input = { false };
	bool combinatorial_rms_sym = { false };
	bool dn_with_3 = { false };
	bool dn_with_5 = { false };
}

namespace ensemble_docking{
	bool ensemble_prepack = {false};
	int e_size_max = 100;
	FArray2D_string pdblist(2,100);
	FArray1D_bool ensemble_read(2);
	FArray1D_int  ensemble_size(2);
	FArray1D_int current_conformer(2);
	FArray2D_float cen_ref_energy( 2, e_size_max );
	FArray2D_float FA_ref_energy( 2, e_size_max ); 
	FArray2D_float exp_score_list( e_size_max, e_size_max );
	FArray2D_float score_list( e_size_max, e_size_max );
	FArray2D_float prob_list( e_size_max, e_size_max );


	using namespace pose_ns;
	std::vector<Pose * > ensemble1;
	std::vector<Pose * > ensemble2;

	}

//-----------


//-------
// query
//-------

//jjg  In general, we are dccking 2 partners.  In Rosetta, the coordinates
//jjg  of both partners will be stored in the position arrays together,
//jjg  and the following integers will be used to keep track of the residues
//jjg  that belong to each partner
//ora: general case for multimer


namespace docking_query {
	FArray1D_int part_begin( max_monomers, 0 );
	FArray1D_int part_end( max_monomers, 0 );
}


//-----------------
// decoy: geometry
//-----------------

//jjg  Some geometric information about the partners

/*         ---------------
//      /                  \
//     |                    |
//     |                   /
//     |         1        |
//      \         \       |
//       \         \      |
//         \        \    /
//           --      \  /
//              ------*------
//               /     \      \
//              |       2      |
//               \             |
//                 -----------
*/

//jjg  Geometric information about the relative coordinate system


//                      1
//                      |  /
//                      | /
//                      |/
//        --------------*-----------> v
//                     /|
//                    / |
//                   /  V u
//                  w   2


namespace docking_decoy_geometry {
	FArray1D_float docking_normal( 3 ); // Unit vector along the centroid bond (u)
	FArray1D_float docking_parallel1( 3 ); // Unit vectors perpendicular to the normal
	FArray1D_float docking_parallel2( 3 ); // (v&w, uxv=w)
	FArray2D_float part_centroid( 3, max_monomers ); // The centroids of each partner
	FArray1D_float centroid_bond( 3 ); // The vector between the two centroids, from 2 to 1
	FArray1D_float contact_point( 3 ); // (*) = the point where the centroid bond
		// intersects the surface between the partners
}


//---------------------
// scores/diagnostics
//--------------------

namespace docking_results {
	float docking_rmsd; // root mean square deviation, decoy vs native
	float docking_interf_rmsd; // interface only after superimposition
	float docking_interf_energy = { 0.0 }; // binding-energy like score
	float docking_translation_distance; // how far part2 has moved from start
	FArray1D_float docking_translation_vector( 3 ); // and in what direction
	float docking_rotation_angle; // overall rotation angle

  float docking_interf_elec_energy = { 0.0 }; // SJF electrostatic component
  float docking_score10d_min_after1 = { 0.0 }; // SJF for Ora's FunHunt
  float docking_score10d_min_after5 = { 0.0 }; // SJF for Ora's FunHunt
}

//-------------------
// silent output
//-------------------
namespace docking_silent_io {
	bool docking_silent_input = { false };
	bool docking_fa_silent_input = { false };
	numeric::xyzVector_double docking_silent_translation(0.0);
	numeric::xyzMatrix_double docking_silent_rotation(0.0);
	std::string docking_silent_input_file;
	utility::vector1<std::string> docking_silent_input_name_map;
}

//-------
// start
//-------

//jjg  Start is the original configuration to begin Rosetta searches from.
//jjg  I have included here only variables that change during the search,
//jjg  so they can be reset for a new search

namespace docking_start {
	FArray2D_float start_part_centroid( 3, max_monomers );
	FArray1D_float start_docking_normal( 3 );
	FArray1D_float start_docking_parallel1( 3 );
	FArray1D_float start_docking_parallel2( 3 );
	FArray1D_float start_centroid_bond( 3 );
	FArray1D_float start_contact_point( 3 );
}


//-------
// native
//-------

//jjg  Native is the configuration that we are searching for.
//jjg  The centroid is all we need since we just want to measure distance.
//jjg  The orientation is the vector from the C-alpha at the beginning
//jjg  of the chain to the C-alpha at the end of the chain.
//chu   native should be real cocrystalized structure and it may be different
//     from starting structure, ie unbound structures, in sequence.

namespace docking_native {
	FArray2D_float native_part_centroid( 3, max_monomers );
	FArray1D_float native_part2_orientation( 3 );
	FArray1D_int native_part_begin( max_monomers );
	FArray1D_int native_part_end( max_monomers );
	float native_docking_T_size;
}


//-------
// best
//-------

//jjg  Best is the current structure in the Monte Carlo run (that is, the
//jjg  last one to be accepted.)

namespace docking_best {
	FArray2D_float best_part_centroid( 3, max_monomers );
	FArray1D_float best_docking_normal( 3 );
	FArray1D_float best_docking_parallel1( 3 );
	FArray1D_float best_docking_parallel2( 3 );
	FArray1D_float best_centroid_bond( 3 );
	FArray1D_float best_contact_point( 3 );
}


//-------
// low
//-------

//jjg  Low is lowest energy configuration ever seen during a Monte Carlo run.

namespace docking_low {
	FArray2D_float low_part_centroid( 3, max_monomers );
	FArray1D_float low_docking_normal( 3 );
	FArray1D_float low_docking_parallel1( 3 );
	FArray1D_float low_docking_parallel2( 3 );
	FArray1D_float low_centroid_bond( 3 );
	FArray1D_float low_contact_point( 3 );
}


//-------
// temporary stuff
//-------

namespace dock_bb_save {
	float score_after_bb;
}

namespace initial_rms_x {
	float initial_rms; // rms after the initial perturbation
	float cenmode_rms; // rms after the centroid mode search
	float score_before_mcm; // various intermediate scores...
	float score_after_one_min;
	float score_after_five_mcm;
}


} // namespace docking


namespace docking_hijack_geometry {
	using namespace docking;
	FArray1D_float save_docking_normal( 3 );
	FArray1D_float save_docking_parallel1( 3 );
	FArray1D_float save_docking_parallel2( 3 );
	FArray2D_float save_part_centroid( 3, max_monomers );
	FArray1D_float save_centroid_bond( 3 );
	FArray1D_float save_contact_point( 3 );
	float save_docking_T_size;
}


namespace docking_repack_private {
	bool pack_interface = { true }; // T=pack interface only, F=pack all
}
