// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32323 $
//  $Date: 2009-08-25 13:16:13 -0700 (Tue, 25 Aug 2009) $
//  $Author: johnk $

#ifndef INCLUDED_docking_ns
#define INCLUDED_docking_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include "pose.h" //added by Sid for ensemble docking 

// Utility Headers
#include <utility/vector1.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>


namespace docking {


//jjg   docking_ns: variables for docking calculations using Rosetta
//jjg
//jjg   Jeff Gray 3/7/2001
//jjg
//jjg


//-------
// modes
//-------

namespace docking_flagflags {
	extern bool docking_flag; // true for docking simulations
	extern bool flexbb_docking_flag; // true if backbone is flexible
	extern bool pose_docking_flag; // true if pose is used.
	extern bool docking_randomize1;
	extern bool docking_randomize2;
	extern bool docking_axis_spin_flag; // spin around the centroid bond?
	extern bool docking_small_perturbation; // small perturbation?
	extern bool dock_generate_diversity; // variation of dockpert specifically to generate diversity
	extern bool docking_fullatom_flag; // indicates runs with fullatom parts
	extern bool docking_fullatom_search_flag; // turns on fullatom search
	extern bool docking_minimize_flag; // minimize final fullatom structure?
	extern bool docking_mcm_flag; // monte-carlo minimize search?
	extern bool docking_output_position_hetatm; // print hetatms in pdbfiles?
	extern bool norepack1;
	extern bool norepack2;
	extern bool prepack_mode; // indicates a special protocol: just
	extern bool score_only;
	extern bool docking_jumpout_mode; // jumpout of loop early when true
	extern bool actual_centroids_mode; // use actual centroids on norepacks
	extern float normal_perturbation; // starting perturbation
	extern float parallel_perturbation; // "
	extern float rotational_perturbation; // "
	extern bool smart_scorefilter_flag;
	extern float scorefilter_fraction;
	extern float delta_before_mcm;
	extern float delta_after_one_min;
	extern float delta_after_five_mcm;
	extern bool unboundrot; // indicators for whether native rotamers in unbound
	extern bool unbound_start; // use unbound structure as start
	extern bool dock_rtmin;
	extern bool dock_mcm_loop_min_flag;
	extern bool docking_score_norepack;
	extern bool docking_fake_native; // is 'native' just a reference position?
	extern bool docking_hb_stats;
	extern bool docking_local_refine;
	extern bool docking_loop_trials;
	extern bool dle_flag; // aroop: insert fragment in docking
	extern bool dle_loops_flag; // aroop: loop_building in docking
	// aroop: enable ligh-heavy chain perturbation while docking Ab-Ag
	extern bool antibody_modeling_dock_n_snug_flag;
	extern bool minimize_backbone;
	extern bool docking_ensemble_flag;
}
using namespace docking_flagflags;


namespace prepack_flags {
	extern bool prepack_full;
	extern bool prepack_rtmin;
}
using namespace prepack_flags;

// multimer definition: currently setup as dimer
namespace dock_multi {
        extern int const max_monomers; // max number of monomers in docking
        extern int n_monomers; // number of monomers in docking
}
using namespace dock_multi;

// Pose symmetry stuff
namespace pose_dock_symm {
  extern bool docking_pose_symmetry; // Pose symmetry stuff
  extern bool docking_pose_symm_full; // Pose symmetry stuff
  extern int pose_symm_n_monomers;
  extern bool docking_pose_symm_subsystem;
  extern int docking_pose_symm_subsystem_size;
  extern std::string symm_type;
  extern bool docking_pose_symm_loops;
	extern bool docking_pose_symm_looprlx;
  extern bool monomer_input;
	extern bool combinatorial_rms_sym;
	extern bool dn_with_3;
	extern bool dn_with_5;
}
using namespace pose_dock_symm;

namespace ensemble_docking {
	extern bool ensemble_prepack;
	extern bool ensemble_rms;
	extern int e_size_max;
	extern FArray2D_string pdblist;
	extern FArray1D_bool ensemble_read;
	extern FArray1D_int ensemble_size;
	extern FArray1D_int current_conformer;
	extern FArray2D_float cen_ref_energy;
	extern FArray2D_float FA_ref_energy;
	extern FArray2D_float exp_score_list; 
	extern FArray2D_float score_list; 
	extern FArray2D_float prob_list;

	using namespace pose_ns;
	extern std::vector<Pose * > ensemble1;
	extern std::vector<Pose * > ensemble2;

	}
using namespace ensemble_docking;

//-----------


//-------
// query
//-------

//jjg  In general, we are dccking 2 partners.  In Rosetta, the coordinates
//jjg  of both partners will be stored in the position arrays together,
//jjg  and the following integers will be used to keep track of the residues
//jjg  that belong to each partner
//ora: general case for multimer

namespace docking_query {
	extern FArray1D_int part_begin;
	extern FArray1D_int part_end;
}
using namespace docking_query;


//-----------------
// decoy: geometry
//-----------------

//jjg  Some geometric information about the partners

/*         ---------------
//      /                  \
//     |                    |
//     |                   /
//     |         1        |
//      \         \       |
//       \         \      |
//         \        \    /
//           --      \  /
//              ------*------
//               /     \      \
//              |       2      |
//               \             |
//                 -----------
*/

//jjg  Geometric information about the relative coordinate system

//                      1
//                      |  /
//                      | /
//                      |/
//        --------------*-----------> v
//                     /|
//                    / |
//                   /  V u
//                  w   2

namespace docking_decoy_geometry {
	extern FArray1D_float docking_normal; // Unit vector along the centroid bond (u)
	extern FArray1D_float docking_parallel1; // Unit vectors perpendicular to the normal
	extern FArray1D_float docking_parallel2; // (v&w, uxv=w)
	extern FArray2D_float part_centroid; // The centroids of each partner
	extern FArray1D_float centroid_bond; // The vector between the two centroids, from 2 to 1
	extern FArray1D_float contact_point; // (*) = the point where the centroid bond
		// intersects the surface between the partners
}
using namespace docking_decoy_geometry;


//---------------------
// scores/diagnostics
//--------------------

namespace docking_results {
	extern float docking_rmsd; // root mean square deviation, decoy vs native
	extern float docking_interf_rmsd; // interface only after superimposition
	extern float docking_interf_energy;
	extern float docking_translation_distance; // how far part2 has moved from start
	extern FArray1D_float docking_translation_vector; // and in what direction
	extern float docking_rotation_angle; // overall rotation angle

  extern float docking_interf_elec_energy; // SJF
  extern float docking_score10d_min_after1; // SJF for Ora's FunHunt
  extern float docking_score10d_min_after5; // SJF for Ora's FunHunt
}
using namespace docking_results;


//-------------------
// silent output
//-------------------
namespace docking_silent_io {
	extern bool docking_silent_input;
	extern bool docking_fa_silent_input;
	extern numeric::xyzVector_double docking_silent_translation;
	extern numeric::xyzMatrix_double docking_silent_rotation;
	extern std::string docking_silent_input_file;
	extern utility::vector1<std::string> docking_silent_input_name_map;
}
using namespace docking_silent_io;

//-------
// start
//-------

//jjg  Start is the original configuration to begin Rosetta searches from.
//jjg  I have included here only variables that change during the search,
//jjg  so they can be reset for a new search

namespace docking_start {
	extern FArray2D_float start_part_centroid;
	extern FArray1D_float start_docking_normal;
	extern FArray1D_float start_docking_parallel1;
	extern FArray1D_float start_docking_parallel2;
	extern FArray1D_float start_centroid_bond;
	extern FArray1D_float start_contact_point;
}
using namespace docking_start;


//-------
// native
//-------

//jjg  Native is the configuration that we are searching for.
//jjg  The centroid is all we need since we just want to measure distance.
//jjg  The orientation is the vector from the C-alpha at the beginning
//jjg  of the chain to the C-alpha at the end of the chain.
//chu   native should be real cocrystalized structure and it may be different
//     from starting structure, ie unbound structures, in sequence.

namespace docking_native {
	extern FArray2D_float native_part_centroid;
	extern FArray1D_float native_part2_orientation;
	extern FArray1D_int native_part_begin;
	extern FArray1D_int native_part_end;
	extern float native_docking_T_size;
}
using namespace docking_native;


//-------
// best
//-------

//jjg  Best is the current structure in the Monte Carlo run (that is, the
//jjg  last one to be accepted.)

namespace docking_best {
	extern FArray2D_float best_part_centroid;
	extern FArray1D_float best_docking_normal;
	extern FArray1D_float best_docking_parallel1;
	extern FArray1D_float best_docking_parallel2;
	extern FArray1D_float best_centroid_bond;
	extern FArray1D_float best_contact_point;
}
using namespace docking_best;


//-------
// low
//-------

//jjg  Low is lowest energy configuration ever seen during a Monte Carlo run.

namespace docking_low {
	extern FArray2D_float low_part_centroid;
	extern FArray1D_float low_docking_normal;
	extern FArray1D_float low_docking_parallel1;
	extern FArray1D_float low_docking_parallel2;
	extern FArray1D_float low_centroid_bond;
	extern FArray1D_float low_contact_point;
}
using namespace docking_low;


//-------
// temporary stuff
//-------

namespace dock_bb_save {
	extern float score_after_bb;
}
using namespace dock_bb_save;

namespace initial_rms_x {
	extern float initial_rms; // rms after the initial perturbation
	extern float cenmode_rms; // rms after the centroid mode search
	extern float score_before_mcm; // various intermediate scores...
	extern float score_after_one_min;
	extern float score_after_five_mcm;
}
using namespace initial_rms_x;


} // namespace docking


namespace docking_hijack_geometry {
	extern FArray1D_float save_docking_normal;
	extern FArray1D_float save_docking_parallel1;
	extern FArray1D_float save_docking_parallel2;
	extern FArray2D_float save_part_centroid;
	extern FArray1D_float save_centroid_bond;
	extern FArray1D_float save_contact_point;
	extern float save_docking_T_size;
}


namespace docking_repack_private {
	extern bool pack_interface; // T=pack interface only, F=pack all
}


#endif
