// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19866 $
//  $Date: 2008-01-23 11:54:04 -0800 (Wed, 23 Jan 2008) $
//  $Author: possu $

#ifndef INCLUDED_docking_scoring
#define INCLUDED_docking_scoring

#include <math.h>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// docking_scoring Function Declarations


void
docking_evaluate_all_scores( float & docking_score );


void
docking_evaluate_fa_scores( float & docking_score );


void
docking_detect_interf_res();


void
docking_calc_interf_pair();


void
docking_calc_env_contact_scores();


void
docking_vdw_compute_insert();


int
docking_count_interf_residues();


void
docking_apply_filters(
	bool & accepted,
	std::string & tag
);


void
docking_warshel_electrostatics();


void
inverse_r_elec(
	float q1,
	float q2,
	float r2,
	float & E
);
inline
void
inverse_r_elec(
	float q1,
	float q2,
	float r2,
	float & E
)
{
	E = 322.0637 * q1 * q2 / r2;
}


//SJF Uses Eq.76 of Warshel, including the distance-dependent dielectrica with an exponential term.
//    Also, smoothes the potential around the distance cutoff (60 ^ 0.5), so
//    that the potential at this distance is 0, as is the derivative.
inline
void
inverse_r_elec_smoothEXP(
  float q1,
  float q2,
  float r2,
  float & E
)
{
  float r = sqrt(r2) ;
  E = 322.0637 * q1 * q2 / r / (1 + 60 * (1-exp(-0.1 * r))) - //distance-dependent dielectric
      (-0.2644 * q1 * q2 * r) - (3.2946 * q1 * q2); //smoothing terms
}

//SJF Uses Eq.76 of Warshel, although the distance-dependent dielectric is
//    merely 1/r
//    Also, smoothes the potential around the distance cutoff (60 ^ 0.5), so
//    that the potential at this distance is 0, as is the derivative.
inline
void
inverse_r_elec_smooth(
  float q1,
  float q2,
  float r2,
  float & E
)
{
  static float const c2 = 36.0; // 6^2
  if (r2 >= c2) { E = 0; return; }
  static float const c3 = 216.0; // = 6^3
  float r = sqrt(r2);
  float alpha = 322.0637 * q1 * q2;
  E = alpha * (1.0 / r2 // original energy term
      + (2.0 * r / c3) - 3.0 / c2) // smoothing terms
     * 1.590; // to ramp the function so that the average matches the average in the non-smoothed run on a 20k decoys of 47 proteins run on boinc
}

#endif
