// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_docking_unbound
#define INCLUDED_docking_unbound


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace docking_unbound {


//     Variables for docking native unbound structure.
//     parallel to those in misc.h
//                                    chu 2003.08.13


namespace unbound_pose {
	extern int unbound_total_res;
	extern FArray1D_int unbound_res;
	extern FArray1D_int unbound_res_variant;
	extern FArray1D_float unbound_phi;
	extern FArray1D_float unbound_psi;
	extern FArray1D_float unbound_omega;
	extern FArray3D_float unbound_fullcoord;
	extern FArray2D_float unbound_actcoord;
	extern FArray2D_int unbound_rotarray;
	extern FArray2D_float unbound_chiarray;
}
using namespace unbound_pose;


//chu   Currently two situations needs unbound structure to be aligned
//     with native
//     1. Adding unbound rotamers to native bound backbone
//     2. Use unbound backbone as starting to do docking simulation.
//     There are several flags to bookkeeping align status:
//     unbound_start -- command line flag to indicate unbound backbone
//                      has been used as the starting structure.
//     unboundrot    -- command line flag to indicate extra rotamers
//                      from unbound structure should be included in
//                      side-chain packing.
//     The above two flags are defined  in docking.h
//     unbound_map_set -- internal flag indicating native and unbound
//                        structure share the same sequence, therefore
//                        no align map is necessary.
//     use_mapped_rmsd -- internal flag indicating whether mapping should
//                        be done before rmsd and I_rmsd are calculated,
//                        for example, when native seq is still in current
//                        array or unbound seq is the same as the native,
//                        this flag should be set as false


namespace docking_align {
	extern FArray1D_int unbound_seq_align_map;
	extern bool unbound_map_set;
	extern bool use_mapped_rmsd;
}
using namespace docking_align;


}


#endif
