// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-17 23:39:36 -0700 (Sat, 17 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_dunbrack_pack
#define INCLUDED_dunbrack_pack


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility headers
#include <utility/vector1.fwd.hh>

// C++ Headers
#include <list>


//bk contains namespace with variables that contain info
//bk about dunbrack"s rotamers
//ctsa mod to read in newest dunbrack rotamer set w/ all bb dep chi angles and sds


namespace dunbrack_pack {


extern int const rot_per_chi;

//// exception for ASN chi2
////
extern int const max_rot_per_chi2;

//// exception for GLN chi3
////
extern int const max_rot_per_chi3;

extern int const max_rot_per_bin;

Dimension & nbins(); // Number of phi & psi angle bins

Dimension & max_packed_rotno();

// Forward declarations
class Dunbrack4D;
class Dunbrack5D;

namespace dunbrack {
	extern FArray5D_short aa_rotno_to_packedrotno;
	extern Dunbrack4D dun_chi; // FArray4D_float dun_chi;
	extern Dunbrack4D dun_sd;  // FArray4D_float dun_sd;
	extern FArray3D_float dun_prob;
	extern Dunbrack5D dun_group_rotno_to_rotno;
	extern FArray3D_float highest_dun_prob;
}
using namespace dunbrack;


//// extra rotamers in addition to the canonical library
////
namespace dunbrack_extra {
	extern utility::vector1< std::list< FArray1D_float > > total_chi_set_db;
}
using namespace dunbrack_extra;


} // namespace dunbrack_pack


#endif
