// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14861 $
//  $Date: 2007-05-09 21:57:20 -0700 (Wed, 09 May 2007) $
//  $Author: jiangl $

// Rosetta Headers
#include "enzyme_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Using
using namespace param;


namespace enzyme {

//****************************************************************//
//     enzyme_ns
//     Lin Jiang September 2004
//
//lin  begin enzyme namespaces
//lin  enzyme_logical: the flag for enzyme design and inverse rotamer tree
//lin  lig_virE_param: the paerameter for virtaul energy calculation
//lin  virtual_rot:    inverse rotamer tree and bbind rotamer library
//lin
//lin
//****************************************************************//

//lin ligand aa flag
namespace ligaa_flag {
	bool enable_ligaa = { false };      // enable ligand as aa
	bool read_ligaa = { false };        // read ligand as aa
  bool read_occ_weights = { false };  // if enable_ligaa, read the atomic weight from occ
  bool read_bvalue_charge = { false };// if enalbe_ligaa, read the atomic charge from bfactor
	bool attach_ligaa_by_jump = {false};// if enable_ligaa, attach ligand by jump
	bool read_ligaa_mdl = { false };    // if enable_ligaa, read ligand from mdl format
	bool use_mdl_connect = { false };   // if enable_ligaa, use mdl connectivity from mdl file
	bool read_lig2 = { false }; // read the second ligand
	std::string lig2_file; //file name of the second ligand
	int ligaaN = { 0 };    //number of the ligand as aa
	float ligand_weight_scale = { 1.0 }; //weight for ligand interface
}

//lin cst_mode flag
namespace cst_mode_flag {

	bool enable_cst_mode = { false };

	//lin cst_mode_io_flag
	bool check_finished = { false };           //lin check overwrite
	bool use_pdbout = { false } ;              //lin pdb out
	std::string pdboutname;
	bool use_log_file  = { false };            //lin redirect to logfile
	std::string log_file_name;
	bool dump_structures = { false };        //lin output pdb in different stages
	int ndruns = { 1 };                      //lin how many runs are processed
	bool iterative_run = { false };          //lin do iterative run with ndruns
	bool use_loop_file = { false };          // use loop file to define the allow bb move region
	std::string loop_filename;   // loop file name
	bool use_common_flag = { false };        // common flag
	std::string flag_file;       // common flag from file

	//lin cst_mode constraint flag
	bool covalent_from_cstfile = { false }; //take the covalent bond info from cst file
	bool safety_check = { false };     // debugging
	bool scaffold_from_misc = { false }; // scaffold from misc, default is from pdb file
	bool complex_cstfile = { false };  // read constraint of complicated format
	bool read_enzyme_cst = { false };  // read constraint by old enzyme format
	bool single_line_cst = { false };  // read constraint of single line format
	bool read_old_header = { false };  // read old header format
	std::string cstfile_name;
	std::string enzymecst_name;
	std::string singlecst_name;
	float covalent_cst_scale = { 3.0 };

	//lin cst_submode flag
	bool cst_conformer = { false } ;    // conformer
	bool cst_dockpert = { false } ;    // perturb the ligand
	bool cst_score = { false } ;       // score with input cst
	bool cst_opt = { false } ;         // optimize the cst
	bool cst_design = { false };       // design with input cst
	bool fix_cstaa = { false };        // fix the aa in the constraint positions
	bool cst_min = { false };          // pose minimization with input cst
	bool cst_loop = { false };         // loop refinement with input cst and ligand
	bool short_interface = { false };  // define ligand interface
	float  design_cut_1;     // cutoff 1 for design residues
	float  design_cut_2;     // cutoff 2 for design residues
	float  repack_cut_1;     // cutoff 1 for repack residues
	float  repack_cut_2;     // cutoff 2 for repack residues
	int  crop_aa;          // crop the pocket to crop_aa if cst_opt
	bool use_score_wtsfile = { false };    // setup score weight set
  bool use_packer_wtsfile = { false };    // setup packer weight set
	bool minimize_ligaa_bonds = { false };   // minimize_ligand_bonds if cst_min and ligaa
	bool minimize_ligaa_angles = { false };  // minimize_ligand_angles if cst_min and ligaa
	bool minimize_ligaa_torsions = { false };// minimize_ligand_torsions if cst_min and ligaa
	bool bb_move = { false };                // vary bb phi, psi if cst_min
	bool chi_move = { false };               // vary sc chi if cst_min
	bool rb_move = { false };                // vary 6 rigid body param if cst_min
	bool fix_lig2 = { false };
	int cst_min_cycles;                      // how many cycle to do cst_min
	bool keep_constraint_sd = { false };        // if keep the cst sd when cst_min
	bool crop_pocket = { false };            // crop the pocket to poly_ala/poly_gly
	bool limit_perturb = { false };           //only keep the good perturb
	float repE_limit = { 10.0 };
	float cstE_limit = { 50.0 };
	float chainbreakE_limit = { 3.0 };
// 	bool ;
// 	bool ;
// 	bool ;
	FArray1D_bool missingres( MAX_RES(), false );
}

namespace enzyme_logical {
	bool enzyme_flag = { false };
	bool enzyme_vrot = { false };
	float vrot_perc = { 0.9 };
}


namespace lig_virE_param {
	bool exact_match_vatom = { false };
	float lig_virE_dmax = { 4.0 };
}


namespace virtual_rot {
	float vrot_repmaxE = { 3.0 };
	int const VIRTUAL_RESIDUE_MAX = { 5 };
	int virtual_residue_count;
	FArray1D_string virtual_residue_id( VIRTUAL_RESIDUE_MAX, std::string( 3, ' ' ) );
	FArray2D_string virtual_resbase_name( 3, VIRTUAL_RESIDUE_MAX );
	FArray3D_float virtual_resbase_coord( 3, 3, VIRTUAL_RESIDUE_MAX );
	int const max_vrot_count = { 200 };
	Dimension max_vrotamers;
	int vrot_counts;
	FArray1D_int vrotaa( max_vrotamers );
	FArray1D_int vrotres( max_vrotamers );
	FArray1D_int vrot_begin(VIRTUAL_RESIDUE_MAX),vrot_end(VIRTUAL_RESIDUE_MAX);
	FArray1D_float	vrot_repE( max_vrotamers );
	FArray2D_float	vrot_vrot_repE( max_vrotamers, max_vrotamers );
	FArray2D_float	vrchi( 20, max_vrot_count );
	FArray2D_float	vdun_perc( 20, max_vrot_count );
	FArray3D_float	vrotcoord( 3, MAX_ATOM(), max_vrotamers );
	FArray3D_float	vdun_chi( 20, max_vrot_count, MAX_CHI );
	FArray3D_float	vdun_sd( 20, max_vrot_count, MAX_CHI );
	FArray3D_int vdun_group_rotno_to_rotno( 20, max_vrot_count, MAX_CHI );
	FArray1D_int vdun_count( 20 );
}


} // namespace enzyme
