// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.23 $
//  $Date: 2005/10/06 22:35:31 $
//  $Author: pbradley $


// Rosetta Headers
#include "evolve.h"
#include "after_opts.h"
#include "files_paths.h"
#include "fullatom.h"
#include "initialize.h"
#include "jumping_pairings.h"
#include "jumping_refold.h"
#include "loop_relax.h"
#include "misc.h"
#include "evolve_ns.h"
#include "namespace_options.h"
#include "output_decoy.h"
#include "param.h"
#include "pose.h"
#include "pose_io.h"
#include "pose_rms.h"
#include "score.h"
#include "silent_input.h"
#include "random_numbers.h"
#include "relax.h"

// ObjexxFCL Headers
#include <ObjexxFCL/formatted.io.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/string.functions.hh>


// C++ Headers
#include <algorithm>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <sstream>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>

//////////////////////////////////////////////////////////////////////////////
/// @begin csa_manager()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void evolution_manager(
	int nstruct,
	int nstart
)
{

	using namespace evolve_ns;
	using namespace files_paths;

	initialize_evolve();

	pose_ns::Pose start_pose;
	// defines length, sequence of start_pose
	initialize_query_pose( start_pose );

	evolve_ns::ideal_pose_csa = true;
	evolve_ns::fullatom_csa = true;

	if ( truefalseoption("prepare_parents") ) {
		prepare_parents("runlowe");
		exit(0);
	}

	modify_jobfile( -1 );

	for ( int i = 1; i <= iteration; ++i ){
		bool end_generation( false );
		float current_per(.0);
		int tribe_list_index;
		get_tribe_list_index( tribe_list_index );
		std::cout << "tribe_list_index = " << tribe_list_index << std::endl;

//		std::string command = "rm -rf " + score_path;
//		std::system( command.c_str() );
//		command = "mkdir " + score_path;
//		std::system( command.c_str() );
		std::string command = "condor_submit " + condorjob;
		std::system( command.c_str() );

		while ( !end_generation ){

			end_generation_check( nstruct*nstart, perc_finish_tol, current_per, end_generation );

			unsigned int seconds = int (expect_seconds * ( 1-current_per ));
			std::cout << "only %" << current_per*100 << " has finished." << std::endl;
			std::cout << "gonna to sleep for " << seconds << " seconds." << std::endl;
			utility::sys_sleep( seconds );
		}

		command = "condor_rm " + user;
		std::system( command.c_str() );

		if ( i % peace == 0 )
			choose_parents_by_score( "runlowe", i, nstart, tribe_list_index );
		else
			choose_parents_by_cluster( "runlowe", i, nstart, tribe_list_index );

		prepare_next_generation();
		modify_jobfile( i );
	}

}

//////////////////////////////////////////////////////////////////////////////
/// @begin prepare_next_generation()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void prepare_next_generation(
){

	using namespace evolve_ns;

	if ( distance_threshhold > 0.6 )
		distance_threshhold -= 0.1;

	if ( perc_loop > 0.21 )
		perc_loop -= 0.05;

	float loop_skip_rate = get_skip_loop_rate();
	if( loop_skip_rate < 0.7 ) loop_skip_rate += 0.1;
	set_skip_loop_rate( loop_skip_rate );


	float loop_combine_rate = get_loop_combine_rate();
	if( loop_combine_rate > 0.11 ) loop_combine_rate -= 0.1;
	set_loop_combine_rate( loop_combine_rate );

}

//////////////////////////////////////////////////////////////////////////////
/// @begin modify_jobfile()
///
/// @brief modify jobfile for next generation of condor jobs
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void modify_jobfile(
	int const & iteration_num
)
{

	using namespace evolve_ns;

	std::stringstream iter_stream;
	iter_stream << iteration_num;

	std::string command = "cp " + condorjob + " " + condorjob + "_" + iter_stream.str();
	std::system( command.c_str() );

	utility::io::izstream jobfile( condorjob.c_str() );

	std::string line;
	std::string newlines;
	while( getline( jobfile, line ) ){
		if( line.find("loop_combine_rate") != std::string::npos ){
			float const loop_combine_rate = get_loop_combine_rate();
			std::stringstream rate_stream;
			rate_stream << loop_combine_rate;
			int const first = line.find("loop_combine_rate")+17;
			line.replace( first, 5," " +  rate_stream.str() + " " );
		}

		if( line.find("loop_skip_rate") != std::string::npos ){
			float const loop_skip_rate = get_skip_loop_rate();
			std::stringstream rate_stream;
			rate_stream << loop_skip_rate;
			int const first = line.find("loop_skip_rate")+14;
			std::cout << line << std::endl;
			std::cout << first << std::endl;
			line.replace( first, 5, " " + rate_stream.str()+" " );
			std::cout << line << std::endl;
		}

		newlines += line + "\n";
	}

	jobfile.close();
	jobfile.clear();

	utility::io::ozstream newjob( condorjob.c_str() );
	newjob << newlines << std::endl;
	newjob.close();
	newjob.clear();
}

//////////////////////////////////////////////////////////////////////////////
/// @begin end_generation_check()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void end_generation_check(
	int noutput,
	float percentage_finished_tol,
	float & current_percentage,
	bool & end_generation
)
{

	using namespace files_paths;

	end_generation = false;


	std::string score_file( "temp_outpdb_list" );
  std::string command = "ls " + score_path + "/*pdb > " + score_file;
	std::system( command.c_str() );

	//std::string score_file = score_path + "/" + code + protein_name + ".fasc";
	std::cout << "output_pdblist_file: " << score_file << std::endl;
	utility::io::izstream score_stream( score_file.c_str() );

	if ( !score_stream.good() ){
		std::cout << "WARNING:: No file named " << score_file << std::endl;
		return;
	}

	std::string line;
	float num_output( 0.0 );

	while( getline( score_stream, line ) ){
		if ( line.find(score_path) != std::string::npos ) num_output++;
	}
	score_stream.close();
	score_stream.clear();

	current_percentage = num_output/float(noutput);
	if ( current_percentage > percentage_finished_tol )
		end_generation = true;

}

//////////////////////////////////////////////////////////////////////////////
/// @begin end_generation_check()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
choose_parents_by_score(
	std::string const & temp_parents_dir,
	int const & iteration_num,
	int & parent_size,
	int tribe_list_index
)
{

	using namespace files_paths;

	float survive_rate( evolve_ns::survive_rate );

	std::string const dssp_loc = get_dssp_loc();
	bool const get_loop_def = get_loopfile_exist();

	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > tribe_list;
	std::vector< std::string > tribe_names;
	make_clusters(
		temp_parents_dir,
		tribe_list,
		tribe_names,
		tribe_list_index,
		parent_size
	);
	int const ntribe = tribe_list.size();

	// find the fitness cutline
	std::vector< float > scores;
	for ( int nt = 0; nt < ntribe; ++nt ){
		for ( int pr = 0; pr < int( tribe_list[nt].size() ); ++pr ){
			scores.push_back( tribe_list[nt][pr].second );
		}
	}
	std::sort( scores.begin(), scores.end() );
	int cut_index = int( survive_rate * scores.size() )-1;
	if ( cut_index < 0 ) cut_index = 0;
	if ( cut_index  < parent_size - 1 )
		// should have at lease parent_size number of members survive
		cut_index = parent_size - 1;
	float const cut_score = scores[ cut_index ];


	// tribe war begins, unfitted members gone
	std::cout << "cutscore = " << cut_score << std::endl;
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > survived_tribe_list;
	for ( int nt = 0; nt < ntribe; ++nt ){
		std::vector< std::pair< pose_ns::Pose*, float > > tribe;
		for ( int pr = 0; pr < int(tribe_list[nt].size()); ++pr ){
			if ( tribe_list[nt][pr].second <= cut_score ){// survives
				tribe.push_back(tribe_list[nt][pr]);
			}else{
				delete tribe_list[nt][pr].first;
			}
		}
		survived_tribe_list.push_back(tribe);
	}

	// our environment can only provide for so many people
	float population_size( 0.0 );
	for ( int nt = 0; nt < ntribe; ++nt )
		population_size += int( survived_tribe_list[nt].size() );

	float const compacity( ( parent_size - 1 )/population_size );
	assert( compacity < 1.0 );
	std::cout << "parent size = " << parent_size
		<< ". population size = " << population_size
		<< ". compacity = " << compacity << std::endl;

	tribe_list.clear();
	for ( int nt = 0; nt < ntribe; ++nt ){
		scores.clear();
		for ( int pr = 0; pr < int( survived_tribe_list[nt].size() ); ++pr )
			scores.push_back( survived_tribe_list[nt][pr].second );
		std::sort( scores.begin(), scores.end() );
		int cutindex = int( compacity * scores.size() ) - 1;
		if ( cutindex < 0 ) cutindex = 0;
		float const cut_score = scores[ cutindex ];

		std::vector< std::pair< pose_ns::Pose*, float > > tribe;
		for ( int pr = 0; pr < int(survived_tribe_list[nt].size()); ++pr ){
			std::cout << nt << " " << pr << " " << survived_tribe_list[nt][pr].second << " vs " << cut_score;
			if ( survived_tribe_list[nt][pr].second <= cut_score ){// survive guy
				std::cout << " survives " << std::endl;
				tribe.push_back(survived_tribe_list[nt][pr]);
			}else{
				delete survived_tribe_list[nt][pr].first;
				std::cout << std::endl;
			}
		}
		tribe_list.push_back(tribe);
	}

	// new parent size
	parent_size = 0;
	for ( int nt = 0; nt < ntribe; ++nt )
		parent_size += int( tribe_list[nt].size() );


	// now make the newparents
	make_new_parents(
		tribe_list,
		tribe_names,
		temp_parents_dir,
		get_loop_def,
		dssp_loc,
		iteration_num
	);


	//clear off
	for ( int m = 0; m < int(tribe_list.size()); ++m ){
		for( int n = 0; n < int(tribe_list[m].size()); ++n ){
			delete tribe_list[ m ][ n ].first;
		}
	}

}

//////////////////////////////////////////////////////////////////////////////
/// @begin choose_parents_by_cluster
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
choose_parents_by_cluster(
	std::string const & temp_parents_dir,
	int const & iteration_num,
	int & parent_size,
	int tribe_list_index
)
{

	using namespace pose_ns;
	using namespace evolve_ns;

	std::string const dssp_loc = get_dssp_loc();
	bool const get_loop_def = get_loopfile_exist();

	std::string parent_list( "temp_parent_list" );
	std::string command = "ls " + temp_parents_dir + "/*pdb > " + parent_list;
	std::system( command.c_str() );

	std::string offspring_list( "temp_decoy_list" );
	command = "ls " + files_paths::score_path + "/*pdb > " + offspring_list;
	std::system( command.c_str() );

	std::vector< std::vector< std::pair< Pose*, float > > > tribe_list;
	std::vector< std::string > tribe_names;
	bool const fullatom( evolve_ns::fullatom_csa );
	bool const ideal_pose( evolve_ns::ideal_pose_csa );
	read_pdb_to_tribes( parent_list, tribe_list, tribe_names, "", fullatom, ideal_pose );

	for ( int i =0 ; i<int(tribe_names.size()); i++){
		std::cout << "tribe name " << tribe_names[i] << std::endl;
	}

	std::vector< std::pair< std::pair< std::string, Pose* >, float > >
		offspring_pose_list;
	read_pdblist_to_pose( offspring_list, offspring_pose_list, fullatom, ideal_pose );

	int const ndec_offspring = offspring_pose_list.size();

	std::string name_p;
	std::string name_o;
	std::string tribe_name;

	for ( int os = 0; os < ndec_offspring; ++os ){

		int dum = 0;
		for ( int nt = 0; nt < int( tribe_list.size()); ++nt )
			dum += int(tribe_list[nt].size());
		std::cout << "offspring number: " << os << " current parent size: " << dum << std::endl;

		int changed_index, changed_member;
		if ( !assign_offspring_to_tribes( tribe_list, offspring_pose_list[os], tribe_list_index, tribe_names, changed_index, changed_member ) ){
			std::cout << "killing offspring number "  << os << std::endl;
		}

	}

	// new parent size
	parent_size = 0;
	for ( int nt = 0; nt < int( tribe_list.size() ); ++nt )
		parent_size += int( tribe_list[nt].size() );


	make_new_parents(
		tribe_list,
		tribe_names,
		temp_parents_dir,
		get_loop_def,
		dssp_loc,
		iteration_num
	);

	//clear off
	for ( int m = 0; m < int(tribe_list.size()); ++m ){
		for( int n = 0; n < int(tribe_list[m].size()); ++n ){
			delete tribe_list[ m ][ n ].first;
		}
	}

}


//////////////////////////////////////////////////////////////////////////////
/// @begin prepare_parents
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
prepare_parents(
	std::string const & temp_parents_dir
)
{

	using namespace pose_ns;
	using namespace evolve_ns;

	std::string const dssp_loc = get_dssp_loc();
	bool const get_loop_def = get_loopfile_exist();

	std::string parent_list( "temp_parent_list" );
	std::string command = "ls " + temp_parents_dir + "/*pdb > " + parent_list;
	std::system( command.c_str() );

	std::vector< std::vector< std::pair< Pose*, float > > > tribe_list;
	std::vector< std::string > tribe_names;
	bool const fullatom( evolve_ns::fullatom_csa );
	bool const ideal_pose( evolve_ns::ideal_pose_csa );
	read_pdb_to_tribes( parent_list, tribe_list, tribe_names, "", fullatom, ideal_pose );

	for ( int i =0 ; i<int(tribe_names.size()); i++){
		std::cout << "tribe name " << tribe_names[i] << std::endl;
	}


	make_new_parents(
		tribe_list,
		tribe_names,
		temp_parents_dir,
		get_loop_def,
		dssp_loc,
		0
	);

	//clear off
	for ( int m = 0; m < int(tribe_list.size()); ++m ){
		for( int n = 0; n < int(tribe_list[m].size()); ++n ){
			delete tribe_list[ m ][ n ].first;
		}
	}

}
//////////////////////////////////////////////////////////////////////////////
/// @begin assign_offspring_to_tribes
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
bool
assign_offspring_to_tribes(
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > & tribe_list,
	std::pair< std::pair< std::string, pose_ns::Pose* >, float > & offspring,
	int & tribe_list_index,
	std::vector< std::string > & tribe_names,
	int & changed_tribe_index,
	int & changed_tribe_member
)
{

	using namespace pose_ns;
	using namespace evolve_ns;

	std::string name_p;
	std::string name_o;
	Pose* pose_parent;
	Pose* pose_offspring;
	std::string tribe_name;
	int tribe_index(0);

	float low_rmsd = 10000;
	int const ntribe = tribe_list.size();
	pose_offspring = offspring.first.second;
	for ( int nt = 0; nt < ntribe; ++nt ){
		for( int pr = 0; pr < int(tribe_list[nt].size() ); ++pr ){
			pose_parent = tribe_list[nt][pr].first;
			float const rmsd( CA_rmsd( *pose_parent, *pose_offspring ) );
			if ( rmsd < low_rmsd ){
				tribe_name = tribe_names[nt];
				tribe_index = nt;
				low_rmsd = rmsd;
			}
		}
	}
	if ( low_rmsd > distance_threshhold ){ // potential new tribe
		float high_score = -99999;
		float const score_o( offspring.second );
		int remove_me_nt(0);
		int remove_me_pr(0);
		for ( int nt = 0; nt < ntribe; ++nt ){
			for( int pr = 0; pr < int(tribe_list[nt].size() ); ++pr ){
				float const this_score = tribe_list[nt][pr].second;
				if ( this_score > high_score ){
					high_score = this_score;
					remove_me_nt = nt;
					remove_me_pr = pr;
				}
			}
		}
		if ( score_o <= high_score ){ // new tribe in town
			std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > survived_tribe_list;
			survived_tribe_list.clear();
			for ( int nt = 0; nt < ntribe; ++nt ){
				std::vector< std::pair< pose_ns::Pose*, float > > tribe;
				for ( int pr = 0; pr < int(tribe_list[nt].size()); ++pr ){
					if ( nt !=remove_me_nt || pr != remove_me_pr ){// survive
						tribe.push_back(tribe_list[nt][pr]);
					}else{
						delete tribe_list[ nt ][ pr ].first;
					}
				}
				survived_tribe_list.push_back(tribe); // note! keep the empty tribes
			}
			tribe_list.clear();
			tribe_list = survived_tribe_list;
			tribe_list_index++; // adding a new tribe
			std::stringstream iter_stream;
			iter_stream << tribe_list_index;
			std::string new_tribe_name = "dec" + iter_stream.str() + "_";
			tribe_names.push_back( new_tribe_name );
			std::vector< std::pair< Pose*, float > > new_tribe;
			new_tribe.push_back( std::make_pair( pose_offspring, score_o ) );
			tribe_list.push_back( new_tribe );
			std::cout << "removing " << remove_me_nt << " " << remove_me_pr <<
			" adding new tribe. Current tribe size = " << tribe_list.size() << std::endl;

			changed_tribe_index = int( tribe_list.size() ) - 1;
			changed_tribe_member = 0;
			return true; // tribe_list changed

		}else{
			delete offspring.first.second;
			std::cout << "delete offspring! " << std::endl;
			return false;
		}
	}else{
		// now find out who shall die
		float high_score = -99999;
		int remove_me(0);
		for( int pr = 0; pr < int(tribe_list[tribe_index].size() ); ++pr ){
			float const score_p( tribe_list[tribe_index][pr].second );
			if ( score_p > high_score ){
				high_score = score_p;
				remove_me = pr;
			}
		}
		float const score_o( offspring.second );
		if( score_o > high_score ){
			delete offspring.first.second;
			return false;

		}else{
			delete tribe_list[tribe_index][remove_me].first;
			tribe_list[tribe_index][remove_me] = std::make_pair( pose_offspring, score_o );
			std::cout << "killing parent number:" << tribe_index << " " << remove_me << std::endl;

			changed_tribe_index  = tribe_index;
			changed_tribe_member = remove_me;
			return true;
		}
	}

	return true;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin make_clusters
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
make_clusters(
	std::string const & temp_parents_dir,
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > & new_tribes,
	std::vector< std::string > & new_tribe_names,
	int tribe_list_index,
	int & parent_size
)
{

	using namespace pose_ns;
	using namespace evolve_ns;

	std::string parent_list( "temp_parent_list" );
	std::string command = "ls " + temp_parents_dir + "/*pdb > " + parent_list;
	std::system( command.c_str() );

	std::string offspring_list( "temp_decoy_list" );
	command = "ls " + files_paths::score_path + "/*pdb > " + offspring_list;
	std::system( command.c_str() );

	std::vector< std::vector< std::pair< Pose*, float > > > tribe_list;
	std::vector< std::string > tribe_names;
	bool const fullatom( evolve_ns::fullatom_csa );
	bool const ideal_pose( evolve_ns::ideal_pose_csa );
	read_pdb_to_tribes( parent_list, tribe_list, tribe_names, "", fullatom, ideal_pose );

	parent_size = 0;
	for ( int nt = 0; nt < int( tribe_list.size() ); ++nt )
		parent_size += int( tribe_list[nt].size() );

	std::vector< std::pair< std::pair< std::string, Pose* >, float > >
		offspring_pose_list;
	read_pdblist_to_pose( offspring_list, offspring_pose_list, fullatom, ideal_pose );

	int const ndec_offspring = offspring_pose_list.size();

	std::string name_p;
	std::string name_o;
	Pose* pose_parent;
	Pose* pose_offspring;
	std::string tribe_name;
	int tribe_index(0);

	for ( int os = 0; os < ndec_offspring; ++os ){
		float low_rmsd = 10000;
		int const ntribe = tribe_list.size();
		pose_offspring = offspring_pose_list[os].first.second;
		float const score_o( offspring_pose_list[os].second );
		for ( int nt = 0; nt < ntribe; ++nt ){
			for( int pr = 0; pr < int(tribe_list[nt].size() ); ++pr ){
				pose_parent = tribe_list[nt][pr].first;
				float const rmsd( CA_rmsd( *pose_parent, *pose_offspring ) );
				if ( rmsd < low_rmsd ){
					tribe_name = tribe_names[nt];
					tribe_index = nt;
					low_rmsd = rmsd;
				}
			}
		}
		if ( low_rmsd > distance_threshhold ){ // new tribe
			tribe_list_index++; // adding a new tribe
			std::stringstream iter_stream;
			iter_stream << tribe_list_index;
			std::string new_tribe_name = "dec" + iter_stream.str() + "_";
			tribe_names.push_back( new_tribe_name );
			std::vector< std::pair< Pose*, float > > new_tribe;
			new_tribe.push_back( std::make_pair( pose_offspring, score_o ) );
			tribe_list.push_back( new_tribe );
		}else{
			tribe_list[tribe_index].push_back( std::make_pair( pose_offspring, score_o ) );
		}
	}

	new_tribes = tribe_list;
	new_tribe_names = tribe_names;

}

//////////////////////////////////////////////////////////////////////////////
/// @begin make_new_parents()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
make_new_parents(
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > const & tribe_list,
	std::vector< std::string > const & tribe_names,
	std::string const & temp_parents_dir,
	bool get_loop_def,
	std::string const & getDsspSS_location,
	int const & iteration_num
)
{

	using namespace files_paths;
	using namespace evolve_ns;

	std::stringstream iter_stream;
	iter_stream << iteration_num;
	std::string newparents = temp_parents_dir + "_" + iter_stream.str();
	std::string command = "rm -fr " + newparents;
	std::system( command.c_str() );
	command = "mv  " + temp_parents_dir + " " + newparents;
	std::system( command.c_str() );
	command = "mkdir " + temp_parents_dir;
	std::system( command.c_str() );

	std::vector<float> ave_allrms;
	std::vector< std::pair< int, int > > loopfile;
	for ( int nt = 0; nt < int( tribe_list.size() ); ++nt ){

		ave_allrms.clear();
		loopfile.clear();
		get_tribe_coordcst(tribe_list[nt], ave_allrms, loopfile);

		int const ndecoy( int(tribe_list[nt].size()) );

		int counter = 0;
		for ( int pr = 0; pr < ndecoy; ++pr ){
			counter++;
			std::stringstream counter_stream;
			counter_stream << counter;
			std::string outname = temp_parents_dir + "/" + tribe_names[nt]
												+ counter_stream.str() + ".pdb";
			pose_ns::Pose * const thispose( tribe_list[nt][pr].first );
			thispose->dump_pdb( outname );

			if ( get_loop_def ){
				if ( ndecoy > 1 ){
					std::string filename = temp_parents_dir + "/"
								+ tribe_names[nt] + counter_stream.str() + ".loopfile";
					utility::io::ozstream out_stream( filename.c_str() );
					if ( !out_stream ) {
						std::cout << "Open failed for file: " << filename << std::endl;
						utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
					}
					for ( int i = 0; i < int( loopfile.size()); ++i )
						out_stream << loopfile[i].first << " " << loopfile[i].second << std::endl;
					out_stream.close();
					out_stream.clear();
				}else{
					command = getDsspSS_location + " -pdbfile " + outname
								+ " -fastafile " + protein_name + protein_chain + ".fasta"
								+ " -outfile " + temp_parents_dir + "/" + tribe_names[nt]
								+ counter_stream.str() + ".loopfile";
					bool err ( std::system( command.c_str() ) );
					if ( err ){
						std::cout << "cound't run " << command << std::endl;
						utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
					}
				}
			}

			if ( get_coordcst ){
				std::string filename = temp_parents_dir + "/"
							+ tribe_names[nt] + counter_stream.str() + ".coordcst";
				utility::io::ozstream out_stream( filename.c_str() );
				if ( !out_stream ) {
					std::cout << "Open failed for file: " << filename << std::endl;
					utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
				}
				for ( int i = 0; i < int( ave_allrms.size()); ++i )
					out_stream << i+1 << " " << ave_allrms.at(i) << std::endl;
				out_stream.close();
				out_stream.clear();
			}
		}
	}

	make_list_name( temp_parents_dir );
	prepare_outdir( iteration_num );

}

//////////////////////////////////////////////////////////////////////////////
/// @begin get_tribe_coordcst()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
get_tribe_coordcst(
	std::vector< std::pair< pose_ns::Pose*, float > > const & tribe,
//	std::string const & tribe_name,
//	std::string const & temp_parents_dir,
	std::vector<float> & ave_allrms,
	std::vector< std::pair< int, int > > & loopfile
)
{

	using namespace evolve_ns;
//	if ( ! get_coordcst ) return;

	int const ndecoys = int( tribe.size() );
	if ( ndecoys < 1 ) return; // empty tribe

	std::vector< std::pair< float, int > > rmsd_list;

	for ( int i = 0; i < ndecoys; ++i ) {
		const pose_ns::Pose* pose1( tribe[i].first );
		// calc avg rmsd to everyone else
		float avg_rmsd( 0.0 );
		for( int j = 0; j < ndecoys; ++j ) {
			const float rmsd( CA_rmsd( *pose1, *(tribe[j].first) ) );
			avg_rmsd += rmsd;
		}
		avg_rmsd /= ndecoys;
		rmsd_list.push_back( std::make_pair( avg_rmsd, i ) );
	}
	std::sort( rmsd_list.begin(), rmsd_list.end() );

	// now superimpose all the decoys onto the template
	int rank_of_center( 0 );
	const int decoy( rmsd_list[rank_of_center].second );
	const pose_ns::Pose * const center_pose( tribe[decoy].first );
	std::cout << "using decoy# " << decoy << " as center\n";

	std::vector< std::vector< float > > allresrms;

	std::vector< float > perresrmsd;
	for ( int i = 0; i < ndecoys; ++i ){
		perresrmsd.clear();
		per_res_CA_rmsd( *center_pose, *(tribe[i].first), perresrmsd );
		allresrms.push_back( perresrmsd );
	}

	for ( int i = 0; i < int( allresrms.at( 0 ).size() ); ++i ){
		ave_allrms.push_back(0);
		for ( int j = 0; j < int( allresrms.size() ); ++j ){
			ave_allrms.at(i) += allresrms.at(j).at(i);
		}
	}

	for(int i = 0; i < int( ave_allrms.size() ); ++i ){
		ave_allrms.at(i) /= float(allresrms.size());
		ave_allrms.at(i) += 0.5; // pad 0.2 A
	}

	// now make the loop files
	loopfile.clear();
	std::vector< std::pair < float, int > > res_rmsd;
	for ( int i = 0; i < int( ave_allrms.size() ); ++i ){
		res_rmsd.push_back( std::make_pair( ave_allrms.at(i), i ) );
	}
	std::sort( res_rmsd.begin(), res_rmsd.end() );

	float const perc_loop( get_perc_loop() );
	int const start = int( ( 1 - perc_loop ) * res_rmsd.size() );
	std::vector< int > loop_marker;
	for( int i = 0; i < int(res_rmsd.size()); ++i ) loop_marker.push_back(0);
	for( int i = start; i < int( res_rmsd.size() ); ++i )
		loop_marker[ res_rmsd[i].second ] = 1;

	bool inloop( false );
	int loop_start(1);
	int loop_end(1);
	for( int i = 0; i < int( loop_marker.size() ); ++i ){
		if ( loop_marker[i] == 1 && !inloop ){
			loop_start = i+1;
			loop_end = i+1;
			inloop = true;
		}
		else if( loop_marker[i] == 1 && inloop )
			loop_end = i+1;
		else if( loop_marker[i] == 0 && inloop ){
			loopfile.push_back( std::make_pair(loop_start, loop_end) );
			inloop = false;
		}
	}
	if ( inloop ) // last loop
		loopfile.push_back( std::make_pair(loop_start, loop_end) );

/*
	int counter = 0;
	for ( int pr = 0; pr < int( tribe.size() ); ++pr ){
		counter++;
		std::stringstream counter_stream;
		counter_stream << counter;

	// output
		std::string filename;
		filename = temp_parents_dir + "/" + tribe_name
							+ counter_stream.str() + ".coordcst";
		utility::io::ozstream out_stream( filename.c_str() );
		if ( !out_stream ) {
			std::cout << "Open failed for file: " << filename << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
		for (int i=0; i < int(allresrms.at(0).size()); ++i){
			out_stream << i+1 << " " << ave_allrms.at(i) << std::endl;
		}

		out_stream.close();
		out_stream.clear();
	}
*/

}

//////////////////////////////////////////////////////////////////////////////
/// @begin make_list_name()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
make_list_name(
	std::string const & temp_parents_dir
)
{
	std::string listname;
	stringafteroption( "l", "none", listname );
	std::string command = "ls " + temp_parents_dir + "/*pdb > " + listname;
	std::system( command.c_str() );
}

//////////////////////////////////////////////////////////////////////////////
/// @begin prepare_outdir()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
prepare_outdir(
	int const & iteration_num
)
{
	using namespace files_paths;

	std::stringstream iteration_num_stream;
	iteration_num_stream << iteration_num;
	std::string command = "rm -fr run_output_" + iteration_num_stream.str();
	std::system( command.c_str() );
	command = "mv " + score_path + " run_output_" + iteration_num_stream.str();
	std::system( command.c_str() );
	command = "mkdir " + score_path;
	std::system( command.c_str() );

}

//////////////////////////////////////////////////////////////////////////////
/// @begin get_perc_loop()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
float
get_perc_loop(
)
{
	using namespace evolve_ns;

	return perc_loop;

}

//////////////////////////////////////////////////////////////////////////////
/// @begin get_tribe_list_index()
///
/// @brief get the current index of tribe_list
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
get_tribe_list_index(
	int & tribe_list_index
)
{

	using namespace pose_ns;
	using namespace misc;

	std::string list_name;
	stringafteroption( "l", "none", list_name );

	utility::io::izstream pdblist( list_name.c_str() );
	if ( !pdblist.good() ) {
		std::cout << "cant open " << list_name << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	std::string index_string;
	int max_index = -999;
	std::string filename;
	int index_int(0);
	while ( getline( pdblist, filename ) ) {

		// now figure out which tribe this pose belongs to
		index_string.clear();
		index_string = filename.substr( filename.find_last_of("/")+1+3,
											filename.find_first_of('_') -
											filename.find_last_of("/") - 3
								);

		std::stringstream index_stream (index_string);
		index_stream >> index_int;
		if ( index_int > max_index ) max_index = index_int;
	}

	tribe_list_index = max_index;
	std::cout << "max index is: " << tribe_list_index << std::endl;
}


//////////////////////////////////////////////////////////////////////////////
/// @begin read_pdb_to_tribes()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
read_pdb_to_tribes(
	std::string const & list_name,
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > & tribe_list,
	std::vector< std::string > & tribe_names,
	std::string const & code,
	bool const & fullatom,
	bool const & ideal_pose
)
{

	using namespace pose_ns;
	using namespace misc;


	int const tribe_name_offset( code.size() );
	int const nres( total_residue );

	utility::io::izstream pdblist( list_name.c_str() );
	if ( !pdblist.good() ) {
		std::cout << "cant open " << list_name << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	std::string filename;
	std::string tribe_name;
	while ( getline( pdblist, filename ) ) {

		// to avoid the silly empty files
		utility::io::izstream data_stream( filename.c_str() );
		if ( !data_stream.good() ) {
			std::cout << "WARNING: unable to open pdb file: " << filename << std::endl;
			data_stream.clear();
			continue; // failed
		}
		data_stream >> tribe_name;
		if ( data_stream.eof() ) {
			data_stream.clear();
			continue;
		} else data_stream.clear();


		// make a new pose
		Pose * const pose_ptr( new Pose() );
		Pose & one_pose( *pose_ptr );
		one_pose.set_fullatom_flag( fullatom, false );
		one_pose.simple_fold_tree( nres );
		bool const ok( pose_from_pdb( one_pose, filename, fullatom, ideal_pose ) );
		if ( !ok ) {
			std::cout << "input failed: " << filename << std::endl;
			continue;
		}
		float score;
		bool const got_score( read_score_from_decoy( filename, score ) );
//		bool const got_score(false);
		if ( !got_score ) {
			std::cout << "WARNING:: Decoy " << filename
				<< " doesn't have \"score:\" field!" << std::endl;
			if ( fullatom )	score = one_pose.score(score12);
			else score = one_pose.score(score6);
		}

		// now figure out which tribe this pose belongs to
		tribe_name.clear();
		tribe_name = filename.substr( filename.find_last_of("/")+1+tribe_name_offset,
											filename.find_first_of('_') -
											filename.find_last_of("/")-tribe_name_offset
								);
		bool found = false;
		for ( int i = 0; i < int( tribe_names.size() ); ++i ){
			if ( tribe_name == tribe_names[i] ){
				tribe_list[i].push_back( std::make_pair( pose_ptr, score ) );
				found = true;
				break;
			}
		}
		if ( !found ){
			tribe_names.push_back( tribe_name );
			std::vector< std::pair< Pose*, float > > new_tribe;
			new_tribe.push_back( std::make_pair( pose_ptr, score ) );
			tribe_list.push_back( new_tribe );
		}

	}
}


//////////////////////////////////////////////////////////////////////////////
/// @begin read_pdblist_to_pose()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
read_pdblist_to_pose(
	std::string list_name,
	std::vector< std::pair< std::pair< std::string, pose_ns::Pose* >, float > >
		&	pose_list,
	bool const & fullatom,
	bool const & ideal_pose
)
{

	using namespace pose_ns;
	using namespace misc;

	int const nres( total_residue );

	utility::io::izstream pdblist( list_name.c_str() );
	if ( !pdblist.good() ) {
		std::cout << "cant open " << list_name << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	std::string filename;
	while ( getline( pdblist, filename ) ) {

		// to avoid the silly empty files
		utility::io::izstream data_stream( filename.c_str() );
		if ( !data_stream.good() ) {
			std::cout << "WARNING: unable to open pdb file: " << filename << std::endl;
			data_stream.clear();
			continue; // failed
		}
		std::string junk;
		data_stream >> junk;
		if ( data_stream.eof() ) {
			data_stream.clear();
			continue;
		} else data_stream.clear();

		//make a new pose
		Pose * const pose_ptr( new Pose() );
		Pose & one_pose( *pose_ptr );
		one_pose.set_fullatom_flag( fullatom, false );
		one_pose.simple_fold_tree( nres );
		bool const ok (
				pose_from_pdb( one_pose, filename, fullatom, ideal_pose )
		);
		if ( !ok ) {
			std::cout << "input failed: " << filename << std::endl;
			continue;
		}
		float score;
		bool const got_score = read_score_from_decoy( filename, score );
		if ( !got_score ) {
			std::cout << "WARNING:: Decoy " << filename
				<< " doesn't have \"score:\" field!" << std::endl;
			if ( fullatom )	score = one_pose.score(score12);
			else score = one_pose.score(score6);
		}
		pose_list.push_back(
				std::make_pair( std::make_pair( filename, pose_ptr ), score )
		);
	}
}

//////////////////////////////////////////////////////////////////////////////
/// @begin read_score_from_decoy
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
bool
read_score_from_decoy(
	std::string decoy_file,
	float & score
)
{

	utility::io::izstream infile( decoy_file.c_str() );
	if ( !infile.good() ){
		return false;
	}
	std::string line;
	std::string junk;
	std::string scoreline;
	while( getline( infile, line )) {
		if ( line.find("score:") != std::string::npos ){
			scoreline = line.substr( line.find("score:") );
			std::stringstream line_stream( scoreline );
			line_stream >> junk >> score;
			return true;
		}else if( line.find("SCORE") != std::string::npos ){
			scoreline = line.substr( line.find("SCORE") );
			std::stringstream line_stream( scoreline );
			line_stream >> junk >> score;
			return true;
		}
	}

	return false;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin get_dssp_loc
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
std::string
get_dssp_loc()
{
	using namespace evolve_ns;

	return dssp_pl_location;

}

//////////////////////////////////////////////////////////////////////////////
/// @begin initialize_evolve
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
initialize_evolve()
{

	using namespace evolve_ns;

	if ( !truefalseoption( "evolution" ) && !truefalseoption( "evol_recomb" ) ) return;
	evolution = true;
	get_loopfile = truefalseoption("getloop");
	get_coordcst = truefalseoption("getcoordcst");

	// communicate with looprlx
	if ( get_coordcst ) set_coord_cst_exist( true );

	stringafteroption( "dssppl", "", dssp_pl_location );
	intafteroption( "generation", 0, iteration );
	intafteroption( "peace_break", 9999, peace );
	intafteroption( "expect", 600, expect_seconds );
	realafteroption( "perc_finish_tol", 0.95, perc_finish_tol );
	stringafteroption( "condorjob", "", condorjob );
	realafteroption( "distance_threshhold", 2.0, distance_threshhold );
	stringafteroption( "user", "bqian", user );
	realafteroption( "survive_rate", 0.3, survive_rate );

}

//////////////////////////////////////////////////////////////////////////////
/// @begin get_iteration_num
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
int
get_iteration_num()
{

	using namespace evolve_ns;

	return iteration;

}

//////////////////////////////////////////////////////////////////////////////
/// @begin get_loopfile_exist
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
bool
get_loopfile_exist()
{

	return evolve_ns::get_loopfile;

}

//////////////////////////////////////////////////////////////////////////////
/// @begin recombine_parts
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
recombination(
	int const nstruct
)
{

	using namespace pose_ns;
	using namespace evolve_ns;

	std::string list_name;
	stringafteroption( "l", "none", list_name );


	// get native pose
	Pose native_pose;
	bool const native_exists( truefalseoption("n") );
	if ( native_exists )
		pose_from_pdb( native_pose, stringafteroption("n"), false, false );

	evolve_ns::ideal_pose_csa = false;
	evolve_ns::fullatom_csa = false;
	evolve_ns::survive_rate = 0.9;

	std::vector< std::vector< std::pair< Pose*, float > > > tribe_list;
	std::vector< std::string > tribe_names;
	bool const fullatom( evolve_ns::fullatom_csa );
	bool const ideal_pose( evolve_ns::ideal_pose_csa );
	read_pdb_to_tribes( list_name, tribe_list, tribe_names, "", fullatom, ideal_pose );

	std::vector< std::pair< int, int > > variable_regions;
	get_variable_regions( variable_regions );

	// make tags
	std::vector< std::vector< std::vector< std::string > > > tags;
	for( int i = 0; i < int( tribe_list.size() ); ++i ){
		std::vector< std::vector< std::string > > tribe_tag;
		for( int j = 0; j < int( tribe_list[i].size() ); ++j ){
			std::vector< std::string > member_tag;
			for ( int k = 0; k < int( variable_regions.size()); ++k ){
				member_tag.push_back( tribe_names[i] );
			}
			tribe_tag.push_back( member_tag );
		}
		tags.push_back( tribe_tag );
	}

	int tribe_list_index;
	get_tribe_list_index( tribe_list_index );

// only using the variable regions to do recombination
// delete_intervals( tribe_list, variable_regions );

	for ( int round = 0; round < iteration; ++round ){
		std::vector< std::pair< std::pair< std::string, Pose* >, float > > all_offsprings;
		std::vector< std::vector<std::string> > all_offspring_tags;
		int const ntribes( int( tribe_list.size() ) );
		for ( int m = 0; m < ntribes; ++m ){
			for( int n = 0; n < int(tribe_list[m].size()); ++n ){
				for ( int i = 0; i < nstruct; ++i ){

					int ndecoys1 = 0;
					int tr1;
					while( ndecoys1 <= 0 ){
						tr1 = int( ran3() * ntribes );
		//				int const tr2 = int( ran3() * ntribes );
						ndecoys1 = int( tribe_list[tr1].size() );
		//				int const ndecoys2( int( tribe_list[tr2].size() ) );
					}
					int const pr1 = int( ran3() * ndecoys1 );
	//				int const pr2 = int( ran3() * ndecoys2 );

					Pose & pose1( *tribe_list[tr1][pr1].first );
					Pose & pose2( *tribe_list[ m ][ n ].first );
//			std::cout << "WARNING: copy: " << tr1 << "-" << pr1 << " to " << m << "-" << n << std::endl;
//					pose1 = *tribe_list[tr1][pr1].first;
//					pose2 = *tribe_list[ m ][ n ].first;

	//				pose2 = *tribe_list[tr2][pr2].first;

//					Pose* const offspring_pose( new Pose() );
					Pose* const offspring_pose_ptr( new Pose() );
					Pose & offspring_pose( *offspring_pose_ptr );
					offspring_pose = pose2;
//					offspring_pose.simple_fold_tree( pose2.total_residue());
					std::pair< std::pair< std::string, Pose* >, float > offspring;
					std::vector<std::string> offspring_tag(tags[m][n]);

					recombine_two_poses( pose1, offspring_pose, tags[tr1][pr1], offspring_tag, variable_regions );

			// link to native pose if exists
			//	if ( get_native_exists() )
//					offspring_pose.set_native_pose(native_pose);
//					calc_rms( offspring_pose );
					float score_o = offspring_pose.score(score6);

					std::string dummy(""); // space holder for offspring name
					offspring = std::make_pair( std::make_pair( dummy, offspring_pose_ptr ), score_o );

					all_offsprings.push_back( offspring );
					all_offspring_tags.push_back( offspring_tag );
				}
			}
		}

		for( int os = 0; os < int( all_offsprings.size() ); ++os ){
			int changed_index, changed_member;
			bool new_tribe = assign_offspring_to_tribes( tribe_list, all_offsprings[os], tribe_list_index, tribe_names, changed_index, changed_member );
			if (new_tribe) {
				if ( changed_index > int(tags.size()) - 1 ){//new tag in a new tribe
					std::vector< std::vector< std::string > > tribe_tag;
					tribe_tag.push_back( all_offspring_tags[os] );
					tags.push_back( tribe_tag );
				}else if( changed_member > int(tags[changed_index].size() - 1 ) ){// new tag in a old tribe
					std::cout << "ERROR:: strange new tag: " << changed_index << ' ' << changed_member << std::endl;
					utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	//				tags[changed_index].push_back(offspring_tag);
				}else{
					tags[changed_index][changed_member] = all_offspring_tags[os];
				}
			}
		}
	}


//	silent_io::Decoy_out decoy_out(false);
	std::string scorefile = files_paths::pdb_out_path + "/score";
	utility::io::ozstream score_file(scorefile.c_str());
	int const ntribes( int(tribe_list.size() ) );
	for ( int m = 0; m < ntribes; ++m ){
		int counter(0);
		for( int n = 0; n < int(tribe_list[m].size()); ++n ){
//		open_decoy_pdb(mode, 1, i, file_exists);
//		if ( file_exists ) continue;
			counter++;
			std::string decoy_name( files_paths::pdb_out_path +
															tribe_names[m] +
															string_of(counter) +
															".pdb");
			tribe_list[m][n].first->dump_pdb( decoy_name );

			score_file << decoy_name << " ";
			for ( int l = 0; l < int(tags[m][n].size()); ++l )
				score_file << tags[m][n][l] << "_";
			score_file << " ";
			tribe_list[m][n].first->show_scores( score_file );
			score_file << '\n';

		}
	}
	score_file.close();
	score_file.clear();

	for ( int m = 0; m < ntribes; ++m ){
		for( int n = 0; n < int(tribe_list[m].size()); ++n ){
			delete tribe_list[ m ][ n ].first;
		}
	}

}


//////////////////////////////////////////////////////////////////////////////
/// @begin delete_intervals
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
delete_intervals
(
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > & tribe_list,
	std::vector< std::pair< int, int > > & variable_regions
)
{

	// update variable regions
	std::vector< std::pair< int, int > > new_variable_regions;
	int copied_seg = 1;
	for ( int n = 0; n < int(variable_regions.size()); ++n ) {
		int const seg_size( variable_regions[n].second - variable_regions[n].first + 1 );
		new_variable_regions.push_back( std::make_pair( copied_seg, copied_seg+seg_size-1 ) );
		copied_seg += seg_size;
	}

	// update tribe_list
	int nres = copied_seg - 1;
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > new_tribe_list;
	int ntribes = int( tribe_list.size() );
	for ( int i = 0; i < ntribes; ++i ){
		std::vector< std::pair< pose_ns::Pose*, float> > one_tribe;
		one_tribe.clear();
		for( int j = 0; j < int(tribe_list[i].size()); ++j ){
			pose_ns::Pose * const pose_ptr( new pose_ns::Pose() );
			pose_ptr->simple_fold_tree( nres );
			// copy segments from full_pose into pose
			int copied_seg = 1;
			for ( int n = 0; n < int(variable_regions.size()); ++n ) {
				int const seg_size( variable_regions[n].second - variable_regions[n].first + 1 );
				pose_ptr->copy_segment( seg_size, *tribe_list[i][j].first, copied_seg, variable_regions[n].first );
				copied_seg += seg_size;
			}

			pose_ptr->update_backbone_bonds_and_torsions();
			float const this_score = pose_ptr->score(score6);
			one_tribe.push_back( std::make_pair( pose_ptr, this_score) );
			delete tribe_list[i][j].first;
		}
		new_tribe_list.push_back( one_tribe );
	}
	tribe_list.clear();
	tribe_list = new_tribe_list;


	variable_regions.clear();
	variable_regions = new_variable_regions;


}

//////////////////////////////////////////////////////////////////////////////
/// @begin recombine_two_poses
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
recombine_two_poses(
	pose_ns::Pose & pose1,
	pose_ns::Pose & pose2,
	std::vector<std::string> const & tag1,
	std::vector<std::string> & tag2,
	std::vector< std::pair< int, int > > const & variable_segs
)
{

	bool const ideal_pos( false );
	maxsub_orient_pose( pose1, pose2, ideal_pos );

	int const nres( pose1.total_residue() );

	int const total_segs( int( variable_segs.size() ) );
	int const seg( int(ran3() * total_segs));
	int begin( int( variable_segs[seg].first  ) );
	int end  ( int( variable_segs[seg].second ) );
	if ( begin < 1 ) begin = 1;
	if( end > nres ) end = nres;
	int size( end - begin + 1 );
		// copy a stretch of coordinates/torsions from another pose

	pose2.copy_segment( size, pose1, begin, begin );
	pose2.update_backbone_bonds_and_torsions();
	tag2[seg] = tag1[seg];
/*
	int const seg2( int(ran3() * total_segs));
	begin = int( variable_segs[seg2].first  + ran3() * 2 );
	end = int( variable_segs[seg2].second + ran3() * 2 );
	if (begin<1) begin = 1;
	if(end > nres) end = nres;
	size = end - begin + 1;
		// copy a stretch of coordinates/torsions from another pose

	pose2.copy_segment( size, pose1, begin, begin );
	pose2.update_backbone_bonds_and_torsions();
*/

}

//////////////////////////////////////////////////////////////////////////////
/// @begin get_variable_regions
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
get_variable_regions(
	std::vector< std::pair< int, int > > & variable_regions
)
{

	static bool init(false);
	static std::vector< std::pair< int, int > > var_regs;

	if ( !init ){

		var_regs.clear();
		std::string filename;
		stringafteroption( "variable_regions", "", filename);
		if ( filename == "" ){
			std::cout << "No variable_regions_file specified! Try to find variable_regions in start_path!"
			<< std::endl;
			filename = files_paths::start_path + files_paths::start_file + ".var";
		}
		utility::io::izstream data( filename.c_str() );
		if ( !data ) {
			std::cout << "Couldn't open variable region file " << filename << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		std::string line;
		while ( getline( data, line ) ) {
			std::istringstream line_stream( line );
			int begin,end;
				line_stream >> begin >> end;
			if ( !line_stream.fail() ) {
				var_regs.push_back( std::make_pair( begin, end ) );
				std::cout << "variable region: " << ' ' << begin << ' ' << end << std::endl;
			}
		}
		data.close();
		init = true;
	}

	variable_regions = var_regs;

}

//////////////////////////////////////////////////////////////////////////////
/// @begin csa_manager()
///
/// @brief
///
/// @detailed
///
/// @param  fail - [in/out]? -
/// @param  mode - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void evolution_manager_recomb(
	int nstruct
//	int nstart
)
{

	using namespace evolve_ns;
	using namespace files_paths;

	initialize_evolve();

	pose_ns::Pose start_pose;
	// defines length, sequence of start_pose
	initialize_query_pose( start_pose );

	recombination( nstruct );
/*
	for ( int i = 1; i <= iteration; ++i ){
		int tribe_list_index;
		get_tribe_list_index( tribe_list_index );
		std::cout << "tribe_list_index = " << tribe_list_index << std::endl;

		recombination( nstruct );

		if ( i % peace == 0 )
			choose_parents_by_score( "runlowe", i, nstart, tribe_list_index );
		else
			choose_parents_by_cluster( "runlowe", i, nstart, tribe_list_index );

//		prepare_next_generation();
	}
*/
}
