// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13036 $
//  $Date: 2007-02-22 19:03:09 -0800 (Thu, 22 Feb 2007) $
//  $Author: yab $


// Rosetta Headers
#include "after_opts.h"
#include "fold_abinitio_csa.h"
#include "fold_abinitio.h"
#include "constraints.h"
#include "counters.h"
#include "diagnostics_rosetta.h"
#include "dipolar.h"
#include "fold_constraints.h"
#include "fragments.h"
#include "fullatom.h"
#include "maps.h"
#include "misc.h"
#include "monte_carlo.h"
#include "orient_rms.h"
#include "param.h"
#include "recover.h"
#include "refold.h"
#include "score.h"
#include "ssblocks.h"
#include "taboo_search.h"
#include "torsion_bbmove_trials.h"
#include "structure.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/formatted.o.hh>

// C++ Headers
#include <iostream>


////////////////////////////////////////////////////////////////////////////////
/// @begin fold_abinitio_csa
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fold_abinitio_csa(int stage1_ncycles,
                  int stage2_ncycles,
                  int stage3_nloops,
                  int stage3_ncycles,
                  int stage4_nloops,
                  int stage4_ncycles)
{
	using namespace counters;
	using namespace misc;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	int const contig_cut1 = { 4 };
	 // cutoffs for largest insertable region // return
	int const contig_cut2 = { 10 }; // use 3mers only
	int const contig_cut3 = { 30 };
	 // when contig < cutoff then: // use 3mers and 9mers in early sections

	int size=9;
	float cutoff;
	float init_temp;

	int nloop2,nloop,cycles;

	int contig_size,total_size;

//------------------------------------------------------------------------------

	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) {
  	score_set_cst_mode(3);
		classical_constraints::BOUNDARY::set_max_seqSep(5);
	}

// initial conditions for the protocol
	init_temp = 2.0;
	monte_carlo_set_quench_temp(init_temp);
	monte_carlo_set_temp(init_temp); // reset temp
	monte_carlo_set_simannealing(true); // don't let mc change temp
	set_fullatom_flag(false); // should be off, but ensure it is

	int number3merfrags = get_number3merfrags(); // Default 25
	int number9merfrags = get_number9merfrags(); // Default 200

	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) {
		choose_frag_set_top_N_frags(200); // use top 200 frags if contraints exist
	}else{
		choose_frag_set_top_N_frags(number9merfrags); // use top 200 frags if contraints exist
	}

  if (get_random_frag_state()) {
		pick_random_frags(200,100,75,25);// randomly pick 100 of the top 200 3mers and 25 of the top 75 9mers.  different choice for each trajectory to spread out sampling
	}


// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  insert secondary structure, bump check only
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
if(stage1_ncycles>0){
	std::cout << "starting fragment insertions..." << std::endl;

	decide_block_state();
// parameters
	recover_LOW(score0);


	cycles = stage1_ncycles;
	size = 9;
	insert_map_get_max_contig_size(contig_size,total_size);
	if ( contig_size < contig_cut1 ) return;
	if ( contig_size < contig_cut2 ) size = 3; // use 3mers only

// diagnostics
	reset_trial_counters();

// frag insertions
	for ( int j = 1; j <= cycles; ++j ) {
		main_frag_trial(size,score0,-1);
		if ( start_sim() == 1 ) goto L101; // all swapped one or more times
	}
	for ( int j = 1; j <= cycles; ++j ) {
	 // if still not all swapped, try smaller frags
		main_frag_trial(3,score0,-1);
		if ( start_sim() == 1 ) goto L101;
	}
	std::cout << "WARNING: extended chain may still remain!" << std::endl;
L101:

// diagnostics
	refold(1,total_residue); // recover current structure
	calc_rms();
	std::cout << "score0 done: (best, low) rms" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "---------------------------------------------------------" << std::endl;
}
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    regular moves   w/bumps,secondary structure, light strand pairing
//    no rg or cbeta yet
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) {
		classical_constraints::BOUNDARY::set_max_seqSep(10);
	}

if(stage2_ncycles>0){
  size=9;
// parameters/setup
	monte_carlo_set_simannealing(false); // let mc raise temp

  cycles = stage2_ncycles;
	if ( contig_size < contig_cut3 ) cycles /= 2; // do 3mers too
	new_score_function(score1);

// diagnostics
	reset_trial_counters();

// frag insertions
	for ( int j = 1; j <= cycles; ++j ) {
		main_frag_trial(size,score1,j);
		if ( contig_size < contig_cut3 ) main_frag_trial(3,score1,j);
	}

// diagnostics
	refold(1,total_residue);
	calc_rms();
	std::cout << "score1 done: (best, low) rms (best,low)" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) <<
	 SS( low_rms ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;

	recover_LOW(score2);
}
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   Add cbeta, rg (collapse chain)
//   alternate score2/score5 (high/low sheet weight)
//   convergence-checking enabled in monte_carlo
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) {
		classical_constraints::BOUNDARY::set_max_seqSep(20);
	}

if(stage3_nloops>0){


// setup
	nloop = 1;
	nloop2 = stage3_nloops;
	cycles =  stage3_ncycles;
	if ( contig_size < contig_cut3 ) {
		nloop = 2; // 9mers, then 3mers
		nloop2 = stage3_nloops/2;
		cycles = stage3_ncycles;
	}
	monte_carlo_set_temp(init_temp); // reset mc temp

// diagnostics
	std::cout << "Alternate score2/score5..." << std::endl;
	std::cout << "kk score2 score5 low_score n_low_accept" <<
	 " rms rms_min low_rms" << std::endl;
	std::cout << I( 3, 0 ) << ' ' << F( 8, 3, score ) << ' ';
	std::cout << F( 8, 3, score5() ) << ' '; // Sequence point
	std::cout << F( 8, 3, low_score ) << ' ' <<
	 I( 4, n_low_accept ) << ' ' << F( 8, 3, rms_err ) << ' ' <<
	 F( 8, 3, rms_min ) << ' ' << F( 8, 3, low_rms ) << std::endl;

	reset_trial_counters();

// frag insertions
	for ( int jj = 1; jj <= nloop; ++jj ) {
		if ( jj > 1 ) size = 3;
		for ( int kk = 1; kk <= nloop2; ++kk ) {
			if ( mod( kk, 2 ) == 0 || kk > 7 ) {
				recover_LOW(score2);
			} else {
				recover_LOW(score5);
			}

			for ( int j = 1; j <= cycles; ++j ) {
				if ( mod( kk, 2 ) == 0 || kk > 7 ) {
					main_frag_trial(size,score2,j*kk+100000);  // MIKE MOD
				} else {
					main_frag_trial(size,score5,j*kk*100000);
				}
				if ( get_monte_carlo_converged() == 1 ) goto L112;
			}               // j
L112:; //  escape

//$ diagnostics
			refold(1,total_residue); // recover current structure
			calc_rms();
			std::cout << I( 3, kk ) << ' ' <<
			 F( 8, 3, score2() ) << ' '; // Sequence point
			std::cout << F( 8, 3, score5() ) << ' '; // Sequence point
			std::cout << F( 8, 3, low_score ) << ' ' <<
			 I( 4, n_low_accept ) << ' ' << F( 8, 3, rms_err ) << ' ' <<
			 F( 8, 3, rms_min ) << ' ' << F( 8, 3, low_rms ) << std::endl;
//$ end diagnostics

		}                  // kk
	}                     // jj

// diagnostics
	output_trial_counters( std::cout );
	recover_LOW(score3);
}

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   regular moves/smooth moves
//   score 3 ->all centroid based terms on
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) {
		classical_constraints::BOUNDARY::set_max_seqSep(total_residue);
	}

if(stage4_nloops > 0){

	std::cout << "Starting score3 moves..." << std::endl;

// setup
	nloop = stage4_nloops;
	cycles = stage4_ncycles;
	cutoff = 5;
	size = 3;

// diagnostics
	reset_trial_counters();
	std::cout << "kk,score3,low_score,rms_err,low_rms,rms_min,naccept" << std::endl;
	calc_rms();
	std::cout << I( 3, 0 ) << ' ' <<
	 F( 8, 3, score ) << ' ' <<
	 F( 8, 3, low_score ) << ' ' <<
	 F( 8, 3, rms_err ) << ' ' <<
	 F( 8, 3, low_rms ) << ' ' <<
	 F( 8, 3, rms_min ) << ' ' <<
	 I( 4, naccept ) << std::endl;

//  frag insertions
	for ( int kk = 1; kk <= nloop; ++kk ) {
		recover_LOW(score3);
		monte_carlo_set_temp(init_temp); // reset mc temp
		if ( kk == 1 ) choose_frag_set_top_N_frags(number3merfrags);
		//if ( kk == 2 ) choose_frag_set_top_N_frags(200);
		for ( int j = 1; j <= cycles; ++j ) {
		  if((rand()%1000) > 250) size = 3;
			else                    size = 9;
			if ( kk == -1 ) {  // ==1 for normal rosetta , == kk for rough rosetta ==-1 for smooth rosetta mikemod
				main_frag_trial(size,score3,j*kk);
			} else {
				main_smooth_trial(size,cutoff,score3,j*kk);
			}
		}                  // loop j

//$ diagnostics
		refold(1,total_residue);
		calc_rms();
		std::cout << I( 3, kk ) << ' ' <<
		 F( 8, 3, score3() ) << ' '; // Sequence point
		std::cout <<
		 F( 8, 3, low_score ) << ' ' <<
		 F( 8, 3, rms_err ) << ' ' <<
		 F( 8, 3, low_rms ) << ' ' <<
		 F( 8, 3, rms_min ) << ' ' <<
		 I( 4, naccept ) << std::endl;
//$ end diagnostics

	}                     // kk


// diagnostics
	output_block_state( std::cout );
	output_trial_counters( std::cout );
  }

	if ( get_dipolar_exist() && ! get_fast_cst_protocol()) refine_constraints();

}

