// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 20370 $
//  $Date: 2008-02-13 20:42:09 -0800 (Wed, 13 Feb 2008) $
//  $Author: bblum $

#ifndef INCLUDED_force_barcode
#define INCLUDED_force_barcode


// Rosetta Headers
#include "barcode_classes.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <map>
#include <string>
#include <iosfwd>
#include <vector>


// Types
typedef  float (*Scoring_Function)();

// The X's get assigned to zero and are used as dummy starting values.
namespace BigBin {
	enum State{ X, A, B, G, E, O };
	extern int const NUM_STATES;
	extern FArray1D_char StateChar;
}

namespace Secstruct {
	enum State{ X, E, H, L };
	extern int const NUM_STATES;
	extern FArray1D_char StateChar;
}

namespace DSSP {
	enum State{ X, B, E, G, H, L, I, S, T};
	extern int const NUM_STATES;
	extern FArray1D_char StateChar;
}

namespace BBlum {
	enum State{ X, b, B, e, E, H, L };
	extern int const NUM_STATES;
	extern FArray1D_char StateChar;
}

namespace barcode_energy{

	extern bool need_DSSP;
	extern bool ignore_beta_pair_barcode_in_score;

	extern FArray2D_float barcode_contact_energy;
	extern FArray2D_float barcode_contact_distance;
	extern FArray4D_float barcode_beta_pair_energy;
	extern FArray2D_float barcode_big_bin_energy;
	extern FArray2D_float barcode_ss_energy;
	extern FArray2D_float barcode_dssp_energy;
	extern FArray2D_float barcode_bblum_energy;
	extern int const MAX_NEIGHBORS;
	extern FArray2D_float barcode_env_energy;

}

barcode_classes::feature_set const &
barcode_feature_set();


void
barcode_initialize_start(
  int const nres
);


void
barcode_initialize_decoy();


float
barcode_score(
	int nres_in,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega,
	FArray1Da_char secstruct
);

float
max_barcode_score_residue(
	int nres_in
);

float
min_barcode_score_residue(
	int nres_in
);

int get_big_bin_state( char const big_bin );

int get_big_bin_state( float const phi, float const psi, float const omega );

int get_secstruct_state( char const ss );

int get_dssp_state( char const ss );

int get_bblum_state( char const ss );

float
barcode_energy_score();

float
barcode_score_residue(
	int pos,
	float phi,
	float psi,
	float omega,
	char secstruct
);


float
apply_chi_tether(
	int const res,
	int const aa,
	int const aa_variant,
	FArray1Da_float chi,
	FArray1Da_int rot
);


bool
barcode_get_rot_cst_exists( int const seqpos );


bool
barcode_allow_rotamer(
	const int res,
	const int aa,
	const int aa_variant,
	FArray1Da_float chi,
	FArray1Da_int rot
);


void
output_barcode_info( utility::io::orstream & out );


bool
barcode_exist();


void
flavor_move(
	int feature_id,
	std::vector< int > & moved_residues,
	int & length,
	int & begin,
	int & end
);


std::map< std::string, int >
get_closest_barcode();


std::map< std::string, int >
get_closest_barcode(
	FArray1D_float const & phi,
	FArray1D_float const & psi
);


void
pick_a_feature(
	int num,
	barcode_classes::feature & found_feature
);


void
barcode_moves(
	int const nmoves,
	FArray1Da_int move_list,
	int & length,
	int const nwobble,
	int const max_wobble_gap,
	int & begin,
	int & end
);


void
flavor_move_wobble(
	int const feature_id,
	int const flavor_id,
	int const nwobble,
	int const max_wobble_gap,
	std::vector< int > & moved_residues
);


void
make_nat_code_decoy(
	int & first,
	int & last,
	std::vector< int > & moved_residues
);


void
barcode_iterative_trial(
	Scoring_Function score_fxn,
	int cycle_number,
	std::string const & type
);


bool
get_increment_barcode();


void
add_barcode(
	FArray1D_float const & phi,
	FArray1D_float const & psi
);


void
dump_barcode();


std::vector< int >
get_feature_residues(
	int i
);


bool
has_movable_res(
	barcode_classes::feature f
);


bool
contains(
	std::vector< int > const & v,
	int i
);


void
barcode_accept();


void
target_small_wobble_move(
	int const nmoves,
	FArray1DB_int & move_list,
	int & length,
	int const nwobble,
	int const max_wobble_gap,
	int & begin,
	int & end
);


void
loop_update_active_cst_list(
	int const & loop_begin,
	int const & loop_end,
	std::vector< int > const & free_res,
	int const & loop_begin_extend,
	int const & loop_end_extend
);


void
reset_barcode_list ();


void
set_barcode_status(
	bool yes_no
);


bool
topology_filter();


void
reset_barcode_sspair_limits(
);


float
barcode_sspair_constraint_score(
	int const pos1,
	int const pos2,
	float const theta,
	float ss_score
);

void
barcode_read_disulf_constraints();

bool
get_output_flavor();

void
barcode_flavor_output( std::ostream & iunit );


void
BigBinStateCharInitializer( FArray1D_char & StateChar);

void
SecStructCharInitializer( FArray1D_char & StateChar);

void
DSSPCharInitializer( FArray1D_char & StateChar);

void
BBlumCharInitializer( FArray1D_char & StateChar);

#endif
