// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15154 $
//  $Date: 2007-05-24 23:00:33 -0700 (Thu, 24 May 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_fragments
#define INCLUDED_fragments


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <iosfwd>


// read_fragments Function Declarations


void
choose_frag_set_top_N_frags( int nn );


void
choose_frag_get_top_N_frags( int & nn );


void
choose_frag_set_check_ss( bool on_off);


void
choose_frag_get_check_ss ( bool & check_ss );


void
choose_fragment(
	int & size,
	int & begin // location frag was inserted
);


int
same_neighbor();


bool
same_frag(
	int & frag_begin,
	int & frag_end
);


int
get_index_by_frag_size( int want_size );


void
read_fragments();


void
read_fragments(
	int const nres
);


void
read_fragments_one_file(
	std::string filename,
	int const size,
	FArray3Da_float a_phi,
	FArray3Da_float a_psi,
	FArray3Da_float a_omega,
	FArray1Da_int a_frag_list_depth,
	int const a_max_neigh,
	int const a_max_len,
	int const a_max_res,
	int const a_total_residue,
	FArray2Da_string a_name,
	FArray3Da_char a_ss_type,
	FArray2Da_char a_chain,
	FArray3Da_char a_res_id,
	FArray2Da_int a_resseq // for new vall
);


void
set_check_homs_state( bool state );


void
get_check_homs_state( bool & state );


void
homolog_check();


void
precompute_frag_movement(
	int const length,
	int const size_bin,
	int const total_residue
);


void
pick_random_frags(
	int const frag3_pool_size,
	int const frag3_final,
	int const frag9_pool_size,
	int const frag9_final
);


bool
get_random_frag_state();

bool
get_jitter_frag_state();

float
jitter_frag( float angle_val, char const ss);

/////////////////////////////////////////////////////////
/// here starts fragments w/constraints related stuff ///
/////////////////////////////////////////////////////////

void
choose_fragment_cst(
	float tolerance,
	int size,
	int & frag_begin
);

void
precompute_fragmove_noedist(
	FArray2Da_float A1,
	FArray1Da_float U1,
	FArray2Da_float A2,
	FArray1Da_float U2,
	FArray2Da_float ZtC,
	FArray1Da_float O2,
	FArray2Da_float R,
	FArray1Da_float L
);

void
frag_move_noe_dist2(
	FArray1Da_float xyz1,
	FArray1Da_float xyz2_in,
	FArray2Da_float R,
	FArray1Da_float L,
	float & dis2
);

void
copy_fragments( int const source_res, int const dest_res, int const numres );

#endif
