// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19170 $
//  $Date: 2007-12-16 15:24:38 -0800 (Sun, 16 Dec 2007) $
//  $Author: rvernon $

#ifndef INCLUDED_fragments_ns
#define INCLUDED_fragments_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray3D.hh>

// C++ Headers
#include <map>

namespace fragments {


extern int fragments_nres;


namespace neigh_names {
	extern FArray3D_string align_name;
	extern FArray3D_char align_chain;
	extern FArray4D_char align_res_id;
	extern FArray3D_int align_resseq;
}
using namespace neigh_names;


//cems says- note mentally ill order of array subscripts


namespace neighbors {

	// std::map< int, FArray3D_float > phi_alternate_fragment_sizes;
// 	std::map< int, FArray3D_float > psi_alternate_fragment_sizes;
// 	std::map< int, FArray3D_float > omega_alternate_fragment_sizes;



	/// @brief Get or set the phi alignment of particular fragments.
	float & align_phi(int residue, int neighbor, int fragment, int fragment_bin);
	/// @brief Get or set the psi alignment of particular fragments.
	float & align_psi(int residue, int neighbor, int fragment, int fragment_bin);
	/// @brief Get or set the phi alignment of particular fragments.
	float & align_omega(int residue, int neighbor, int fragment, int fragment_bin);

	float & align_phi_v(int residue, int neighbor, int fragment, int fragment_size);
	float & align_psi_v(int residue, int neighbor, int fragment, int fragment_size);
	float & align_omega_v(int residue, int neighbor, int fragment, int fragment_size);

// void initialize_phi(int fragment_size);
// 	void initialize_psi(int fragment_size);
// 	void initialize_omega(int fragment_size);

	void initialize_alternate_fragment_size(int fragment_size);


	/// @brief
	extern FArray2D_int align_depth;
}
using namespace neighbors;


namespace neighbors_int {
	extern FArray4D_char ss_type;
}
using namespace neighbors_int;


namespace choose_frag_parm {
	extern int top_N_frags;
	extern bool check_ss;
}


namespace frag_pointer {
	extern FArray3D_int block_frag_pointer;
	extern FArray2D_int block_depth;
}


namespace frag_precompute {
	extern FArray1D_bool initialized;
}


namespace chuck {
	extern FArray5D_float frag_rot;
	extern FArray4D_float frag_off;
}


} // namespace fragments


#endif
