// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15095 $
//  $Date: 2007-05-23 06:25:07 -0700 (Wed, 23 May 2007) $
//  $Author: sarel $

#ifndef INCLUDED_fullatom_energies
#define INCLUDED_fullatom_energies


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace fullatom_energies {


//bk  fullatomE       :total full atom energy,no backbone-backbone hbondenergies
//car  hbenergy_bb     :total backbone-backbone hbondenergy


namespace totals {
	extern float fullatomE;
	extern float hbenergy_srbb;
	extern float hbenergy_lrbb;
}
using namespace totals;


namespace energies {
	extern FArray1D_float atrenergy;
	extern FArray1D_float repenergy;
	extern FArray1D_float solenergy;
	extern FArray1D_float gb_elecenergy;
	extern FArray1D_float probenergy;
	extern FArray1D_float dunenergy;
	extern FArray1D_float unfenergy;
	extern FArray1D_float protonation_energy;
	extern FArray1D_float hbenergy;
	extern FArray1D_float hbenergy_sc_sc;
	extern FArray1D_float hbenergy_sc_bb;
	extern FArray1D_float hbenergy_sr_bb;
	extern FArray1D_float hbenergy_lr_bb;
	extern FArray2D_float atr_pair;
	extern FArray2D_float rep_pair;
	extern FArray2D_float sol_pair;
	extern FArray2D_float gb_elec_pair;
  extern FArray2D_float elec_pair;
	extern FArray2D_float cst_pair;
	extern FArray2D_float pair_pair;
	extern FArray2D_float plane_plane;
	extern FArray1D_float resenergy;
	extern FArray1D_float pair_energy;
	extern FArray1D_float plane_energy;
	extern FArray2D_float hbond_pair;
	extern FArray1D_float h2oenergy;
	extern FArray2D_float h2o_pair;
	extern FArray1D_float h2ohbenergy;
	extern FArray2D_float h2o_hb_pair;
	extern FArray1D_float wsolenergy;
	extern FArray1D_float intraresenergy;
	extern FArray1D_float cstenergy;
  extern FArray1D_float elecenergy;
	extern FArray1D_float bondangleenergy;
}
using namespace energies;


//KMa aa-ligand(surface) excluding aa-aa energies  2006/1
namespace lenergies {
    extern FArray1D_float latrenergy;
	extern FArray1D_float lrepenergy;
	extern FArray1D_float lsolenergy;
	extern FArray1D_float lgb_elecenergy;
	extern FArray1D_float lh2oenergy;
	extern FArray1D_float lhbenergy;
	extern FArray1D_float lpair_energy;
	extern FArray1D_float lresenergy;
}
using namespace lenergies;


namespace best_energies {
	extern FArray1D_float best_atrenergy;
	extern FArray1D_float best_repenergy;
	extern FArray1D_float best_solenergy;
	extern FArray1D_float best_wsolenergy;
	extern FArray1D_float best_gb_elecenergy;
	extern FArray1D_float best_probenergy;
	extern FArray1D_float best_dunenergy;
	extern FArray1D_float best_unfenergy;
	extern FArray1D_float best_protonation_energy;
	extern FArray2D_float best_atr_pair;
	extern FArray2D_float best_rep_pair;
	extern FArray2D_float best_sol_pair;
	extern FArray2D_float best_cst_pair;
	extern FArray2D_float best_gb_elec_pair;
	extern FArray2D_float best_plane_plane;
	extern FArray1D_float best_resenergy;
	extern FArray1D_float best_h2oenergy;
	extern FArray2D_float best_h2o_pair;
	extern FArray1D_float best_h2ohbenergy;
	extern FArray2D_float best_h2o_hb_pair;
	extern FArray1D_float best_intraresenergy;
	extern FArray1D_float best_cstenergy;
  extern FArray1D_float best_elecenergy;
  extern FArray2D_float best_elec_pair;
	extern FArray1D_float best_bondangleenergy;
}
using namespace best_energies;


//bk energies binned by atom type


namespace atm_energies {
	extern FArray1D_float solE_atm;
	extern FArray1D_float atrE_atm;
	extern FArray1D_float repE_atm;
	extern FArray1D_int n_atm;
}
using namespace atm_energies;


}


#endif
