// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7523 $
//  $Date: 2006-02-20 15:10:59 -0800 (Mon, 20 Feb 2006) $
//  $Author: jiangl $

//////////////////////////////////////////////
// Rosetta Headers
#include "fullatom_id.h"
#include "kin_atom.h"
#include "misc.h"
#include "param_aa.h"

namespace kin {

  //lin defining a unique atom by rsd, atomno, aa, aav

  /////////////////////////////////////////////////////////////////////////////
  void Fullatom_id::assign( int const res_in, int const atm_in,
       int const aa_in, int const aav_in ){
    rsd_=res_in; atomno_=atm_in; aa_=aa_in; aav_=aav_in;
    set_key();
  }

  /////////////////////////////////////////////////////////////////////////////
  void Fullatom_id::assign() {
    rsd_=0; atomno_=0; aa_=0; aav_=0;
    set_key();
  }

  /////////////////////////////////////////////////////////////////////////////
  void Fullatom_id::assign(Atom_id const & atom_id  ){
    rsd_=atom_id.rsd();
    atomno_=atom_id.atomno();
		if( atom_id.rsd() <= misc::ints::total_residue ) {
			aa_=misc::ints::res( atom_id.rsd() );
			aav_=misc::current_pose::res_variant( atom_id.rsd() );
		} else if( atom_id.rsd() == misc::ints::total_residue + 1 ) {//lin set to LG1
			aa_=param_aa::ligand_aa_vector[1];
			aav_=1;
		} else if( atom_id.rsd() == misc::ints::total_residue +2 ) {//lin set to LG2
			aa_=param_aa::ligand_aa_vector[2];
			aav_=1;
		} else {
			std::cout<<"ERROR:: rsd() " << atom_id.rsd() << " bigger than total_residue"<<std::endl;
			assert(false);
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
    set_key();
  }

  /////////////////////////////////////////////////////////////////////////////
  void Fullatom_id::assign(Atom_id const & atom_id, int const aa_in, int const aav_in ){
    rsd_=atom_id.rsd();
    atomno_=atom_id.atomno();
    aa_=aa_in;
    aav_=aav_in;
    set_key();
  }

  /////////////////////////////////////////////////////////////////////////////
  //lin Attention: only compare seqpos aa aav
  bool operator==( Fullatom_id const & ta1, Fullatom_id const & ta2 ) {
    return ( ta1.rsd() == ta2.rsd() && ta1.aa() == ta2.aa() && ta1.aav() == ta2.aav() );
    //return ( ta1.key() == ta2.key() );
  }

  /////////////////////////////////////////////////////////////////////////////
  bool operator>( Fullatom_id const & ta1, Fullatom_id const & ta2 ) {
    return ( ta1.key() > ta2.key() );
  }

  /////////////////////////////////////////////////////////////////////////////
  bool operator<( Fullatom_id const & ta1, Fullatom_id const & ta2 ) {
    return ( ta1.key() < ta2.key() );
  }

  /////////////////////////////////////////////////////////////////////////////
  std::ostream& operator<< ( std::ostream& s, const Fullatom_id & d ) {
    s << " rsd=" << d.rsd() << " atomno=" << d.atomno() << " aa=" << d.aa() << " aav=" << d.aav() ;
    // why not work? s << kin::Atom_id::<< d << " aa=" << d.aa() << " aav=" << d.aav() ;
    return s;
  }

}

