// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16636 $
//  $Date: 2007-08-21 15:47:16 -0700 (Tue, 21 Aug 2007) $
//  $Author: ashworth $

#ifndef INCLUDED_ga_seq_opt
#define INCLUDED_ga_seq_opt

#include <vector>
#include <iostream>

#ifdef _WIN32
	#include <hash_map>
	using namespace stdext;
#else
	#include <ext/hash_map>
	using namespace __gnu_cxx;
#endif

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// utility
#include <utility/vector1.hh>


namespace ga_seq_opt {

std::string seqstr( std::vector<int> const & vec );

////////////////////////////////////////////////////////////////////////////////
// havranek, ashworth
class PopMember {

	private:
		bool _cached;
		float _fitness;
		int _rank;
		std::vector< float > _state_energies;

	public:
		std::vector< int > _sequence; // public because many external functions (that could be made into member functions?) operate on it

		// construct empty member
		PopMember( int seq_length, int num_states ) :
			_cached( false ), _fitness( 0. ), _rank( 0 )
		{
			_sequence.assign( seq_length, 0 );
			_state_energies.assign( num_states, 0. );
		}

		// construct member from file input
		PopMember( std::string line );

		// copy constructor
		PopMember( PopMember const & src )
		{
			_cached = src.cached();
			_fitness = src.fitness();
			_rank = src.rank();
			_state_energies = src.state_energies();
			_sequence = src._sequence;
		}

		void set_from_cached( PopMember const & cached )
		{
			_cached = true;
			_fitness = cached.fitness();
			_state_energies = cached.state_energies();
		}
		void set_cached( bool val ) { _cached = val; }
		void set_fitness( float val ) { _fitness = val; }
		// for reading/assignment of energies
		float & state_energies( int index ) { return _state_energies[index]; }

		/// constant methods ///
		bool cached() const { return _cached; }
		bool not_cached() const { return !_cached; } // for count_if
		float fitness() const { return _fitness; }
		int rank() const { return _rank; }
		float state_energies( int index ) const { return _state_energies[index]; }

		std::vector<float> const &
		state_energies() const { return _state_energies; }

		// used to validate after constructing from file
		bool validate( size_t const seq_length, size_t const num_states ) const
		{
			return ( ( _sequence.size() == seq_length ) &&
			         ( _state_energies.size() == num_states ) );
		}
};

std::ostream & operator<< ( std::ostream & os, PopMember const & pm );

////////////////////////////////////////////////////////////////////////////////
class
ga_seq_hash {
	public:
		enum
		{
			bucket_size = 2,
			min_buckets = 1000
		};

		size_t operator() ( const std::vector<int> &this_seq ) const;

		bool operator() (
			std::vector<int> const & seq1,
			std::vector<int> const & seq2
		) const;
};

////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
// Storage for caching sequence values
//------------------------------------------------------------------------------
namespace multi_state {

	typedef hash_map< std::vector<int>,
	                  PopMember,
	                  ga_seq_hash > MultistateHashMap;

	extern MultistateHashMap _ms_hash_map;

}

using namespace multi_state;

}

#endif
