// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_geometric_solvation
#define INCLUDED_geometric_solvation


// Rosetta Headers
#include "geometric_solvation_ns.h"
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>

void
fill_geo_sol_arrays(
  bool const fullatom,
	FArray1DB_int const & aa,
	FArray1DB_int const & aav,
	FArray3DB_float const & xyz,
	int const nres,
	FArray2DB_bool const & neighborlist,
	bool const update_deriv = false
);


float
res_res_geometric_sol(
	int const polar_res,
  int const occ_res,
	int const polar_aa,
  int const polar_aav,
	int const occ_aa,
  int const occ_aav,
	FArray2Da_float polar_coord,
	FArray2Da_float occ_coord,
  bool const include_polar_bb,
	bool const include_occ_bb,
  bool const include_polar_sc,
	bool const include_occ_sc,
	bool const update_deriv = false
);


float
get_water_cos(
	FArray1Da_float atmA,
	FArray1Da_float atmB,
	FArray1Da_float atmC
);

void
compute_atom_geom_sol_deriv(
					 int const atomno1,
					 int const rsd1,
					 numeric::xyzVector_float & F1,
					 numeric::xyzVector_float & F2 );

#endif
